/* 
 *  Graphics context manipulation
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "internal3d.h"
//#include "util.h"

/*----------------------------------------------------------------------*/

/* function table updating */

void GGI3DRegisterUpdateFunc(ggi_visual_t vis, updatefunc f, ggi_uint mask)
{
	ggi3d_data *data = GGI3D_DATA(vis);
	
	if (data->modules == MAX_MODULES) 
	{
		printf("Error: too many modules loaded on %p\n",vis);
		return;
	}
	
	data->module[data->modules].update = f;
	data->module[data->modules].change_mask = mask;
	data->change_mask |= mask;
	data->modules++;
}

void GGI3DInitGC(ggi_visual_t vis)
{
//	struct ggi_info *info;
  
//	info = ggiGetInfo(vis);
	
//	GGI3D_ACCELCHANGES(vis) = GGI3D_UPD_ALL; 
	/* Need more context! */
}

void GGI3DUpdate(ggi_visual_t vis, ggi_uint change)
{
	ggi_uint	i;
	ggi3d_data	*data = GGI3D_DATA(vis);
	
	if (change & data->change_mask) {
		for (i = 0;  i < data->modules; i++)
			if (change & data->module[i].change_mask)
				data->module[i].update(vis, change);
	}
	data->gc.accel_changes |= change; 
}

/*----------------------------------------------------------------------*/

/* manipulation of the GC */

void ggi3DReset(ggi_visual_t vis)
{
	printf("Reset of visual %p\n", vis);
	GGI3DInitGC(vis);
	GGI3DUpdate(vis, GGI3D_UPD_ALL);	
}
