/* $Id: gii.h,v 1.6 1998/10/26 11:40:23 ajapted Exp $
***************************************************************************

   LibGII internals
 
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_INTERNAL_GII_H
#define _GGI_INTERNAL_GII_H

#define _BUILDING_LIBGII

#include "config.h"
#include <ggi/system.h>
#include <ggi/events.h>

typedef struct gii_input *gii_input_t;

#include <ggi/gii.h>
#include <ggi/internal/gii_debug.h>

/* Global variables */
extern void                 *_giiconfhandle;

typedef struct gii_input {
	unsigned int		version;
/*	ggi_mutex		mutex;        Lock when changing. FIXME - later ! */
	struct gii_input *next,*prev;        /* Ring structure */

	struct gii_dlhandle	*dlhand;	/* for closing */

	uint32			origin;
	int 			maxfd;
	fd_set			fdset;
	gii_event_mask		curreventmask,targetcan;
	struct gii_ev_queue_set	*queue;

	gii_event_mask		(*GIIeventpoll)(struct gii_input *inp);
	int			(*GIIsendevent)(struct gii_input *inp, gii_event *event);
	int			(*GIIseteventmask)(struct gii_input *inp, gii_event_mask evm);
	gii_event_mask		(*GIIgeteventmask)(struct gii_input *inp);
	int			(*GIIgetselectfdset)(struct gii_input *inp, fd_set *readfds);
	int			(*GIIclose)(struct gii_input *inp);

	void 			*priv;
} gii_input;

#define EV_TIMESTAMP(ev)  { gettimeofday(& (ev)->any.time, NULL); }

#define GII_QUEUE_SIZE      8192
#define GII_Q_THRESHOLD     (GII_QUEUE_SIZE - sizeof(gii_event) - 1)

/* The threshold the point where events wrap back to the start of the
 * buffer.  Events are stored in the buffer in whole; they do not get
 * split in half at the end of the buffer.  Instead, the event that
 * crosses the threshold will physically be the last, and the next event
 * has offset 0 in the buffer.
 *
 * Corollary: head is always <= Q_THRESHOLD.
 */

typedef struct gii_ev_queue {
	int count;	/* number of events in the buffer */
	int head;	/* offset into buf[] where next event is put */
	int tail;	/* offset into buf[] of last event */
	uint8 buf[GII_QUEUE_SIZE];
} gii_ev_queue;

typedef struct gii_ev_queue_set {
	gii_event_mask seen;
	gii_ev_queue * queues[evLast];
} gii_ev_queue_set;

typedef struct gii_dlhandle {
	struct gii_dlhandle *next;	/* For correctly closing them all */
	void   *handle;
	struct gii_input *input;	/* For access to all other funcs. */
	int     (*init)(struct gii_input *inp,const char *args);
} gii_dlhandle;

/* Internal API calls
 */

void 			*_gii_malloc(size_t size);

#endif /* _GGI_INTERNAL_GII_H */
