/* $Id: input.c,v 1.4 1998/10/26 04:11:17 ajapted Exp $
***************************************************************************

   Input-pcjoy: all-in-one-file.
   
   This source is likely to be removed again later, as it is 
   _evil_ _evil_ _evil_ to access hardware directly.
   Well - it might come in handy for the DOS port ...

   Copyright (C) 1998 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/gii-dl.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_IO_H
#include <sys/io.h>
#endif
#ifdef HAVE_ASM_IO_H
#include <asm/io.h>
#endif

struct joystate {
	int button;
	int axis[4];
};

struct joyinfo {
	int treshold;
	struct joystate last;
	struct joystate new;
};

static int _GII_pcjoy_getbuttons(void)
{
	DPRINT_MISC("input-pcjoy: getbuttons\n");
	return (inb(0x201)>>4)^0x0f;	/* Invert ! */
}

static int _GII_pcjoy_getaxis(int number)
{
	int x=0;
	int mask=1<<number;

	DPRINT_MISC("input-pcjoy: getaxis %d\n",number);
	while((inb(0x201)&mask)&&x<3000) x++;	/* Let old run clear */
	x=0;outb(0x00,0x201);
	while((inb(0x201)&mask)&&x<3000) x++;	/* Count new run */
	return x;
}

static void _GII_pcjoy_getnew(struct joyinfo *joy)
{
	int x,y;

	DPRINT_MISC("input-pcjoy: getnew\n");
	joy->new.button=_GII_pcjoy_getbuttons();
	for(x=0;x<4;x++)
	{
		joy->new.axis[x]+=_GII_pcjoy_getaxis(x);
		joy->new.axis[x]/=2;
		y=joy->new.axis[x]-joy->last.axis[x];
		if (y<0) y=-y;
		if (y<joy->treshold) 
			joy->new.axis[x]=joy->last.axis[x];
	}
}

gii_event_mask GII_pcjoy_poll(struct gii_input *inp)
{
	struct joyinfo *joy=inp->priv;
	gii_event_mask rc=0;
	gii_event ev;
	int x;
	
	DPRINT_MISC("input-pcjoy: poll(%p);\n",inp);

	/* Get new data first. */
	_GII_pcjoy_getnew(joy);

	if (memcmp(&joy->new,&joy->last,sizeof(joy->last))==0)
		return 0;	/* Nothing happened */

	for(x=0;x<4;x++)
		if ((joy->last.button&(1<<x))!=(joy->new.button&(1<<x)))
		{
			_giiEventBlank(&ev);
			ev.key.size=sizeof(gii_key_event);
			ev.key.type=(joy->new.button&(1<<x)) ?
				evKeyPress : evKeyRelease;
			rc |= (joy->new.button&(1<<x)) ?
				emKeyPress : emKeyRelease;
			DPRINT_MISC("input-pcjoy: read KEY\n");
			ev.key.origin=inp->origin;
			ev.key.target=0;
			ev.key.effect=0;
			ev.key.sym=ev.key.label=GIIK_VOID;
			ev.key.button=x;
			_giiEvQueueAdd(inp,&ev);
		}
	for(x=0;x<4;x++)
		if (joy->last.axis[x]!=joy->new.axis[x])
		{
			_giiEventBlank(&ev);
			ev.size=sizeof(gii_val_event);
			DPRINT_MISC("input-pcjoy: read VAL\n");
			ev.val.type=evValAbsolute;
			rc |= emValAbsolute;
			ev.val.origin=inp->origin;
			ev.val.target=0;
			ev.val.first=x;
			ev.val.count=1;
			ev.val.value[0]=joy->new.axis[x];
//--			for(;x<4;x++)
//--			if (joy->last.axis[x]!=joy->new.axis[x])
//--			{
//--				ev.val.value[ev.val.changed]=joy->new.axis[x];
//--				ev.val.changed++;
//--			}
			_giiEvQueueAdd(inp,&ev);
		}

	joy->last=joy->new;

	return rc;
}

int GII_pcjoy_close(gii_input *inp)
{
	free(inp->priv);
	
	DPRINT_MISC("input-pcjoy: close %p\n",inp);
	return 0;
}

int GIIdlinit(gii_input *inp,const char *args)
{
	struct joyinfo *joy;

	DPRINT_MISC("input-pcjoy starting.\n");

	if (NULL==(inp->priv=joy=malloc(sizeof(struct joyinfo))))
	{
		DPRINT_MISC("input-pcjoy: no memory.\n");
		return -1;
	}

	if (ioperm(0x201,1,1))
	{
		DPRINT_MISC("input-pcjoy: Need to be root for pcjoy.\n");
		return -1;
	}

	joy->treshold=30;	/* FIXME ! Read all params from file or args. */
	joy->last.button=0;
	joy->last.axis[0]=joy->last.axis[1]=
	joy->last.axis[2]=joy->last.axis[3]=0;
	joy->new=joy->last;
	
	/* We leave these on the default handlers
	 *	inp->GIIseteventmask=_GIIstdseteventmask;
	 *	inp->GIIgeteventmask=_GIIstdgeteventmask;
	 *	inp->GIIgetselectfdset=_GIIstdgetselectfd;
	 */

	/* They are already set, so we can as well use them instead of
	 * accessing the curreventmask member directly.
	 */
	inp->targetcan=emKeyPress | emKeyRelease | emValAbsolute;
	inp->GIIseteventmask(inp,emKeyPress | emKeyRelease | emValAbsolute);

	inp->maxfd=0;			/* We poll - ouch ! */

	inp->GIIclose	 =GII_pcjoy_close;
	inp->GIIeventpoll=GII_pcjoy_poll;

	DPRINT_MISC("input-pcjoy fully up\n");

	return 0;
}

