/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: internal.h,v $
 * Revision 1.6  1998/09/29 20:46:39  ortalo
 * Should compile again w/ new libggi scheme. (But only on Linux.)
 *
 * Revision 1.5  1998/09/02 02:21:57  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:18  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:41:01  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/11 22:09:12  ortalo
 * Incorporated the work made by Tristan Wibberley. Still in alpha
 * development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#ifndef __GGI_GWT_INTERNAL_H
#define __GGI_GWT_INTERNAL_H

#include <ggi/internal/internal.h>
#include "gwt_types.h"

#define _BUILDING_LIBGWT
#include <ggi/gwt.h>

/*
 * Window IDs management - Internal API
 */
extern gwt_id_t gwt_allocate_id(void);
extern int gwt_associate_id(gwt_id_t, gwt_window_t);
extern int gwt_get_window_from_id(gwt_id_t, gwt_window_t *);
extern void gwt_free_id(gwt_id_t);

/*
 * Window Z-Order management - Internal API
 */

/* TODO: Locking for threadsafety */
#define GWT_Z_BOTTOM_CHILD(win) (win)->zorder.zbottom
#define GWT_Z_TOP_CHILD(win) (win)->zorder.ztop
#define GWT_Z_UP(win) (win)->zprev	/* goes from where you are to top */
#define GWT_Z_DOWN(win) (win)->znext	/* and vice versa, regardless of which */
					/* direction the list goes. */

extern int gwt_zinit_window(gwt_window_t win);
extern int gwt_zextract(gwt_window_t win);
extern int gwt_reparent(gwt_window_t win, gwt_window_t newparent);

/* TODO: Global locking */

/*
 * Window invalid/visible region management
 */
/* TODO: When visible regions are implemented, invalid regions are simple
 *	Move as much of the code to do this into invalidate.c, where it
 *	all is now is a hack
 */
int gwt_invalidate(gwt_window_t win, gwt_region_t region);
int gwt_validate(gwt_window_t win, gwt_region_t region);
int gwt_invalidate_all(gwt_window_t win);
int gwt_validate_all(gwt_window_t win);

void gwt_visible_setvisinv_children(gwt_window_t win);
void gwt_visible_setvisinv_family(gwt_window_t win);
void gwt_visible_setvisinv(gwt_window_t win);
int gwt_visible_lower(gwt_window_t old_z, gwt_window_t new_z, gwt_window_t win);
int gwt_visible_raise(gwt_window_t old_z, gwt_window_t new_z, gwt_window_t win);
int gwt_visible_hide(gwt_window_t win);
int gwt_visible_show(gwt_window_t win);

int gwt_copy_displayed_region(ggi_visual_t vis, gwt_region_t region, int dx, int dy);


#endif /* __GGI_GWT_INTERNAL_H */




