/**
 *
 * $Id: ShadowI.h,v 1.1 1998/06/14 20:14:39 pgw Exp $
 *
 * Copyright (C) 1998 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_SHADOW_I_H
#define XM_SHADOW_I_H

#ifdef __cplusplus
extern "C" {
#endif

/* define externs for the version 1.2 functions */
extern void _XmDrawShadows_1_2_(Display *display,
                           Drawable d,
                           GC top_gc,
                           GC bottom_gc,
                           Position x,
                           Position y,
                           Dimension width,
                           Dimension height, Dimension shad_thick,
                           unsigned int shad_type);

extern void _XmDrawShadow_1_2_(Display *display,
                          Drawable d,
                          GC top_gc,
                          GC bottom_gc,
                          Dimension shad_thick,
                          Position x,
                          Position y,
                          Dimension width,
                          Dimension height);

extern void _XmClearBorder_1_2_(Display *display,
                           Window w,
                           Position x,
                           Position y,
                           Dimension width,
                           Dimension height,
                           Dimension shadow_thick);

extern void _XmDrawSeparator_1_2_(Display *display,
                            Drawable d,
                            GC top_gc,
                            GC bottom_gc,
                            GC separator_gc,
                            Position x,
                            Position y,
                            Dimension width,
                            Dimension height,
                            Dimension shadow_thick,
                            Dimension margin,
                            unsigned char orientation,
                            unsigned char separator_type);

extern void _XmDrawDiamond_1_2_(Display *display,
                           Drawable d,
                           GC top_gc,
                           GC bottom_gc,
                           GC center_gc,
                           Position x,
                           Position y,
                           Dimension width,
                           Dimension height,
                           Dimension shadow_thick,
                           Dimension fill);

extern void _XmDrawSimpleHighlight_1_2_(Display *display,
                                   Drawable d,
                                   GC gc,
                                   Position x,
                                   Position y,
                                   Dimension width,
                                   Dimension height,
                                   Dimension highlight_thick);


extern void _XmDrawHighlight_1_2_(Display *display,
                             Drawable d,
                             GC gc,
                             Position x,
                             Position y,
                             Dimension width,
                             Dimension height,
                             Dimension highlight_thick,
                             int line_style);


extern void _XmDrawArrow_1_2_(Display *display,
                         Drawable d,
                         GC top_gc,
                         GC bot_gc,
                         GC cent_gc,
                         Position x,
                         Position y,
                         Dimension width,
                         Dimension height,
                         Dimension shadow_thick,
                         unsigned char direction);


extern void _XmHighlightBorder_1_2_(Widget w);
extern void _XmUnhighlightBorder_1_2_(Widget w);

#ifdef __cplusplus
}
#endif

#endif

