-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
-- Copyright (C) 1998 Emmanuel Briot and Joel Brobecker              --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

package body Gdk.Bitmap is

   ------------------------
   --  Create_From_Data  --
   ------------------------

   procedure Create_From_Data (Bitmap :    out Gdk_Bitmap;
                               Window : in     Gdk.Window.Gdk_Window'Class;
                               Data   : in     String;
                               Width  : in     Gint;
                               Height : in     Gint) is
      function Internal (Window        : in System.Address;
                         Data          : in String;
                         Width, Height : in Gint) return System.Address;
      pragma Import (C, Internal, "gdk_bitmap_create_from_data");
   begin
      Set_Object (Bitmap, Internal (Get_Object (Window), Data & ASCII.NUL,
                                    Width, Height));
   end Create_From_Data;

   ---------------------
   --  Set_Clip_Mask  --
   ---------------------

   procedure Set_Clip_Mask (GC    : in out Gdk.GC.Gdk_GC'Class;
                            Mask  : in     Gdk_Bitmap) is
      procedure Internal (GC, Mask : in System.Address);
      pragma Import (C, Internal, "gdk_gc_set_clip_mask");
   begin
      Internal (Get_Object (GC), Get_Object (Mask));
   end Set_Clip_Mask;


end Gdk.Bitmap;
