/*
 * Copyright (c) 1997 Stanford University
 *
 * The use of this software for revenue-generating purposes may require a
 * license from the owners of the underlying intellectual property.
 * Specifically, the SRP-1 protocol may not be used for revenue-generating
 * purposes without a license.
 *
 * Within that constraint, permission to use, copy, modify, and distribute
 * this software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notices and this permission
 * notice appear in all copies of the software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>

#define FSEPARATOR	':'

int
t_nextfield(fp, s, max)
FILE * fp;
char * s;
unsigned max;
{
  int c, count = 0;

  while((c = getc(fp)) != EOF) {
    if(c == '\n') {
      ungetc(c, fp);
      break;
    }
    else if(c == FSEPARATOR)
      break;
    if(count < max - 1) {
      *s++ = c;
      ++count;
    }
  }
  *s++ = '\0';
  return count;
}

int
t_nextline(fp)
FILE * fp;
{
  int c;

  while((c = getc(fp)) != '\n')
    if(c == EOF)
      return -1;
  return 0;
}
