/*								-*- C++ -*-
 * $Id: GDI_pen+brush.cpp,v 1.2 1996-11-19 13:30:33+01 mho Exp $
 *
 * Purpose: pen and brush classes needed for drawing
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "GDI_pen+brush.h"
#endif

#define  Uses_wxBitmap
#define  Uses_wxPenBrush
#include "wx.h"

IMPLEMENT_DYNAMIC_CLASS(wxPen, wxObject)
IMPLEMENT_DYNAMIC_CLASS(wxPenList, wxList)
IMPLEMENT_DYNAMIC_CLASS(wxBrush, wxObject)
IMPLEMENT_DYNAMIC_CLASS(wxBrushList, wxList)

//-----------------------------------------------------------------------------
// internal represeantation for pen and brush
//-----------------------------------------------------------------------------

class wxBrushRep : public wxObject {
DECLARE_DYNAMIC_CLASS(wxBrushRep)
public:
    wxColour colour;
    int      style;
    wxBitmap stipple;
    int      ref_count;
#if WXDEBUG
    void Dump(ostream& str);
#endif
};

IMPLEMENT_ABSTRACT_CLASS(wxBrushRep, wxObject)

#if WXDEBUG
void wxBrushRep::Dump(ostream& str)
{
    str << "wxBrushRep ref = " << ref_count;
}
#endif // WXDEBUG

class wxPenRep : public wxObject {
DECLARE_DYNAMIC_CLASS(wxPenRep)
public:
    int       nb_dash;
    wxDash    *dash;
    wxColour  colour;
    int       width;
    int       style;
    int       join;
    int       cap;
    wxBitmap  stipple;
    int       ref_count;
#if WXDEBUG
    void Dump(ostream& str);
#endif
};

IMPLEMENT_ABSTRACT_CLASS(wxPenRep, wxObject)

#if WXDEBUG
void wxPenRep::Dump(ostream& str)
{
    str << "wxPenRep ref = " << ref_count;
}
#endif // WXDEBUG

//-----------------------------------------------------------------------------
// wxBrush
//-----------------------------------------------------------------------------

wxBrush::wxBrush(void)
{
    __type = wxTYPE_BRUSH;

    rep = wxNEW wxBrushRep; rep->ref_count = 1;

    rep->colour = wxWHITE;
    rep->style  = wxSOLID;

#if !WXGARBAGE_COLLECTION_ON
    wxTheBrushList->AddBrush(this);
#endif
}

wxBrush::wxBrush(wxBrush& new_brush)
{
    __type = wxTYPE_BRUSH;

    rep = new_brush.rep;
    if (rep) rep->ref_count++;
}

wxBrush::wxBrush(wxColour &col, int Style)
{
    __type = wxTYPE_BRUSH;

    rep = wxNEW wxBrushRep; rep->ref_count = 1;

    rep->colour = col;
    rep->style  = Style;

#if !WXGARBAGE_COLLECTION_ON
    wxTheBrushList->AddBrush(this);
#endif
}

wxBrush::wxBrush(const char *col, int Style)
{
    __type = wxTYPE_BRUSH;

    rep = wxNEW wxBrushRep; rep->ref_count = 1;

    rep->colour = col;
    rep->style  = Style;

#if !WXGARBAGE_COLLECTION_ON
    wxTheBrushList->AddBrush(this);
#endif
}

wxBrush::~wxBrush(void)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;

#if !WXGARBAGE_COLLECTION_ON
    wxTheBrushList->RemoveBrush(this);
#endif
}

wxBrush& wxBrush::operator = (wxBrush& new_brush)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;
    rep = new_brush.rep;
    if (rep) rep->ref_count++;

    return (*this);
}

void wxBrush::operator = (wxBrush* new_brush)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;
    if (new_brush) {
	rep = new_brush->rep;
	if (rep) rep->ref_count++;
    } else {
	rep = wxNEW wxBrushRep; rep->ref_count = 1;
	rep->colour = wxWHITE;
	rep->style  = wxSOLID;
    }
}

//-----------------------------------------------------------------------------
// set and get attributes of wxBrush
//-----------------------------------------------------------------------------

wxColour& wxBrush::GetColour(void)
{
    return (rep ? rep->colour : *wxWHITE);
}

wxBitmap* wxBrush::GetStipple(void)
{
    return (rep ? &(rep->stipple) : (wxBitmap*)NULL);
}

int wxBrush::GetStyle(void)
{
    return (rep ? rep->style : wxSOLID);
}

void wxBrush::SetColour(wxColour& col)
{
    if (rep)
	rep->colour = col;
}

void wxBrush::SetColour(const char *col)
{
    if (rep)
	rep->colour = col;
}

void wxBrush::SetColour(char r, char g, char b)
{
    if (rep)
	rep->colour.Set(r, g, b);
}

void wxBrush::SetStipple(wxBitmap *s)
{
    if (rep)
	rep->stipple = *s;
}

void wxBrush::SetStyle(int s)
{
    if (rep)
	rep->style = s;
}

//-----------------------------------------------------------------------------
// wxPen create and destroy
//-----------------------------------------------------------------------------

wxPen::wxPen(void)
{
    __type = wxTYPE_PEN;

    rep = wxNEW wxPenRep; rep->ref_count = 1;

    rep->colour  = wxBLACK;
    rep->style   = wxSOLID;
    rep->join    = wxJOIN_ROUND;
    rep->cap     = wxCAP_ROUND;
    rep->nb_dash = 0;
    rep->dash    = NULL;
    rep->width   = 1;

#if !WXGARBAGE_COLLECTION_ON
    wxThePenList->AddPen(this);
#endif
}

wxPen::wxPen(wxPen& new_pen)
{
    __type = wxTYPE_PEN;

    rep = new_pen.rep;
    if (rep) rep->ref_count++;
}

wxPen::wxPen(wxColour &col, int Width, int Style)
{
    __type = wxTYPE_PEN;

    rep = wxNEW wxPenRep; rep->ref_count = 1;

    rep->colour  = col;
    rep->width   = Width;
    rep->style   = Style;
    rep->join    = wxJOIN_ROUND;
    rep->cap     = wxCAP_ROUND;
    rep->nb_dash = 0;
    rep->dash    = NULL;

#if !WXGARBAGE_COLLECTION_ON
    wxThePenList->AddPen(this);
#endif
}

wxPen::wxPen(const char *col, int Width, int Style)
{
    __type = wxTYPE_PEN;

    rep = wxNEW wxPenRep; rep->ref_count = 1;

    rep->colour  = col;
    rep->width   = Width;
    rep->style   = Style;
    rep->join    = wxJOIN_ROUND;
    rep->cap     = wxCAP_ROUND;
    rep->nb_dash = 0;
    rep->dash    = NULL;

#if !WXGARBAGE_COLLECTION_ON
    wxThePenList->AddPen(this);
#endif
}

wxPen::~wxPen(void)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;

#if !WXGARBAGE_COLLECTION_ON
    wxThePenList->RemovePen(this);
#endif
}

wxPen& wxPen::operator = (wxPen& new_pen)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;
    rep = new_pen.rep;
    if (rep) rep->ref_count++;

    return (*this);
}

void wxPen::operator = (wxPen* new_pen)
{
    // delete if representation has no more references
    if (rep && --rep->ref_count==0)
	delete rep;
    if (new_pen) {
	rep = new_pen->rep;
	if (rep) rep->ref_count++;
    } else {
	rep = wxNEW wxPenRep; rep->ref_count = 1;
	rep->colour  = wxBLACK;
	rep->style   = wxSOLID;
	rep->join    = wxJOIN_ROUND;
	rep->cap     = wxCAP_ROUND;
	rep->nb_dash = 0;
	rep->dash    = NULL;
	rep->width   = 1;
    }
}

//-----------------------------------------------------------------------------
// set and get attributes of wxPen
//-----------------------------------------------------------------------------

int wxPen::GetCap(void)
{
    return (rep ? rep->cap : wxCAP_ROUND);
}

wxColour& wxPen::GetColour(void)
{
    return (rep ? rep->colour : *wxBLACK);
}

int wxPen::GetDashes(wxDash **p)
{
    if (rep) {
	*p = rep->dash;
	return rep->nb_dash;
    }
    *p = NULL;
    return 0;
}

int wxPen::GetJoin(void)
{
    return (rep ? rep->join : wxJOIN_ROUND);
}

wxBitmap* wxPen::GetStipple(void)
{
    return (rep ? &(rep->stipple) : (wxBitmap*)NULL);
}

int wxPen::GetStyle(void)
{
    return (rep ? rep->style : wxSOLID);
}

int wxPen::GetWidth(void)
{
    return (rep ? rep->width : 1);
}

void wxPen::SetCap(int c)
{
    if (rep)
	rep->cap = c;
}

void wxPen::SetColour(wxColour& col)
{
    if (rep)
	rep->colour = col;
}

void wxPen::SetColour(const char *col)
{
    if (rep)
	rep->colour = col;
}

void wxPen::SetColour(char r, char g, char b)
{
    if (rep)
	rep->colour.Set(r, g, b);
}

void wxPen::SetDashes(int n, wxDash *d)
{
    if (rep) {
	rep->nb_dash = n;
	rep->dash = d;
    }
}

void wxPen::SetJoin(int j)
{
    if (rep)
	rep->join = j;
}

void wxPen::SetStipple(wxBitmap *s)
{
    if (rep)
	rep->stipple = *s;
}

void wxPen::SetStyle(int s)
{
    if (rep)
	rep->style = s;
}

void wxPen::SetWidth(int w)
{
    if (rep)
	rep->width = w;
}

//-----------------------------------------------------------------------------
// wxBrushList
//-----------------------------------------------------------------------------

wxBrushList::wxBrushList(void) : wxList()
{
    // there is one representation of wxBrushList
    wxTheBrushList = this;

    wxBLUE_BRUSH        = FindOrCreateBrush("BLUE", wxSOLID);
    wxGREEN_BRUSH       = FindOrCreateBrush("GREEN", wxSOLID);
    wxWHITE_BRUSH       = FindOrCreateBrush("WHITE", wxSOLID);
    wxBLACK_BRUSH       = FindOrCreateBrush("BLACK", wxSOLID);
    wxTRANSPARENT_BRUSH = FindOrCreateBrush("BLACK", wxTRANSPARENT);
    wxCYAN_BRUSH        = FindOrCreateBrush("CYAN", wxSOLID);
    wxRED_BRUSH         = FindOrCreateBrush("RED", wxSOLID);
    wxGREY_BRUSH        = FindOrCreateBrush("GREY", wxSOLID);
    wxMEDIUM_GREY_BRUSH = FindOrCreateBrush("MEDIUM GREY", wxSOLID);
    wxLIGHT_GREY_BRUSH  = FindOrCreateBrush("LIGHT GREY", wxSOLID);
}

wxBrushList::~wxBrushList(void)
{
    wxNode *node = First();
    while (node) {
	wxBrush *brush = (wxBrush*)node->Data();
	wxNode *next = node->Next();
	delete brush;
	node = next;
    }
}

wxBrush *wxBrushList::FindOrCreateBrush(wxColour *colour, int style)
{
    if (!colour)
	return NULL;

    for (wxNode *node = First(); node; node = node->Next()) {
	wxBrush *each_brush = (wxBrush*)node->Data();
	if (each_brush &&
	    each_brush->GetStyle() == style &&
	    each_brush->GetColour().Red() == colour->Red() &&
	    each_brush->GetColour().Green() == colour->Green() &&
	    each_brush->GetColour().Blue() == colour->Blue())
	    return each_brush;
    }

    wxBrush *brush = wxNEW wxBrush(*colour, style);

#if WXGARBAGE_COLLECTION_ON
    // otherwise done by wxFont()
    AddBrush(brush);
#endif

    return brush;
}

wxBrush *wxBrushList::FindOrCreateBrush(char *colour, int style)
{
    wxColour *the_colour = wxTheColourDatabase->FindColour(colour);
    if (the_colour)
	return FindOrCreateBrush(the_colour, style);
    return NULL;
}

//-----------------------------------------------------------------------------
// wxPenList
//-----------------------------------------------------------------------------

wxPenList::wxPenList(void) : wxList()
{
    // there is one representation of wxPenList
    wxThePenList = this;

    wxRED_PEN          = FindOrCreatePen("RED", 1, wxSOLID);
    wxCYAN_PEN         = FindOrCreatePen("CYAN", 1, wxSOLID);
    wxGREEN_PEN        = FindOrCreatePen("GREEN", 1, wxSOLID);
    wxBLACK_PEN        = FindOrCreatePen("BLACK", 1, wxSOLID);
    wxWHITE_PEN        = FindOrCreatePen("WHITE", 1, wxSOLID);
    wxTRANSPARENT_PEN  = FindOrCreatePen("BLACK", 1, wxTRANSPARENT);
    wxBLACK_DASHED_PEN = FindOrCreatePen("BLACK", 1, wxSHORT_DASH);
    wxGREY_PEN         = FindOrCreatePen("GREY", 1, wxSOLID);
    wxMEDIUM_GREY_PEN  = FindOrCreatePen("MEDIUM GREY", 1, wxSOLID);
    wxLIGHT_GREY_PEN   = FindOrCreatePen("LIGHT GREY", 1, wxSOLID);
}

wxPenList::~wxPenList(void)
{
    wxNode *node = First();
    while (node) {
	wxPen *pen = (wxPen*)node->Data();
	wxNode *next = node->Next();
	delete pen;
	node = next;
    }
}

wxPen *wxPenList::FindOrCreatePen(wxColour *colour, int w, int style)
{
    if (!colour)
	return NULL;

    for (wxNode *node = First(); node; node = node->Next()) {
	wxPen *each_pen = (wxPen*)node->Data();
	if (each_pen &&
	    each_pen->GetWidth() == w &&
	    each_pen->GetStyle() == style &&
	    each_pen->GetColour().Red() == colour->Red() &&
	    each_pen->GetColour().Green() == colour->Green() &&
	    each_pen->GetColour().Blue() == colour->Blue())
	    return each_pen;
    }
    wxPen *pen = wxNEW wxPen(*colour, w, style);

#if WXGARBAGE_COLLECTION_ON
    // otherwise done by wxFont()
    AddPen(pen);
#endif

    return pen;
}

wxPen *wxPenList::FindOrCreatePen(char *colour, int width, int style)
{
    wxColour *the_colour = wxTheColourDatabase->FindColour(colour);
    if (the_colour)
	return FindOrCreatePen(the_colour, width, style);
    return NULL;
}
