/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef FORTRANIZE_H
#define FORTRANIZE_H

/*
 * convert C name -> FORTRAN name.  On some systems,
 * append an underscore. On other systems, use all caps.
 *
 * x is the lower case name, X is the all caps name.
 */

#if defined(CRAY) || defined(_UNICOS) || defined(_CRAYMPP)
#define FORTRANIZE(x,X) X /* all upper-case on the Cray */

#elif defined(IBM6000) || defined(_AIX)
#define FORTRANIZE(x,X) x  /* all lower-case on RS/6000 */

#elif defined(__hpux)
#define FORTRANIZE(x,X) x  /* all lower-case on HP-UX */

#elif defined(USING_G77) /* users should define this when using with the g77
			    Fortran compiler */
#define FORTRANIZE(x,X) x##__  /* g77 expects *two* underscores after
				  names with an underscore */

#else
#define FORTRANIZE(x,X) x##_  /* use all lower-case with underscore
				 by default */

#endif

#endif /* FORTRANIZE_H */
