#include <config.h>
#include <string.h>
#include <gnome.h>
#include <gdk_imlib.h>
#include <applet-lib.h>
#include <applet-widget.h>
#include "applet.h"
#include "pixmaps.h"

#define DISCARD_KEY -1

#ifdef GNOME

GtkWidget *darea;

void applet_exposed_cb( GtkWidget *widget, gpointer data )
{
	applet_update( Current_Status, NULL, data );
}

void applet_update( DWORD status, GdkPixmap *flash, struct sokandlb *data )
{
	static GtkTooltips *tt = NULL;
	static GdkFont *font = NULL;
	GdkPixmap *status_pix;
	static GdkPixmap *pm = NULL;
	char *status_string;
	char *message_count;
	int num_messages = 0;
	int cx;
	char *tooltips_str;

	if( applet_toggle == FALSE )
		return;

	if( font == NULL )
		font = gdk_font_load( "-adobe-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" );

	if( tt == NULL )
		tt = gtk_tooltips_new();

	message_count = (char *)malloc( 16 );
	tooltips_str = (char *)malloc( 64 );

	if( pm == NULL )
		pm = gdk_pixmap_new( darea->window,
		                     darea->allocation.width,
		                     darea->allocation.height,
		                     -1 );

	if( status == STATUS_OFFLINE )
		status_pix = icon_offline_pixmap;
	else switch( status & 0xffff )
	{
		case STATUS_ONLINE:
			status_pix = icon_online_pixmap;
			break;
		case STATUS_AWAY:
			status_pix = icon_away_pixmap;
			break;
		case STATUS_NA:
			status_pix = icon_na_pixmap;
			break;
		case STATUS_DND:
			status_pix = icon_dnd_pixmap;
			break;
		case STATUS_FREE_CHAT:
			status_pix = icon_ffc_pixmap;
			break;
		case STATUS_OCCUPIED:
			status_pix = icon_occ_pixmap;
			break;
		case STATUS_INVISIBLE:
			status_pix = icon_inv_pixmap;
			break;
		default:
			status_pix = icon_offline_pixmap;
			break;
	}

	gdk_draw_rectangle( pm,
	                    darea->style->bg_gc[ GTK_STATE_NORMAL ],
	                    TRUE, 0, 0,
	                    darea->allocation.width,
	                    darea->allocation.height );

	gdk_draw_pixmap( pm,
	                 darea->style->fg_gc[ GTK_WIDGET_STATE( darea ) ],
	                 status_pix,
	                 0, 0, 0, 4, -1, -1 );

	if( flash != NULL )
		gdk_draw_pixmap( pm,
		                 darea->style->fg_gc[ GTK_WIDGET_STATE( darea ) ],
		                 flash,
		                 0, 0, 0, 24, -1, -1 );

	else
		gdk_draw_pixmap( pm,
		                 darea->style->fg_gc[ GTK_WIDGET_STATE( darea ) ],
		                 nomess_pixmap,
		                 0, 0, 0, 24, -1, -1 );

	status_string = Convert_Status_2_Str( status );

	gdk_draw_string( pm, font,
	                 darea->style->fg_gc[ GTK_STATE_NORMAL ],
	                 20, 16, status_string );

	for( cx = 0; cx < Num_Contacts; cx ++ )
		num_messages += Contacts[ cx ].messages;

	if( num_messages != 1 )
		sprintf( message_count, "%d Messages", num_messages );
	else
		sprintf( message_count, "%d Message", num_messages );

	gdk_draw_string( pm, font,
	                 darea->style->fg_gc[ GTK_WIDGET_STATE( darea ) ],
	                 20, 36, message_count );

	gdk_draw_pixmap( darea->window,
	                 darea->style->fg_gc[ GTK_WIDGET_STATE( darea ) ],
	                 pm, 0, 0, 0, 0, -1, -1 );

	sprintf( tooltips_str, "%ld: %d User(s) Online", UIN, data->online );
	gtk_tooltips_set_tip( tt, darea, tooltips_str, NULL );
	gtk_tooltips_enable( tt );

	free( message_count );
	free( tooltips_str );
}

void applet_hide_main( GtkWidget *widget, gpointer data )
{
	if( !GTK_WIDGET_VISIBLE( app ) )
		gtk_widget_show( app );
	else
		gtk_widget_hide( app );
}


void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
	if( ev == NULL )
		return;

	if( ev->button != 1 || ev->type != GDK_2BUTTON_PRESS )
		return;

	if( !GTK_WIDGET_VISIBLE( app ) )
		gtk_widget_show( app );
	else
		gtk_widget_hide( app );
}

GtkWidget *create_applet(GtkWidget *window, struct sokandlb *data )
{
	GtkWidget *frame;
	GtkStyle *style;
	GtkWidget *hbox;

	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

   style = gtk_widget_get_style( data->lb_userwin );
	hbox = gtk_hbox_new( FALSE, 0 );
	
	darea = gtk_drawing_area_new();

	gtk_drawing_area_size(GTK_DRAWING_AREA(darea),
			      90,
			      40);
	gtk_widget_set_events(darea, gtk_widget_get_events(darea) |
			      GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
	gtk_widget_show(darea);

	frame = gtk_frame_new( NULL );
	gtk_frame_set_shadow_type(GTK_FRAME( frame ), GTK_SHADOW_IN );
	gtk_container_add( GTK_CONTAINER( frame ), darea );

	gtk_box_pack_start( GTK_BOX( hbox ), frame, FALSE, FALSE, 0 );

	gtk_signal_connect( GTK_OBJECT( darea ), "expose_event",
	                    GTK_SIGNAL_FUNC( applet_exposed_cb ), data );
	gtk_signal_connect( GTK_OBJECT( darea ), "button_press_event",
	                    GTK_SIGNAL_FUNC( applet_clicked_cb ), NULL );

/*	button = gtk_toggle_button_new();
	gtk_container_add( GTK_CONTAINER( button ), applet_to_big_widget );
	gtk_widget_show( applet_to_big_widget );
	gtk_signal_connect(GTK_OBJECT( button ), "toggled",
			   GTK_SIGNAL_FUNC( applet_clicked_cb ), NULL);
	gtk_widget_set_usize( button, 20, 20 );
	gtk_box_pack_start( GTK_BOX( vbox ), button, TRUE, TRUE, 0 );
	gtk_widget_show( button );
	
	gtk_box_pack_start( GTK_BOX( hbox ), vbox, FALSE, FALSE, 0 );

	gtk_widget_show( vbox );
*/
	gtk_widget_show( frame );

	gtk_widget_show( darea );
	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();
        return hbox;
}

void
make_applet( int argc, char *argv[], struct sokandlb *data )
{
	int cx;
	static struct argp_option arguments[] =
	{
		{
			"discard-session", DISCARD_KEY, N_("ID"), 0, N_("Discard session"), 1
		},
		{
			"config", 'c', N_("CONFIG"), 0, N_("Use this file instead of ~/.icq/gtkicqrc"), 1
		},
		{
			"noapplet", 'a', NULL, 0, N_("startup without applet support"), 1
		},
		{
			NULL, 0, NULL, 0, NULL, 0
		}
	};

	static struct argp parser =
	{
		arguments,
		parse_an_arg,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL
	};

	GtkWidget *widget;
	GtkWidget *applet;

	for( cx = 0; cx < argc; cx ++ )
	{
		if( !strcmp( "-a", argv[ cx ] ) )
			applet_toggle = FALSE;
	}

	if( applet_toggle == FALSE )
		return;

	applet_widget_init_defaults("gtkicq_applet", &parser, argc, argv, 0, NULL,
				    argv[0]);

	applet = applet_widget_new();
	if ( !applet )
		g_error( _( "Can't create applet!\n" ) );

	gtk_widget_realize( applet );
	widget = create_applet( applet, data );
	gtk_widget_show( widget );

	applet_widget_add( APPLET_WIDGET( applet ), widget );

	gtk_widget_show( applet );
}

error_t parse_an_arg( int key, char *arg, struct argp_state *state )
{
	if( key == DISCARD_KEY )
	{
		gnome_config_clean_file( arg );
		gnome_config_sync();
		
		gnome_client_disable_master_connection();
	
		return 0;
	}
	else if( key == 'c' )
	{
		strncpy( configfilename, arg, 255 );
		return 0;
	}
	else if( key == 'a' )
	{
		applet_toggle = FALSE;
		return 0;
	}

	return ARGP_ERR_UNKNOWN;
}

#endif
