dnl Check for libreadline of proper version
AC_DEFUN(READLINE_CHECK,
[AC_MSG_CHECKING(for readline)
AC_CACHE_VAL(lftp_cv_precompiled_readline,
[
   old_LIBS="$LIBS"
   LIBS="-lreadline $READLINE_SUPPLIB $LIBS"
   AC_TRY_LINK([extern int (*rl_getc_function)();],
      [rl_getc_function=0;],
      lftp_cv_precompiled_readline=yes,
      lftp_cv_precompiled_readline=no)
   LIBS="$old_LIBS"
])
if test $lftp_cv_precompiled_readline = yes; then
   READLINE_DIR=''
   AC_MSG_RESULT(yes)
   READLINE='-lreadline'
   READLINE_DEPEND=''
   COMPILE_READLINE=no
else
   READLINE_DIR=readline-2.2
   AC_MSG_RESULT(no - will compile)
   AC_CONFIG_SUBDIRS($READLINE_DIR)
   LINK_SRC="$LINK_SRC $READLINE_DIR"
   LINK_DST="$LINK_DST include/readline"
   READLINE='-L$(top_builddir)/$(READLINE_DIR) -lreadline'
   READLINE_DEPEND='$(top_builddir)/$(READLINE_DIR)/libreadline.a'
   COMPILE_READLINE=yes
fi
AC_SUBST(COMPILE_READLINE)
AC_SUBST(READLINE_DIR)
AC_SUBST(READLINE_DEPEND)
AC_SUBST(READLINE)
])

dnl check if c++ compiler can use dynamic initializers for static variables
AC_DEFUN(CXX_DYNAMIC_INITIALIZERS,
[
   AC_LANG_SAVE
   AC_LANG_CPLUSPLUS
   AC_MSG_CHECKING(if c++ compiler can handle dynamic initializers)
   AC_TRY_RUN(
   [
      int f() { return 1; }
      int a=f();
      int main()
      {
	 exit(1-a);
      }
   ],
   [cxx_dynamic_init=yes],
   [cxx_dynamic_init=no],
   [cxx_dynamic_init=yes])
   AC_MSG_RESULT($cxx_dynamic_init)
   if test x$cxx_dynamic_init = xno; then
      AC_MSG_ERROR(C++ compiler cannot handle dynamic initializers of static objects)
   fi
   AC_LANG_RESTORE
])

dnl Check for size of addr length argument
AC_DEFUN(ADDRLEN_TYPE_CHECK,
[
   AC_MSG_CHECKING(for addrlen type)
   AC_CACHE_VAL(lftp_cv_addrlen_type,
   [
      AC_LANG_SAVE
      AC_LANG_CPLUSPLUS
      old_CXXFLAGS="$CXXFLAGS"
      if test "$GXX" = yes; then
	 CXXFLAGS="$CXXFLAGS -Werror"
      fi
      lftp_cv_addrlen_type=unknown
      for type in socklen_t size_t int; do
	 AC_TRY_COMPILE([
	    #include <sys/types.h>
	    #include <sys/socket.h>
	 ],
	 [
	    $type len;
	    getpeername(0,0,&len);
	 ],
	 [
	    lftp_cv_addrlen_type=$type
	    break
	 ])
      done
      AC_LANG_RESTORE
      CXXFLAGS="$old_CXXFLAGS"
   ])
   if test $lftp_cv_addrlen_type = unknown; then
      ADDRLEN_TYPE=int
      AC_MSG_RESULT(unknown - assuming $ADDRLEN_TYPE)
   else
      ADDRLEN_TYPE=$lftp_cv_addrlen_type
      AC_MSG_RESULT($ADDRLEN_TYPE)
   fi
   AC_DEFINE_UNQUOTED(ADDRLEN_TYPE, $ADDRLEN_TYPE)
])

AC_DEFUN(LFTP_FUNC_POLL,
[
   AC_MSG_CHECKING(for working poll)
   AC_CACHE_VAL(lftp_cv_func_poll_works,
   [
      AC_TRY_RUN([int main() { return poll(0,0,0)!=0; }],
	    [lftp_cv_func_poll_works=yes;],
	    [lftp_cv_func_poll_works=no;],
	    [lftp_cv_func_poll_works=no;])
   ])
   AC_MSG_RESULT($lftp_cv_func_poll_works)
   if test $lftp_cv_func_poll_works = yes; then
      AC_DEFINE(HAVE_POLL)
   fi
])

AC_DEFUN(LFTP_PROG_CXXLINK,
[
   AC_MSG_CHECKING(how to link simple c++ programs)
   if test "$GCC" = yes -a "$GXX" = yes; then
      old_CXX="$CXX"
      CXX="$CC"
      AC_LANG_SAVE
      AC_LANG_CPLUSPLUS
      AC_TRY_COMPILE([],[char *a=new char[10]; exit(0);],
	 [],[CXX="$old_CXX";])
      AC_LANG_RESTORE
   fi
   AC_MSG_RESULT(using $CXX)
])
