/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>

#include "mserver.h"


bool cfile_write(char *connection)
{
	FILE *cfile;

	char temp[1024];
	int cspeed;
	time_t cur_time;

	cspeed = config_getvalue_int("cspeed");	
	config_getvalue("confile", temp, 1024);

	unlink(temp);
	cfile = fopen(temp, "w");

	if (cfile == NULL)
	{
		return false;
	}

	time(&cur_time);

	fprintf (cfile, "%s:%d:%d\n", connection, cspeed, cur_time);

	fclose(cfile);
	
	return true;
}

void cfile_unlink(void)
{
	char temp[1024];
	
	config_getvalue("confile", temp, 1024);

	unlink(temp);
}
