/*  Hash table functions
    Copyright (C) 1998  Charles P. Wright

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    You may link this program with the Qt Free Edition.
*/

#ifdef USE_HASH

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>
#include <syslog.h>

#include "mserver.h"

struct htab *hashtab[HASHELEMENTS];

void inittab(void)
{
	int i;

	for (i = 0; i < HASHELEMENTS; i++)
	{
		hashtab[i] == NULL;
	}
}

unsigned int hash (const char *s) {
   int i, n, len;
   unsigned int hashval, ival;
   char *p;

   p = (char *) &ival; 
 
   hashval = ival = 0;

   //n = (int) ((((log10((double)(UINT_MAX)) / log10(2.0))) / CHAR_BIT) + 0.5);
   n = sizeof(int);

   len = strlen(s);
   for(i = 0; i < len; i += n) {
      strncpy(p, s + i, n);
      hashval += ival;
   }

   return hashval % HASHELEMENTS;
}

struct htab *addhash (const char *key, const char *data)
{
	struct htab *newhash;
	struct htab *curhash;
	unsigned int i, hashval;
	int len;

	newhash = (struct htab *)(malloc(sizeof(struct htab)));
	if (newhash == NULL)
	{
		syslog (LOG_ERR, "Can not malloc hash entries!");
		fprintf (stderr, "Can not malloc hash entries!");
		exit(1);
	}

	len = strlen(key);
	for(i = 0; i <= len; i++)
	{
		newhash->key[i] = key[i];
	}

	len = strlen(data);
	for(i = 0; i <= len; i++)
	{
		newhash->data[i] = data[i];
	}

	hashval = hash(key);

	if (hashtab[hashval] == NULL)
	{
		hashtab[hashval] = newhash;
		hashtab[hashval]->parent = NULL;
		hashtab[hashval]->child = NULL;
	}
	else
	{
		if (!strncmp(hashtab[hashval]->key, key, MAXDATA))
		{
			strncpy(hashtab[hashval]->key, key, MAXCOMMAND);
			strncpy(hashtab[hashval]->data, data, MAXDATA);
		}
		else
		{
			curhash=hashtab[hashval];
			while(curhash->child != NULL)
			{
				curhash=curhash->child;
			}
			curhash->child = newhash;
			newhash->child = NULL;
			newhash->parent = curhash;
		}
 	} 
	return newhash;
}

struct htab *findhash(const char *key) {
   unsigned int hashval;
   struct htab *curhash;
   
   hashval = 0;

   hashval = hash(key);

   
   if (hashtab[hashval] == NULL) {
      return NULL;
   }
 
   if (!strcmp((hashtab[hashval]->key), (key))) {
      curhash = hashtab[hashval];
      return curhash; 
   }
   else {
      if (hashtab[hashval]->child == NULL) {
         return NULL;
      }

      curhash = hashtab[hashval]->child;


      if (!strcmp((curhash->key), (key))) {
         return curhash;
      }

      while (curhash->child != NULL) {
         if (!strcmp((curhash->key), (key))) {
            return curhash;
         }
         curhash = curhash->child;
      }
      if (!strcmp((curhash->key), (key))) {
         return curhash;
      }
      else {
         return NULL;
     }
   }
}

int delhash(const char *key) {
   unsigned int hashval;
   struct htab *curhash;
   
   hashval = 0;

   hashval = hash(key);

   
   if (hashtab[hashval] == NULL) {
      return 0;
   }
 
   if (!strcmp((hashtab[hashval]->key), (key))) {
      curhash = hashtab[hashval];
      hashtab[hashval] = curhash->child;
      free(curhash);
      return 1; 
   }
   else {
      if (hashtab[hashval]->child == NULL) {
         return 0;
      }

      curhash = hashtab[hashval]->child;


      if (!strcmp((curhash->key), (key))) {
         curhash->parent->child = curhash->child;
         if (curhash->child != NULL) {
            curhash->child->parent = curhash->parent;
         }
         free(curhash);
         return 1; 
      }

      while (curhash->child != NULL) {
         if (!strcmp((curhash->key), (key))) {
            curhash->parent->child = curhash->child;
            if (curhash->child != NULL) {
               curhash->child->parent = curhash->parent;
            }
            free(curhash);
            return 1; 
         }
         curhash = curhash->child;
      }
      if (!strcmp((curhash->key), (key))) {
         curhash->parent->child = curhash->child;
         if (curhash->child != NULL) {
            curhash->child->parent = curhash->parent;
         }
         free(curhash);
         return 1; 
      }
      else {
         return 0;
     }
   }
}
#endif
