
/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;
FILE *logfile;


bool parse_pppd_init(void)
{
	char temp[1024];

	config_getvalue("logfile", temp, 1024);

	logfile = fopen(temp, "r");

	if (logfile == NULL)
	{
		syslog(LOG_WARNING, "Could not open pppd log file: %s", temp);

		fprintf(outsock, "ERROR: Could not open pppd log file: %s\n", temp);
		fprintf(outsock,"END\n");
		return false;
	}

	(void) fseek(logfile, 0L, SEEK_END);
	
	return true;
}

bool parse_pppd (void)
{
	int sleep_sec;
	int log_timeout;

	char temp[1024];

	log_timeout = config_getvalue_int("logtimeout");
	sleep_sec = 0;

	while (true)
	{
		if (fgets(temp, 1024, logfile) == NULL)
		{
			util_sleep (1);
			sleep_sec++;
			if (sleep_sec > log_timeout)
			{
				fprintf (outsock, "Timeout parsing logfile\n");
				return false;
			}
		}
		else
		{
			if (strstr(temp, "pppd[") != NULL)
			{
				if (strstr(temp, "started") != NULL)
				{
					fprintf(outsock, "PPPD Process Started\n");
					fflush(outsock);
				}
				else if (strstr(temp, "Serial connection established") != NULL)
				{
					fprintf (outsock, "Modem Connected\n");
					fflush(outsock);
				}
				else if (strstr(temp, "Connect: ppp") != NULL)
				{
					fprintf (outsock, "PPP Link Established\n");
					return true;
				}
				else if (strstr(temp, "Connect script failed") != NULL)
				{
					fprintf (outsock, "Connect script failed\n");
					return false;
				}
				else if (strstr(temp, "Modem hangup") != NULL)
				{
					fprintf (outsock, "Modem hungup\n");
					return false;
				}
				else if (strstr(temp, "Connection terminated") != NULL)
				{
					fprintf (outsock, "Connection terminated\n");
					return false;
				}
				else if (strstr(temp, "Exit.") != NULL)
				{
					fprintf (outsock, "PPPD Exited!\n");
					return false;
				}
			}
			else if (strstr(temp, "chat[") != NULL)
			{
				if (strstr(temp, "send"))
				{
					if (strstr(temp, "ATZ"))
					{
						fprintf(outsock, "Initializing Modem\n");
						fflush(outsock);
					}
					else if (strstr(temp, "ATDT"))
					{
						fprintf(outsock, "Dialing Modem\n");
						fflush(outsock);
					}
				}
				else if (strstr(temp, "assword:"))
				{
					fprintf(outsock, "Sending Password\n");
					fflush(outsock);
				}
				else if (strstr(temp, "ogin:"))
				{
					fprintf(outsock, "Sending Login\n");
					fflush(outsock);
				}
				else if (strstr(temp, "sername:"))
				{
					fprintf(outsock, "Sending Username\n");
					fflush(outsock);
				}
				else if (strstr(temp, "Failed"))
				{
					fprintf(outsock, "Chat script failed!\n");
					return false;
				}
			}
		}
	}		
	fclose(logfile);
}
