
/*  A Bison parser, made from mglparse.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	QSTRING	258
#define	NUM	259
#define	INADDR	260
#define	ID	261
#define	CHR	262
#define	ADDOP	263
#define	MULOP	264
#define	COMPARISON	265
#define	OROP	266
#define	XOROP	267
#define	ANDOP	268
#define	NOTOP	269
#define	VAR	270
#define	CONST	271
#define	TYPE	272
#define	SCREEN	273
#define	PROCEDURE	274
#define	FUNCTION	275
#define	ARRAY	276
#define	RECORD	277
#define	RETURN	278
#define	RESTART	279
#define	PRINT	280
#define	SELECT	281
#define	ITEM	282
#define	IF	283
#define	ELSE	284
#define	GOTOXY	285
#define	TIMEOUT	286
#define	LOAD	287
#define	FROM	288
#define	GATEWAY	289
#define	GET	290
#define	MENU	291
#define	REPEAT	292
#define	UNTIL	293
#define	AT	294
#define	WITH	295
#define	THEN	296
#define	WHILE	297
#define	DO	298
#define	BREAK	299
#define	DEFAULT	300
#define	ASSIGN	301
#define	OF	302
#define	CBEGIN	303
#define	END	304
#define	DOTS	305
#define	THEN_PREC	306
#define	UMINUS	307

#line 1 "mglparse.y"

/*
 * mglparse.y  -  Parser for Bootrom Menu Generation Language
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "mknbi.h"
#include "nblib.h"
#include "mgl.h"
#include "gencode.h"



/*
 *****************************************************************************
 *
 * Global variables
 */
int lineno = 1;				/* Current line number */
int errors = 0;				/* Number of errors */
int warnings = 0;			/* Number of warnings */
int curlevel = 0;			/* Current nesting level */
struct typesdef *typetab = NULL;	/* Types table */
struct sym *symtab = NULL;		/* Symbol table */
struct sym *curproc = NULL;		/* Current procedure, function, menu */



/*
 *****************************************************************************
 *
 * Local variables
 */
static int yyerrstatus = 0;		/* Error status of parser */
static int inargdef = FALSE;		/* TRUE when defining proc args */
static int reclevel = 0;		/* Current level within a record def */
static varattrib curattrib = ATTR_NONE;	/* Current argument attribute */
static addr_t levelptr[MAX_LEVELS + 1];		/* Current offset to BP */
static struct sym *symstack[MAX_LEVELS + 1];	/* Symbol stack for nesting */



/*
 *****************************************************************************
 *
 * Make life simpler using preprocessor defines:
 */
#define newexpr()	((struct expr *)nbmalloc(sizeof(struct expr)))
#define newtype()	((struct typesdef *)nbmalloc(sizeof(struct typesdef)))
#define newsym()	((struct sym *)nbmalloc(sizeof(struct sym)))
#define newsymlist()	((struct symlist *)nbmalloc(sizeof(struct symlist)))
#define newtypelist()	((struct typelist *)nbmalloc(sizeof(struct typelist)))
#define newvarinfo()	((struct varinfo *)nbmalloc(sizeof(struct varinfo)))



/*
 *****************************************************************************
 *
 * Convert string into IP number
 */
static char *getinet(name)
char *name;
{
#ifdef HAVE_INET
  static struct in_addr addr;
  struct hostent *hp;

  addr.s_addr = INADDR_ANY;
  if ((hp = gethostbyname(name)) == NULL)
	warning("host not found, assuming 0.0.0.0");
  else
	addr = *((struct in_addr *)(hp->h_addr));
#else
  static char addr[INADDR_SIZE];

  warning("no IP address support available, assuming 0.0.0.0");
  memset(addr, 0, INADDR_SIZE);
#endif
  return((char *)&addr);
}



/*
 *****************************************************************************
 *
 * Delete the list of symbols, which has been builtup during a variable
 * or enumeration declaration. We also delete the symbols themselves if
 * they are not used.
 */
static void delsymlist(symlist)
struct symlist *symlist;
{
  struct sym *sp;
  struct symlist *slp, *slptmp;

  slp = symlist;
  while (slp != NULL) {
	if (isnosym(slp->sym)) {
		/*
		 * The symbol is not in use, so delete it. To do this we
		 * have to first find the preceding symbol.
		 */
		for (sp = symtab; sp != NULL; sp = sp->next)
			if (sp->next == slp->sym)
				break;
		if (sp != NULL && sp->next != NULL) {
			sp->next = sp->next->next;
			free(slp->sym->name);
			free(slp->sym);
		}
	}
	slptmp = slp->next;
	free(slp);
	slp = slptmp;
  }
}



/*
 *****************************************************************************
 *
 * Delete all symbols with higher or equal nesting level than the current
 * level.
 */
static void delsymbols()
{
  struct sym *sp1, *sp2, *sp3;

  /* First delete all symbols */
  sp1 = NULL;
  sp2 = symtab;
  while (sp2 != NULL) {
	sp3 = sp2->next;
	if (sp2->level >= curlevel) {
		/* Delete any string in a constant */
		if (sp2->type == constsym && sp2->def.c.t->type == EXPR_STRING)
			if (sp2->def.c.val.s != NULL)
				free(sp2->def.c.val.s);

		/* Now delete the symbol name and the symbol itself */
		if (sp1 != NULL)
			sp1->next = sp3;
		else
			symtab = sp3;
		free(sp2->name);
		free(sp2);
	} else
		sp1 = sp2;
	sp2 = sp3;
  }
}



/*
 *****************************************************************************
 *
 * Check if the symbol is already defined within the current level. If it
 * has been defined in a lower level, we can assign the name again, and have
 * to create a new symbol table entry for it.
 */
static struct sym *checksym(sp)
struct sym *sp;
{
  struct sym *newsp;

  /* If it's not defined at all, we can return it unchanged */
  if (isnosym(sp))
	return(sp);

  /* Check if symbol is defined within the current level */
  if (sp->level >= curlevel) {
	error("identifier already declared");
	return(NULL);
  }

  /* Create new entry in symbol table */
  newsp = newsym();
  newsp->type = nosym;
  newsp->level = curlevel;
  newsp->next = symtab;
  symtab = newsp;

  /* We have to create a new copy of the name to be able to delete the symbol */
  copystr(&(newsp->name), sp->name);
  return(newsp);
}



/*
 *****************************************************************************
 *
 * Scan through the current symbol list and assign a variable type to
 * all symbols.
 */
static void assignvartype(tp, symlist)
struct typesdef *tp;
struct symlist *symlist;
{
  struct sym *sp;
  struct symlist *slp;
  addr_t varsize;

  for (slp = symlist; slp != NULL; slp = slp->next) {
	if (slp->sym == NULL)
		continue;
	if (reclevel > 0) {
		/*
		 * We are defining variables for a record definition. This
		 * is a bit complicated, because the symbols in the record
		 * can have names which are already declared even in the
		 * current level. To care for this, we declare symbols here
		 * which have a higher level than the current level, so
		 * that they can be sorted out lateron.
		 */
		curlevel += reclevel;
		if ((sp = checksym(slp->sym)) == NULL) {
			curlevel--;
			break;
		}
		sp->type = varsym;
		sp->def.v.t = tp;
		sp->def.v.attr = ATTR_NONE;
		sp->level = curlevel;
		curlevel -= reclevel;
		continue;
	}
	if ((sp = checksym(slp->sym)) == NULL)
		break;
	sp->type = varsym;
	sp->def.v.t = tp;
	sp->def.v.attr = ATTR_NONE;
	varsize = tp->size;
	if (tp->type == EXPR_STRING)
		/* Strings occupy one byte more than their size */
		varsize++;
	if (inargdef) {
		/*
		 * We are preparing an argument list to a function or
		 * procedure. There, non-scalars get always passed as
		 * pointers. If they have to be passed by value, the
		 * caller has to provide a copy of the argument value
		 * on the stack before calling the procedure.
		 * Additionally, when a string gets passed by reference,
		 * not only the address but also the string size gets
		 * pushed onto the stack.
		 * We use sp->addr to temporarily save the size of the
		 * argument on the stack. A positive value of sp->addr
		 * marks this as an argument to a function.
		 */
		if (curattrib == ATTR_REF)
			sp->addr = (tp->type == EXPR_STRING ? 4 : 2);
		else
			sp->addr = (isscalar(tp) ?
					(varsize + 1) & 0xfffe : 2);
		sp->def.v.attr = curattrib;
	} else if (curlevel > 0) {
		levelptr[curlevel] += (varsize + 1) & 0xfffe;
		sp->addr = -levelptr[curlevel];
	} else {
		sp->addr = dataptr;
		dataptr += varsize;
	}
  }

  /* Finally delete the symbol list */
  delsymlist(symlist);
}



/*
 *****************************************************************************
 *
 * Return a pointer to an enumeration type which has the elements listed
 * in the current symbol list.
 */
static struct typesdef *enumcreate(symlist)
struct symlist *symlist;
{
  struct sym *sp;
  struct symlist *slp;
  struct typesdef *tp;
  int i;

  /* Just for safety */
  if (symlist == NULL)
	return(NULL);

  /* Check that all symbols in the list are available */
  for (slp = symlist; slp != NULL; slp = slp->next) {
	if (slp->sym == NULL)
		continue;
	if ((slp->sym = checksym(slp->sym)) == NULL) {
		delsymlist(symlist);
		return(NULL);
	}
  }

  /* First we count the number of symbols in the symbol list and number them */
  for (i = 0, slp = symlist; slp != NULL; slp = slp->next, i++) {
	if (slp->sym == NULL)
		break;
	slp->num = i;
  }
  if (slp != NULL || i == 0) {
	delsymlist(symlist);
	return(NULL);
  }

  /* Reverse the numbers in the list */
  i--;
  for (slp = symlist; slp != NULL; slp = slp->next)
	slp->num = i - slp->num;

  /* Let's see if we have a type like this already */
  for (tp = typetab; tp != NULL; tp = tp->next)
	if (tp->type == EXPR_ENUM &&
	    tp->def.s.min == 0 &&
	    tp->def.s.max == i)
		break;

  /* We can now safely create a new enumeration type */
  if (tp == NULL) {
	tp = newtype();
	tp->type = EXPR_ENUM;
	tp->def.s.boundaddr = -1;
	tp->def.s.min = 0;
	tp->def.s.max = i;
	tp->size = int_type.size;
	tp->next = typetab;
	typetab = tp;
  }

  /* Finally we have to assign a new type to all symbols in the list */
  for (slp = symlist; slp != NULL; slp = slp->next) {
	sp = slp->sym;
	sp->type = constsym;
	sp->def.c.t = tp;
	sp->def.c.val.e = slp->num;
  }

  /* Release the symbol list and return the new enumeration type */
  delsymlist(symlist);
  return(tp);
}



/*
 *****************************************************************************
 *
 * Return a pointer to an array type.
 */
static struct typesdef *arraycreate(index, base)
struct typesdef *index;
struct typesdef *base;
{
  struct typesdef *tp;
  int elementnum;
  addr_t size;

  /* Just for safety */
  if (index == NULL || base == NULL)
	return(NULL);

  /* Find out the number of elements in the array */
  if (!isscalar(index)) {
	error("scalar type required for array index");
	return(NULL);
  }
  elementnum = index->def.s.max - index->def.s.min + 1;
#ifdef PARANOID
  if (elementnum < 1)
	interror(3, "number of elements in array < 1");
#endif

  /* Determine the total size of the new array type */
  size = elementnum * base->size;
  if (size > MAX_ARRAY_SIZE) {
	error("array size too large");
	return(NULL);
  }

  /* Let's see if we have a type like this already */
  for (tp = typetab; tp != NULL; tp = tp->next)
	if (tp->type == EXPR_ARRAY &&
	    tp->def.a.elementnum == elementnum &&
	    tp->def.a.indextype == index &&
	    tp->def.a.basetype == base)
		break;

  /* We can now safely create a new enumeration type */
  if (tp == NULL) {
	tp = newtype();
	tp->type = EXPR_ARRAY;
	tp->def.a.elementnum = elementnum;
	tp->def.a.indextype = index;
	tp->def.a.basetype = base;
	tp->size = size;
	tp->next = typetab;
	typetab = tp;
  }
  return(tp);
}



/*
 *****************************************************************************
 *
 * Return a pointer to a record type. The symbols which are part of the
 * record have been created by the parser in the global symbol list with
 * a higher level than the current level. We have to take all these
 * symbols out and insert them into the record specification.
 */
static struct typesdef *recordcreate()
{
  struct sym *sp1, *sp2, *sp3;
  struct sym *elements;
  struct typesdef *tp;
  int elementnum;
  addr_t size;

  /* Create our own elements list from the symbol list */
  elements = NULL;
  elementnum = 0;
  sp2 = NULL;
  sp1 = symtab;
  while (sp1 != NULL) {
	if (sp1->level >= curlevel + reclevel) {
		/* This is our symbol -> remove it from global list */
		if (sp2 == NULL)
			symtab = sp1->next;
		else
			sp2->next = sp1->next;
		sp3 = sp1->next;
		sp1->next = elements;
		elements = sp1;
		elementnum++;
		sp1 = sp3;
	} else {
		sp2 = sp1;
		sp1 = sp1->next;
	}
  }

  /* Now scan through our own symbol list and determine the record size */
  size = 0;
  for (sp1 = elements; sp1 != NULL; sp1 = sp1->next) {
#ifdef PARANOID
	if (!isvarsym(sp1))
		interror(100, "invalid symbol list in record specification");
#endif
	sp1->def.v.attr = ATTR_NONE;
	sp1->level = -1;		/* required for code generator */
	sp1->addr = size;
	size += sp1->def.v.t->size;
  }

  /* Check for some errors */
  if (size > MAX_REC_SIZE) {
	error("record too large");
	while (elements != NULL) {
		sp1 = elements->next;
		free(sp1->name);
		free(sp1);
		elements = sp1;
	}
	return(NULL);
  }
#ifdef PARANOID
  if (elementnum == 0 || elements == NULL)
	interror(101, "empty symbol list in record definition");
#endif

  /* Let's see if we have a type like this already */
  for (tp = typetab; tp != NULL; tp = tp->next)
	if (tp->type == EXPR_RECORD &&
	    tp->def.r.elementnum == elementnum) {
		sp1 = tp->def.r.elements;
		sp2 = elements;
		while (sp1 != NULL && sp2 != NULL)
			if (sp1->type != varsym || sp1->type != sp2->type ||
			    sp1->def.v.t != sp2->def.v.t ||
			    strcmp(sp1->name, sp2->name))
				break;
		if (sp1 == NULL && sp2 == NULL)
			break;
	}

  /* If we have a type like this already, we can return it */
  if (tp != NULL) {
	while (elements != NULL) {
		sp1 = elements->next;
		free(sp1->name);
		free(sp1);
		elements = sp1;
	}
	return(tp);
  }

  /* We can now safely create a new record type */
  tp = newtype();
  tp->type = EXPR_RECORD;
  tp->def.r.elementnum = elementnum;
  tp->def.r.elements = elements;
  tp->size = size;
  tp->next = typetab;
  typetab = tp;
  return(tp);
}



/*
 *****************************************************************************
 *
 * Lookup the symbol table and assign all symbols, which are arguments to
 * the current procedure or function, to that procedure. It returns the
 * total size of the arguments on the stack.
 */
static addr_t procargassign(proc, level)
struct sym *proc;
int level;
{
  struct sym *sp;
  addr_t varsize;
  addr_t argptr;
  int i, j;

  /*
   * Count all arguments to the procedure, and recalculate the offsets to
   * the procedure arguments. This will also reverse the order of the
   * arguments.
   */
  i = MAX_EXPRS - 1;
  argptr = 4;
  for (sp = symtab; sp != NULL; sp = sp->next) {
	if (sp->level != level)
		break;
	if (isvarsym(sp) && sp->addr > 0) {
		if (i < 0) {
			error("too many arguments");
			break;
		}
		varsize = sp->addr;
		sp->addr = argptr;
		argptr += varsize;
		proc->def.f.args[i] = sp->def.v.t;
		proc->def.f.attribs[i] = sp->def.v.attr;
		i--;
	}
  }

  /* Move the arguments down and clear all unused table entries */
  for (i++, j = 0; i < MAX_EXPRS; i++, j++) {
	proc->def.f.args[j] = proc->def.f.args[i];
	proc->def.f.attribs[j] = proc->def.f.attribs[i];
  }
  proc->def.f.argnum = j;
  for ( ; j < MAX_EXPRS; j++) {
	proc->def.f.args[j] = NULL;
	proc->def.f.attribs[j] = ATTR_NONE;
  }
  return(argptr);
}



/*
 *****************************************************************************
 *
 * Check if two types are assignable to each other
 */
static int checkassign(type1, type2)
struct typesdef *type1;
struct typesdef *type2;
{
  /* If the types are exactly the same, we can always assign */
  if (type1 == type2)
	return(TRUE);

  /* Enumerations have to be exactly the same */
  if (type1->type == EXPR_ENUM || type2->type == EXPR_ENUM)
	return(type1 == type2);

  /*
   * With scalars, the types have to be the same, and the ranges must not
   * be disjunct.
   */
  if (isscalar(type1) && isscalar(type2) &&
      type1->type == type2->type &&
      type1->def.s.min < type2->def.s.max &&
      type1->def.s.max > type2->def.s.min)
	return(TRUE);

  /*
   * Strings are always possible regardless of sizes, because the runtime
   * module will care for the sizes and truncate if necessary.
   */
  if (type1->type == EXPR_STRING &&
      type1->type == type2->type)
	return(TRUE);

  /* In all other cases, assignment is not possible */
  return(FALSE);
}



/*
 *****************************************************************************
 *
 * Check that an expression has the correct subexpressions for a function
 * or procedure call, and reorder the subexpressions correctly.
 */
static struct expr *setprocexpr(sp, ep)
struct sym *sp;
struct expr *ep;
{
  struct expr *tmpexpr;
  int i, j;

  if (!isfuncsym(sp))
	error("unknown procedure or function");
  else if (sp->def.f.argnum == ep->exprnum) {
	/* Reverse the expression order and reorg each expression subtree */
	j = sp->def.f.argnum - 1;
	for (i = 0; i < (sp->def.f.argnum / 2); i++, j--) {
		tmpexpr = ep->exprlist[i];
		ep->exprlist[i] = ep->exprlist[j];
		ep->exprlist[j] = tmpexpr;
	}

	/* Reorganize all subtrees and check for correct arguments */
	for (i = 0; i < sp->def.f.argnum; i++) {
		ep->exprlist[i] = reorg(ep->exprlist[i]);
		if (sp->def.f.attribs[i] == ATTR_REF &&
		    !isvariable(ep->exprlist[i])) {
			error("variable required for reference argument");
			break;
		}
		if (!checkassign(sp->def.f.args[i], ep->exprlist[i]->type)) {
			error("invalid type for argument in function call");
			break;
		}
		if (isconst(ep->exprlist[i]) &&
		    isscalar(ep->exprlist[i]->type) &&
		    (getord(ep->exprlist[i]) < sp->def.f.args[i]->def.s.min ||
		     getord(ep->exprlist[i]) > sp->def.f.args[i]->def.s.max))
			warning("subclass range exceeded in function argument");
	}

	/* If no error occurred, set the resulting expression correctly */
	if (i >= sp->def.f.argnum) {
		ep->type = sp->def.f.ret;
		ep->opcode = sp->def.f.opcode;
		ep->spec.func = sp;
		return (ep);
	}
  } else
	error("invalid number of arguments to function/procedure call");

  /* In case of error delete all expression subtrees */
  delexpr(ep);
  return(NULL);
}


#line 698 "mglparse.y"
typedef union {
	struct symlist  *symlist;	/* List of symbols in variable decl */
	struct typelist *typelist;	/* List of types in array decl */
	struct typesdef *type;		/* Expression type */
	struct sym      *symbol;	/* Pointer to symbol */
	struct expr     *expr;		/* expression tree */
	char            *inaddr;	/* IP address */
	char            *string;	/* string buffer */
	char             chrarg;	/* character argument */
	int              intarg;	/* integer argument */
	int              op;		/* arithmetic operation */
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		341
#define	YYFLAG		-32768
#define	YYNTBASE	64

#define YYTRANSLATE(x) ((unsigned)(x) <= 307 ? yytranslate[x] : 147)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,    61,     2,     2,     2,    57,
    58,     2,     2,    55,     2,    53,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    56,    54,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    59,     2,    60,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    62,     2,    63,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     7,     9,    12,    15,    18,    22,    26,    30,
    34,    38,    40,    44,    48,    50,    52,    54,    58,    62,
    65,    67,    71,    75,    78,    80,    84,    88,    90,    92,
    94,    96,    99,   103,   107,   108,   112,   116,   123,   125,
   129,   132,   136,   140,   143,   145,   148,   150,   156,   160,
   163,   165,   171,   172,   174,   181,   190,   193,   196,   197,
   199,   201,   203,   207,   209,   210,   214,   215,   219,   221,
   223,   225,   229,   230,   232,   234,   236,   238,   240,   242,
   244,   246,   248,   250,   252,   254,   256,   258,   260,   264,
   271,   275,   279,   284,   286,   291,   294,   297,   301,   304,
   305,   308,   313,   317,   319,   322,   326,   329,   331,   336,
   339,   342,   346,   349,   354,   357,   362,   365,   367,   373,
   377,   380,   385,   387,   392,   395,   396,   399,   402,   403,
   407,   411,   414,   417,   422,   426,   428,   430,   432,   434,
   436,   440,   444,   448,   452,   456,   460,   463,   466,   468,
   470,   472,   474,   479,   486,   490,   492,   494,   496,   501,
   506,   507,   509,   511,   515,   519,   521,   523,   525,   527,
   529,   531,   533,   537,   541,   545,   549,   553,   557,   560,
   563,   564,   566,   567,   569,   570,   572,   573,   575,   577,
   579,   581,   583,   589,   590,   594,   598,   600
};

static const short yyrhs[] = {    83,
    53,     0,    65,    83,    53,     0,    66,     0,    83,    54,
     0,    86,    54,     0,    65,    66,     0,    65,    83,    54,
     0,    65,    86,    54,     0,    15,    73,    54,     0,    16,
    69,    54,     0,    17,    71,    54,     0,    68,     0,    67,
    55,    68,     0,    67,    55,     1,     0,     1,     0,     6,
     0,    70,     0,    69,    54,    70,     0,     6,    10,   133,
     0,     1,    54,     0,    72,     0,    71,    54,    72,     0,
     6,    10,    75,     0,     1,    54,     0,    74,     0,    73,
    54,    74,     0,    67,    56,    75,     0,    76,     0,    78,
     0,    80,     0,     1,     0,     6,    77,     0,   134,    50,
   134,     0,    57,    67,    58,     0,     0,    59,   133,    60,
     0,    59,     1,    60,     0,    21,    59,    79,    60,    47,
    75,     0,    76,     0,    79,    55,    76,     0,    79,     1,
     0,    81,    73,    82,     0,    81,    73,     1,     0,    81,
     1,     0,    22,     0,    54,    49,     0,    49,     0,    84,
    87,    85,    96,   143,     0,    18,     6,    54,     0,    18,
     1,     0,   142,     0,    88,    87,    95,    96,   143,     0,
     0,    65,     0,    19,    94,    57,    89,    58,    54,     0,
    20,    94,    57,    89,    58,    56,    75,    54,     0,    19,
     1,     0,    20,     1,     0,     0,    90,     0,     1,     0,
    91,     0,    90,    54,    91,     0,    74,     0,     0,    15,
    92,    74,     0,     0,    16,    93,    74,     0,     6,     0,
   142,     0,    97,     0,    96,    54,    97,     0,     0,    23,
     0,    24,     0,    44,     0,    98,     0,    99,     0,   100,
     0,   101,     0,   103,     0,   108,     0,   109,     0,   114,
     0,   116,     0,   118,     0,   121,     0,     1,     0,   125,
    46,   122,     0,    61,    59,   122,    60,    46,   122,     0,
     1,    46,   122,     0,   125,    46,     1,     0,     6,    57,
   131,    58,     0,     6,     0,     6,    57,     1,    58,     0,
    30,   144,     0,    30,     1,     0,    25,   122,   102,     0,
    25,     1,     0,     0,    39,   144,     0,   104,   141,   105,
    49,     0,    26,   102,   145,     0,   106,     0,   105,   106,
     0,   107,    56,    96,     0,    27,   122,     0,    45,     0,
    35,   125,   102,   145,     0,    35,     1,     0,   110,   111,
     0,   110,   111,   112,     0,    28,   122,     0,   139,   142,
    96,   143,     0,   139,    97,     0,   113,   142,    96,   143,
     0,   113,    97,     0,    29,     0,   115,   140,   142,    96,
   143,     0,   115,   140,    97,     0,    42,   122,     0,   117,
    96,    38,   122,     0,    37,     0,    32,   122,   119,   120,
     0,    32,     1,     0,     0,    33,   146,     0,    33,     1,
     0,     0,   138,    34,   146,     0,   138,    34,     1,     0,
    36,     6,     0,    36,     1,     0,    61,    59,   122,    60,
     0,    57,   122,    58,     0,   123,     0,   124,     0,   125,
     0,   130,     0,   129,     0,   122,    13,   122,     0,   122,
    11,   122,     0,   122,    12,   122,     0,   122,     8,   122,
     0,   122,     9,   122,     0,   122,    10,   122,     0,    14,
   122,     0,     8,   122,     0,   126,     0,   127,     0,   128,
     0,     6,     0,   125,    59,   122,    60,     0,   125,    59,
   122,    55,   122,    60,     0,   125,    53,     6,     0,     4,
     0,     3,     0,     7,     0,     6,    57,   131,    58,     0,
     6,    57,     1,    58,     0,     0,   132,     0,   122,     0,
   122,    55,   132,     0,    57,   133,    58,     0,   136,     0,
   137,     0,   135,     0,   129,     0,   135,     0,   129,     0,
     6,     0,   133,    13,   133,     0,   133,    11,   133,     0,
   133,    12,   133,     0,   133,     8,   133,     0,   133,     9,
   133,     0,   133,    10,   133,     0,    14,   133,     0,     8,
   133,     0,     0,    40,     0,     0,    41,     0,     0,    43,
     0,     0,    47,     0,    62,     0,    48,     0,    63,     0,
    49,     0,    59,   122,    55,   122,    60,     0,     0,   138,
    31,   122,     0,   138,    31,     1,     0,   133,     0,     5,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   774,   776,   779,   781,   782,   783,   784,   785,   788,   790,
   791,   801,   806,   811,   816,   822,   841,   843,   846,   875,
   889,   891,   894,   907,   921,   923,   926,   945,   947,   948,
   949,   963,  1011,  1063,  1073,  1078,  1094,  1108,  1139,  1152,
  1164,  1184,  1196,  1204,  1211,  1218,  1220,  1230,  1244,  1258,
  1264,  1298,  1312,  1314,  1317,  1323,  1330,  1335,  1342,  1344,
  1345,  1348,  1350,  1353,  1355,  1355,  1356,  1356,  1359,  1376,
  1436,  1438,  1441,  1443,  1444,  1445,  1446,  1447,  1448,  1449,
  1450,  1451,  1452,  1453,  1454,  1455,  1456,  1457,  1467,  1515,
  1549,  1555,  1569,  1580,  1593,  1607,  1609,  1622,  1643,  1649,
  1651,  1661,  1668,  1675,  1677,  1680,  1684,  1699,  1719,  1770,
  1783,  1788,  1794,  1807,  1809,  1812,  1814,  1817,  1831,  1836,
  1842,  1862,  1875,  1889,  1902,  1908,  1913,  1920,  1926,  1931,
  1938,  1951,  1967,  1980,  2012,  2013,  2014,  2015,  2016,  2017,
  2027,  2053,  2078,  2103,  2138,  2171,  2206,  2229,  2260,  2262,
  2263,  2266,  2309,  2330,  2375,  2450,  2462,  2477,  2497,  2535,
  2543,  2552,  2558,  2568,  2583,  2585,  2586,  2587,  2588,  2592,
  2594,  2597,  2631,  2657,  2682,  2707,  2742,  2775,  2806,  2829,
  2860,  2862,  2865,  2867,  2870,  2872,  2875,  2877,  2880,  2882,
  2885,  2887,  2897,  2934,  2946,  2958,  2965,  2979
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","QSTRING",
"NUM","INADDR","ID","CHR","ADDOP","MULOP","COMPARISON","OROP","XOROP","ANDOP",
"NOTOP","VAR","CONST","TYPE","SCREEN","PROCEDURE","FUNCTION","ARRAY","RECORD",
"RETURN","RESTART","PRINT","SELECT","ITEM","IF","ELSE","GOTOXY","TIMEOUT","LOAD",
"FROM","GATEWAY","GET","MENU","REPEAT","UNTIL","AT","WITH","THEN","WHILE","DO",
"BREAK","DEFAULT","ASSIGN","OF","CBEGIN","END","DOTS","THEN_PREC","UMINUS","'.'",
"';'","','","':'","'('","')'","'['","']'","'$'","'{'","'}'","mgl","blocks","declblock",
"id_list","single_id","constdecls","const_declaration","typedecls","type_declaration",
"vardecls","var_declaration","type_spec","type_single","string_length","type_array",
"index_list","type_record","record_name","record_end","screen","screen_name",
"screen_begin","procedure","proc_blocks","proc_def","proc_args","proc_arg_block",
"proc_arg_decl","@1","@2","proc_name","proc_begin","commands","command","assignment",
"callproc","gotoxy","print","print_coordinates","select","select_name","items",
"item","item_name","get","if","if_name","then","else","else_name","while","while_name",
"repeat","repeat_name","load","from","gateway","menu","expr","binaryop","unaryop",
"variable","var_id","var_array","var_record","constant","func","expressions",
"exprlist","const_expr","const_value","const_id","const_binaryop","const_unaryop",
"opt_with","opt_then","opt_do","opt_of","begin","end","coordinates","timeout",
"inetaddr", NULL
};
#endif

static const short yyr1[] = {     0,
    64,    64,    65,    65,    65,    65,    65,    65,    66,    66,
    66,    67,    67,    67,    67,    68,    69,    69,    70,    70,
    71,    71,    72,    72,    73,    73,    74,    75,    75,    75,
    75,    76,    76,    76,    77,    77,    77,    78,    79,    79,
    79,    80,    80,    80,    81,    82,    82,    83,    84,    84,
    85,    86,    87,    87,    88,    88,    88,    88,    89,    89,
    89,    90,    90,    91,    92,    91,    93,    91,    94,    95,
    96,    96,    97,    97,    97,    97,    97,    97,    97,    97,
    97,    97,    97,    97,    97,    97,    97,    97,    98,    98,
    98,    98,    99,    99,    99,   100,   100,   101,   101,   102,
   102,   103,   104,   105,   105,   106,   107,   107,   108,   108,
   109,   109,   110,   111,   111,   112,   112,   113,   114,   114,
   115,   116,   117,   118,   118,   119,   119,   119,   120,   120,
   120,   121,   121,   122,   122,   122,   122,   122,   122,   122,
   123,   123,   123,   123,   123,   123,   124,   124,   125,   125,
   125,   126,   127,   127,   128,   129,   129,   129,   130,   130,
   131,   131,   132,   132,   133,   133,   133,   133,   133,   134,
   134,   135,   136,   136,   136,   136,   136,   136,   137,   137,
   138,   138,   139,   139,   140,   140,   141,   141,   142,   142,
   143,   143,   144,   145,   145,   145,   146,   146
};

static const short yyr2[] = {     0,
     2,     3,     1,     2,     2,     2,     3,     3,     3,     3,
     3,     1,     3,     3,     1,     1,     1,     3,     3,     2,
     1,     3,     3,     2,     1,     3,     3,     1,     1,     1,
     1,     2,     3,     3,     0,     3,     3,     6,     1,     3,
     2,     3,     3,     2,     1,     2,     1,     5,     3,     2,
     1,     5,     0,     1,     6,     8,     2,     2,     0,     1,
     1,     1,     3,     1,     0,     3,     0,     3,     1,     1,
     1,     3,     0,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     3,     6,
     3,     3,     4,     1,     4,     2,     2,     3,     2,     0,
     2,     4,     3,     1,     2,     3,     2,     1,     4,     2,
     2,     3,     2,     4,     2,     4,     2,     1,     5,     3,
     2,     4,     1,     4,     2,     0,     2,     2,     0,     3,
     3,     2,     2,     4,     3,     1,     1,     1,     1,     1,
     3,     3,     3,     3,     3,     3,     2,     2,     1,     1,
     1,     1,     4,     6,     3,     1,     1,     1,     4,     4,
     0,     1,     1,     3,     3,     1,     1,     1,     1,     1,
     1,     1,     3,     3,     3,     3,     3,     3,     2,     2,
     0,     1,     0,     1,     0,     1,     0,     1,     1,     1,
     1,     1,     5,     0,     3,     3,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,     0,     0,     0,     0,     3,     0,    53,
     0,    53,    15,    16,     0,    12,     0,    25,     0,     0,
     0,    17,     0,     0,     0,    21,    50,     0,    57,    69,
     0,    58,     0,     6,     0,     0,     1,     4,    54,     0,
     0,     5,     0,     0,     0,     0,    20,     0,     0,    24,
     0,     0,    49,     0,     0,     2,     7,     8,     0,   190,
   189,     0,    51,     0,    70,    14,    13,    31,   157,   156,
    35,   158,     0,    45,     0,    27,    28,    29,    30,     0,
   171,     0,   170,    26,   172,     0,     0,     0,   169,    19,
   168,   166,   167,    18,    23,    22,    15,    65,    67,    64,
     0,    60,    62,     0,    88,    94,    74,    75,     0,   100,
     0,     0,     0,     0,     0,   123,     0,    76,     0,     0,
    71,    77,    78,    79,    80,    81,   187,    82,    83,   183,
    84,   185,    85,     0,    86,    87,     0,   149,   150,   151,
     0,     0,    32,     0,     0,    44,     0,     0,   180,   179,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    99,   152,     0,     0,     0,     0,
   100,   136,   137,   138,   140,   139,     0,   194,   113,    97,
     0,    96,   125,   126,   110,   152,   100,   133,   132,   121,
     0,   192,     0,   191,    48,   188,     0,   184,   111,     0,
   186,     0,     0,     0,     0,     0,    52,     0,     0,    39,
     0,    34,    43,    47,     0,    42,    33,   165,   176,   177,
   178,   174,   175,   173,    66,    68,    55,    63,     0,    91,
     0,   163,     0,   162,     0,   148,   147,     0,     0,     0,
     0,     0,     0,     0,     0,    98,   101,   182,     0,   103,
     0,     0,   129,   194,     0,    72,     0,   108,     0,   104,
     0,   118,   112,     0,   115,     0,   120,     0,     0,    92,
    89,   155,     0,    37,    36,    41,     0,     0,    46,     0,
    95,     0,    93,     0,     0,   135,     0,   144,   145,   146,
   142,   143,   141,     0,     0,   128,   198,   197,   127,   124,
     0,   109,     0,   107,   102,   105,     0,   117,     0,     0,
     0,   122,     0,   153,    40,     0,    56,   164,   160,   159,
   134,   196,   195,     0,     0,     0,   106,     0,   114,   119,
     0,    38,   193,   131,   130,    90,   116,   154,     0,     0,
     0
};

static const short yydefgoto[] = {   339,
    39,     8,    15,    16,    21,    22,    25,    26,    17,   100,
    76,    77,   143,    78,   211,    79,    80,   216,    40,    10,
    62,    11,    41,    12,   101,   102,   103,   158,   159,    31,
    64,   120,   121,   122,   123,   124,   125,   178,   126,   127,
   259,   260,   261,   128,   129,   130,   199,   263,   264,   131,
   132,   133,   134,   135,   253,   300,   136,   232,   172,   173,
   174,   138,   139,   140,   175,   176,   233,   234,   298,    82,
    91,    92,    93,   249,   200,   202,   197,    63,   195,   182,
   250,   299
};

static const short yypact[] = {   678,
    31,   218,   245,   251,   255,   257,   678,-32768,    52,   678,
   -25,   678,-32768,-32768,   243,-32768,   -14,-32768,     5,    51,
    40,-32768,    59,   107,    83,-32768,-32768,    91,-32768,-32768,
   135,-32768,   139,-32768,   269,   144,-32768,-32768,   678,   146,
   -18,-32768,   -18,   259,   536,    33,-32768,   575,   155,-32768,
   536,   343,-32768,    30,    30,-32768,-32768,-32768,   161,-32768,
-32768,   345,-32768,   345,-32768,-32768,-32768,-32768,-32768,-32768,
    84,-32768,   162,-32768,    31,-32768,-32768,-32768,-32768,   291,
-32768,   185,-32768,-32768,-32768,   575,   575,   575,-32768,   691,
-32768,-32768,-32768,-32768,-32768,-32768,   192,-32768,-32768,-32768,
   196,   189,-32768,   204,   220,   163,-32768,-32768,   475,   240,
    79,    13,   484,   304,   331,-32768,    79,-32768,   232,   148,
-32768,-32768,-32768,-32768,-32768,-32768,   254,-32768,-32768,   267,
-32768,   293,-32768,   419,-32768,-32768,    43,-32768,-32768,-32768,
   148,   561,-32768,    62,   131,   287,    66,   394,-32768,   168,
   611,   575,   575,   575,   575,   575,   575,    31,    31,   280,
   212,   294,    79,   187,-32768,   296,    79,    79,    79,   297,
   679,-32768,-32768,    39,-32768,-32768,   306,   126,   697,-32768,
    79,-32768,-32768,   114,-32768,-32768,    82,-32768,-32768,   697,
    79,-32768,   303,-32768,-32768,-32768,   -10,-32768,   347,   258,
-32768,   258,     0,   493,   366,    79,-32768,   314,   229,-32768,
    15,-32768,-32768,-32768,    27,-32768,-32768,-32768,   374,-32768,
   346,   150,   150,   168,-32768,-32768,-32768,-32768,   536,   697,
   326,   625,   327,-32768,   461,-32768,   260,   617,    79,    79,
    79,    79,    79,    79,    79,-32768,-32768,-32768,   355,-32768,
   673,   310,   104,   126,   265,-32768,    79,-32768,   138,-32768,
   334,-32768,-32768,   258,-32768,   345,-32768,   345,    79,-32768,
   697,-32768,   586,-32768,-32768,-32768,    62,   348,-32768,   338,
-32768,    79,-32768,   344,   349,-32768,   592,   395,-32768,   370,
   221,   221,   260,   502,    79,-32768,-32768,   691,-32768,-32768,
   362,-32768,   357,   697,-32768,-32768,   387,-32768,   345,   148,
   148,   697,    79,-32768,-32768,   536,-32768,-32768,-32768,-32768,
-32768,-32768,   697,   598,   520,    79,   364,   148,-32768,-32768,
   604,-32768,-32768,-32768,-32768,   697,-32768,-32768,   409,   416,
-32768
};

static const short yypgoto[] = {-32768,
   421,     8,   351,   383,-32768,   379,-32768,   378,   353,    10,
   -49,  -135,-32768,-32768,-32768,-32768,-32768,-32768,    18,-32768,
-32768,    19,   422,-32768,   380,-32768,   276,-32768,-32768,   432,
-32768,   -60,  -180,-32768,-32768,-32768,-32768,  -116,-32768,-32768,
-32768,   180,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   -90,-32768,-32768,
   -54,-32768,-32768,-32768,   -45,-32768,   205,   164,   -24,   302,
   -44,-32768,-32768,   199,-32768,-32768,-32768,   -38,  -129,   281,
   206,   128
};


#define	YYLAST		728


static const short yytable[] = {    81,
    83,    95,    89,   141,    65,    81,    83,   137,   210,   137,
    18,   207,   256,   180,    34,   276,   257,     9,   171,   265,
   179,   267,   184,    90,    35,    36,   190,    13,    42,    60,
    97,    13,    14,    13,   258,    14,    14,   269,    14,    46,
    89,    89,    89,    61,    98,    99,    34,    -9,    -9,    -9,
    -9,    -9,    -9,   193,   246,    84,    59,    36,    47,   187,
    48,   149,   150,   151,    69,    70,   213,    71,    72,   277,
   254,   181,   230,   203,   278,   279,   236,   237,   238,   137,
    -9,    69,    70,   308,   166,    72,   167,   -59,   204,    18,
   251,   205,   168,    49,    -9,   205,    89,   206,    81,    83,
   255,   206,    81,    83,    37,    38,    89,    89,    89,    89,
    89,    89,    50,   271,   214,   273,    51,   209,    75,   215,
   177,   240,   241,   242,   243,   244,   245,   219,   220,   221,
   222,   223,   224,  -172,   205,   169,    52,  -181,   137,   170,
   206,   315,   142,   248,    53,   137,   252,   137,   287,   288,
   289,   290,   291,   292,   293,    19,  -181,   152,   153,   154,
    20,   266,   157,   268,   257,   248,   304,   225,   226,   -10,
   -10,   -10,   -10,   -10,   -10,   152,   153,   154,   312,   280,
   329,   330,   258,    81,    83,    44,   305,   231,   212,    69,
    70,    54,   166,    72,   167,    55,   192,    58,   337,    38,
   168,   193,   -10,   323,   324,   310,    89,   311,  -152,   137,
   194,   137,    13,   137,    57,  -152,   -10,    14,    19,   164,
   144,  -152,   331,    20,    84,   309,    98,    99,   240,   241,
   242,    81,    83,   245,   148,   336,   152,   153,   154,   155,
   156,   157,   161,   169,  -161,    23,   327,   170,   328,   -61,
    24,    27,   137,   160,   137,    29,    28,    32,   105,    66,
    30,   162,    30,   106,    14,   163,   332,   240,   241,   242,
    81,    83,   240,   241,   242,   243,   244,   245,   177,    89,
   107,   108,   109,   110,   -73,   111,   -73,   112,   275,   113,
   191,   146,   114,   115,   116,   -73,    14,    44,    45,   117,
   196,   118,   -73,   105,   185,    60,   -73,   198,   106,   186,
   296,   -73,    69,    70,   297,    85,    72,    86,   119,    61,
   -73,    56,    57,    87,   303,   107,   108,   109,   110,   -73,
   111,   188,   112,   227,   113,   201,   189,   114,   115,   116,
   -73,   -15,   -15,    23,   117,   105,   118,   -73,    24,   229,
   106,   -73,   235,   152,   153,   239,   -73,   -11,   -11,   -11,
   -11,   -11,   -11,   119,   181,   -73,    88,   107,   108,   109,
   110,   272,   111,   274,   112,   262,   113,   240,   241,   114,
   115,   116,   153,   281,   283,   294,   117,   105,   118,   307,
   -11,   317,   106,   -73,   316,   325,    69,    70,   -73,    85,
    72,   319,   326,   241,   -11,   119,   320,   -73,   340,   107,
   108,   109,   110,   -73,   111,   341,   112,   193,   113,   105,
     7,   114,   115,   116,   106,   145,    67,    94,   117,    96,
   118,   -73,   147,    43,   104,   -73,   228,    33,   306,   285,
   -73,   107,   108,   109,   110,   318,   111,   119,   112,   217,
   113,   301,   335,   114,   115,   116,   -73,   247,     0,   302,
   117,   284,   118,    69,    70,     0,   166,    72,   167,     0,
     0,     0,   -73,     0,   168,   165,     0,    69,    70,   119,
   166,    72,   167,     0,   183,     0,    69,    70,   168,   166,
    72,   167,     0,   270,     0,    69,    70,   168,   166,    72,
   167,     0,   322,     0,    69,    70,   168,   166,    72,   167,
     0,     0,     0,     0,     0,   168,     0,   169,  -161,     0,
   334,   170,    69,    70,   297,    85,    72,    86,     0,     0,
     0,   169,     0,    87,     0,   170,    68,     0,    69,    70,
   169,    71,    72,     0,   170,     0,     0,     0,     0,   169,
     0,     0,     0,   170,     0,     0,    73,    74,   169,     0,
     0,   208,   170,    69,    70,     0,    85,    72,    86,     0,
     0,     0,     0,     0,    87,     0,    88,    69,    70,     0,
    85,    72,    86,     0,     0,     0,     0,     0,    87,     0,
     0,     0,    75,   240,   241,   242,   243,   244,   245,   240,
   241,   242,   243,   244,   245,   240,   241,   242,   243,   244,
   245,   240,   241,   242,   243,   244,   245,    88,   152,   153,
   154,   155,   156,   157,   240,   241,   242,   243,   244,   245,
     0,    88,   240,   241,   242,   243,   244,   245,     0,     0,
   313,     0,     0,     0,     0,   314,     0,     0,     0,     0,
     0,   321,     0,     0,     0,     0,     0,   333,     0,     0,
     0,     0,     0,   338,     0,     0,     0,     0,   218,     0,
     0,     0,     0,     0,   286,     0,     0,     0,     0,   282,
   240,   241,   242,   243,   244,   245,   240,   241,   242,   243,
   244,   245,     1,     2,     3,     4,     5,     6,   152,   153,
   154,   155,   156,   157,   240,   241,   242,   243,   244,   245,
     0,     0,     0,     0,     0,     0,     0,   177,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   295
};

static const short yycheck[] = {    45,
    45,    51,    48,    64,    43,    51,    51,    62,   144,    64,
     1,   141,   193,     1,     7,     1,    27,     0,   109,   200,
   111,   202,   113,    48,     7,     7,   117,     1,    54,    48,
     1,     1,     6,     1,    45,     6,     6,    38,     6,    54,
    86,    87,    88,    62,    15,    16,    39,    15,    16,    17,
    18,    19,    20,    54,   171,    46,    39,    39,    54,   114,
    10,    86,    87,    88,     3,     4,     1,     6,     7,    55,
   187,    59,   163,   134,    60,    49,   167,   168,   169,   134,
    48,     3,     4,   264,     6,     7,     8,    58,    46,    80,
   181,    53,    14,    54,    62,    53,   142,    59,   144,   144,
   191,    59,   148,   148,    53,    54,   152,   153,   154,   155,
   156,   157,    54,   204,    49,   206,    10,   142,    57,    54,
    39,     8,     9,    10,    11,    12,    13,   152,   153,   154,
   155,   156,   157,    50,    53,    57,    54,    34,   193,    61,
    59,   277,    59,    40,    54,   200,    33,   202,   239,   240,
   241,   242,   243,   244,   245,     1,    31,     8,     9,    10,
     6,   200,    13,   202,    27,    40,   257,   158,   159,    15,
    16,    17,    18,    19,    20,     8,     9,    10,   269,   229,
   310,   311,    45,   229,   229,    55,    49,     1,    58,     3,
     4,    57,     6,     7,     8,    57,    49,    54,   328,    54,
    14,    54,    48,   294,   295,   266,   252,   268,    46,   264,
    63,   266,     1,   268,    54,    53,    62,     6,     1,    57,
    59,    59,   313,     6,   215,   264,    15,    16,     8,     9,
    10,   277,   277,    13,    50,   326,     8,     9,    10,    11,
    12,    13,    54,    57,    58,     1,   307,    61,   309,    58,
     6,     1,   307,    58,   309,     1,     6,     1,     1,     1,
     6,    58,     6,     6,     6,    46,   316,     8,     9,    10,
   316,   316,     8,     9,    10,    11,    12,    13,    39,   325,
    23,    24,    25,    26,    27,    28,    29,    30,    60,    32,
    59,     1,    35,    36,    37,    38,     6,    55,    56,    42,
    47,    44,    45,     1,     1,    48,    49,    41,     6,     6,
     1,    54,     3,     4,     5,     6,     7,     8,    61,    62,
    63,    53,    54,    14,    60,    23,    24,    25,    26,    27,
    28,     1,    30,    54,    32,    43,     6,    35,    36,    37,
    38,    55,    56,     1,    42,     1,    44,    45,     6,    56,
     6,    49,    57,     8,     9,    59,    54,    15,    16,    17,
    18,    19,    20,    61,    59,    63,    57,    23,    24,    25,
    26,     6,    28,    60,    30,    29,    32,     8,     9,    35,
    36,    37,     9,    58,    58,    31,    42,     1,    44,    56,
    48,    54,     6,    49,    47,    34,     3,     4,    54,     6,
     7,    58,    46,     9,    62,    61,    58,    63,     0,    23,
    24,    25,    26,    27,    28,     0,    30,    54,    32,     1,
     0,    35,    36,    37,     6,    75,    44,    49,    42,    52,
    44,    45,    80,    12,    55,    49,   161,     6,   259,   235,
    54,    23,    24,    25,    26,   282,    28,    61,    30,   148,
    32,   253,   325,    35,    36,    37,    38,   177,    -1,   254,
    42,     1,    44,     3,     4,    -1,     6,     7,     8,    -1,
    -1,    -1,    54,    -1,    14,     1,    -1,     3,     4,    61,
     6,     7,     8,    -1,     1,    -1,     3,     4,    14,     6,
     7,     8,    -1,     1,    -1,     3,     4,    14,     6,     7,
     8,    -1,     1,    -1,     3,     4,    14,     6,     7,     8,
    -1,    -1,    -1,    -1,    -1,    14,    -1,    57,    58,    -1,
     1,    61,     3,     4,     5,     6,     7,     8,    -1,    -1,
    -1,    57,    -1,    14,    -1,    61,     1,    -1,     3,     4,
    57,     6,     7,    -1,    61,    -1,    -1,    -1,    -1,    57,
    -1,    -1,    -1,    61,    -1,    -1,    21,    22,    57,    -1,
    -1,     1,    61,     3,     4,    -1,     6,     7,     8,    -1,
    -1,    -1,    -1,    -1,    14,    -1,    57,     3,     4,    -1,
     6,     7,     8,    -1,    -1,    -1,    -1,    -1,    14,    -1,
    -1,    -1,    57,     8,     9,    10,    11,    12,    13,     8,
     9,    10,    11,    12,    13,     8,     9,    10,    11,    12,
    13,     8,     9,    10,    11,    12,    13,    57,     8,     9,
    10,    11,    12,    13,     8,     9,    10,    11,    12,    13,
    -1,    57,     8,     9,    10,    11,    12,    13,    -1,    -1,
    55,    -1,    -1,    -1,    -1,    60,    -1,    -1,    -1,    -1,
    -1,    60,    -1,    -1,    -1,    -1,    -1,    60,    -1,    -1,
    -1,    -1,    -1,    60,    -1,    -1,    -1,    -1,    58,    -1,
    -1,    -1,    -1,    -1,    58,    -1,    -1,    -1,    -1,    55,
     8,     9,    10,    11,    12,    13,     8,     9,    10,    11,
    12,    13,    15,    16,    17,    18,    19,    20,     8,     9,
    10,    11,    12,    13,     8,     9,    10,    11,    12,    13,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    55
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 12:
#line 803 "mglparse.y"
{
			yyval.symlist = yyvsp[0].symlist;
		;
    break;}
case 13:
#line 807 "mglparse.y"
{
			yyvsp[0].symlist->next = yyvsp[-2].symlist;
			yyval.symlist = yyvsp[0].symlist;
		;
    break;}
case 14:
#line 812 "mglparse.y"
{
			delsymlist(yyvsp[-2].symlist);
			yyval.symlist = NULL;
		;
    break;}
case 15:
#line 817 "mglparse.y"
{
			yyval.symlist = NULL;
		;
    break;}
case 16:
#line 824 "mglparse.y"
{
			struct symlist *slp;

			slp = newsymlist();
			slp->sym = yyvsp[0].symbol;
			slp->next = NULL;
			yyval.symlist = slp;
		;
    break;}
case 19:
#line 848 "mglparse.y"
{
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			else if (yyvsp[-1].op != CMD_EQ)
				error("equal sign expected");
			else if (!isconst(yyvsp[0].expr))
				error("expression not constant");
			else if (exprtype(yyvsp[0].expr) != EXPR_NUM &&
			         exprtype(yyvsp[0].expr) != EXPR_STRING &&
			         exprtype(yyvsp[0].expr) != EXPR_CHAR &&
			         exprtype(yyvsp[0].expr) != EXPR_BOOL)
				error("invalid constant expression type");
			else if ((yyvsp[-2].symbol = checksym(yyvsp[-2].symbol)) != NULL) {
				yyvsp[-2].symbol->type = constsym;
				yyvsp[-2].symbol->def.c = yyvsp[0].expr->spec.cval;
				yyvsp[-2].symbol->def.c.t = yyvsp[0].expr->type;
				if (exprtype(yyvsp[0].expr) == EXPR_STRING) {
					yyvsp[-2].symbol->def.c.val.s =
						strdup(yyvsp[0].expr->spec.cval.val.s);
					if (yyvsp[-2].symbol->def.c.val.s == NULL) {
						perror(progname);
						exit(EXIT_MEMORY);
					}
				}
			}
			delexpr(yyvsp[0].expr);
		;
    break;}
case 20:
#line 876 "mglparse.y"
{
			error("constant declaration expected");
			yyerrok;
		;
    break;}
case 23:
#line 896 "mglparse.y"
{
			if (yyvsp[-1].op != CMD_EQ)
				error("equal sign expected");
			else if (yyvsp[0].type == NULL)
				error("type specification expected");
			else if ((yyvsp[-2].symbol = checksym(yyvsp[-2].symbol)) != NULL) {
				/* Setup the symbol to contain the type */
				yyvsp[-2].symbol->type = typesym;
				yyvsp[-2].symbol->def.t = yyvsp[0].type;
			}
		;
    break;}
case 24:
#line 908 "mglparse.y"
{
			error("type declaration expected");
			yyerrok;
		;
    break;}
case 27:
#line 928 "mglparse.y"
{
			if (yyvsp[-2].symlist == NULL)
				error("missing variable name(s)");
			else if (yyvsp[0].type == NULL)
				error("type specification expected");
			else
				assignvartype(yyvsp[0].type, yyvsp[-2].symlist);
		;
    break;}
case 28:
#line 946 "mglparse.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 29:
#line 947 "mglparse.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 30:
#line 948 "mglparse.y"
{ yyval.type = yyvsp[0].type; ;
    break;}
case 31:
#line 950 "mglparse.y"
{
			error("type specification expected");
			yyval.type = NULL;
		;
    break;}
case 32:
#line 965 "mglparse.y"
{
			struct typesdef *tp;

			tp = NULL;
			if (yyvsp[-1].symbol == NULL || isnosym(yyvsp[-1].symbol))
				error("unknown type identifier");
			else if (!istypesym(yyvsp[-1].symbol))
				error("identifier is not a type");
			else if (yyvsp[-1].symbol->def.t->type != EXPR_STRING && yyvsp[0].intarg != 0)
				error("length specification not allowed");
			else if (yyvsp[-1].symbol->def.t->type != EXPR_STRING)
				/* Assign non-string type */
				tp = yyvsp[-1].symbol->def.t;
			else if (yyvsp[-1].symbol->level >= 0 && yyvsp[0].intarg != 0)
				error("cannot redeclare string type");
			else if (yyvsp[-1].symbol->level >= 0)
				/* Assign user defined string type */
				tp = yyvsp[-1].symbol->def.t;
			else {
				/*
				 * Strings are a bit special because different
				 * sizes are actually different types. There-
				 * fore we have to create a new type with the
				 * required size.
				 */
				if (yyvsp[0].intarg == 0)
					yyvsp[0].intarg = MAX_STR_LEN;

				for (tp = typetab; tp != NULL; tp = tp->next)
					if (tp->type == EXPR_STRING &&
					    tp->size == yyvsp[0].intarg)
						break;

				if (tp == NULL) {
					tp = newtype();
					tp->size = yyvsp[0].intarg;
					tp->type = EXPR_STRING;
					tp->def.a.elementnum = yyvsp[0].intarg;
					tp->def.a.indextype = &strindex_type;
					tp->def.a.basetype = &char_type;
					tp->next = typetab;
					typetab = tp;
				}
			}
			yyval.type = tp;
		;
    break;}
case 33:
#line 1012 "mglparse.y"
{
			/* Find a subclass specification of a scalar */

			int submin, submax;
			struct typesdef *tp;

			tp = NULL;
			if ((yyvsp[-2].expr = reorg(yyvsp[-2].expr)) == NULL ||
			    (yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (!isconst(yyvsp[-2].expr) || !isconst(yyvsp[0].expr))
				error("subclass specification has to be constant");
			else if (!isscalar(yyvsp[-2].expr->type) || !isscalar(yyvsp[0].expr->type))
				error("subclass specification has to be scalar");
			else if (exprtype(yyvsp[-2].expr) != exprtype(yyvsp[0].expr) ||
			         yyvsp[-2].expr->type->def.s.min != yyvsp[0].expr->type->def.s.min ||
			         yyvsp[0].expr->type->def.s.max != yyvsp[0].expr->type->def.s.max)
				error("subclass involves different types");
			else {
				submin = getord(yyvsp[-2].expr);
				submax = getord(yyvsp[0].expr);
				if (submin > submax ||
				    submin < yyvsp[-2].expr->type->def.s.min ||
				    submax > yyvsp[-2].expr->type->def.s.max)
					error("invalid subclass range");
				else {
					/* See if we have the type already */
					for (tp = typetab; tp != NULL;
								tp = tp->next)
						if (tp->type == exprtype(yyvsp[-2].expr) &&
						    tp->def.s.min == submin &&
						    tp->def.s.max == submax)
							break;

					if (tp == NULL) {
						/* No, make a new one */
						tp = newtype();
						tp->size = yyvsp[-2].expr->type->size;
						tp->type = yyvsp[-2].expr->type->type;
						tp->def.s.min = submin;
						tp->def.s.max = submax;
						tp->def.s.boundaddr = -1;
						tp->next = typetab;
						typetab = tp;
					}
				}
			}
			delexpr(yyvsp[-2].expr);
			delexpr(yyvsp[0].expr);
			yyval.type = tp;
		;
    break;}
case 34:
#line 1064 "mglparse.y"
{
			yyval.type = NULL;
			if (yyvsp[-1].symlist == NULL)
				error("missing names in enumeration");
			else
				yyval.type = enumcreate(yyvsp[-1].symlist);
		;
    break;}
case 35:
#line 1075 "mglparse.y"
{
			yyval.intarg = 0;
		;
    break;}
case 36:
#line 1079 "mglparse.y"
{
			yyval.intarg = 0;
			if ((yyvsp[-1].expr = reorg(yyvsp[-1].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[-1].expr) != EXPR_NUM)
				error("length must be a number");
			else if (!isconst(yyvsp[-1].expr))
				error("length must be constant");
			else if (yyvsp[-1].expr->spec.cval.val.i < 1 ||
			         yyvsp[-1].expr->spec.cval.val.i > MAX_STR_LEN)
				error("invalid length");
			else
				yyval.intarg = yyvsp[-1].expr->spec.cval.val.i;
			delexpr(yyvsp[-1].expr);
		;
    break;}
case 37:
#line 1095 "mglparse.y"
{
			error("number expected");
			yyval.intarg = 0;
		;
    break;}
case 38:
#line 1110 "mglparse.y"
{
			struct typesdef *tp;
			struct typelist *tlp1, *tlp2;

			tp = NULL;
			if (yyvsp[-3].typelist == NULL)
				error("index type for array missing");
			else if (yyvsp[0].type == NULL)
				error("base type for array missing");
			else if ((tp = arraycreate(yyvsp[-3].typelist->t, yyvsp[0].type)) != NULL) {
				for (tlp1 = yyvsp[-3].typelist->next; tlp1 != NULL;
							tlp1 = tlp1->next) {
					tp = arraycreate(tlp1->t, tp);
					if (tp == NULL)
						break;
				}
				if (tlp1 != NULL)
					tp = NULL;
			}
			tlp1 = yyvsp[-3].typelist;
			while (tlp1 != NULL) {
				tlp2 = tlp1->next;
				free(tlp1);
				tlp1 = tlp2;
			}
			yyval.type = tp;
		;
    break;}
case 39:
#line 1141 "mglparse.y"
{
			struct typelist *tlp;

			tlp = NULL;
			if (yyvsp[0].type != NULL) {
				tlp = newtypelist();
				tlp->t = yyvsp[0].type;
				tlp->next = NULL;
			}
			yyval.typelist = tlp;
		;
    break;}
case 40:
#line 1153 "mglparse.y"
{
			struct typelist *tlp;

			tlp = NULL;
			if (yyvsp[0].type != NULL) {
				tlp = newtypelist();
				tlp->t = yyvsp[0].type;
				tlp->next = yyvsp[-2].typelist;
			}
			yyval.typelist = tlp;
		;
    break;}
case 41:
#line 1165 "mglparse.y"
{
			struct typelist *tlp1, *tlp2;

			for (tlp1 = yyvsp[-1].typelist; tlp1 != NULL; tlp1 = tlp1->next) {
				tlp2 = tlp1->next;
				free(tlp1);
				tlp1 = tlp2;
			}
			yyval.typelist = NULL;
		;
    break;}
case 42:
#line 1186 "mglparse.y"
{
			/*
			 * The vardecls rule created symbols in the global
			 * list which have a higher level than the
			 * current level. These have to be sorted out.
			 */
			yyval.type = recordcreate();
			if (reclevel > 0)
				reclevel--;
		;
    break;}
case 43:
#line 1197 "mglparse.y"
{
			curlevel += reclevel;
			delsymbols();
			curlevel -= reclevel;
			if (reclevel > 0)
				reclevel--;
		;
    break;}
case 44:
#line 1205 "mglparse.y"
{
			if (reclevel > 0)
				reclevel--;
		;
    break;}
case 45:
#line 1213 "mglparse.y"
{
			reclevel++;
		;
    break;}
case 48:
#line 1232 "mglparse.y"
{
			/* Delete all symbols defined in this nesting level */
			if (curlevel > 0) {
				delsymbols();
				curlevel--;
			}

			/* Return to caller */
			docmd(CODE_PROC_END, NULL, NULL, NULL);
		;
    break;}
case 49:
#line 1246 "mglparse.y"
{
			if ((yyvsp[-1].symbol = checksym(yyvsp[-1].symbol)) == NULL)
				YYERROR;
			else if (curlevel >= MAX_LEVELS) {
				error("too many nesting levels");
				YYERROR;
			} else {
				curlevel++;
				symstack[curlevel] = yyvsp[-1].symbol;
				levelptr[curlevel] = 0;
			}
		;
    break;}
case 50:
#line 1259 "mglparse.y"
{
			error("screen identifier expected");
		;
    break;}
case 51:
#line 1266 "mglparse.y"
{
			struct sym symbol;

			/* Restore pointer to current procedure */
			curproc = symstack[curlevel];
			curproc->type = funcsym;
			curproc->addr = codeptr;
			curproc->level = curlevel - 1;
			startadr = codeptr;

			/*
			 * We use a symbol to pass the global values to the
			 * code generator
			 */
			symbol.type = nosym;
			symbol.addr = levelptr[curlevel];
			symbol.level = curlevel;
			docmd(CODE_PROC_START, &symbol, NULL, NULL);
			curproc->def.f.restartaddr = codeptr;
			curproc->def.f.opcode = CMD_MENU;
			curproc->def.f.ret = NULL;
			curproc->def.f.argnum = 0;
		;
    break;}
case 52:
#line 1300 "mglparse.y"
{
			/* Delete all symbols defined in this nesting level */
			if (curlevel > 0) {
				delsymbols();
				curlevel--;
			}

			/* Return to caller */
			docmd(CODE_PROC_END, NULL, NULL, NULL);
		;
    break;}
case 55:
#line 1319 "mglparse.y"
{
			symstack[curlevel]->def.f.ret = NULL;
			inargdef = FALSE;
		;
    break;}
case 56:
#line 1324 "mglparse.y"
{
			if (yyvsp[-1].type == NULL)
				error("missing function type");
			symstack[curlevel]->def.f.ret = yyvsp[-1].type;
			inargdef = FALSE;
		;
    break;}
case 57:
#line 1331 "mglparse.y"
{
			inargdef = FALSE;
			error("procedure identifier expected");
		;
    break;}
case 58:
#line 1336 "mglparse.y"
{
			inargdef = FALSE;
			error("function identifier expected");
		;
    break;}
case 61:
#line 1345 "mglparse.y"
{ curattrib = ATTR_NONE; ;
    break;}
case 65:
#line 1355 "mglparse.y"
{ curattrib = ATTR_REF; ;
    break;}
case 66:
#line 1355 "mglparse.y"
{ curattrib = ATTR_NONE; ;
    break;}
case 67:
#line 1356 "mglparse.y"
{ curattrib = ATTR_CONST; ;
    break;}
case 68:
#line 1356 "mglparse.y"
{ curattrib = ATTR_NONE; ;
    break;}
case 69:
#line 1361 "mglparse.y"
{
			if ((yyvsp[0].symbol = checksym(yyvsp[0].symbol)) == NULL)
				YYERROR;
			else if (curlevel >= MAX_LEVELS) {
				error("too many nesting levels");
				YYERROR;
			} else {
				inargdef = TRUE;
				curlevel++;
				symstack[curlevel] = yyvsp[0].symbol;
				levelptr[curlevel] = 0;
			}
		;
    break;}
case 70:
#line 1378 "mglparse.y"
{
			addr_t argptr;
			struct sym symbol;

			/*
			 * For functions care for space for the return value,
			 * if we have a scalar type. Otherwise the space has
			 * to be provided by the caller, and it's address
			 * pushed onto the stack before calling.
			 */
			curproc = symstack[curlevel];
			if (curproc->def.f.ret != NULL &&
			    isscalar(curproc->def.f.ret)) {
				levelptr[curlevel] += 2;
				curproc->def.f.retaddr = -levelptr[curlevel];
			} else
				curproc->def.f.retaddr = 0;
			curproc->type = funcsym;
			curproc->addr = codeptr;
			curproc->level = curlevel - 1;

			/*
			 * We use a symbol to pass the global values to the
			 * code generator
			 */
			symbol.type = nosym;
			symbol.addr = levelptr[curlevel];
			symbol.level = curlevel;
			docmd(CODE_PROC_START, &symbol, NULL, NULL);
			curproc->def.f.restartaddr = codeptr;
			curproc->def.f.opcode = CMD_USERFUNC;
			curproc->def.f.argnum = 0;

			/*
			 * Count all arguments to the procedure and reverse
			 * the order of the arguments.
			 */
			argptr = procargassign(curproc, curlevel);

			/*
			 * If we don't have a scalar return type, the
			 * return value's space is pointed to by a value
			 * pushed before the arguments. Adjust the return
			 * value pointer accordingly.
			 */
			if (curproc->def.f.ret != NULL &&
			    !isscalar(curproc->def.f.ret))
				curproc->def.f.retaddr = argptr;
		;
    break;}
case 74:
#line 1443 "mglparse.y"
{ docmd(CODE_PROC_END, NULL, NULL, NULL); ;
    break;}
case 75:
#line 1444 "mglparse.y"
{ docmd(CODE_RESTART, NULL, NULL, NULL); ;
    break;}
case 76:
#line 1445 "mglparse.y"
{ docmd(CODE_BREAK, NULL, NULL, NULL); ;
    break;}
case 89:
#line 1469 "mglparse.y"
{
			struct varinfo *vp;

			if (yyvsp[-2].expr == NULL || (yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;

			if (!isvariable(yyvsp[-2].expr)) {
				error("variable expected for lvalue");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
				break;
			}

			/* Find last item in var list -> base record */
			for (vp = &(yyvsp[-2].expr->spec.var); vp != NULL; vp = vp->next)
				if (vp->next == NULL)
					break;
			if (vp == NULL || vp->symbol == NULL ||
			    (!isvarsym(vp->symbol) && !isfuncsym(vp->symbol))) {
				error("variable expected for lvalue");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
				break;
			}
			if (vp->symbol->def.v.attr == ATTR_CONST) {
				error("cannot assign to variable declared constant");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
				break;
			}

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type)) {
				error("variable type doesn't match expression");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
				break;
			}

			if (isconst(yyvsp[0].expr) && isscalar(yyvsp[0].expr->type) &&
			    (getord(yyvsp[0].expr) < yyvsp[-2].expr->type->def.s.min ||
			     getord(yyvsp[0].expr) > yyvsp[-2].expr->type->def.s.max))
				warning("subclass range exceeded in scalar assignment");
			docmd(CODE_ASSIGN, NULL, yyvsp[-2].expr, yyvsp[0].expr);
			delexpr(yyvsp[-2].expr);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 90:
#line 1516 "mglparse.y"
{
			struct expr *ep;

			/* We need this for the code generator */
			static struct sym putbootp = {
				funcsym, "", 0, -1, {
				  { 0, 0, CMD_PUTBOOTP, 2, NULL,
				    { &int_type, &string_type },
				    { ATTR_NONE, ATTR_CONST }
				  }
				}, NULL
			};

			if ((yyvsp[-3].expr = reorg(yyvsp[-3].expr)) == NULL ||
			    (yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[-3].expr) != EXPR_NUM ||
			    exprtype(yyvsp[0].expr) != EXPR_STRING) {
				error("invalid types in BOOTP assignment");
				delexpr(yyvsp[-3].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = putbootp.def.f.ret;
				ep->opcode = putbootp.def.f.opcode;
				ep->exprnum = putbootp.def.f.argnum;
				ep->exprlist[0] = reorg(yyvsp[-3].expr);
				ep->exprlist[1] = reorg(yyvsp[0].expr);
				ep->spec.func = &putbootp;
				docmd(CODE_CALL_PROC, NULL, ep, NULL);
				delexpr(ep);
			}
		;
    break;}
case 91:
#line 1550 "mglparse.y"
{
			error("variable identifier expected");
			delexpr(yyvsp[0].expr);
			yyerrok;
		;
    break;}
case 92:
#line 1556 "mglparse.y"
{
			error("expression expected");
			delexpr(yyvsp[-2].expr);
		;
    break;}
case 93:
#line 1571 "mglparse.y"
{
			if (!isfuncsym(yyvsp[-3].symbol) || yyvsp[-3].symbol->def.f.ret != NULL)
				error("symbol is not a procedure");
			else if (yyvsp[-1].expr != NULL &&
			         (yyvsp[-1].expr = setprocexpr(yyvsp[-3].symbol, yyvsp[-1].expr)) != NULL) {
				docmd(CODE_CALL_PROC, NULL, yyvsp[-1].expr, NULL);
				delexpr(yyvsp[-1].expr);
			}
		;
    break;}
case 94:
#line 1581 "mglparse.y"
{
			/* Special case for procedures without arguments */
			struct expr *ep;

			ep = newexpr();
			ep->exprnum = 0;
			if (!isfuncsym(yyvsp[0].symbol) || yyvsp[0].symbol->def.f.ret != NULL)
				error("symbol is not a procedure");
			else if ((ep = setprocexpr(yyvsp[0].symbol, ep)) != NULL)
				docmd(CODE_CALL_PROC, NULL, ep, NULL);
			delexpr(ep);
		;
    break;}
case 95:
#line 1594 "mglparse.y"
{
			error("invalid procedure arguments");
			yyerrok;
		;
    break;}
case 96:
#line 1608 "mglparse.y"
{ /* handled in coordinates already */ ;
    break;}
case 97:
#line 1610 "mglparse.y"
{
			error("coordinates expected");
		;
    break;}
case 98:
#line 1624 "mglparse.y"
{
			if ((yyvsp[-1].expr = reorg(yyvsp[-1].expr)) == NULL)
				error("expression expected in print command");
			else switch (exprtype(yyvsp[-1].expr)) {
				case EXPR_NUM:
					docmd(CODE_INT_PRINT, NULL, yyvsp[-1].expr, NULL);
					break;
				case EXPR_STRING:
					docmd(CODE_STR_PRINT, NULL, yyvsp[-1].expr, NULL);
					break;
				case EXPR_CHAR:
					docmd(CODE_CHAR_PRINT, NULL, yyvsp[-1].expr, NULL);
					break;
				default:
					error("invalid expression in print command");
					break;
			}
			delexpr(yyvsp[-1].expr);
		;
    break;}
case 99:
#line 1644 "mglparse.y"
{
			error("expression expected in print command");
		;
    break;}
case 101:
#line 1651 "mglparse.y"
{ /* everything handled in coordinates */ ;
    break;}
case 102:
#line 1663 "mglparse.y"
{
			docmd(CODE_ENDNEST, NULL, NULL, NULL);
		;
    break;}
case 103:
#line 1670 "mglparse.y"
{
			docmd(CODE_SELECT, NULL, yyvsp[0].expr, NULL);
		;
    break;}
case 107:
#line 1686 "mglparse.y"
{
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL ||
			    exprtype(yyvsp[0].expr) != EXPR_NUM)
				error("numerical value required for item number");
			else if (!isconst(yyvsp[0].expr))
				error("constant value required for item number");
			else if (yyvsp[0].expr->spec.cval.val.i < 0 ||
			         yyvsp[0].expr->spec.cval.val.i > 9)
				error("item identifier out of range");
			else
				docmd(CODE_ITEM, NULL, yyvsp[0].expr, NULL);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 108:
#line 1700 "mglparse.y"
{
			struct expr ep;

			memset(&ep, 0, sizeof(ep));
			ep.type = &int_type;
			ep.opcode = CMD_CONST;
			ep.exprnum = 0;
			ep.spec.cval.val.i = -1;
			docmd(CODE_ITEM, NULL, &ep, NULL);
		;
    break;}
case 109:
#line 1721 "mglparse.y"
{
			struct varinfo *vp;
			int ok = FALSE;

			if (yyvsp[-2].expr == NULL || !isvariable(yyvsp[-2].expr)) {
				error("variable expected in get command");
				delexpr(yyvsp[-2].expr);
				break;
			}

			/* Find last item in var list -> base record */
			for (vp = &(yyvsp[-2].expr->spec.var); vp != NULL; vp = vp->next)
				if (vp->next == NULL)
					break;
			if (vp == NULL || vp->symbol == NULL ||
			    (!isvarsym(vp->symbol) && !isfuncsym(vp->symbol))) {
				error("variable expected in get command");
				delexpr(yyvsp[-2].expr);
				break;
			}
			if (vp->symbol->def.v.attr == ATTR_CONST) {
				error("cannot use variable which is declared constant");
				delexpr(yyvsp[-2].expr);
				break;
			}

			switch (exprtype(yyvsp[-2].expr)) {
				case EXPR_NUM:
					if ((ok = checkassign(yyvsp[-2].expr->type, &int_type)))
						docmd(CODE_INT_GET, NULL,
								yyvsp[-2].expr, yyvsp[0].expr);
					break;
				case EXPR_STRING:
					if ((ok = checkassign(yyvsp[-2].expr->type, &string_type)))
						docmd(CODE_STR_GET, NULL,
								yyvsp[-2].expr, yyvsp[0].expr);
					break;
				case EXPR_CHAR:
					if ((ok = checkassign(yyvsp[-2].expr->type, &char_type)))
						docmd(CODE_CHAR_GET, NULL,
								yyvsp[-2].expr, yyvsp[0].expr);
					break;
				default:
					break;
			}
			if (!ok)
				error("invalid type in get command");
			delexpr(yyvsp[-2].expr);
		;
    break;}
case 110:
#line 1771 "mglparse.y"
{
			error("variable expected in get command");
		;
    break;}
case 111:
#line 1785 "mglparse.y"
{
			docmd(CODE_ENDNEST, NULL, NULL, NULL);
		;
    break;}
case 112:
#line 1789 "mglparse.y"
{
			docmd(CODE_ENDNEST, NULL, NULL, NULL);
		;
    break;}
case 113:
#line 1796 "mglparse.y"
{
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[0].expr) != EXPR_BOOL)
				error("boolean expression expected");
			else
				docmd(CODE_IF, NULL, yyvsp[0].expr, NULL);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 118:
#line 1819 "mglparse.y"
{
			docmd(CODE_ELSE, NULL, NULL, NULL);
		;
    break;}
case 119:
#line 1833 "mglparse.y"
{
			docmd(CODE_ENDNEST, NULL, NULL, NULL);
		;
    break;}
case 120:
#line 1837 "mglparse.y"
{
			docmd(CODE_ENDNEST, NULL, NULL, NULL);
		;
    break;}
case 121:
#line 1844 "mglparse.y"
{
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[0].expr) != EXPR_BOOL)
				error("boolean expression expected");
			else
				docmd(CODE_WHILE, NULL, yyvsp[0].expr, NULL);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 122:
#line 1864 "mglparse.y"
{
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[0].expr) != EXPR_BOOL)
				error("boolean expression expected");
			else
				docmd(CODE_ENDNEST, NULL, yyvsp[0].expr, NULL);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 123:
#line 1877 "mglparse.y"
{
			docmd(CODE_REPEAT, NULL, NULL, NULL);
		;
    break;}
case 124:
#line 1891 "mglparse.y"
{
			if ((yyvsp[-2].expr = reorg(yyvsp[-2].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[-2].expr) != EXPR_STRING) {
				error("filename expected in load command");
				delexpr(yyvsp[-2].expr);
				YYERROR;
			}
			docmd(CODE_LOAD, NULL, yyvsp[-2].expr, NULL);
			delexpr(yyvsp[-2].expr);
		;
    break;}
case 125:
#line 1903 "mglparse.y"
{
			error("filename expected in load command");
		;
    break;}
case 126:
#line 1910 "mglparse.y"
{
			docmd(CODE_PUSH_IPADDR, NULL, NULL, NULL);
		;
    break;}
case 127:
#line 1914 "mglparse.y"
{
			struct sym symbol;

			symbol.name = yyvsp[0].inaddr;
			docmd(CODE_PUSH_IPADDR, &symbol, NULL, NULL);
		;
    break;}
case 128:
#line 1921 "mglparse.y"
{
			yyerror("IP address expected");
		;
    break;}
case 129:
#line 1928 "mglparse.y"
{
			docmd(CODE_PUSH_IPADDR, NULL, NULL, NULL);
		;
    break;}
case 130:
#line 1932 "mglparse.y"
{
			struct sym symbol;

			symbol.name = yyvsp[0].inaddr;
			docmd(CODE_PUSH_IPADDR, &symbol, NULL, NULL);
		;
    break;}
case 131:
#line 1939 "mglparse.y"
{
			yyerror("IP address expected");
		;
    break;}
case 132:
#line 1953 "mglparse.y"
{
			struct expr exp;

			if (!isfuncsym(yyvsp[0].symbol) || yyvsp[0].symbol->def.f.opcode != CMD_MENU)
				error("symbol in menu command is not a screen");
			else {
				memset(&exp, 0, sizeof(exp));
				exp.type = NULL;
				exp.opcode = CMD_MENU;
				exp.exprnum = 0;
				exp.spec.func = yyvsp[0].symbol;
				docmd(CODE_CALL_PROC, NULL, &exp, NULL);
			}
		;
    break;}
case 133:
#line 1968 "mglparse.y"
{
			error("menu identification expected in menu command");
		;
    break;}
case 134:
#line 1982 "mglparse.y"
{
			struct expr *ep;

			/* We need this for the code generator */
			static struct sym getbootp = {
				funcsym, "", 0, 0, {
				  { 0, 0, CMD_GETBOOTP, 1, &string_type,
				    { &int_type },
				    { ATTR_NONE }
				  }
				}, NULL
			};

			yyval.expr = NULL;
			if (yyvsp[-1].expr == NULL)
				break;

			if (exprtype(yyvsp[-1].expr) != EXPR_NUM) {
				error("invalid BOOTP tag");
				delexpr(yyvsp[-1].expr);
			} else {
				ep = newexpr();
				ep->type = getbootp.def.f.ret;
				ep->opcode = getbootp.def.f.opcode;
				ep->exprnum = getbootp.def.f.argnum;
				ep->exprlist[0] = reorg(yyvsp[-1].expr);
				ep->spec.func = &getbootp;
				yyval.expr = ep;
			}
		;
    break;}
case 135:
#line 2012 "mglparse.y"
{ yyval.expr = yyvsp[-1].expr; ;
    break;}
case 136:
#line 2013 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 137:
#line 2014 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 138:
#line 2015 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 139:
#line 2016 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 140:
#line 2017 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 141:
#line 2029 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 142:
#line 2054 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 143:
#line 2079 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 144:
#line 2104 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (yyvsp[-1].op == '+' &&
			    ((exprtype(yyvsp[-2].expr) == EXPR_CHAR ||
			      exprtype(yyvsp[-2].expr) == EXPR_STRING) &&
			     (exprtype(yyvsp[0].expr) == EXPR_CHAR ||
			      exprtype(yyvsp[0].expr) == EXPR_STRING))) {
				ep = newexpr();
				ep->type = &string_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			           exprtype(yyvsp[-2].expr) != EXPR_NUM) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 145:
#line 2139 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (yyvsp[-1].op == '*' &&
			    exprtype(yyvsp[-2].expr) == EXPR_CHAR &&
			    exprtype(yyvsp[0].expr) == EXPR_NUM) {
				ep = newexpr();
				ep->type = &string_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			           exprtype(yyvsp[-2].expr) != EXPR_NUM) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 146:
#line 2172 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (isnonscalar(yyvsp[-2].expr->type) &&
			     exprtype(yyvsp[-2].expr) != EXPR_STRING) ||
			    (isnonscalar(yyvsp[0].expr->type) &&
			     exprtype(yyvsp[0].expr) != EXPR_STRING)) {
				error("invalid comparison");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &bool_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 147:
#line 2208 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[0].expr == NULL)
				break;

			if (exprtype(yyvsp[0].expr) != EXPR_BOOL &&
			    exprtype(yyvsp[0].expr) != EXPR_NUM) {
				error("NOT operation not allowed");
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[0].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 1;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 148:
#line 2230 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[0].expr == NULL)
				break;

			if (exprtype(yyvsp[0].expr) != EXPR_NUM) {
				error("unary operation not allowed");
				delexpr(yyvsp[0].expr);
			} else if (yyvsp[-1].op == '-') {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 1;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (yyvsp[-1].op == '+') {
				yyval.expr = yyvsp[0].expr;
			}
		;
    break;}
case 149:
#line 2261 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 150:
#line 2262 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 151:
#line 2263 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 152:
#line 2268 "mglparse.y"
{
			struct expr *ep;
			struct typesdef *tp;

			yyval.expr = NULL;
			if (isnosym(yyvsp[0].symbol) || yyvsp[0].symbol == NULL)
				yyerror("symbol not defined");
			else if isconstsym(yyvsp[0].symbol) {
				ep = newexpr();
				ep->opcode = CMD_CONST;
				ep->exprnum = 0;
				ep->type = yyvsp[0].symbol->def.c.t;
				ep->spec.cval = yyvsp[0].symbol->def.c;
				if (yyvsp[0].symbol->def.c.t->type == EXPR_STRING &&
				    (ep->spec.cval.val.s =
				     strdup(yyvsp[0].symbol->def.c.val.s)) == NULL) {
					perror(progname);
					exit(EXIT_MEMORY);
				}
				yyval.expr = ep;
			} else if (!isvarsym(yyvsp[0].symbol) && !isfuncsym(yyvsp[0].symbol))
				error("symbol is not a variable or function");
			else if (isfuncsym(yyvsp[0].symbol) && yyvsp[0].symbol->def.f.ret == NULL)
				error("cannot use a procedure in expression");
			else if (isfuncsym(yyvsp[0].symbol) && yyvsp[0].symbol != curproc)
				error("cannot access return value in different function");
			else {
				tp = isvarsym(yyvsp[0].symbol) ? yyvsp[0].symbol->def.v.t : yyvsp[0].symbol->def.f.ret;
				ep = newexpr();
				ep->opcode = CMD_VAR;
				ep->exprnum = 0;
				ep->type = tp;
				ep->spec.var.symbol = yyvsp[0].symbol;
				ep->spec.var.type = tp;
				ep->spec.var.index = NULL;
				ep->spec.var.next = NULL;
				yyval.expr = ep;
			}
		;
    break;}
case 153:
#line 2311 "mglparse.y"
{
			yyval.expr = NULL;
			if ((yyvsp[-1].expr = reorg(yyvsp[-1].expr)) == NULL)
				error("expression expected as array index");
			else if (yyvsp[-3].expr == NULL || !isvariable(yyvsp[-3].expr) ||
			         (exprtype(yyvsp[-3].expr) != EXPR_ARRAY &&
			          exprtype(yyvsp[-3].expr) != EXPR_STRING))
				error("array or string variable expected");
			else if (!isscalar(yyvsp[-1].expr->type))
				error("scalar type expected for array index");
			else if (!checkassign(yyvsp[-3].expr->type->def.a.indextype,
								yyvsp[-1].expr->type))
				error("invalid scalar type for array index");
			else {
				yyvsp[-3].expr->type = yyvsp[-3].expr->type->def.a.basetype;
				yyvsp[-3].expr->spec.var.index = yyvsp[-1].expr;
				yyval.expr = yyvsp[-3].expr;
			}
		;
    break;}
case 154:
#line 2331 "mglparse.y"
{
			struct expr *ep;

			/* We need this for the code generator */
			static struct sym strsub = {
				funcsym, "", 0, -1, {
				  { 0, 0, CMD_STRSUB, 3, &string_type,
				    { &string_type, &int_type, &int_type },
				    { ATTR_CONST, ATTR_NONE, ATTR_NONE }
				  }
				}, NULL
			};

			yyval.expr = NULL;
			if ((yyvsp[-3].expr = reorg(yyvsp[-3].expr)) == NULL ||
			    (yyvsp[-1].expr = reorg(yyvsp[-1].expr)) == NULL)
				YYERROR;
			if (yyvsp[-5].expr == NULL || !isvariable(yyvsp[-5].expr) ||
			    exprtype(yyvsp[-5].expr) != EXPR_STRING) {
				error("string variable expected");
				delexpr(yyvsp[-5].expr);
				delexpr(yyvsp[-3].expr);
				delexpr(yyvsp[-1].expr);
			} else if (exprtype(yyvsp[-3].expr) != EXPR_NUM ||
			           exprtype(yyvsp[-3].expr) != EXPR_NUM) {
				error("string subrange indices have to be numerical");
				delexpr(yyvsp[-5].expr);
				delexpr(yyvsp[-3].expr);
				delexpr(yyvsp[-1].expr);
			} else {
				ep = newexpr();
				ep->type = strsub.def.f.ret;
				ep->opcode = strsub.def.f.opcode;
				ep->exprnum = strsub.def.f.argnum;
				ep->exprlist[0] = yyvsp[-5].expr;
				ep->exprlist[1] = yyvsp[-3].expr;
				ep->exprlist[2] = yyvsp[-1].expr;
				ep->spec.func = &strsub;
				yyval.expr = ep;
			}

		;
    break;}
case 155:
#line 2377 "mglparse.y"
{
			struct sym *sp;
			struct varinfo *vp;
			struct expr *ep;

			/* We need this for the code generator */
			static struct sym strlen = {
				funcsym, "", 0, -1, {
				  { 0, 0, CMD_STRLEN, 1, &int_type,
				    { &string_type },
				    { ATTR_CONST }
				  }
				}, NULL
			};

			/* Handle string length specially */
			if (yyvsp[-2].expr != NULL && isvariable(yyvsp[-2].expr) &&
			    exprtype(yyvsp[-2].expr) == EXPR_STRING &&
			    yyvsp[0].symbol != NULL && !strcmp(yyvsp[0].symbol->name, "len")) {
				ep = newexpr();
				ep->type = strlen.def.f.ret;
				ep->opcode = strlen.def.f.opcode;
				ep->exprnum = strlen.def.f.argnum;
				ep->exprlist[0] = reorg(yyvsp[-2].expr);
				ep->spec.func = &strlen;
				yyval.expr = ep;
				break;
			}

			/* Now handle ordinary records */
			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || !isvariable(yyvsp[-2].expr) ||
			    exprtype(yyvsp[-2].expr) != EXPR_RECORD) {
				error("record variable expected");
				break;
			}
			if (yyvsp[0].symbol == NULL) {
				error("record variant expected");
				break;
			}

			/* Find the symbol in the record item list */
			for (sp = yyvsp[-2].expr->type->def.r.elements;
					sp != NULL; sp = sp->next)
				if (!strcmp(sp->name, yyvsp[0].symbol->name))
					break;
			if (sp == NULL) {
				error("record variant unknown");
				break;
			}
#ifdef PARANOID
			if (!isvarsym(sp))
				interror(102, "invalid symbol list in record specification");
#endif

			/* Generate a new variable record */
			vp = newvarinfo();
			*vp = yyvsp[-2].expr->spec.var;
			yyvsp[-2].expr->spec.var.next = vp;
			yyvsp[-2].expr->spec.var.symbol = sp;
			yyvsp[-2].expr->spec.var.type = sp->def.v.t;
			yyvsp[-2].expr->type = sp->def.v.t;
			yyval.expr = yyvsp[-2].expr;
		;
    break;}
case 156:
#line 2452 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->opcode = CMD_CONST;
			ep->type = &int_type;
			ep->exprnum = 0;
			ep->spec.cval.val.i = yyvsp[0].intarg;
			yyval.expr = ep;
		;
    break;}
case 157:
#line 2463 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->opcode = CMD_CONST;
			ep->type = &string_type;
			ep->exprnum = 0;
			ep->spec.cval.val.s = strdup(yyvsp[0].string);
			if (ep->spec.cval.val.s == NULL) {
				perror(progname);
				exit(EXIT_MEMORY);
			}
			yyval.expr = ep;
		;
    break;}
case 158:
#line 2478 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->opcode = CMD_CONST;
			ep->type = &char_type;
			ep->exprnum = 0;
			ep->spec.cval.val.c = yyvsp[0].chrarg;
			yyval.expr = ep;
		;
    break;}
case 159:
#line 2499 "mglparse.y"
{
			yyval.expr = NULL;
			if (yyvsp[-1].expr == NULL)
				break;

			if (isnosym(yyvsp[-3].symbol)) {
				error("function not defined");
				delexpr(yyvsp[-1].expr);
			} else if (!isfuncsym(yyvsp[-3].symbol)) {
				error("symbol in expression is not a function");
				delexpr(yyvsp[-1].expr);
			} else if (!iscmdscalar(&(yyvsp[-3].symbol->def.f))) {
				/* Handle normal function call */
				yyval.expr = setprocexpr(yyvsp[-3].symbol, yyvsp[-1].expr);
			} else if (yyvsp[-1].expr->exprnum != 1) {
				error("invalid number of arguments");
				delexpr(yyvsp[-1].expr);
			} else if (!isscalar(yyvsp[-1].expr->left->type)) {
				error("scalar expression required");
				delexpr(yyvsp[-1].expr);
			} else {
				/*
				 * General scalar operations need special
				 * handling because they can operate on a
				 * variety of data types. By using the
				 * checks 'iscmdscalar' and 'isscalar' we
				 * should be pretty sure that we have a
				 * correct function call.
				 */
				yyvsp[-1].expr->type = yyvsp[-3].symbol->def.f.opcode == CMD_ORD ?
						&int_type : yyvsp[-1].expr->left->type;
				yyvsp[-1].expr->opcode = yyvsp[-3].symbol->def.f.opcode;
				yyvsp[-1].expr->spec.func = yyvsp[-3].symbol;
				yyval.expr = yyvsp[-1].expr;
			}
		;
    break;}
case 160:
#line 2536 "mglparse.y"
{
			yyval.expr = NULL;
			error("invalid function arguments");
			yyerrok;
		;
    break;}
case 161:
#line 2545 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->exprnum = 0;
			yyval.expr = ep;
		;
    break;}
case 162:
#line 2553 "mglparse.y"
{
			yyval.expr = yyvsp[0].expr;
		;
    break;}
case 163:
#line 2560 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->exprnum = 1;
			ep->exprlist[0] = yyvsp[0].expr;
			yyval.expr = ep;
		;
    break;}
case 164:
#line 2569 "mglparse.y"
{
			yyvsp[0].expr->exprlist[yyvsp[0].expr->exprnum] = yyvsp[-2].expr;
			yyvsp[0].expr->exprnum++;
			yyval.expr = yyvsp[0].expr;
		;
    break;}
case 165:
#line 2584 "mglparse.y"
{ yyval.expr = yyvsp[-1].expr; ;
    break;}
case 166:
#line 2585 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 167:
#line 2586 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 168:
#line 2587 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 169:
#line 2588 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 170:
#line 2593 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 171:
#line 2594 "mglparse.y"
{ yyval.expr = yyvsp[0].expr; ;
    break;}
case 172:
#line 2599 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (isnosym(yyvsp[0].symbol) || yyvsp[0].symbol == NULL)
				yyerror("symbol not defined");
			else if (!isconstsym(yyvsp[0].symbol))
				yyerror("constant symbol expected");
			else {
				ep = newexpr();
				ep->opcode = CMD_CONST;
				ep->exprnum = 0;
				ep->type = yyvsp[0].symbol->def.c.t;
				ep->spec.cval = yyvsp[0].symbol->def.c;
				if (yyvsp[0].symbol->def.c.t->type == EXPR_STRING &&
				    (ep->spec.cval.val.s =
				     strdup(yyvsp[0].symbol->def.c.val.s)) == NULL) {
					perror(progname);
					exit(EXIT_MEMORY);
				}
				yyval.expr = ep;
			}
		;
    break;}
case 173:
#line 2633 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 174:
#line 2658 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 175:
#line 2683 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			    (exprtype(yyvsp[-2].expr) != EXPR_NUM &&
			     exprtype(yyvsp[-2].expr) != EXPR_BOOL)) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[-2].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 176:
#line 2708 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (yyvsp[-1].op == '+' &&
			    ((exprtype(yyvsp[-2].expr) == EXPR_CHAR ||
			      exprtype(yyvsp[-2].expr) == EXPR_STRING) &&
			     (exprtype(yyvsp[0].expr) == EXPR_CHAR ||
			      exprtype(yyvsp[0].expr) == EXPR_STRING))) {
				ep = newexpr();
				ep->type = &string_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			           exprtype(yyvsp[-2].expr) != EXPR_NUM) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 177:
#line 2743 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (yyvsp[-1].op == '*' &&
			    exprtype(yyvsp[-2].expr) == EXPR_CHAR &&
			    exprtype(yyvsp[0].expr) == EXPR_NUM) {
				ep = newexpr();
				ep->type = &string_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type) ||
			           exprtype(yyvsp[-2].expr) != EXPR_NUM) {
				error("invalid operation");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 178:
#line 2776 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[-2].expr == NULL || yyvsp[0].expr == NULL)
				break;

			if (!checkassign(yyvsp[-2].expr->type, yyvsp[0].expr->type)) {
				error("invalid comparison");
				delexpr(yyvsp[-2].expr);
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = &bool_type;
				ep->exprnum = 2;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[-2].expr;
				ep->right = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 179:
#line 2808 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[0].expr == NULL)
				break;

			if (exprtype(yyvsp[0].expr) != EXPR_BOOL &&
			    exprtype(yyvsp[0].expr) != EXPR_NUM) {
				error("NOT operation not allowed");
				delexpr(yyvsp[0].expr);
			} else {
				ep = newexpr();
				ep->type = (exprtype(yyvsp[0].expr) == EXPR_NUM ?
							&int_type : &bool_type);
				ep->exprnum = 1;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[0].expr;
				yyval.expr = ep;
			}
		;
    break;}
case 180:
#line 2830 "mglparse.y"
{
			struct expr *ep;

			yyval.expr = NULL;
			if (yyvsp[0].expr == NULL)
				break;

			if (exprtype(yyvsp[0].expr) != EXPR_NUM) {
				error("unary operation not allowed");
				delexpr(yyvsp[0].expr);
			} else if (yyvsp[-1].op == '-') {
				ep = newexpr();
				ep->type = &int_type;
				ep->exprnum = 1;
				ep->opcode = yyvsp[-1].op;
				ep->left = yyvsp[0].expr;
				yyval.expr = ep;
			} else if (yyvsp[-1].op == '+') {
				yyval.expr = yyvsp[0].expr;
			}
		;
    break;}
case 193:
#line 2899 "mglparse.y"
{
			struct expr *ep;

			/* We need this for the code generator */
			static struct sym gotoxy = {
				funcsym, "", 0, -1, {
				  { 0, 0, CMD_GOTOXY, 2, NULL,
				    { &int_type, &int_type },
				    { ATTR_NONE, ATTR_NONE }
				  }
				}, NULL
			};

			if ((yyvsp[-3].expr = reorg(yyvsp[-3].expr)) == NULL ||
			    (yyvsp[-1].expr = reorg(yyvsp[-1].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[-3].expr) != EXPR_NUM ||
			    exprtype(yyvsp[-1].expr) != EXPR_NUM) {
				error("coordinate values have to be numerical");
				delexpr(yyvsp[-3].expr);
				delexpr(yyvsp[-1].expr);
			} else {
				ep = newexpr();
				ep->type = gotoxy.def.f.ret;
				ep->opcode = gotoxy.def.f.opcode;
				ep->exprnum = gotoxy.def.f.argnum;
				ep->exprlist[0] = reorg(yyvsp[-3].expr);
				ep->exprlist[1] = reorg(yyvsp[-1].expr);
				ep->spec.func = &gotoxy;
				docmd(CODE_CALL_PROC, NULL, ep, NULL);
				delexpr(ep);
			}
		;
    break;}
case 194:
#line 2936 "mglparse.y"
{
			struct expr *ep;

			ep = newexpr();
			ep->opcode = CMD_CONST;
			ep->type = &int_type;
			ep->exprnum = 0;
			ep->spec.cval.val.i = 0;
			yyval.expr = ep;
		;
    break;}
case 195:
#line 2947 "mglparse.y"
{
			yyval.expr = NULL;
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[0].expr) != EXPR_NUM) {
				error("timeout value has to be a number");
				delexpr(yyvsp[0].expr);
			} else {
				yyval.expr = yyvsp[0].expr;
			}
		;
    break;}
case 196:
#line 2959 "mglparse.y"
{
			yyval.expr = NULL;
			error("expression expected for timeout value");
		;
    break;}
case 197:
#line 2967 "mglparse.y"
{
			yyval.inaddr = NULL;
			if ((yyvsp[0].expr = reorg(yyvsp[0].expr)) == NULL)
				YYERROR;
			if (exprtype(yyvsp[0].expr) != EXPR_STRING)
				error("IP address has to be numerical or a string");
			else if (!isconst(yyvsp[0].expr))
				error("IP address has to be constant");
			else
				yyval.inaddr = getinet(yyvsp[0].expr->spec.cval.val.s);
			delexpr(yyvsp[0].expr);
		;
    break;}
case 198:
#line 2980 "mglparse.y"
{
			yyval.inaddr = yyvsp[0].inaddr;
		;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 2985 "mglparse.y"




/*
 *****************************************************************************
 *
 * Handle an internal error
 */
#ifdef PARANOID
void interror(num, msg)
int num;
char *msg;
{
  fprintf(stderr, "%s: internal error %d: %s\n", progname, num, msg);
  exit(EXIT_INTERNAL);
}
#endif



/*
 *****************************************************************************
 *
 * Print an error message
 */
void yyerror(msg)
char *msg;
{
#ifdef YYRECOVERING
  if (YYRECOVERING())
	return;
#endif

  fprintf(stderr, "%s: %d: error: %s at ", curfile, lineno, msg);
  print_token();
  fprintf(stderr, "\n");
  if (++errors > MAX_ERRS) {
	fprintf(stderr, "%s: too many errors, aborting\n", progname);
	exit(EXIT_MGL_COMPERRS);
  }
}



/*
 *****************************************************************************
 *
 * Print an error message without token
 */
void error(msg)
char *msg;
{
#ifdef YYRECOVERING
  if (YYRECOVERING())
	return;
#endif

  fprintf(stderr, "%s: %d: error: %s\n", curfile, lineno, msg);
  if (++errors > MAX_ERRS) {
	fprintf(stderr, "%s: too many errors, aborting\n", progname);
	exit(EXIT_MGL_COMPERRS);
  }
}



/*
 *****************************************************************************
 *
 * Print a warning message without a token
 */
void warning(msg)
char *msg;
{
#ifdef YYRECOVERING
  if (YYRECOVERING())
	return;
#endif

  fprintf(stderr, "%s: %d: warning: %s\n", curfile, lineno, msg);
  warnings++;
}

