/*
 * $Id: host.c,v 1.2 1997/08/12 19:17:13 begemot Exp begemot $
 * $Log: host.c,v $
 * Revision 1.2  1997/08/12 19:17:13  begemot
 * New modes, new options (show speed, sort).
 *
 * Revision 1.1  1997/08/12 16:37:50  begemot
 * Initial revision
 *
 * Revision 1.8  1995/11/09  15:30:00  begemot
 * Bug caused "Internal hash management error" msg fixed, I hope.
 *
 * Revision 1.7  1995/02/26  19:21:02  begemot
 * Some improvements (?) in hash management.
 *
 * Revision 1.6  1995/02/26  18:59:25  begemot
 * Added RCS Id & Log entries into the all source files.
 *
 */

/*
 * Copyright (C) 1994-1996 D.Gorodchanin. See COPYING for more info.
 */

#include "trafshow.h"
#include <setjmp.h>
#include <signal.h>

#define HASH_BITS 8
#define HASH_SIZE (1 << HASH_BITS)
#define HASH(x)  ((x ^ (x >> 8) ^ (x >> 16) ^ (x >> 24)) & (HASH_SIZE - 1))
#define TABLE_SIZE (HOSTS_COUNT + 1)

#define MAX_TRY 10

struct hash_entry  {
	unsigned long key;
	unsigned long seq;
	unsigned int  next;
	unsigned int  try;
	char name[MAX_HOST_NAME + 1];
};

static struct hash_entry table[TABLE_SIZE];
static unsigned int hash_table[HASH_SIZE];

static unsigned long lookup_no = 0;

static jmp_buf resolv_buf;

static void do_alarm(int sig)
{
	longjmp(resolv_buf, 0);
}

static char const * resolve(unsigned long const addr)
{
	struct hostent * h;	

	gettimeofday(&now, NULL);
	if (now.tv_sec >= next.tv_sec - 1)
		return NULL;

	if (setjmp(resolv_buf)) 
		return NULL;

	signal(SIGALRM, do_alarm);
	alarm(next.tv_sec - now.tv_sec - 1);
	h = gethostbyaddr((char *) &addr, 4, AF_INET);
	alarm(0);
	
	if (h) 
		return h->h_name;

	return NULL;
}

static char const * lookup(unsigned long const key)
{
	int h;
	unsigned const char * n;

	h = hash_table[HASH(key)];
	
	while ( h )  {
		if  (key == table[h].key)  {
			struct hash_entry * t = table + h;
			t->seq = ++lookup_no;
			/* gettimeofday(&now); no need in this */
			if (now.tv_sec >= next.tv_sec - 2) 
				return t->name;
			if (t->try <= MAX_TRY) {
				
				if ((n = resolve(key)))  {
					strncpy(t->name,n,MAX_HOST_NAME);
					t->name[MAX_HOST_NAME] = 0;
					t->try = MAX_TRY + 1;
				} else if (t->try++ == MAX_TRY) {
					t->name[strlen(t->name)-1] = 0;
				}
			}
			return t->name;
		}
		h = table[h].next;
	}
	return NULL;
}

static char * insert(unsigned long const key, char const * const name)
{
	unsigned int i;
	unsigned long minseq = lookup_no;
	unsigned int minno = 0;
	
	for (i = 1; i < TABLE_SIZE; i++) {
		if (table[i].seq < minseq)  {
			minno = i;
			if (!(minseq = table[i].seq))  {
				break;
			}
		}
	}
	if (minseq)  {
		i = hash_table[HASH(table[minno].key)];
		if (i == minno)  {
			hash_table[HASH(table[minno].key)] = table[i].next;
		} else  {
			while (table[i].next != minno)  {
				if (!table[i].next)  {
					fprintf (stderr,"host: Internal logic error in hash management!!!!\n");
					exit(1);
				}
				i = table[i].next;
			}
			table[i].next = table[minno].next;
		}
	}
		
	table[minno].try = 0;
	table[minno].key = key;
	table[minno].seq = ++lookup_no;		
	strncpy(table[minno].name, name, MAX_HOST_NAME - 1);
	table[minno].name[MAX_HOST_NAME - 1] = '\0';
	strcat(table[minno].name, "*");
	table[minno].name[MAX_HOST_NAME] = '\0';
	table[minno].next = hash_table[HASH(key)];
	hash_table[HASH(key)] = minno;
	
	return table[minno].name;
}

char const * get_host_name(unsigned long const addr)
{
	char const *name;
	
	if ((name = lookup(addr))) {
		return name;
	}
#if 0
	_res.retrans = 0;
	_res.retry = 1;
#endif
	name = inet_ntoa(*((struct in_addr *) &addr));
	return insert(addr, name);
}
