/*
  $Id: setproctitle.c,v 1.6 1996/08/12 20:13:28 luik Exp $

  setproctitle.c - setproctitle() library function to modify command line.
  Based on the sendmail-8.7.3 version. UCB copyrights: see below.
  Modified by Andreas Luik, <luik@pharao.s.bawue.de>.


*/

/*
 * Copyright (c) 1983, 1995 Eric P. Allman
 * Copyright (c) 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(RCSID) && !defined(lint)
static char rcsid[] = "$Id: setproctitle.c,v 1.6 1996/08/12 20:13:28 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#if defined(SCCSID) && !defined(lint)
static char sccsid[] = "@(#)conf.c	8.243 (Berkeley) 11/20/95";
#endif /* not lint */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#if STDC_HEADERS
#include <stdarg.h>
#define VA_START(ap, f)	va_start(ap, f)
#define VA_END(ap)	va_end(ap)
#else
#include <varargs.h>
#define VA_START(ap, f)	va_start(ap)
#define VA_END(ap)	va_end(ap)
#endif
#define NOVAPROTO		/* suppress varargs prototypes in "libomirr.h" */
#include "libomirr.h"
#undef NOVAPROTO


/* Pointers for setproctitle.  */
static char **Argv = NULL;	/* pointer to argument vector */
static char *LastArgv = NULL;	/* end of argv */

/* initsetproctitle - initializes the above pointers for setproctitle.
   It must be called once before setproctitle.  */
/*ARGSUSED*/
void initsetproctitle(int argc, char **argv, char **envp)
{
    Argv = argv;
    LastArgv = argv[argc - 1] + strlen(argv[argc - 1]);
}

#ifndef HAVE_SETPROCTITLE
/* setproctitle - set the command line of calling process to specified
   string (may use printf(3) like formatting directives). This results
   in more informative output from ps(1).  Currently implemented
   methods: (1) overwriting the argv argument vector (works on Solaris
   2.x, SunOS 4.x, Linux).  */
/*VARARGS1*/
#if STDC_HEADERS
void setproctitle(const char *fmt, ...)
#else
void setproctitle(fmt, va_alist)
const char *fmt;
va_dcl
#endif
{
    int len;
    char *cp;
    char buf[512];
    va_list ap;

    if (Argv == NULL || LastArgv == NULL) /* initsetproctitle not called */
	return;

    VA_START(ap, fmt);
    vsprintf(buf, fmt, ap);
    VA_END(ap);

    len = strlen(buf);

    if (len > LastArgv - Argv[0]) { /* ensure not to write past end of argv */
	len = LastArgv - Argv[0];
	buf[len] = '\0';
    }
    strcpy(Argv[0], buf);
    cp = &Argv[0][len];
    while (cp < LastArgv)	/* pad with spaces */
	*cp++ = ' ';
    Argv[1] = NULL;
}

#endif /* !defined(HAVE_SETPROCTITLE) */

