/*
  $Id: xstrerror.c,v 1.3 1996/08/10 14:09:01 luik Exp $

  xstrerror.c - xstrerror() library function: like strerror() but
  never returns NULL.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>

static char unknown_error[] = "Unknown error %d";

/* xstrerror() - return a string representation of errno like
   strerror, but never return NULL.  */
char *xstrerror(int e)
{
    char *msg;
    static char buf[sizeof unknown_error + 20];

    if ((msg = strerror(e)) == NULL) {
	sprintf(buf, unknown_error, e);
	msg = buf;
    }

    return msg;
}
