/*
  $Id: getmount.c,v 1.4 1996/08/12 22:26:06 luik Exp $

  getmount.c - operating system mount table access functions for omirrd.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* TODO:
 *
 * - portability: check for HAVE_GETMNTENT (set by AC_FUNC_GETMNTENT)
 */

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: getmount.c,v 1.4 1996/08/12 22:26:06 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "getmount.h"


static FILE *default_mount_file; /* default mnttab file */


FILE *setmountent(const char *filename, const char *type)
{
#ifdef PATH_MTAB
    if (!filename)
	filename = PATH_MTAB;
#endif

    if (!type)
	type = "r";

#if GETMOUNT_TYPE == GETMOUNT_BSD
    return setmntent(filename, type);
#endif /* GETMOUNT_TYPE == GETMOUNT_BSD */

#if GETMOUNT_TYPE == GETMOUNT_SYSV
    return fopen(filename, type);
#endif /* GETMOUNT_TYPE == GETMOUNT_SYSV */

    return NULL;
}

int endmountent(FILE *f)
{
    if (f == default_mount_file)
	default_mount_file = NULL;

#if GETMOUNT_TYPE == GETMOUNT_BSD
    return endmntent(f);
#else
    return fclose(f);
#endif
}

struct mountent *getmountent(FILE *f)
{
    static struct mountent mount_ent;

    if (f == NULL)
	if (((f = default_mount_file)) == NULL)
	    if (((f = default_mount_file = setmountent(NULL, NULL))) == NULL)
		return NULL;

#if GETMOUNT_TYPE == GETMOUNT_BSD
    {
	struct mntent *mnt_entp;

	if ((mnt_entp = getmntent(f))) {
	    mount_ent.fsname = mnt_entp->mnt_fsname;
	    mount_ent.dir = mnt_entp->mnt_dir;
	    mount_ent.type = mnt_entp->mnt_type;
	    mount_ent.opts = mnt_entp->mnt_opts;
	    return &mount_ent;
	}
    }
#endif /* GETMOUNT_TYPE == GETMOUNT_BSD */

#if GETMOUNT_TYPE == GETMOUNT_SYSV
    {
	struct mnttab mnt_tab;

	if (getmntent(f, &mnt_tab) == 0) {
	    mount_ent.fsname = mnt_tab.mnt_special;
	    mount_ent.dir = mnt_tab.mnt_mountp;
	    mount_ent.type = mnt_tab.mnt_fstype;
	    mount_ent.opts = mnt_tab.mnt_mntopts;
	    return &mount_ent;
	}
    }
#endif /* GETMOUNT_TYPE == GETMOUNT_SYSV */

    return NULL;
}

struct mountent *getmountentbydev(dev_t dev)
{
    FILE *f;
    struct mountent *mount_entp = NULL;

    if ((f = setmountent(NULL, NULL))) {
	while ((mount_entp = getmountent(f))) {
	    struct stat statbuf;
	    if (stat(mount_entp->dir, &statbuf) != -1 && statbuf.st_dev == dev)
		break;
	}
	endmountent(f);
    }
    return mount_entp;
}
