/*
  $Id: lio.h,v 1.5 1996/08/18 13:27:22 luik Exp $

  lio.h - line input/output function definitions for omirrd.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef LIO_H_INCLUDED
#define LIO_H_INCLUDED

#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */
#include <sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define LIO_BUF_SIZE 512	/* inital buffer size for line I/O buffer */

typedef void (*LioCallbackFunc)(char *buf, void *data);

typedef struct LioCallback_ {
    LioCallbackFunc callback;
    void *data;			/* user data */
    char *buf;
    int buf_size;		/* allocated size of buffer */
    int buf_start;		/* current read position in buffer */
    int buf_end;		/* current buffer end position */
} *LioCallback, LioCallbackRec;

typedef struct LioContext_ {
    LioCallbackRec readcbs[FD_SETSIZE];
} *LioContext, LioContextRec;

/* lio.c */
extern LioContext lioAlloc(void);
extern void lioFree(LioContext context);
extern LioContext lioAddReadCallback(LioContext context, int fd, LioCallbackFunc callback, void *data);
extern LioContext lioRemoveReadCallback(LioContext context, int fd);
extern int lioMpReadFunc(int fd, void *data);

#ifdef	__cplusplus
}
#endif

#endif /* defined(LIO_H_INCLUDED) */
