/*
  $Id: optflags.c,v 1.3 1996/08/14 14:05:40 luik Exp $

  optflags.c - omirrd option flags handling.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: optflags.c,v 1.3 1996/08/14 14:05:40 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#include "optflags.h"


unsigned long option_flag;	/* bit mask of global option flags */




static OptTableEntRec opt_list[] = {
    { "whole",		OPT_WHOLE,		0 },
    { "nowhole",	0,			OPT_WHOLE },
    { "numchkgroup",	OPT_NUMCHKGROUP,	0 },
    { "nonumchkgroup",	0,			OPT_NUMCHKGROUP },
    { "numchkowner",	OPT_NUMCHKOWNER,	0 },
    { "nonumchkowner",	0,			OPT_NUMCHKOWNER },
    { NULL,		0,			0 }
};

/* optParseOptions - parses the `optstring' for option flags related
   command line switches (like "-w") or a comma separated list of
   option flags (like "whole,numchkowner"). The corresponding flags
   are set in either the bit mask `*setp' or `*clearp'. Returns 0 on
   success and -1 if the optstring could not be parsed, setting
   `*unknown_argsp' to a string containing the unparsable parts of the
   `optstring'.  */

int optParseOptions(char *optstring, unsigned long *setp, unsigned long *clearp,
		    char **unknown_argsp)
{
    int result = 0;
    static char unknown[64];

    *setp = 0;
    *clearp = 0;
    *unknown_argsp = unknown;

    if (streq(optstring, "-w"))
	*setp |= OPT_WHOLE;
    else if (*optstring == '\0') {
	result = -1;
	*unknown_argsp = "<empty>";
    }
    else if (*optstring != '-') {
	result = optParseList(optstring, setp, clearp, unknown_argsp, opt_list);
    }
    else {
	result = -1;
	strncpy(unknown, optstring, sizeof(unknown));
	/* Add "..." if too long.  */
	if (unknown[sizeof(unknown) - 4] != '\0')
	    strcpy(unknown + sizeof(unknown) - 4, "...");
    }
    return (result);
}

#ifdef DEBUG
#define APPEND(S,T)	strncat(S,T,sizeof(S) - strlen(S))

char *optStrOptions(unsigned long options)
{
    static char optstring[64];

    *optstring = '\0';
    
    if (options & OPT_WHOLE)
	APPEND(optstring, "whole,");
    if (options & OPT_NUMCHKGROUP)
	APPEND(optstring, "numchkgroup,");
    if (options & OPT_NUMCHKOWNER)
	APPEND(optstring, "numchkowner,");

    optstring[sizeof(optstring) - 1] = '\0'; /* null terminate string */
    if (optstring[strlen(optstring) - 1] == ',')
	optstring[strlen(optstring) - 1] = '\0'; /* remove trailing ',' */
    /* Add "..." if too long.  */
    if (optstring[sizeof(optstring) - 4] != '\0')
	strcpy(optstring + sizeof(optstring) - 4, "...");

    return (optstring);
}
#endif /* defined(DEBUG) */




/* optParseList - parses the `optstring' for a comma separated list of
   option strings found in the option table `tablep'. The
   corresponding flags are set in either the bit mask `*setp' or
   `*clearp'. Returns 0 on success and -1 if the optstring could not
   be parsed, setting *unknown_argsp to a string containing the
   unparsable parts of the `optstring'.  */

int optParseList(char *optstring, unsigned long *setp, unsigned long *clearp,
		 char **unknown_argsp, OptTableEnt tablep)
{
    char *cp;
    char *end;
    int result = 0;
    OptTableEnt tp;
    static char unknown[64];

    *setp = 0;
    *clearp = 0;
    *unknown_argsp = unknown;
    *unknown = '\0';
    for (end = cp = optstring; *end; cp = end + 1) {
	if (((end = strchr(cp, ','))) == NULL)
	    end = strchr(cp, '\0');
	for (tp = tablep; tp->name; tp++) {
	    if (strneq(cp, tp->name, end - cp)) {
		*setp |= tp->set_flag;
		*clearp |= tp->clear_flag;
		break;
	    }
	}
	if (tp->name == NULL) {	/* nothing found */
	    result = -1;
	    strncat(unknown, cp, end - cp);
	}
    }
    /* Add "..." if too long.  */
    if (unknown[sizeof(unknown) - 4] != '\0')
	strcpy(unknown + sizeof(unknown) - 4, "...");
    return (result);
}

