/*
  $Id: optflags.h,v 1.2 1996/08/14 13:42:54 luik Exp $

  optflags.h - definitions of option flags for omirrd.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef OPTFLAGS_H_INCLUDED
#define OPTFLAGS_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

/* option flags */
/* #define OPT_VERIFY	0x1	not supported yet */
#define OPT_WHOLE	0x2
/* #define OPT_YOUNGER	0x4	not supported yet */
/* #define OPT_COMPARE	0x8	not supported yet */
/* #define OPT_REMOVE	0x10	not supported yet */
/* #define OPT_FOLLOW	0x20	not supported yet */
/* #define OPT_IGNLNKS	0x40	not supported yet */
#define OPT_NUMCHKGROUP	0x80
#define OPT_NUMCHKOWNER	0x100


/* OptTableEnt may be used to define an options table for optParseList.  */
typedef struct OptTableEnt_ {
    char *name;			/* options name */
    unsigned long set_flag;	/* bits to set in mask */
    unsigned long clear_flag;	/* bits to clean in mask */
} *OptTableEnt, OptTableEntRec;


extern unsigned long option_flag; /* bit mask of global option flags */


/* optflags.c */
extern int optParseOptions(char *optstring, unsigned long *setp, unsigned long *clearp, char **unknown_argsp);
#ifdef DEBUG
extern char *optStrOptions(unsigned long options);
#endif
extern int optParseList(char *optstring, unsigned long *setp, unsigned long *clearp, char **unknown_argsp, OptTableEnt tablep);

#ifdef	__cplusplus
}
#endif

#endif /* defined(OPTFLAGS_H_INCLUDED) */
