# This is an object used to hold an error message.

package Error;
use strict;

sub new {
	my $proto=shift;
	my $class = ref($proto) || $proto;
	my $this = {};
	
	$this->{message} = shift;
	
	bless($this, $class);
	return $this;
}

sub message {
	my $this=shift;
	
	if (@_) {
		return $this->{message}=shift;
	}
	else {
		return $this->{message};
	}
}

# Returns true if the passed object is indeed an Error.
sub iserror {
	return (ref shift eq "Error");
}

1;
