# This contains random utilities used by perlmoo.

package Utils;


{
	my $use_syslog=undef;

	# Output text. Priority is a syslog priority.
	sub Log {
		my $priority=shift || return;
		my $message=join('',@_);
		if (! $use_syslog) { # Log to stdout/err.
			if ($priority eq 'notice') {
				print STDERR localtime()." Perlmoo ($$): $message\n";
			}
			else {
				print localtime()." Perlmoo ($$): $message\n";
			}
		}
		else {
			syslog($priority,$message);
		}
	}

	# Call to enable logging to syslog.
	sub LogToSyslog {
		$use_syslog=1;
		
		require Sys::Syslog; import Sys::Syslog; # delayed use
		Sys::Syslog::setlogsock('unix');
		openlog("perlmoo","pid","daemon");
	}
}

# This makes the active user be a wizard. The wizard is a special one, that
# will not get dumped out, or even show up on the object list. Returns the 
# wizard.
sub SuWizard {
	ActiveUser::setactive();
	my $wiz=Wizard->new;
	$wiz->nodump(1);
	ActiveUser::setactive($wiz);
	ThingList::remove($wiz); # remove from object list.
	# Can't use $wiz->remove here, because this sib is called inside
	# Thing::remove, and it'd lead to a loop.
	return $wiz;
}

1
