# This bbundles up all the data a verb needs to know when it
# is called.

package VerbCall;
use Utils;
use strict;
use vars qw($AUTOLOAD);

sub new {
	my $proto=shift;
	my $class = ref($proto) || $proto;
	my $this = {};
	
	$this->{'caller'} = shift; # caller is a reserved word
	$this->{object} = shift;
	$this->{direct_object} = shift;
	$this->{indirect_object} = shift;
	$this->{command} = shift;
	@{$this->{words}} = @_;
	
	bless($this, $class);
	return $this;
}

# Set/get a word as it was entered by the user.
# Type can be any of verb, direct_object, preposition, or indirect_object.
sub word {
	my $this=shift;
	my $type=shift;

	my $i;
	if ($type eq 'verb') {
		$i=0;
	}
	elsif ($type eq 'direct_object') {
		$i=1;
	}
	elsif ($type eq 'preposition') {
		$i=2;
	}
	elsif ($type eq 'indirect_object') {
		$i=3;
	}
	
	if (! defined($i)) {
		Utils::Log("notice","Unknown word specifier, $type");
	}

	if (@_) {
		return $this->{words}[$i]=shift;
	}
	else {
		return $this->{words}[$i];
	}
}

# Need to handle this specially so an array can be passed in.
sub words {
	my $this=shift;

	if (@_) {
		return @{$this->{words}} = @_;
	}
	else {
		return @{$this->{words}};
	}
}

sub AUTOLOAD {
	my $this=shift;
	
	my $name = $AUTOLOAD;
	$name =~ s/.*://; # strip fully-qualified portion
	
	if (@_) {
		return $this->{$name} = shift;
	}
	else {
		return $this->{$name};
	}	
}

1;
