/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *	Copyright 1997 Cistron Internet Services B.V.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

static char sccsid[] =
"@(#)builddbm.c	1.4 Copyright 1992 Livingston Enterprises Inc\n"
"               2.0 Copyright 1997 Cistron Internet Services";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<strings.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>
#ifdef DBM
#  include	<dbm.h>
#endif
#ifdef NDBM
#  include	<ndbm.h>
#endif

#include	"radiusd.h"

char		*progname;
int		debug_flag;
char		*radius_dir;

#define FIND_MODE_NAME	0
#define FIND_MODE_REPLY	1
#define FIND_MODE_SKIP	2
#define FIND_MODE_FLUSH	3

FILE		*userfd;

/*
 *	Return each user in the database - name is key content
 *	is 2 strings - check values, and reply values seperated
 *	by a newline.
 */
int user_read(char *name, char *content)
{
	static char	buffer[256];
	char		*ptr;
	int		namelen;
	int		mode;
	VALUE_PAIR	*check_first;
	VALUE_PAIR	*reply_first;

	/*
	 *	Open the user table
	 */
	if (userfd == NULL) {
		sprintf(buffer, "%s/%s", radius_dir, RADIUS_USERS);
		if ((userfd = fopen(buffer, "r")) == NULL) {
			fprintf(stderr, "%s: ", progname);
			perror(buffer);
			exit(1);
		}
		buffer[0] = 0;
	}

	mode = FIND_MODE_NAME;

	while (1) {
		if (buffer[0] == 0) {
			if (fgets(buffer, sizeof(buffer), userfd) == NULL)
				break;
		}
		if (buffer[0] == '#') {
			buffer[0] = 0;
			continue;
		}

		if (mode == FIND_MODE_NAME) {
			/*
			 *	Find the entry starting with the users name
			 */
			if (isspace(*buffer)) {
				buffer[0] = 0;
				continue;
			}

			ptr = buffer;
			while(*ptr != ' ' && *ptr != '\t' &&
				*ptr != '\n' && *ptr != '\0')
					*name++ = *ptr++;
			*name = '\0';
			if (*ptr == '\0') {
				buffer[0] = 0;
				continue;
			}

			while(*ptr == ' ' || *ptr == '\t')
				ptr++;

			strcpy(content, ptr);
			content += strlen(content);
			mode = FIND_MODE_REPLY;
		}
		else {
			if (buffer[0] != ' ' && buffer[0] != '\t') {
				/*
				 *	Done with this entry.
				 */
				return 0;
			}
			ptr = buffer;
			while(*ptr == ' ' || *ptr == '\t')
					ptr++;

			strcpy(content, ptr);
			content += strlen(content);
			content -= 2;
			while(*content == ' ' || *content == '\t' )
					content--;
			content++;
			*content = '\0';
			if (*(content - 1) != ',') {
				/*
				 *	We also stop if the line doesn't end
				 *	with a comma.
				 *	FIXME: consistent with users.c ?
				 */
				buffer[0] = 0;
				return 0;
			}
		}
		buffer[0] = 0;
	}

	fclose(userfd);
	userfd = NULL;
	return (mode == FIND_MODE_REPLY) ? 0 : -1;
}


int main(int argc, char **argv)
{
	char	name[128];
	char	content[1024];
	char 	*progname;
	int	fd;
	datum	named;
	datum	contentd;
	int	defno = 0;
#ifdef NDBM
	DBM	*dbm;
#endif

	progname = *argv;
	radius_dir = ".";

	/*
	 *	Initialize a new, empty database.
	 */
#ifdef DBM
	if ((fd = open("users.pag", O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(stderr, "%s: Couldn't open users.pag for writing\n",
			progname);
		exit(1);
	}
	close(fd);
	if ((fd = open("users.dir", O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(stderr, "%s: Couldn't open users.dir for writing\n",
			progname);
		exit(1);
	}
	close(fd);
	if (dbminit("users") != 0) {
		fprintf(stderr, "%s: ", progname);
		perror("dbminit(users)");
		exit(1);
	}
#endif
#ifdef NDBM
	if ((dbm = dbm_open("users", O_RDWR|O_CREAT|O_TRUNC, 0600)) == NULL) {
		fprintf(stderr, "%s: ", progname);
		perror("dbm_open(users)");
		exit(1);
	}
#endif
	while (user_read(name, content) == 0) {
		if (strcmp(name, "DEFAULT") == 0) {
			if (defno > 0)
				sprintf(name, "DEFAULT%d", defno);
			defno++;
		}
		named.dptr = name;
		named.dsize = strlen(name);
		contentd.dptr = content;
		contentd.dsize = strlen(content);
#ifdef DBM
		if (store(named, contentd) != 0)
#endif
#ifdef NDBM
		if (dbm_store(dbm, named, contentd, DBM_INSERT) != 0)
#endif
		{
			fprintf(stderr, "%s: Couldn't store datum for %s\n",
				progname, name);
			exit(1);
		}
	}
#ifdef DBM
	dbmclose();
#endif
#ifdef NDBM
	dbm_close(dbm);
#endif
	return 0;
}

