/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "style.h"
#include "xchat.h"
#include "dcc.h"
#include <netdb.h>
#include <time.h>

extern GSList *sess_list;
extern struct server firstserver;

extern struct DCC *find_dcc(char *nick, char *file, int type);
extern void dcc_close(struct DCC *dcc, int stat, int destroy);
extern struct dialog *new_dialog(struct server *serv, char *nick);
extern struct dialog *find_dialog(struct server *serv, char *nick);
extern int dcc_write_chat(char *nick, char *text);
extern void PrintText(struct session *sess, char *text);
extern void connect_server(struct session *sess, char *server, int port, int quiet);
extern void kill_session(GtkWidget *win, struct session *sess);
extern void channel_action(struct session *sess, char *chan, char *from, char *text);
//extern void new_nick(struct session *sess, char *newnick);
extern void user_new_nick(struct server *serv, char *outbuf, char *nick, char *newnick, int quiet);
extern void channel_msg(struct server *serv, char *outbuf, char *chan, char *from, char *text, char fromme);
extern void dcc_list(struct session *sess, char *outbuf);
extern void dcc_get(struct session *sess, char *nick);
extern void dcc_send(struct session *sess, char *tbuf, char *to, char *file);
extern void dcc_chat(struct session *sess, char *nick);
extern void disconnect_server(struct session *sess, int sendquit);
extern void dcc_draw(struct session *sess, char *nick);


void notj_msg(struct session *sess)
{  
   PrintText(sess, "No channel joined. Try /join #<channel>\n");
}

void notc_msg(struct session *sess)
{
   PrintText(sess, "Not connected. Try /server <host> [<port>]\n");
}

void add_to_history(struct session *sess, char *cmd)
{
   if(sess->history[sess->realpos]) free(sess->history[sess->realpos]);
   sess->history[sess->realpos] = malloc(strlen(cmd)+1);
   strcpy(sess->history[sess->realpos], cmd);
   sess->realpos++;
   if(sess->realpos == 100) sess->realpos = 0;
   sess->pos = sess->realpos;
}

void process_data_init(unsigned char *buf, char *cmd, char *word[], char *word_eol[])
{
   int wordcount = 2;
   int space = FALSE;
   int j = 0;
   
   word[1] = cmd;
   word_eol[1] = buf;

   while(1)
   {
     switch(*cmd)
     {
      case 0:
	jump:
	buf[j] = 0;
	for(j=wordcount; j<32; j++)
	{
	   word[j] = "\000\000";
	   word_eol[j] = "\000\000";
	}
	return;
      case ' ':
	if(!space)
	{
	   buf[j] = 0;
	   j++;
	   
	   word[wordcount] = &buf[j];
	   word_eol[wordcount] = cmd+1;
	   wordcount++;
	   
	   if(wordcount==31) goto jump;
	   
	   space = TRUE;
	}
	break;
      default:
	space = FALSE;
	buf[j] = *cmd;
	j++;
     }
     cmd++;
   }
}

void cmd_away(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_ban(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_banlist(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_chat(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_ctcp(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_dcc(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_debug(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_deop(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_devoice(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_discon(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_draw(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_exit(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_gate(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_help(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_hidever(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_join(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_kick(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_kickban(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_me(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_msg(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_mode(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_names(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_nick(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_notice(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_op(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_oper(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_part(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_ping(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_query(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_quote(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_server(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_topic(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_unban(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_whois(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_whowas(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_ver(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
void cmd_voice(struct session *sess, char *tbuf, char *word[], char *word_eol[]);

typedef void (*cmd_callback) (struct session *sess, char *tbuf, char *word[], char *word_eol[]);

struct commands
{
   char *name;
   cmd_callback callback;
   char needserver;
   char needchannel;
   char *help;
   char *simplecmd;
};

struct commands cmds[] =
{
     {"AWAY",   cmd_away,   1, 0, 0, 0},
     {"BAN",    cmd_ban,    1, 1, "/BAN <mask>\n", 0},
     {"BANLIST",cmd_banlist,1, 1, 0, 0},
     {"CHAT",   cmd_chat,   1, 0, 0, 0},
     {"CTCP",   cmd_ctcp,   1, 0, "/CTCP <nick> <message>\n", 0},
     {"DCC",    cmd_dcc,    0, 0, "\n"
	 "/DCC GET <nickname>          - receive an offered file\n"
         "/DCC SEND <nickname> <file>  - send a file to someone\n"
         "/DCC LIST                    - show DCC list\n"
	 "/DCC CHAT <nickname>         - offer DCC CHAT to someone\n",
	  0},
     {"DEBUG",  cmd_debug,  0, 0, 0, 0},
     {"DEOP",   cmd_deop,   1, 1, "/DEOP <nick>\n", 0},
     {"DEVOICE",cmd_devoice,1, 1, "/DEVOICE <nick>\n", 0},
     {"DIALOG", cmd_query,  0, 0, "/DIALOG <nick>\n", 0},
     {"DISCON", cmd_discon, 1, 0, "/DISCON\n\nDisconnects from server\n", 0},
     {"DRAW",   cmd_draw,   1, 0, 0, 0},
     {"EXIT",   cmd_exit,   0, 0, 0, 0},
     {"GATE",   cmd_gate,   0, 0, "/GATE <host> [<port>]\n", 0},
     {"HELP",   cmd_help,   0, 0, 0, 0},
     {"HIDEVER",cmd_hidever,0, 0, 0, 0},
     {"INFO",   0,          1, 0, 0, "INFO\r\n"},
     {"J",      cmd_join,   1, 0, 0, 0},
     {"JOIN",   cmd_join,   1, 0, "/JOIN <channel>\n", 0},
     {"KICK",   cmd_kick,   1, 1, "/KICK <nick>\n", 0},
     {"KICKBAN",cmd_kickban,1, 1, 0, 0},
     {"LINKS",  0,          1, 0, 0, "LINKS\r\n"},
     {"LIST",   0,          1, 0, 0, "LIST\r\n"},
     {"MAP",    0,          1, 0, 0, "MAP\r\n"},
     {"ME",     cmd_me,     1, 1, "/ME <action>\n", 0},
     {"MOTD",   0,          1, 0, 0, "MOTD\r\n"},
     {"M",      cmd_msg,    1, 0, 0, 0},
     {"MSG",    cmd_msg,    1, 0, 0, 0},
     {"MODE",   cmd_mode,   1, 0, "/MODE [<channel>] <mode>\n", 0},
     {"NAMES",  cmd_names,  1, 1, 0, 0},
     {"NICK",   cmd_nick,   0, 0, 0, 0},
     {"NOTICE", cmd_notice, 1, 0, 0, 0},
     {"OP",     cmd_op,     1, 1, 0, 0},
     {"OPER",   cmd_oper,   1, 0, "/OPER <username> <password>\n", 0},
     {"PART",   cmd_part,   1, 1, 0, 0},
     {"PING",   cmd_ping,   1, 0, 0, 0},
     {"QUERY",  cmd_query,  0, 0, 0, 0},
     {"QUIT",   cmd_exit,   0, 0, 0, 0},
     {"QUOTE",  cmd_quote,  1, 0, 0, 0},
     {"RAW",    cmd_quote,  1, 0, 0, 0},
     {"SERVER", cmd_server, 0, 0, "/SERVER <host> [<port>]\n", 0},
     {"TOPIC",  cmd_topic,  1, 1, 0, 0},
     {"UNBAN",  cmd_unban,  1, 1, 0, 0},
     {"WHOIS",  cmd_whois,  1, 0, 0, 0},
     {"WHOWAS", cmd_whowas, 1, 0, 0, 0},
     {"VER",    cmd_ver,    1, 0, 0, 0},
     {"VERSION",cmd_ver,    1, 0, 0, 0},
     {"VOICE",  cmd_voice,  1, 1, 0, 0},
     {0,0,0,0,0,0}
};

void help(struct session *sess, char *helpcmd, int quiet)
{
   int i = 0;
      while(1)
      {
	 if(!cmds[i].name) break;
	 if(!strcasecmp(helpcmd, cmds[i].name))
	 {
	    if(cmds[i].help)
	    {
	       PrintText(sess, "Usage: ");
	       PrintText(sess, cmds[i].help);
	       return;
	    } else {
	       if(!quiet) PrintText(sess, "\nNo help available on that command.\n");
	       return;
	    }
	 }
	 i++;
      }
   if(!quiet) PrintText(sess, "No such command.\n");
}

#define find_word_to_end(a, b) word_eol[b]
#define find_word(a, b) word[b]

void cmd_away(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *reason = find_word_to_end(cmd, 2);
   if(*reason)
   {
     sprintf(tbuf, "AWAY :%s\r\n", reason);
     send(sess->server->sok, tbuf, strlen(tbuf), 0);
   } else
     send(sess->server->sok, "AWAY\r\n", 6, 0);
}

void cmd_ban(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *mask = find_word(pdibuf, 2);
   if(*mask)
     sprintf(tbuf, "MODE %s +b %s\r\n", sess->channel, mask);
   else
     sprintf(tbuf, "MODE %s +b\r\n", sess->channel);
   send(sess->server->sok, tbuf, strlen(tbuf), 0);
}

void cmd_banlist(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   sprintf(tbuf, "MODE %s +b\r\n", sess->channel);
   send(sess->server->sok, tbuf, strlen(tbuf), 0);
}

void cmd_chat(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   if(*word[2]) dcc_chat(sess, word[2]);
}

void cmd_ctcp(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *to = find_word(pdibuf, 2);
   if(*to)
   {
      char *msg = find_word_to_end(cmd, 3);
      if(*msg)
      {	 
	 if(!strcasecmp(msg, "VERSION")) msg = "VERSION";
	 sprintf(tbuf, "PRIVMSG %s :\001%s\001\r\n", to, msg);
	 send(sess->server->sok, tbuf, strlen(tbuf), 0);
	 sprintf(tbuf, "\0033>\003 %s\0033< \003 CTCP %s\n", to, msg);
	 PrintText(sess, tbuf);
	 return;
      }
   }
   help(sess, "CTCP", TRUE);
}

void cmd_dcc(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *type = find_word(pdibuf, 2);
   if(*type)
   {
      if(!strcasecmp(type, "CLOSE"))
      {
	 if(*word[3] && *word[4])
	 {
	    if(!strcasecmp(word[3], "DRAW"))
	    {
	       struct DCC *dcc = find_dcc(word[4], "", TYPE_DRAWRECV);
	       if(!dcc) dcc = find_dcc(word[4], "", TYPE_DRAWSEND);
	       if(dcc)
	       {
		  dcc_close(dcc, 0, TRUE);
	       }
	    }
	 }
	 return;
      }
      if(!strcasecmp(type, "CHAT"))
      {
	 char *nick = find_word(pdibuf, 3);
	 if(*nick) dcc_chat(sess, nick);
	 return;
      }
      if(!strcasecmp(type, "LIST"))
      {
	 dcc_list(sess, tbuf);
	 return;
      }
      if(!strcasecmp(type, "GET"))
      {
	 char *nick = find_word(pdibuf, 3);
	 if(*nick) dcc_get(sess, nick);
	 return;
      }
      if(!strcasecmp(type, "SEND"))
      {
	 char *nick = find_word(pdibuf, 3);
	 if(*nick) 
	 {
	    int i = 4;
	    char *file;
	    while(1)
	    {
	       file = find_word(pdibuf, i);
	       if(!*file) break;
	       dcc_send(sess, tbuf, nick, file);
	       i++;
	    }
	 }
	 return;
      }
   } else
     dcc_list(sess, tbuf);
}

void cmd_debug(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   struct session *s;
   struct server *v = &firstserver;
   GSList *list = sess_list;

   PrintText(sess, "Session    Chan Server\n");

   while(list)
   {
      s = (struct session *)list->data;
      sprintf(tbuf, "0x%lx %s   0x%lx\n",
	      (unsigned long)s, s->channel, (unsigned long)s->server);
      PrintText(sess, tbuf);
      list = list->next;
   }

   PrintText(sess, "Server    Used Sok Name\n");
   do
   {
      sprintf(tbuf, "0x%lx %d    %ld   %s\n",
	      (unsigned long)v, v->used, v->sok, v->servername);
      PrintText(sess, tbuf);
      v = v->next;
   } while(v);
}

void cmd_deop(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   int i = 2;
   while(1)
   {
      char *name = find_word(pdibuf, i);
      if(!*name) break;
      sprintf(tbuf, "MODE %s -o %s\r\n", sess->channel, name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      i++;
   }
}

void cmd_devoice(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   int i = 2;
   while(1)
   {
      char *name = find_word(pdibuf, i);
      if(!*name) break;
      sprintf(tbuf, "MODE %s -v %s\r\n", sess->channel, name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      i++;
   }
}

void cmd_discon(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   disconnect_server(sess, TRUE);
}

void cmd_draw(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   if(*word[2]) dcc_draw(sess, word[2]);
}

void cmd_exit(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   kill_session(sess->window, sess);
}

void cmd_gate(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   	 char *server = find_word(pdibuf, 2);
	 if(*server)
	 {
	    char *port = find_word(pdibuf, 3);
	    if(*port)
	      connect_server(sess, server, atoi(port), TRUE);
	    else
	      connect_server(sess, server, 23, TRUE);
	 }
}

void cmd_help(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   int i = 0;
   char *helpcmd = "";
   
   if(tbuf) helpcmd = find_word(pdibuf, 2);
   if(*helpcmd)
   {
      help(sess, helpcmd, FALSE);
   } else {
      char *buf = malloc(4096);
      int t = 1, j;
      strcpy(buf, "\nCommands Available:\n\n  ");
      while(1)
      {
	 if(!cmds[i].name) break;
	 strcat(buf, cmds[i].name);
	 for(j=0; j<(10-strlen(cmds[i].name)); j++) strcat(buf, " ");
	 i++;
	 t++;
	 if(t == 5)
	 {
	    t = 1;
	    strcat(buf, "\n  ");
	 }
      } 
      strcat(buf, "\n");
      PrintText(sess, buf);
      free(buf);
   }
}

int hidever = 0;

void cmd_hidever(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   if(hidever)
   {
      hidever = FALSE;
      PrintText(sess, STARTON" HIDE-VER off\n");
   } else {
      hidever = TRUE;
      PrintText(sess, STARTON" HIDE-VER on\n");
   }
}

void cmd_join(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *chan = find_word(pdibuf, 2);
   if(*chan)
   {
      char *pass = find_word(pdibuf, 3);
      if(*pass)
	sprintf(tbuf, "JOIN %s %s\r\n", chan, pass);
      else
	sprintf(tbuf, "JOIN %s\r\n", chan);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      if(sess->channel[0] == 0) strcpy(sess->waitchannel, chan);
   }
}

void cmd_kick(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *nick = find_word(pdibuf, 2);
   if(*nick)
   {
      char *reason = find_word_to_end(cmd, 3);
      if(*reason)
	sprintf(tbuf, "KICK %s %s :%s\r\n", sess->channel, nick, reason);
      else
	sprintf(tbuf, "KICK %s %s\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void cmd_kickban(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *nick = find_word(pdibuf, 2);
   if(*nick)
   {
      sprintf(tbuf, "MODE %s +b %s!*@*\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      {
	 char *reason = find_word_to_end(cmd, 3);
	 if(*reason)
	   sprintf(tbuf, "KICK %s %s :%s\r\n", sess->channel, nick, reason);
	 else
	   sprintf(tbuf, "KICK %s %s\r\n", sess->channel, nick);
	 send(sess->server->sok, tbuf, strlen(tbuf), 0);
      }
   }
}

void cmd_me(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *act = find_word_to_end(cmd, 2);
   if(*act)
   {
      channel_action(sess, sess->channel, sess->server->nick, act);
      sprintf(tbuf, "PRIVMSG %s :\001ACTION %s\001\r\n", sess->channel, act);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void cmd_msg(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *nick = find_word(pdibuf, 2);
   if(*nick)
   {
      char *msg = find_word_to_end(cmd, 3);
      if(*msg)
      {
	 if(strcmp(nick, ".") == 0) { /* /msg the last nick /msg'ed */
	    if(sess->lastnick[0])
	      nick = sess->lastnick;
	 } else
	   strcpy(sess->lastnick, nick); /* prime the last nick memory */
	 
	 sprintf(tbuf, "\0033>\003 %s\0033< \003 %s\n", nick, msg);
	 PrintText(sess, tbuf);
	 if(!dcc_write_chat(nick, msg))
	 {
	    sprintf(tbuf, "PRIVMSG %s :%s\r\n", nick, msg);
	    send(sess->server->sok, tbuf, strlen(tbuf), 0);
	 }
      }
   }
}

void cmd_mode(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   sprintf(tbuf, "MODE %s\r\n", word_eol[2]);
   send(sess->server->sok, tbuf, strlen(tbuf), 0);
}

void cmd_names(struct session *sess, char *tbuf, char *word[], char *word_eol[])//(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   sprintf(tbuf, "NAMES %s\r\n", sess->channel);
   send(sess->server->sok, tbuf, strlen(tbuf), 0);
}

void cmd_nick(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *nick = find_word(pdibuf, 2);
   if(*nick)
   {
     if(sess->server->flags&(1<<0))
     {
	sprintf(tbuf, "NICK %s\r\n", nick);
	send(sess->server->sok, tbuf, strlen(tbuf), 0);
     } else
	user_new_nick(sess->server, tbuf, sess->server->nick, nick, TRUE);
	//new_nick(sess, nick);
   }
}

void cmd_notice(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   if(*word[2] && *word_eol[3])
   {
      sprintf(tbuf, "NOTICE %s :%s\r\n", word[2], word_eol[3]);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      sprintf(tbuf, "\0033>\003 %s\0033< \003 %s\n", word[2], word_eol[3]);
      PrintText(sess, tbuf);
   }
}

void cmd_op(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   int i = 2;
   while(1)
   {
      char *name = find_word(pdibuf, i);
      if(!*name) break;
      sprintf(tbuf, "MODE %s +o %s\r\n", sess->channel, name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      i++;
   }
}

void cmd_oper(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *user = find_word(pdibuf, 2);
   if(*user)
   {
      char *pass = find_word(pdibuf, 3);
      if(*pass)
      {
	 sprintf(tbuf, "OPER %s %s\r\n", user, pass);
	 send(sess->server->sok, tbuf, strlen(tbuf), 0);
	 return;
      }
   }
   help(sess, "OPER", TRUE);
}

void cmd_part(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   	 char *chan = find_word(pdibuf, 2);
	 if(!*chan) chan = sess->channel;
	 if(*chan)
	 {
	       sprintf(tbuf, "PART %s\r\n", chan);
	       send(sess->server->sok, tbuf, strlen(tbuf), 0);
	 }
}

void cmd_ping(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   long t;
   char *to = find_word(pdibuf, 2);
   time(&t);
   if(*to)
      sprintf(tbuf, "PRIVMSG %s :\001PING %ld\001\r\n", to, t);
   else
      sprintf(tbuf, "PING %ld :%s\r\n", t, sess->server->servername);
   send(sess->server->sok, tbuf, strlen(tbuf), 0); 
}

void cmd_query(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *nick = find_word(pdibuf, 2);
   if(*nick)
   {
      if(!find_dialog(sess->server, nick))
	 new_dialog(sess->server, nick);
   }
}

void cmd_quote(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   	 char *raw = find_word_to_end(cmd, 2);
	 if(*raw)
	 {
	       send(sess->server->sok, raw, strlen(raw), 0);
	       send(sess->server->sok, "\r\n", 2, 0);
	 }
}

void cmd_server(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *server = find_word(pdibuf, 2);
   if(*server)
   {
      char *port = find_word(pdibuf, 3);
      if(*port)
	connect_server(sess, server, atoi(port), FALSE);
      else
	connect_server(sess, server, 6667, FALSE);
   } else
     help(sess, "SERVER", TRUE);
}

void cmd_topic(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *topic = find_word_to_end(cmd, 2);
   if(*topic)
     sprintf(tbuf, "TOPIC %s :%s\r\n", sess->channel, topic);
   else
     sprintf(tbuf, "TOPIC %s\r\n", sess->channel);  
   send(sess->server->sok, tbuf, strlen(tbuf), 0);
}

void cmd_unban(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *mask = find_word(pdibuf, 2);
   if(*mask)
   {
      sprintf(tbuf, "MODE %s -b %s\r\n", sess->channel, mask);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void cmd_whois(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *name = find_word(pdibuf, 2);
   if(*name)
   {
      sprintf(tbuf, "WHOIS %s\r\n", name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void cmd_whowas(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   char *name = find_word(pdibuf, 2);
   if(*name)
   {
      sprintf(tbuf, "WHOWAS %s\r\n", name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void cmd_ver(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   if(word[2])
   {
      sprintf(tbuf, "PRIVMSG %s :\001VERSION\001\r\n", word[2]);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      sprintf(tbuf, "\0033>\003 %s\0033< \003 CTCP VERSION\n", word[2]);
      PrintText(sess, tbuf);
   }  
}

void cmd_voice(struct session *sess, char *tbuf, char *word[], char *word_eol[])
{
   int i = 2;
   while(1)
   {
      char *name = find_word(pdibuf, i);
      if(!*name) break;
      sprintf(tbuf, "MODE %s +v %s\r\n", sess->channel, name);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
      i++;
   }
}
void check_special_chars(char *cmd) /* check for ^X */
{
   char *buf = malloc(strlen(cmd) + 1);
   if(buf)
   {
      int i = 0, j = 0;
      while(cmd[j])
      {
	 switch(cmd[j])
	 {
	  case '^':
	    switch(cmd[j+1])
	    {
	     case 'R':
	       buf[i] = '\026'; i++; j++; break;
	     case 'U':
	       buf[i] = '\037'; i++; j++; break;
	     case 'B':
	       buf[i] = '\002'; i++; j++; break;
	     default:
	       buf[i] = cmd[j];
	       i++;
	    }
	    break;
	  default:
	    buf[i] = cmd[j];
	    i++;
	 }
	 j++;
      }
      buf[i] = 0;
      strcpy(cmd, buf);
      free(buf);
   }
}

void handle_command(char *cmd, struct session *sess)
{
   unsigned char pdibuf[1024];
   unsigned char tbuf[2048];
   char *word[32];
   char *word_eol[32];
   
   add_to_history(sess, cmd);
   check_special_chars(cmd);
   
   if(cmd[0] == '/')
   {
      int i = 0;

      cmd++;
      process_data_init(pdibuf, cmd, word, word_eol);

      while(1)
      {
	 if(!cmds[i].name) break;
	 if(!strcasecmp(pdibuf, cmds[i].name))
	 {
	    if(cmds[i].needserver && !(sess->server->flags&(1<<0)))
	    {
	       notc_msg(sess);
	       return;
	    }
	    if(cmds[i].needchannel && sess->channel[0]==0)
	    {
	       notj_msg(sess);
	       return;
	    }
	    if(cmds[i].simplecmd)
	      send(sess->server->sok, cmds[i].simplecmd, strlen(cmds[i].simplecmd), 0);
	    else
	      cmds[i].callback(sess, tbuf, word, word_eol);
	    return;
	 }
	 i++;
      }
      PrintText(sess, "Unknown Command. Try /help\n");

   } else {
      if(sess->server->flags&(1<<0))
      {
	 if(sess->channel[0])
	 {
	    sprintf(tbuf, "PRIVMSG %s :%s\r\n", sess->channel, cmd);
	    send(sess->server->sok, tbuf, strlen(tbuf), 0);
	    channel_msg(sess->server, tbuf, sess->channel, sess->server->nick, cmd, TRUE);
	 } else
	   notj_msg(sess);
      } else
	notc_msg(sess);
   }
}

void handle_inputgad(GtkWidget *igad, struct session *sess)
{
   char *cr;
   char *cmd = gtk_entry_get_text((GtkEntry *)igad);
   
   if(cmd[0] == 0) return;

   cr = strchr(cmd, '\n');
   if(cr)
   {
      while(1)
      {
	 if(cr) *cr = 0;
	 handle_command(cmd, sess);
	 if(!cr) break;
	 cmd = cr + 1;
	 if(*cmd == 0) break;
	 cr = strchr(cmd, '\n');
      }
   } else
     handle_command(cmd, sess);

   gtk_entry_set_text((GtkEntry *)igad, "");
}
