#define VERSION "0.2.3"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <netdb.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/syslog.h>
#include <sys/param.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gtk/gtk.h>

int FLAG=1;
int Call(int signo) { FLAG=0; return 0; }
int HELP_FLAG=0;
int DIALOG_FLAG=0;

GtkWidget *e_domain;
GtkWidget *text_field;
const gchar *list_item_data_key="list_item_data";
char *servers[256];
char server[256];
char text_buffer[12288];

void about_close(GtkWidget *widget,GtkWidget *dialog)
{
  gtk_widget_destroy( dialog );
  DIALOG_FLAG = 0;
}

void about_window(GtkWidget *widget,gpointer data)
{
  GtkWidget *a_dialog;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *a_main_box;

  a_dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW (a_dialog),"About Xwhois");
  gtk_widget_show (a_dialog);

  a_main_box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_main_box, TRUE, TRUE, 5);
  gtk_widget_show (a_main_box);

  label = gtk_label_new ("Xwhois version "VERSION"");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("Bjorn Lindgren  (bjorn@goatnet.ml.org)");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("1998");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("   Licensed under GNU GENERAL PUBLIC LICENSE (GPL)   ");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("Homepage:  http://www.goatnet.ml.org/software.html");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("Main dist site:  ftp://sangis.kalix.net/pub/nr/xwhois");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  button = gtk_button_new_with_label (" Close ");
  gtk_signal_connect (GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(about_close),a_dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(a_dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}

int about_init(GtkWidget *widget,gpointer data)
{
  if (DIALOG_FLAG == 0)
    {
      DIALOG_FLAG = 1;
      about_window(widget,data);
    }
  return 0;
}

void probe_external_whois(GtkWidget *widget,gpointer data)
{
  FILE *fp;
  char *c_domain;
  char cmd[256];
  int i;
  guint x;
  c_domain = gtk_entry_get_text (GTK_ENTRY(e_domain));
  sprintf(cmd,"%s","whois -h ");
  strcat(cmd,server);
  strcat(cmd," ");
  strcat(cmd,c_domain);

  x = gtk_text_get_length(GTK_TEXT(text_field));
  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_forward_delete ((void *)text_field,x);

  fp = popen(cmd,"r");
  i = fread(text_buffer,1,sizeof(text_buffer),fp);

  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_insert ((void *)text_field,NULL,NULL,NULL,text_buffer,strlen(text_buffer));
  /*  gtk_entry_set_text (GTK_ENTRY(e_domain),""); */
}

void probe_external_fwhois(GtkWidget *widget,gpointer data)
{
  FILE *fp;
  char *c_domain;
  char cmd[256];
  int i;
  guint x;
  c_domain = gtk_entry_get_text (GTK_ENTRY(e_domain));
  sprintf(cmd,"%s","whois ");
  strcat(cmd,c_domain);
  strcat(cmd,"@");
  strcat(cmd,server);

  x = gtk_text_get_length(GTK_TEXT(text_field));
  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_forward_delete ((void *)text_field,x);

  fp = popen(cmd,"r");
  i = fread(text_buffer,1,sizeof(text_buffer),fp);

  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_insert ((void *)text_field,NULL,NULL,NULL,text_buffer,strlen(text_buffer));
  /*  gtk_entry_set_text (GTK_ENTRY(e_domain),""); */
}

int probe_internal(GtkWidget *widget,gpointer data)
{
  struct hostent *whois_server;
  struct sockaddr_in serv_addr;
  struct in_addr outgoing;
  char *c_domain;
  char host[100],out_buffer[1024],in_buffer[12288];
  int outsocket, X;
  guint z;

  if (HELP_FLAG == 1)
    {
      c_domain = "HELP";
      HELP_FLAG = 0;
    }
  else
    {
      c_domain = gtk_entry_get_text (GTK_ENTRY(e_domain));
    }

  z = gtk_text_get_length(GTK_TEXT(text_field));
  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_forward_delete ((void *)text_field,z);

  outsocket = socket (AF_INET, SOCK_STREAM, 0);

  memset (&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;

  if ((whois_server = gethostbyname(server)) == NULL)
    {
      sprintf(text_buffer,"Could not resolve host %s",server);
      gtk_text_set_point ((void *)text_field, 0);
      gtk_text_insert ((void *)text_field,NULL,NULL,NULL,text_buffer,strlen(text_buffer));

      return(0);
    }

  (void *) memcpy (&outgoing.s_addr, whois_server->h_addr_list[0],sizeof(outgoing.s_addr));
  strcpy (host, inet_ntoa (outgoing));
  serv_addr.sin_addr.s_addr = inet_addr (host);
  serv_addr.sin_port = htons (43);

  /*  signal(SIGALRM,(void *)Call); */
  FLAG=1;
  alarm(10);
  X=connect(outsocket,(struct sockaddr *) &serv_addr,sizeof(serv_addr));
  alarm(0);

  sprintf(out_buffer,"%s",c_domain);
  strcat(out_buffer,"\r\n");
#ifdef STD
  memset(&text_buffer,0,sizeof(text_buffer));
#endif
#ifdef SYSV
  memset(text_buffer,0,sizeof(text_buffer));
#endif
  if (FLAG == 1 && X == 0)
    {
      write(outsocket,out_buffer,strlen(out_buffer));
      while ((X=read(outsocket,in_buffer,2048))!=0)
	{
	  strcat(text_buffer,in_buffer);
#ifdef STD
	  memset(&in_buffer,0,sizeof(in_buffer));
#endif
#ifdef SYSV
          memset(in_buffer,0,sizeof(in_buffer));
#endif
	}
    }
  close(outsocket);

  gtk_text_set_point ((void *)text_field, 0);
  gtk_text_insert ((void *)text_field,NULL,NULL,NULL,text_buffer,strlen(text_buffer));
#ifdef STD
  memset(&text_buffer,0,sizeof(text_buffer));
#endif
#ifdef SYSV
  memset(text_buffer,0,sizeof(text_buffer));
#endif
  /*  gtk_entry_set_text (GTK_ENTRY(e_domain),""); */
  return 0;
}

void probe_help(GtkWidget *widget, GtkWidget *entry)
{
  HELP_FLAG=1;
  sprintf(server,"%s","whois.internic.net");
  probe_internal(widget,entry);
}

void enter_callback(GtkWidget *widget, GtkWidget *entry)
{
  probe_internal(widget,entry);
}

void get_servers()
{
  FILE* fp;
  char buffer[256];
  int i=0;

#ifdef SYSV
  sprintf(buffer,"%s",getenv("HOME"));
#endif
#ifdef STD
  snprintf(buffer,255,"%s",getenv("HOME"));
#endif
  strcat(buffer,"/.xwhois.servers");

  if (!(fp=fopen(buffer,"r")))
    {
      /*      sprintf(buffer,"%s","/usr/lib/xwhois/xwhois.servers"); */
      sprintf(buffer,"%s",XWHOIS_SERVERS);
      if (!(fp=fopen(buffer,"r")))
	{
	  printf("Could not open xwhois server file!\n");
	  exit(0);
	}
    }
  while (fgets(buffer,255,fp))
    {
      servers[i] = malloc(strlen(buffer)+1);
      sscanf(buffer,"%s",servers[i]);
      i++;
    }
  fclose(fp);
}

void list_selection(GtkWidget *server_list,gpointer func_data)
{
  GList *dlist;
  dlist=GTK_LIST(server_list)->selection;
  while (dlist)
    {
      GtkObject *list_item;
      gchar *item_data_string;
      list_item=GTK_OBJECT(dlist->data);
      item_data_string=gtk_object_get_data(list_item,list_item_data_key);
      sprintf(server,"%s",item_data_string);
      dlist=dlist->next;
    }
}

void destroy(GtkWidget *widget)
{
  gtk_main_quit();
}

int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *menu_bar;
  GtkWidget *root_menu;
  GtkWidget *menu;
  GtkWidget *sub_menu;
  GtkWidget *sub_menu_item;
  GtkWidget *menu_item_quit;
  GtkWidget *menu_item_about;
  GtkWidget *menu_item_fwhois;
  GtkWidget *menu_item_whois;
  GtkWidget *h_box_top;
  GtkWidget *box;
  GtkWidget *h_box_low;
  GtkWidget *label;
  GtkWidget *b_submit;
  GtkWidget *b_help;
  GtkWidget *b_quit;
  GtkWidget *v_scrollbar;
  GtkWidget *scrolled_window;
  GtkWidget *server_list;
  GtkWidget *list_item;
  int i=0;

  get_servers();
  sprintf(server,"%s",servers[0]);

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window),"xwhois "VERSION"");
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_widget_show (window);

  main_box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), main_box);
  gtk_widget_show (main_box);

  menu_bar = gtk_menu_bar_new ();
  gtk_box_pack_start (GTK_BOX (main_box), menu_bar, FALSE, FALSE, 0);
  gtk_widget_show (menu_bar);

  root_menu = gtk_menu_item_new_with_label ("Main");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu);
  gtk_widget_show (root_menu);

  menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);

  sub_menu_item = gtk_menu_item_new_with_label ("External");
  gtk_menu_append (GTK_MENU (menu), sub_menu_item);
  gtk_widget_show (sub_menu_item);

  sub_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (sub_menu_item), sub_menu);

  menu_item_fwhois = gtk_menu_item_new_with_label ("Fwhois");
  gtk_menu_append (GTK_MENU (sub_menu), menu_item_fwhois);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_fwhois), "activate",
			     GTK_SIGNAL_FUNC (probe_external_fwhois), NULL);
  gtk_widget_show (menu_item_fwhois);

  menu_item_whois = gtk_menu_item_new_with_label ("Whois");
  gtk_menu_append (GTK_MENU (sub_menu), menu_item_whois);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_whois), "activate",
			     GTK_SIGNAL_FUNC (probe_external_whois), NULL);
  gtk_widget_show (menu_item_whois);

  menu_item_about = gtk_menu_item_new_with_label ("About");
  gtk_menu_append (GTK_MENU (menu), menu_item_about);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_about),"activate",
			     GTK_SIGNAL_FUNC (about_init), NULL);
  gtk_widget_show (menu_item_about);

  menu_item_quit = gtk_menu_item_new_with_label ("Quit");
  gtk_menu_append (GTK_MENU (menu), menu_item_quit);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_quit),"activate",
			     GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_widget_show (menu_item_quit);

  h_box_top = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), h_box_top, FALSE, FALSE, 5);
  gtk_widget_show (h_box_top);

  label = gtk_label_new ("Object");
  gtk_box_pack_start (GTK_BOX (h_box_top), label, FALSE, TRUE, 10);
  gtk_widget_show (label);

  e_domain = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (e_domain), "activate",
		      GTK_SIGNAL_FUNC (enter_callback), e_domain);
  gtk_box_pack_start (GTK_BOX (h_box_top), e_domain, TRUE, TRUE, 0);
  gtk_widget_show (e_domain);

  b_submit = gtk_button_new_with_label (" Submit ");
  gtk_signal_connect (GTK_OBJECT(b_submit),"clicked",GTK_SIGNAL_FUNC(probe_internal),NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_submit, FALSE, TRUE, 10);
  gtk_widget_show (b_submit);

  b_help = gtk_button_new_with_label (" ? ");
  gtk_signal_connect (GTK_OBJECT(b_help),"clicked",GTK_SIGNAL_FUNC(probe_help),NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_help, FALSE, TRUE, 0);
  gtk_widget_show (b_help);

  b_quit = gtk_button_new_with_label (" Quit ");
  gtk_signal_connect (GTK_OBJECT(b_quit),"clicked",GTK_SIGNAL_FUNC(destroy),NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_quit, FALSE, TRUE, 10);
  gtk_widget_show (b_quit);

  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), box, TRUE, TRUE, 10);
  gtk_widget_show (box);

  h_box_low = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), h_box_low, TRUE, TRUE, 10);
  gtk_widget_show (h_box_low);

  text_field = gtk_text_new (NULL,NULL);
  gtk_box_pack_start (GTK_BOX (h_box_low), text_field, TRUE, TRUE, 0);
  gtk_widget_show (text_field);
  gtk_widget_set_usize (text_field,350,200);

  v_scrollbar = gtk_vscrollbar_new (GTK_TEXT(text_field)->vadj);
  gtk_box_pack_start (GTK_BOX (h_box_low), v_scrollbar, FALSE, FALSE, 0);
  gtk_widget_show (v_scrollbar);

  scrolled_window = gtk_scrolled_window_new (NULL,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (h_box_low), scrolled_window, FALSE, TRUE, 0);
  gtk_widget_show (scrolled_window);
  gtk_widget_set_usize (scrolled_window,130,0);

  server_list = gtk_list_new ();
  gtk_container_add (GTK_CONTAINER (scrolled_window),server_list);
  gtk_widget_show (server_list);
  gtk_signal_connect (GTK_OBJECT (server_list),"selection_changed",
		      GTK_SIGNAL_FUNC (list_selection),NULL);

  while (servers[i] != 0)
    {
      GtkWidget *label;
      gchar *string;
      list_item = gtk_list_item_new_with_label (servers[i]);
      label = gtk_label_new (servers[i]);
      gtk_container_add (GTK_CONTAINER (server_list),list_item);
      gtk_widget_show (list_item);
      gtk_label_get (GTK_LABEL (label),&string);
      gtk_object_set_data (GTK_OBJECT(list_item),list_item_data_key,string);
      i++;
    }

  gtk_main ();
  return 0;
}
