.\" @(#)xiterm.1		-*- nroff -*-
.\"-------
.\" Dd	distance to space vertically before a "display"
.\" These are what n/troff use for interparagraph distance
.\"-------
.if t .nr Dd .4v
.if n .nr Dd 1v
.\"-------
.\" Sp	space down the interparagraph distance
.\"-------
.de Sp
.sp \\n(Ddu
..
.\"-------
.\" Ds	begin a display, indented .5 inches from the surrounding text.
.\"
.\" Note that uses of Ds and De may NOT be nested.
.\"-------
.de Ds
.Sp
.in +0.5i
.nf
..
.\"-------
.\" De	end a display (no trailing vertical spacing)
.\"-------
.de De
.fi
.in
..
.TH XITERM 1 "September, 1st 1997" "X Version 11" "X Tools"
.UC
.SH NAME
xiterm \(em VT102 emulator for the X window system
.SH SYNOPSIS
.B xiterm
.RI [ options ]
.RB [ \-e
.I command
.RI [ args ]]
.\"
.\" change the following strings to suit your installation
.\" hk = HOTKEY, bf = BIGFONT, sf = SMALLFONT
.\" .ds hk Ctrl
.ds hk Alt
.ds bf >
.ds sf <
.\" end of editing region
.SH DESCRIPTION
.B xiterm
\(em version
.B 1.4
\(em is a color vt102 terminal emulator intended as an
.IR xterm (1)
replacement for users who do not require features such as Tektronix 4014
emulation and toolkit-style configurability.
As a result,
.B xiterm
uses much less swap space \(em a significant advantage on a machine serving
many X sessions.
.SH OPTIONS
The
.B xiterm
options
(mostly a subset of
.IR xterm 's)
are listed below.
In keeping with the smaller-is-better philosophy, options may be eliminated
or default values chosen at compile-time, so options and defaults listed
may not accurately reflect the version installed on your system.
.LP
Note that
.B xiterm
permits the resource name to be used as a long-option (\-\-/++ option) so the
potential command-line options are far greater than those listed.
.br
For example: `xiterm \-\-loginShell \-\-color1 Orange'.
.TP
.BR "\-help" , "\-\-help"
Print out a message describing available options.
.TP
.BI \-display " displayname"
Attempt to open a window on the named X display
.RB ( \-d
still respected).
In the absence of this option, the display specified by the
.B DISPLAY
environment variable is used.
.TP
.BI \-geometry " geom"
Window geometry
.RB ( \-g
still respected); resource
.BR geometry .
.TP
.BR \-rv |+ rv
Turn on/off simulated reverse video; resource
.BR reverseVideo .
.TP
.BI \-bg " color"
Window background color; resource
.BR background .
.TP
.BI \-fg " color"
Window foreground color; resource
.BR foreground .
.TP
.BI \-pixmap: " file[;geom]"
Specify XPM file for the background and also optionally specify its
scaling with a geometry string; resource
.BR backgroundPixmap .
.TP
.BI \-cr " color"
The cursor color; resource
.BR cursorColor .
.TP
.BI \-fn " fontname"
Main normal text font; resource
.BR font .
.TP
.BI \-fb " fontname"
Main bold text font; resource
.BR boldFont .
.TP
.BI \-fk " fontname"
Main Kanji font; resource
.BR kfont .
.TP
.BI \-km " mode"
Kanji encoding mode;
.BR eucj :
EUC Japanese encoding.
.BR sjis :
Shift JIS encoding; resource
.BR kanji_encoding .
.TP
.BI \-grk " mode"
Greek keyboard translation;
.BR iso :
ISO-8859 mapping.
.BR ibm :
IBM-437 mapping; resource
.BR greek_keyboard .
.TP
.BI \-name " name"
Specify the application name under which resources are to be obtained,
rather than the default executable file name.
Name should not contain `.' or `*' characters.
Also sets the icon and title name.
.TP
.BR \-ls |+ ls
Start as a login-shell/sub-shell; resource
.BR loginShell .
.TP
.BR \-ut |+ ut
Inhibit/enable writing a utmp entry; resource
.BR utmpInhibit .
.TP
.BR \-vb |+ vb
Turn on/off visual bell on receipt of a bell character; resource
.BR visualBell .
.TP
.BR \-sb |+ sb
Turn on/off scrollbar; resource
.BR scrollBar .
.TP
.B \-iconic
Start iconified, if the window manager supports that option.
.TP
.BI \-sl " number"
Save
.I number
lines in the scrollback buffer; resource
.BR saveLines .
.TP
\fB\-e\fP \fIcommand\fP [\fIarguments\fP]
Run the command with its command-line arguments in the
.B xiterm
window.
If this option is used, it must be the last on the command-line.
If there is no
.B \-e
option then the default is to run the program specified by the
.B SHELL
environment variable or, failing that,
.IR sh (1).
.TP
.BI \-title " text"
Window title
.RB ( \-T
still respected); resource
.BR title .
.TP
.BI \-n " text"
Icon name; resource
.BR iconName .
.TP
.B \-C
Capture system console messages.
.SH RESOURCES (available also as long-options)
.B xiterm
accepts application defaults set in XAPPLOADDIR/Xiterm (compile-time defined:
usually
.BR /usr/lib/X11/app-defaults/Xiterm )
and resources set in
.B ~/.Xdefaults
or
.BR ~/.Xresources .
Note that when reading X resources,
.B xiterm
recognizes two class names:
.B XTerm
and
.BR Xiterm .
The class name
.B XTerm
allows resources common to both
.B xiterm
and
.I xterm
to be easily configured, while the class name
.B Xiterm
allows resources unique to
.BR xiterm ,
notably colors and key-handling, to be shared between different
.B xiterm
configurations.
If no resources are specified, suitable defaults will be used.
Command-line arguments can be used to override resource settings.
The following resources are allowed:
.TP
.BI geometry: " geom"
Create the window with the specified X window geometry [default 80x24]; option
.BR \-geometry .
.TP
.BI background: " color"
Use the specified color as the window's background color
[default White];
option
.BR \-bg .
.TP
.BI foreground: " color"
Use the specified color as the window's foreground color
[default Black];
option
.BR \-fg .
.TP
.BI color n : " color"
Use the specified color for the color value
.IR n ,
where 0\-7 corresponds to low-intensity (normal) colors and 8\-15
corresponds to high-intensity (bold = bright foreground, blink = bright
background) colors.
The canonical names are as follows:
0=black,
1=red,
2=green,
3=yellow,
4=blue,
5=magenta,
6=cyan,
7=white,
but the actual color names used are listed in the
.B "COLORS AND GRAPHICS"
section.
.TP
.BI colorBD: " color"
Use the specified color to display bold characters when the foreground color
is the default.
.TP
.BI colorUL: " color"
Use the specified color to display underlined characters when the foreground
color is the default.
.TP
.BI cursorColor: " color"
Use the specified color for the cursor.
The default is to use the foreground color; option
.BR \-cr .
.TP
.BI cursorColor2: " color"
Use the specified color for the color of the cursor text.
For this to take effect,
.B cursorColor
must also be specified.
The default is to use the background color.
.TP
.BI reverseVideo: " boolean"
.BR True :
simulate reverse video by foreground and background colors; option
.BR \-rv ,
.BR False :
regular screen colors [default]; option
.RB + rv .
See note in
.B "COLORS AND GRAPHICS"
section.
.TP
.BI scrollColor: " color"
Use the specified color for the scrollbar [default #B2B2B2].
.TP
.BI backgroundPixmap: " file[;geom]"
Use the specified XPM file (note the `.xpm' extension is optional) for
the background and also optionally specify its scaling with a geometry
string
.BR WxH+X+Y ,
in which
.BR "W" / "H"
specify the horizontal/vertical scale (percent) and
.BR "X" / "Y"
locate the image centre (percent).
A scale of 0 displays the image with tiling.
A scale of 1 displays the image without any scaling.
A scale of 2 to 9 specifies the number of images in that direction.
No image will be magnified beyond 10 times its original size.
The maximum permitted scale is 1000.
[default 100x100+50+50]
.TP
.BI path: " path"
Specify the colon-delimited search path for finding XPM files, in
addition to the paths specified by the
.B XITERMPATH
and
.B PATH
environment variables.
.TP
.BI font: " fontname"
Select the main text font used [default 7x14]; option
.BR \-fn .
.TP
.BI font n : " fontname"
Specify the alternative font
.IR n .
The default font values:
.\"-------
.\" Table start
.\"-------
.nr t0 \w'\fBfont4\fP:\0\0\0\0'u
.ta \n(t0u
.Ds
.nf
.BR font ":\t7x14"
.BR font1 ":\t6x10"
.BR font2 ":\t6x13"
.BR font3 ":\t8x13"
.BR font4 ":\t9x15"
.fi
.De
.\"-------
.\" Table end
.\"-------
.TP
.BI boldFont: " fontname"
Specify the name of the bold font to use if
.B colorBD
has not been specified and it is not possible to map the default foreground
color to color 8\-15 [default NONE].
This font must be the same height and width as the normal font;
option
.BR \-fb .
.TP
.BI kfont: " fontname"
Select the main Kanji text font used [default k14]; option
.BR \-fk .
.TP
.BI kfont n : " fontname"
Specify the alternative Kanji font
.IR n .
If compiled for Kanji, the Roman and Kanji font sizes should match.
The default font values:
.\"-------
.\" Table start
.\"-------
.nr t0 \w'\fBkfont4\fP:\0\0\0\0'u
.ta \n(t0u
.Ds
.nf
.BR font  ":\t7x14"
.BR font1 ":\t8x16"
.BR font2 ":\t9x18"
.BR font3 ":\t12x24"
.BR font4 ":\t13x26"
.Sp
.BR kfont  ":\tk14"
.BR kfont1 ":\tjiskan16"
.BR kfont2 ":\tjiskan18"
.BR kfont3 ":\tjiskan24"
.BR kfont4 ":\tjiskan26"
.fi
.De
.\"-------
.\" Table end
.\"-------
.TP
.BI kanji_encoding: " mode"
Set the Kanji encoding mode to be used;
.BR eucj :
EUC Japanese encoding [default].
.BR sjis :
Shift JIS encoding; option
.BR \-km .
.TP
.BI greek_keyboard: " mode"
Set the Greek keyboard translation mode to be used;
.BR iso :
ISO-8859 mapping (elot-928) [default].
.BR ibm :
IBM-437 mapping (DOS codepage 737); option
.BR \-grk .
Use
.B Mode_switch
to toggle keyboard input.
For more details, see the distributed file
.BR README.greek .
.TP
.BI title: " text"
Set window title string, the default title is the command-line specified
after the
.B \-e
option, if any, otherwise the application name; option
.BR \-title .
.TP
.BI iconName: " text"
Set the name used to label the window's icon or displayed in an icon manager
window, it also sets the window's title unless it is explicitly set;
option
.BR \-n .
.TP
.BI mapAlert: " boolean"
.BR True :
de-iconify (map) on receipt of a bell character.
.BR False :
no de-iconify (map) on receipt of a bell character [default].
.TP
.BI visualBell: " boolean"
.BR True :
use visual bell on receipt of a bell character; option
.BR \-vb .
.BR False :
no visual bell [default]; option
.RB + vb .
.TP
.BI loginShell: " boolean"
.BR True :
start as a login shell by prepending a `\-' to
.B argv[0]
of the shell; option
.BR \-ls .
.BR False :
start as a normal sub-shell [default]; option
.RB + ls .
.TP
.BI utmpInhibit: " boolean"
.BR True :
inhibit writing record into the system log file
.BR utmp ;
option
.BR \-ut .
.BR False :
write record into the system log file
.B utmp
[default]; option
.RB + ut .
.TP
.BI print-pipe: " string"
Specify a command pipe for vt100 printer [default
.IR lpr (1)].
Use
.B Print
to initiate a screen dump to the printer and
.B Ctrl-Print
or
.B Shift-Print
to include the scrollback as well.
.TP
.BI scrollBar: " boolean"
.BR True :
enable the scrollbar [default]; option
.BR \-sb .
.BR False :
disable the scrollbar; option
.RB + sb .
Note that the scrollbar position (left/right) and its type (with/without
arrows) is compile-time selected.
.TP
.BI smallfont_key: " keysym"
If enabled, use
.BI \*(hk- "keysym"
to toggle to a smaller font [default
.BR \*(hk-\*(sf ].
.TP
.BI bigfont_key: " keysym"
If enabled, use
.BI \*(hk- "keysym"
to toggle to a bigger font [default
.BR \*(hk-\*(bf ].
.TP
.BI saveLines: " number"
Save
.I number
lines in the scrollback buffer [default 64]; option
.BR \-sl .
.TP
.BI meta8: " boolean"
.BR True :
handle Meta (Alt) + keypress to set the 8th bit.
.BR False :
handle Meta (Alt) + keypress as an escape prefix [default].
.TP
.BI cutchars: " string"
The characters used as delimiters for double-click word selection.
The built-in default:
.br
.B TAB SPACE BACKSLASH `"'&()*,;<=>?@[]{|}
.TP
.BI keysym. sym : " string"
Associate
.I string
with keysym
.I sym
.RB ( 0xFF00
\-
.BR 0xFFFF ).
It may contain escape values (\ea: bell, \eb: backspace, \ee, \eE:
escape, \en: newline, \er: return, \et: tab, \e000: octal number) or
control characters (^?: delete, ^@: null, ^A ...) and may enclosed
with double quotes so that it can start or end with whitespace.
The intervening resource name
.B keysym.
cannot be omitted.
This resource is only available when compiled with
.BR FAKE_RESOURCES .
.SH "THE SCROLLBAR"
Lines of text that scroll off the top of the
.B xiterm
window (resource:
.BR saveLines )
and can be scrolled back using the scrollbar or by keystrokes.
The normal
.B xiterm
scrollbar has arrows and its behaviour is fairly intuitive.
The
.B xterm-scrollbar
is without arrows and its behaviour mimics that of
.IR xterm .
.LP
Scroll down with
.B Button1
.RB ( "xterm-scrollbar" )
or
.BR Shift-Next .
.br
Scroll up with
.B Button3
.RB ( "xterm-scrollbar" )
or
.BR Shift-Prior .
.br
Continuous scroll with
.BR Button2 .
.SH "MOUSE REPORTING"
To temporarily override mouse reporting, for either the scrollbar or the
normal text selection/insertion, hold either the Shift or the Meta (Alt) key
while performing the desired mouse action.
.LP
If mouse reporting mode is active, the normal scrollbar actions are disabled
\(em on the assumption that we are using a fullscreen application.
Instead, pressing Button1 and Button3 sends
.BR ESC[6~ " (Next)"
and
.BR ESC[5~ " (Prior),"
respectively.
Similarly, clicking on the up and down arrows sends
.BR ESC[A " (Up) and"
.BR ESC[B " (Down),"
respectively.
.SH "TEXT SELECTION AND INSERTION"
The behaviour of text selection and insertion mechanism is similar to
.IR xterm .
.TP
.BR "Selection" :
Left click at the beginning of the region,
drag to the end of the region and release;
Right click to extend the marked region;
Left double-click to select a word;
Left triple-click to select the entire line.
.TP
.BR "Insertion" :
Pressing and releasing the Middle mouse button (or
.BR Shift-Insert )
in an
.B xiterm
window causes the current text selection to be inserted as if it had
been typed on the keyboard.
.SH "CHANGING FONTS"
You can change fonts on-the-fly, which is to say cycle through the
default font and others of various sizes, by using
.BR Shift-KP_Add " and "
.BR Shift-KP_Subtract .
Or, alternatively (if enabled) with
.BR \*(hk-\*(bf " and"
.BR \*(hk-\*(sf ,
where the actual key can be selected using resources
.BR smallfont_key / bigfont_key .
.SH "LOGIN STAMP"
.B xiterm
tries to write an entry into the
.B utmp
file (usually
.BR /etc/utmp ),
so that it can be seen via the
.IR who (1)
command, and can accept messages.
To allow this feature,
.B xiterm
must be installed setuid root.
.SH "COLORS AND GRAPHICS"
If graphics support was enabled at compile-time,
.B xiterm
can be queried with ANSI escape sequences and can address individual pixels
instead of text characters.
Note the graphics support is still considered beta code.
.LP
In addition to the default foreground and background colors,
.B xiterm
can display up to 16 colors (8 ANSI colors plus high-intensity bold/blink
versions of the same).
Here is a list of the colors with their
.B rgb.txt
names.
.\"------------
.\" Table start
.\"------------
.nr t0 \w'\fBcolor15\fP\0\0'u
.nr t1 \n(t0+\w'(bright magenta)\0\0'u
.ta \n(t0u \n(t1u
.Ds
.nf
.BR color0 "\t(black)\t= Black"
.BR color1 "\t(red)\t= Red3"
.BR color2 "\t(green)\t= Green3"
.BR color3 "\t(yellow)\t= Yellow3"
.BR color4 "\t(blue)\t= Blue3"
.BR color5 "\t(magenta)\t= Magenta3"
.BR color6 "\t(cyan)\t= Cyan3"
.BR color7 "\t(white)\t= AntiqueWhite"
.Sp
.BR color8 "\t(bright black)\t= Grey25"
.BR color9 "\t(bright red)\t= Red"
.BR color10 "\t(bright green)\t= Green"
.BR color11 "\t(bright yellow)\t= Yellow"
.BR color12 "\t(bright blue)\t= Blue"
.BR color13 "\t(bright magenta)\t= Magenta"
.BR color14 "\t(bright cyan)\t= Cyan"
.BR color15 "\t(bright white)\t= White"
.Sp
.ta \n(t1u
.BR foreground "\t= Black"
.BR background "\t= White"
.fi
.De
.\"----------
.\" Table end
.\"----------
.LP
It is also possible to specify the color values of
.BR foreground ,
.BR background ,
.BR cursorColor ,
.BR cursorColor2 ,
.BR colorBD ,
.B colorUL
as a number 0\-15, as a convenient shorthand to reference the color name of
color0\-color15.
.LP
Note that
.B \-rv
.RB ( "reverseVideo: True" )
simulates reverse video by always swapping the foreground/background colors.
This is in contrast to
.I xterm
where the colors are only swapped if they have not otherwise been specified.
For example,
.TP
.B xiterm \-fg Black \-bg White \-rv
would yield White on Black, while on
.I xterm
it would yield Black on White.
.SH ENVIRONMENT
.B xiterm
sets the environment variables
.BR TERM,
.B COLORTERM
and
.BR COLORFGBG .
The environment variable
.B WINDOWID
is set to the X window id number of the
.B xiterm
window and it also uses and sets the environment variable
.B DISPLAY
to specify which display terminal to use.
.B xiterm
uses the environment variables
.B XITERMPATH
and
.B PATH
to find XPM files.
.SH FILES
.TP 16
.B /etc/utmp
System file for login records.
.TP 16
.B /usr/lib/X11/rgb.txt
Color names.
.SH "SEE ALSO"
.IR xterm (1),
.IR sh (1),
.IR resize (1),
.IR X (1),
.IR pty (4),
.IR tty (4),
.IR utmp (5)
.SH BUGS
Selecting/pasting very large chunks of text is a problem.
But as is the case for
.IR xterm ,
it is a bug of the pseudo terminal driver of those systems.
.LP
xiterm 1.0 has the utmp support cleaned-up and supports
.B utmpx
(i.e. Solaris 2.x) but there are still some problems.
Please inform the maintainer of the correct solutions to utmp problems
since he doesn't have root access of his own to test utmp.
.LP
Cursor change support is not yet implemented.
.LP
Click-and-drag doesn't work with X11 mouse report overriding.
.LP
Graphics support is fairly crude.
.LP
For some fonts there are problems with pixel-droppings being left behind
when simulated bold (overstrike) precedes a space character.
Fixing
.B xiterm
to handle these cases requires a lot of energy.
So the easiest course by far is to specify a boldFont, specify colorBD or,
if it was compiled without NO_BRIGHTCOLOR, to select a foreground color that
matches the pixel values of color 0\-7 so that overstrike bold won't be used.
.LP
Like
.IR xterm ,
.B xiterm
handles mono-space fonts only.
.SH AUTHOR
John Bovey, University of Kent, 1992.
.LP
Very very very heavily modified by Rob Nation
<nation@rocket.sanders.lockheed.com>
.LP
Greek keyboard input: Angelo Haritsis <ah@doc.ic.ac.uk>
.LP
Utmpx addition (Solaris 2.x) and extensive reworking of pseudo-tty handling
and addition of BSD sgtty terminal handling support by Raul Garcia Garcia
<rgg@tid.es> 16/10/95.
.LP
mj olesen <olesen@me.QueensU.CA> (changes.txt 2.11 to 2.20)
.\" for those who don't trust LSM entries, be explicit here
.SH "CURRENT MAINTAINER"
"Guylhem Aznar <guylhem@danmark.linux.eu.org>"
.SH "LOCATION"
<www.linux-france.com>
.br
