/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

MiniIcon::MiniIcon(YWindow *aParent,
                   YFrameWindow *frame,
                   Window win):
    YFrameControl(aParent, frame, win)
{
    selected = 0;
    setGeometry(0, 0, 120, 24);
}

MiniIcon::~MiniIcon() {
}

void MiniIcon::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
#ifdef CONFIG_TASKBAR
    bool focused = frame()->focused();
    YColor *bg = focused ? activeMinimizedWindowBg : normalMinimizedWindowBg;;
    YColor *fg = focused ? activeMinimizedWindowFg : normalMinimizedWindowFg;;
    int tx = 2;
    int x, y, w, h;

    g.setColor(bg);
    g.draw3DRect(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 2, height() - 2);

    x = tx; y = 2;
    w = width() - 6;
    h = height() - 6;

    if (selected == 2) {
        g.setColor(bg->darker());
        g.draw3DRect(x, y, w, h, false);
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
    } else {
        g.setColor(bg->brighter());
        g.drawRect(x + 1, y + 1, w, h);
        g.setColor(bg->darker());
        g.drawRect(x, y, w, h);
        g.setColor(bg);
        g.fillRect(x + 2, y + 2, w - 2, h - 2);
    }

    if (frame()->clientIcon() && frame()->clientIcon()->small()) {
        //int y = (height() - 3 - frame()->clientIcon()->small()->height()) / 2;
        g.drawPixmap(frame()->clientIcon()->small(), 2 + tx + 1, 4);
    }

    char *str = (char *)frame()->client()->iconTitle();
    if (!str)
        str = (char *)frame()->client()->windowTitle();
    if (str) {
        g.setColor(fg);
        g.setFont(minimizedWindowFont);
        int ty = (height() - 1 + titleFont->height()) / 2 - titleFont->descent();
        if (ty < 2)
            ty = 2;
        g.drawChars((char *)str, 0, strlen(str),
                    tx + 4 + 16 + 2,
                    ty);
        //(yheight() - font->height()) / 2 - titleFont->descent() - 4);
    }
#endif
}

void MiniIcon::handleButton(const XButtonEvent &button) {
    if (button.type == ButtonPress) {
        if (!(button.state & ControlMask))
            frame()->wmRaise();
        manager->setFocus(frame(), false);
        if (button.button == 1) {
            selected = 2;
            repaint();
        }
    } else if (button.type == ButtonRelease) {
        if (button.button == 1) {
            if (selected == 2) {
                if (button.state & app->AltMask) {
                    frame()->wmLower();
                } else {
                    if (!(button.state & ControlMask))
                        frame()->wmRaise();
                    frame()->activate();
                }
            }
            selected = 0;
            repaint();
        }
    }
    YWindow::handleButton(button);
}

void MiniIcon::handleClick(const XButtonEvent &/*down*/, const XButtonEvent &up, int /*count*/) {
    if (up.button == 3) {
        frame()->popupSystemMenu(up.x_root, up.y_root, -1, -1,
                                 YPopupWindow::pfCanFlipVertical |
                                 YPopupWindow::pfCanFlipHorizontal |
                                 YPopupWindow::pfPopupMenu);
    }
}

void MiniIcon::handleCrossing(const XCrossingEvent &crossing) {
    if (selected > 0) {
        if (crossing.type == EnterNotify) {
            selected = 2;
            repaint();
        } else if (crossing.type == LeaveNotify) {
            selected = 1;
            repaint();
        }
    }

}

void MiniIcon::handleDrag(const XButtonEvent &down, const XMotionEvent &motion) {
    if (down.button != 1) {
        int x = motion.x_root - down.x;
        int y = motion.y_root - down.y;

        //x += down.x;
        //y += down.y;

        CARD32 l = frame()->getLayer();
        int mx = manager->minX(l), Mx = manager->maxX(l);
        int my = manager->minY(l), My = manager->maxY(l);

        if (x + int(width()) >= Mx) x = Mx - width();
        if (y + int(height()) >= My) y = My - height();
        if (x < mx) x = mx;
        if (y < my) y = my;

        frame()->setPosition(x, y);
    }
}
