/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

int configurationLoaded = 0;

#define CFGDEF
#include "default.h"

CARD32 workspaceCount = 0;
char *workspaceNames[MAXWORKSPACES];

const char *clrBlack                  = "rgb:00/00/00";
const char *clrWhite                  = "rgb:FF/FF/FF";

int is_reg(const char *path) {
    struct stat sb;

    if (stat(path, &sb) != 0)
        return 0;
    if (!S_ISREG(sb.st_mode))
        return 0;
    return 1;
}

int findPath(const char *path, int mode, const char *name, char **fullname) {
#ifdef __EMX__
    char tmp[1024];
    strcpy(tmp, name);
    if (mode & X_OK)
        strcat(tmp, ".exe");
    name = tmp;
#endif
  
    if (strchr(name, '/') != 0
#ifdef __EMX__
        || strchr(name, '\\') != 0
#endif
       )
    {
#ifdef __EMX__
        if (access(name, 0) == 0) {
            *fullname = strdup(name);
            return 1;
        }
#else
        if (access(name, mode) == 0 && is_reg(name)) {
            *fullname = strdup(name);
            return 1;
        }
#endif
    } else {
        if (path == 0)
            return 0;

        char prog[1024];
        const char *p, *q;
        unsigned int len, nameLen = strlen(name);

        if (nameLen > sizeof(prog))
            return 0;

        p = path;
        while (*p) {
            q = p;
            while (*p && *p != PATHSEP)
                p++;

            len = p - q;

            if (len > 0 && len < sizeof(prog) - nameLen - 2) {
                strncpy(prog, q, len);
                if (!ISSLASH(prog[len - 1]))
                    prog[len++] = SLASH;
                strcpy(prog + len, name);

#ifdef DEBUG_P
                if (debug)
                    msg("checking program path %s\n", prog);
#endif
#ifdef __EMX__
                if (access(prog, 0) == 0) {
                    *fullname = strdup(prog);
                    return 1;
                }
#else
                if (access(prog, mode) == 0 && is_reg(prog)) {
                    *fullname = strdup(prog);
                    return 1;
                }
#endif
            }
            if (*p == PATHSEP)
                p++;
        }
    }
    return 0;
}

void addWorkspace(const char *name) {
    if (workspaceCount >= MAXWORKSPACES)
        return;
    workspaceNames[workspaceCount] = strdup(name);
    assert(workspaceNames[workspaceCount] != NULL);
    workspaceCount++;
}

char *getArgument(char *dest, int maxLen, char *p) {
    char *d;
    int len = 0;
    int in_str = 0;
    
    while (*p && (*p == ' ' || *p == '\t'))
        p++;

    d = dest;
    len = 0;
    while (*p && len < maxLen - 1 &&
           (in_str || (*p != ' ' && *p != '\t' && *p != '\n')))
    {
        if (in_str && *p == '\\' && p[1]) {
            p++;
            *d++ = *p++;
            len++;
        } else if (*p == '"') {
            in_str = !in_str;
            p++;
        } else {
            *d++ = *p++;
            len++;
        }
    }
    *d = 0;

    return p;
}

#ifndef NO_CONFIGURE


char *setOption(char *name, char *arg, char *rest) {
    unsigned int a;

    MSG(("SET %s := %s ;\n", name, arg));
    
    for (a = 0; a < ACOUNT(bool_options); a++)
        if (strcmp(name, bool_options[a].option) == 0) {
            if ((arg[0] == '1' || arg[0] == '0') && arg[1] == 0)
                *(bool_options[a].value) = (arg[0] == '1') ? true : false;
            else {
                fprintf(stderr, "bad argument: %s for %s\n", arg, name);
                return 0;
            }
            return rest;
        }

    for (a = 0; a < ACOUNT(uint_options); a++)
        if (strcmp(name, uint_options[a].option) == 0) {
            unsigned int v = atoi(arg);
            
            if (v >= uint_options[a].min && v <= uint_options[a].max)
                *(uint_options[a].value) = v;
            else {
                fprintf(stderr, "bad argument: %s for %s\n", arg, name);
                return 0;
            }
            return rest;
        }
            
    for (a = 0; a < ACOUNT(string_options); a++)
        if (strcmp(name, string_options[a].option) == 0) {
            if (!string_options[a].initial)
                FREE((char *)*string_options[a].value);
            *string_options[a].value = strdup(arg);
            string_options[a].initial = false;
            return rest;
        }
    if (strcmp(name, "AddWorkspace") == 0) {
        addWorkspace(arg);
        return rest;
    } else if (strcmp(name, "Look") == 0) {
#ifdef CONFIG_LOOK_WARP4
        if (strcmp(arg, "warp4") == 0)
            wmLook = lookWarp4;
        else
#endif
#ifdef CONFIG_LOOK_WARP3
        if (strcmp(arg, "warp3") == 0)
            wmLook = lookWarp3;
        else
#endif
#ifdef CONFIG_LOOK_WIN95
        if (strcmp(arg, "win95") == 0)
            wmLook = lookWin95;
        else
#endif
#ifdef CONFIG_LOOK_MOTIF
        if (strcmp(arg, "motif") == 0)
            wmLook = lookMotif;
        else
#endif
#ifdef CONFIG_LOOK_NICE
        if (strcmp(arg, "nice") == 0)
            wmLook = lookNice;
        else
#endif
#ifdef CONFIG_LOOK_PIXMAP
        if (strcmp(arg, "pixmap") == 0)
            wmLook = lookPixmap;
        else
#endif
#ifdef CONFIG_LOOK_METAL
        if (strcmp(arg, "metal") == 0)
            wmLook = lookMetal;
        else
#endif
#ifdef CONFIG_LOOK_GTK
        if (strcmp(arg, "gtk") == 0)
            wmLook = lookGtk;
        else
#endif
        {
            fprintf(stderr, "bad Look name\n");
            return 0;
        }
        return rest;
    }
    fprintf(stderr, "bad option: %s\n", name);
    ///!!! check
    return rest;
}

// parse option name and argument
// name is string without spaces up to =
// option is a " quoted string or characters up to next space
char *parseOption(char *str) {
    char name[64];
    char argument[256];
    char *p = str;
    unsigned int len = 0;

    while (*p && *p != '=' && *p != ' ' && len < sizeof(name) - 1)
        p++, len++;

    strncpy(name, str, len);
    name[len] = 0;

    while (*p && *p != '=')
        p++;
    if (*p != '=')
        return 0;
    p++;

    p = getArgument(argument, sizeof(argument), p);

    return setOption(name, argument, p);
}

void parseConfiguration(char *data) {
    char *p = data;

    while (p && *p) {
        while (*p == ' ' || *p == '\t' || *p == '\n' || (*p == '\\' && p[1] == '\n'))
            p++;
        
        if (*p != '#')
            p = parseOption(p);
        else {
            while (*p && *p != '\n') {
                if (*p == '\\' && p[1] != 0)
                    p++;
                p++;
            }
        }
    }
}

void loadConfiguration(const char *fileName) {
    int fd = open(fileName, O_RDONLY | O_TEXT);

    if (fd == -1)
        return ;

    struct stat sb;

    if (fstat(fd, &sb) == -1)
        return ;

    int len = sb.st_size;

    char *buf = (char *)MALLOC(len + 1);
    if (buf == 0)
        return ;

    if (read(fd, buf, len) != len)
        return;

    buf[len] = 0;
    close(fd);
    parseConfiguration(buf);
    FREE(buf);
    
    configurationLoaded = 1;
}

void freeConfig() {
    for (unsigned int a = 0; a < ACOUNT(string_options); a++)
        if (!string_options[a].initial) {
            FREE((char *)*string_options[a].value);
            string_options[a].initial = 0;
            string_options[a].value = 0;
        }
}
#endif
