/*
 *  window.h	
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@informatik.uni-wuerzburg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1998/10/08 21:48:57 $
 *  $Author: hafner $
 *  $Revision: 1.16 $
 *  $State: Exp $
 */

#ifndef _WINDOW_H
#define _WINDOW_H

#include <proplist.h>
#include <gtk/gtk.h>
#include <misc.h>

typedef struct wtexture
{
   GtkWidget **wpixmap;
   GtkWidget **wgradient;
   proplist_t *key;
} wtexture_t;

void
root_window (int argc, char **argv, bool_t preview_browser, const char *font,
	     proplist_t *wmc, proplist_t *wmlist);
char *
get_pixmap_path (const char *name);
GtkWidget *
make_pixmap (const char *name, unsigned max_width, unsigned max_height,
	     GtkWidget *pw);
gint
quit (GtkWidget *widget, gpointer ptr);
void
save_config_file (GtkWidget *widget, gpointer ptr);

#endif /* not _WINDOW_H */
