/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: helpp.h,v 1.45 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		helpp.h
**
**  contents:		private definitions for help lib
**			libhelp is based on libhtmlw
**
**  interface:		can be included via preprocessor #include
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _HELPP_H_
#define _HELPP_H_ 1

/* -------------------------------------------------------------------- *
*g  initial buffer size
** -------------------------------------------------------------------- */
#ifndef INIT_SIZE
# define INIT_SIZE 4096
#endif /* !INIT_SIZE  */

/* -------------------------------------------------------------------- *
*g  local definitions
** -------------------------------------------------------------------- */
/* 
 *  the help system uses now a dynamic image cache strategy.
 *  the cache starts at IMG_CACHE_SIZE and can grow to have all images
 *  of one html document in core. if not all slots are used for the 
 *  current image the cache shrinks by one slot.
 */
#ifndef IMG_CACHE_SIZE
# define IMG_CACHE_SIZE 8
#endif /* !IMG_CACHE_SIZE */

/*
 *  the buffer cache size is controlled here. BCACHE_SIZE is the number 
 *  of available cache slots. (there is no memory limit for buffers yet).
 */
#ifndef BCACHE_SIZE
# define BCACHE_SIZE 5
#endif /* !BCACHE_SIZE */

/*
 *  the initial libhelp search path. can be augmented at runtime with
 *  the LIBHELPPATH environment variable.
 */
#ifndef HELP_PATH
# define HELP_PATH "/usr/local/lib/mpsql/help:."
#endif /* !HELP_PATH */

#ifndef COLORS_PER_IMAGE
# define COLORS_PER_IMAGE 50
#endif /* !COLORS_PER_IMAGE */

/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include "help.h"

/* -------------------------------------------------------------------- *
*g  identification
** -------------------------------------------------------------------- */
#include "version.h"
#ifndef NO_RCSID
#ifndef RCSID
#define RCSID needed
#endif /* !defined(RCSID) */
#endif /* !defined(NO_RCSID) */

/* editres support  */
#if (XtSpecificationRelease > 4)
# define EDITRES_SUPPORT
# include <X11/Xmu/Editres.h>
#endif
#ifdef EDITRES_SUPPORT
# define editres_support(_shell)					\
    XtAddEventHandler (_shell, (EventMask) 0, True,			\
		       (XtEventHandler) _XEditResCheckMessages, NULL)
#else
# define editres_support(_shell) 
#endif /* EDITRES_SUPPORT  */

/* -------------------------------------------------------------------- *
*g  libhelp resources
**  libhelp resources can be set by the application (the user of the
**  help service) via the function help_set_resource.
** -------------------------------------------------------------------- */
/* internal resources types  */
typedef enum  {

    help_int,
    help_string,
    help_boolean

} representation_t;

/* internal resources  */
typedef struct resource_s {

    int	resource;		/* in the resource array the same as */
				/* the index to the element.*/
    representation_t rep;
    XtPointer	value;
    
} resource_t;

#define help_end_of_resources -1

/* -------------------------------------------------------------------- *
*g  error codes
** -------------------------------------------------------------------- */
/* Here we should have mapping from error codes to strings */
/* for more than one language.  */
#define no_error			0
#define error_out_of_memory 		1
#define error_cannot_open_display 	2
#define error_inconsistency 		3
#define error_no_file_specified		4

#define fatal_error(code) {				\
    fprintf (stderr,					\
	     "Error (code %d) in file %s line %d\na", 	\
	     code, __FILE__, __LINE__);			\
    exit (EXIT_FAILURE);				\
}

/* -------------------------------------------------------------------- *
*g  checked malloc macros
** -------------------------------------------------------------------- */
#include "check.h"

/* -------------------------------------------------------------------- *
*g  useful definitions
** -------------------------------------------------------------------- */
#ifndef FOPEN_READ_STRING
# define FOPEN_READ_STRING "r"
#endif /* !FOPEN_READ_STRING */

/* some c libraris do not define these:  */
#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif /* !EXIT_SUCCESS */

#ifndef EXIT_FAILURE
# define EXIT_FAILURE 1
#endif /* !EXIT_FAILURE */

/* -------------------------------------------------------------------- *
*g  history debugging macros.
** -------------------------------------------------------------------- */
#ifdef EXECUTE
#define execute(_str)						\
{								\
    (void) fprintf (stderr, "------\t%s\n", _str);		\
}
#else
#define execute(_str)
#endif /* EXECUTE  */

#ifdef DEBUG
#define trace(x)				\
{						\
    (void) printf x;				\
    (void) fflush (stdout);			\
}
#define hist_trace(x) printf x
#else
#define trace(x) 
#define hist_trace(x) 
#endif /* DEBUG  */

#ifdef CACHE_DEBUG
#define cache_trace(x) printf x
#else
#define cache_trace(x) 
#endif /* CACHE_DEBUG  */

#ifdef BCACHE_DEBUG
#define bcache_trace(_format,_val) 			\
{							\
    if (_val)  {					\
	(void) printf (_format, _val);			\
    } else  {						\
	(void) printf (_format, "<null>");		\
    }							\
    fflush (stdout);					\
}
#else
#define bcache_trace(_format,_val)
#endif /* BCACHE_DEBUG  */

#endif /* !_HELPP_H_ */
/* -------------------------------------------------------------------- *
*L  Emacs:
**  Local Variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  gh-language:	"english"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  End:
** -------------------------------------------------------------------- */





