/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: load.h,v 1.11 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		load.h
**
**  contents:		header file for module "load"
**
**  interface:		can be included via preprocessor #include
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _LOAD_H_
#define _LOAD_H_ 1

/* -------------------------------------------------------------------- *
*g  needed include files.
** -------------------------------------------------------------------- */
#include "buffer.h"

/* -------------------------------------------------------------------- *
*p  procedure-name:	read_html_file
**
**  purpose:		reads the contents of a file into a buffer that is 
**			globally allocated.
** -------------------------------------------------------------------- *
**  args:		string: name of html-file (name#anchor).
**  return type:	buffer_t*
**  precondition:	-
**  postcondition:	file is opened, read into allocated reusable buffer
**			(should not be freed with free()), file is closed,
**			contents are returned. Or error occured.
**  error handling.:	return NULL pointer on read error
**			exit application on memory error.
** -------------------------------------------------------------------- */
buffer_t*
read_html_file (/* i  */ char* file_anchor);

#endif /* !_LOAD_H_ */
/* -------------------------------------------------------------------- *
*L  Emacs:
**  Local Variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  gh-language:	"english"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  End:
** -------------------------------------------------------------------- */
