/************************************************************************/
/* File   : db.h					                */
/* Purpose: db data module header			                */
/* By     : Keith R. Davis					        */
/* Date   : 12/11/95					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay  Software			*/
/*          Copyright(c) 1994, Regents of the University of California  */
/************************************************************************/

#ifndef _DB_H
#define _DB_H

#define String PQString
#include <libpq-fe.h>                   /* postgres lib                         */
#undef String


#define ERR_MSG_SIZE 5120               /* max error message size               */
#define DATA_SIZE 2048                  /* max len of a single line in a query  */
#define MAX_PATH_LEN 2048               /* max length of a file path            */
#define QY_BUFFER_SIZE 8191             /* max size of a single query statement */
#define COPYBUFSIZ 8192                 /* max copy buffer size                 */ 
#define EXPLAINBUFSIZ 16384             /* max explain qy buffer size           */ 
#define RSLT_BUFFER_SIZE 4096000        /* max size of data in the result win.  */
#define DB_NAME_SZ 255                  /* max size of db name                  */
#define HOST_NAME_SZ 255                /* max size of host name                */
#define PORT_NAME_SZ 10                 /* max size of port id                  */
#define UNAME_NAME_SZ 255               /* max size of uname                    */
#define PWD_NAME_SZ 255                 /* max size of pwd                      */
#define PRINT_NAME_SZ 255               /* max size of printer name             */
#define COL_SZ 5                        /* max size of col width field          */

/* database globals */		
extern PGconn *db;		        /* db ptr		*/
extern char dbname[];		        /* db name ptr		*/
extern char host[];		        /* host name ptr	*/
extern char port[];		        /* port ptr		*/
extern char username[];                 /* user name            */
extern char *passwd;                    /* user password        */
extern char spool_file[];               /* spool file           */
extern char printer[];                  /* printer              */
extern int  alignment;                  /* column alignment     */ 
extern int  outtype;                    /* output type          */ 
extern int  user_prompt;                /* user & pwd prompt    */ 
extern char col_sep;                    /* column separator char*/


/* database functions */

/* connect to database		            */
int  DB_Connect(void);

/* disconnect from database		    */
void DB_Close(void);		         

 /* submits a query to the database         */
int  DB_SubmitQy(void);                 

/* open a sql file                          */
int  DB_OpenFile(char *file);           

/* save buffer to its file                  */  
int  DB_SaveFile(LLISTbuffer *buffer);  

/* handles the formatting of the result set */
void DB_FormatResults(FILE *fout, PGresult *res, PQprintOpt *ps);

/* prints query results */
void DB_PrintTuples(char *qy, PGresult *res, char *fout, int Spool, int PrintAttNames, 
		    int Echo, char sep);

/* writes a string to the result window     */
void DB_WriteToResult(char *data, int spool, FILE *file); 

/* writes a string to the SQL window        */
void DB_WriteToSQL(char *data);

/* writes a string to the specified buffer  */
void DB_WriteToBuffer(char *data, Widget w); 

/* opens a new scratch buffer               */
LLISTbuffer* DB_OpenScratchBuffer(void); 

/* clear sql window with an empty buffer    */
static LLISTbuffer* DB_ClearDisplay();

/* set the SQL window to the spec, buffer   */
LLISTbuffer* DB_SetBuffer(LLISTbuffer *buffer); 

/* set the app's main window title          */
void DB_SetTitle(char *win_title);

/* deletes a buffer                         */
void DB_DeleteBuffer(LLISTbuffer *buffer);

/* print buffer contents                    */
void DB_PrintBuffer(LLISTbuffer *buffer, char *printer); 

/* checks for modified buffers              */
int DB_ChkModBuffers(void);     

/* removes text from top of buffer          */
void DB_ShrinkBuffer(Widget w);

/* handles the copy command requests        */
void DB_HandleCopyOut(PGresult *res);
void DB_HandleCopyIn(PGresult *res);

/* handles the explain command request      */
void DB_TrapStderr(void);
void DB_RedirectStderr(XtPointer client_data, int *fd, XtInputId *id);

#endif	








