/************************************************************************/
/* Module : msgbox.c					                */
/* Purpose: Provides basic message dialogs     	                        */
/* By     : Keith R. Davis					        */
/* Date   : 7/24/98					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/************************************************************************/

#include <Xm/MessageB.h>	/* message box header	        */

/************************************************************************/
/* Function: MSGBOX_Message                                             */
/* Purpose : displays a basic message box with a string                 */
/* Params  : title : dialog title                                       */
/*           msg : dialog box message string                            */
/*           w : msgbox parent                                          */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void MSGBOX_Message(char *title, char *msg, Widget w)
{ 
  /* dialog widget */
  static Widget error_dialog = NULL;

  if(!error_dialog){
    error_dialog = XmCreateInformationDialog(w, "errordialog", NULL, 0);
    
    /* remove uneeded children */
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_CANCEL_BUTTON));
 
  }
  /* setup dialog */
  XtVaSetValues(error_dialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtVaTypedArg, XmNdialogTitle, XmRString,
		title, strlen(title)+1,
		XtVaTypedArg, XmNmessageString, XmRString,
		msg, strlen(msg)+1, NULL);
 
  XtManageChild(error_dialog);
}

/************************************************************************/
/* Function: MSGBOX_Error                                               */
/* Purpose : displays a basic message box with an error string          */
/* Params  : title : dialog title                                       */
/*           msg : dialog box message string                            */
/*           w : msgbox parent                                          */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void MSGBOX_Error(char *title, char *msg, Widget w)
{ 
  /* dialog widget */
  static Widget error_dialog = NULL;

  if(!error_dialog){
    error_dialog = XmCreateErrorDialog(w, "errordialog", NULL, 0);
    
    /* remove uneeded children */
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_CANCEL_BUTTON));
 
  }
  /* setup dialog */
  XtVaSetValues(error_dialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtVaTypedArg, XmNdialogTitle, XmRString,
		title, strlen(title)+1,
		XtVaTypedArg, XmNmessageString, XmRString,
		msg, strlen(msg)+1, NULL);
 
  XtManageChild(error_dialog);
}
