#ifndef _WORDVEC_H_
#define _WORDVEC_H_

extern int SavantVerbose, SavantDebug;

#define WEIGHT_WIDTH 10
#define WV_DVNUM(d) ((d) >> WEIGHT_WIDTH)
#define WV_DVFREQ(d) ((d) & ((1<<WEIGHT_WIDTH)-1))
#define WV_PACK(n,w) (((n) << WEIGHT_WIDTH) + ((w) & ((1<<WEIGHT_WIDTH)-1)))

typedef struct {
  DB_INT num_docs;
  DB_UINT *docweights;  /* Doc weight for this word packed with doc number, actually */
  DB_UINT *wordcode;    /* The wordcode associated with this wordvec */
} WordVec;

typedef struct _WV_List {
  DB_UINT docweight;
  struct _WV_List *next;
} WV_List;

typedef struct _WV_Tree {
  DB_UINT wordcode[WORD_ENCODE_WIDTH];
  DB_INT num_entries;
  WV_List *wvlist;
  struct _WV_Tree *left;
  struct _WV_Tree *right;
} WV_Tree;

extern FILE *WORDVEC_FILE, *WVOFF_FILE, *DVMAG_FILE, 
  *DATE_FILE, *WMAP2_FILE;

#define WORDVEC_FNAME "word_vecs"
#define WVOFF_FNAME "wv_offs"
#define DVMAG_FNAME "dv_mags"
#define DATE_FNAME "date_vecs"
#define WMAP2_FNAME "wvwmap"

#define DOCVEC_FNAME "doc_vecs"

extern DB_INT Num_DocVecs;
extern DB_FLOAT *DocVec_Mags;

/* from writewv_ra.c */
extern int init_write(char *); 
extern int save_dv(DV_Tree *, int);
extern int finalize_write(void);

/* from writewv_common.c */
extern int wvtree_insert_ddv(DenseDocVec *);
extern int write_wvtree_node(WV_Tree *);

/* from readwv_ra.c */
extern int init_read(char *); 
extern DocSim *find_matches(DV_Tree *, int, int *, int, DB_INT *);
extern void merge_databases(int, char **);

/* from readwv_common.c */
extern float sim_contrib(DB_UINT, DB_INT, DB_UINT *, DB_UINT *, 
			 float, int *, DB_INT *, float, int, int);

/* Yenta versions: 
extern int init(char *);
extern int save_dv(DenseDocVec *);
*/

/* Yenta versions:
extern float *find_matches(DenseDocVec *);
extern void remove_doc(int);
extern void incr_dv(DenseDocVec *, int);
extern DenseDocVec *ddv_dup(DenseDocVec *);
*/

/* Yenta?
   from wvio.c 
extern int write_wvtree(FILE *, WV_Tree *);
extern WV_Tree *read_wvtree(FILE *);
*/

#endif
