/* earthmap.c */

#include "map.h"

/* this data is derived from that provided with xearth in mapdata.c.
 *
 * the map data from that program claims be sampled on the order of every 20
 * miles which seems to be true. I have filtered that data way down here using
 * an awk script to what I believe is adequate for default use by xephem. If
 * you would like to build a version of earthmap.c at different resolutions
 * let me know and I will mail you the awk script. ecdowney@noao.edu.
 */

/* xearth included the following notice:
 */

/*
 * Copyright (C) 1989, 1990, 1993, 1994 Kirk Lauritz Johnson
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this
 * permission notice appear in supporting documentation. The author
 * makes no representations about the suitability of this software
 * for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

static MCoord ec0[] = {
    {  3216,  3116},
    {  3185,  3133},
    {  3206,  3139},
    {  3198,  3143},
    {  3080,  3142},
    {  2957,  3099},
    {  2833,  3107},
    {  2709,  3140},
    {  2610,  3159},
    {  2501,  3190},
    {  2373,  3217},
    {  2269,  3275},
    {  2168,  3292},
    {  2071,  3261},
    {  1993,  3174},
    {  1990,  3067},
    {  1874,  3039},
    {  1761,  3099},
    {  1630,  3123},
    {  1537,  3195},
    {  1441,  3257},
    {  1313,  3289},
    {  1179,  3308},
    {  1066,  3361},
    {  1082,  3479},
    {  1072,  3579},
    {  1098,  3699},
    {   989,  3723},
    {   864,  3694},
    {   757,  3701},
    {   657,  3702},
    {   530,  3666},
    {   430,  3690},
    {   324,  3677},
    {   221,  3660},
    {   115,  3650},
    {    22,  3610},
    {  -102,  3566},
    {  -215,  3509},
    {  -344,  3521},
    {  -447,  3517},
    {  -544,  3587},
    {  -625,  3497},
    {  -691,  3396},
    {  -813,  3342},
    {  -913,  3266},
    {  -968,  3166},
    {  -976,  3057},
    { -1006,  2955},
    { -1100,  2877},
    { -1205,  2810},
    { -1317,  2763},
    { -1374,  2661},
    { -1457,  2583},
    { -1490,  2473},
    { -1579,  2392},
    { -1626,  2287},
    { -1691,  2192},
    { -1669,  2077},
    { -1626,  1984},
    { -1615,  1878},
    { -1605,  1763},
    { -1646,  1655},
    { -1674,  1545},
    { -1693,  1433},
    { -1635,  1336},
    { -1554,  1270},
    { -1661,  1258},
    { -1582,  1195},
    { -1512,  1110},
    { -1440,  1024},
    { -1357,   951},
    { -1311,   861},
    { -1248,   767},
    { -1158,   698},
    { -1073,   630},
    {  -976,   561},
    {  -884,   490},
    {  -779,   442},
    {  -673,   470},
    {  -561,   507},
    {  -447,   519},
    {  -332,   518},
    {  -231,   490},
    {  -123,   511},
    {   -17,   554},
    {   101,   590},
    {   206,   629},
    {   322,   639},
    {   430,   638},
    {   521,   574},
    {   557,   469},
    {   660,   440},
    {   759,   458},
    {   880,   457},
    {   967,   392},
    {   988,   281},
    {   967,   164},
    {   963,    62},
    {   921,   -48},
    {   938,  -160},
    {   989,  -247},
    {  1064,  -336},
    {  1142,  -420},
    {  1207,  -507},
    {  1257,  -599},
    {  1285,  -723},
    {  1334,  -829},
    {  1310,  -927},
    {  1352, -1034},
    {  1379, -1140},
    {  1345, -1248},
    {  1266, -1328},
    {  1233, -1437},
    {  1202, -1549},
    {  1182, -1653},
    {  1173, -1768},
    {  1227, -1868},
    {  1287, -1968},
    {  1337, -2073},
    {  1397, -2174},
    {  1453, -2274},
    {  1449, -2389},
    {  1482, -2498},
    {  1496, -2611},
    {  1527, -2719},
    {  1594, -2818},
    {  1678, -2905},
    {  1721, -3015},
    {  1780, -3119},
    {  1833, -3223},
    {  1809, -3323},
    {  1848, -3420},
    {  1955, -3469},
    {  2079, -3442},
    {  2181, -3434},
    {  2304, -3406},
    {  2407, -3404},
    {  2539, -3400},
    {  2655, -3372},
    {  2773, -3312},
    {  2876, -3236},
    {  2968, -3152},
    {  3053, -3063},
    {  3116, -2961},
    {  3206, -2880},
    {  3261, -2778},
    {  3290, -2666},
    {  3299, -2546},
    {  3413, -2497},
    {  3524, -2444},
    {  3546, -2336},
    {  3553, -2224},
    {  3508, -2115},
    {  3474, -2011},
    {  3545, -1939},
    {  3637, -1871},
    {  3717, -1778},
    {  3817, -1723},
    {  3931, -1675},
    {  4012, -1598},
    {  4068, -1503},
    {  4058, -1378},
    {  4058, -1266},
    {  4045, -1150},
    {  4044, -1039},
    {  3971,  -962},
    {  3933,  -852},
    {  3932,  -744},
    {  3893,  -640},
    {  3906,  -525},
    {  3959,  -425},
    {  4005,  -328},
    {  4072,  -247},
    {  4151,  -172},
    {  4215,   -78},
    {  4295,     6},
    {  4376,    89},
    {  4465,   162},
    {  4564,   220},
    {  4653,   293},
    {  4733,   377},
    {  4807,   466},
    {  4872,   562},
    {  4918,   667},
    {  4977,   766},
    {  5035,   864},
    {  5083,   969},
    {  5112,  1082},
    {  5116,  1186},
    {  5013,  1154},
    {  4900,  1126},
    {  4785,  1112},
    {  4678,  1083},
    {  4568,  1081},
    {  4460,  1043},
    {  4364,  1103},
    {  4273,  1155},
    {  4335,  1237},
    {  4255,  1317},
    {  4173,  1394},
    {  4087,  1470},
    {  4004,  1530},
    {  3929,  1597},
    {  3903,  1710},
    {  3851,  1811},
    {  3755,  1876},
    {  3725,  1986},
    {  3710,  2101},
    {  3681,  2212},
    {  3581,  2282},
    {  3554,  2388},
    {  3494,  2499},
    {  3434,  2602},
    {  3388,  2708},
    {  3333,  2808},
    {  3264,  2905},
    {  3349,  2834},
    {  3455,  2860},
    {  3532,  2786},
    {  3599,  2688},
    {  3664,  2592},
    {  3720,  2492},
    {  3793,  2416},
    {  3872,  2326},
    {  3905,  2219},
    {  3921,  2108},
    {  3999,  2027},
    {  4088,  1951},
    {  4142,  1845},
    {  4216,  1756},
    {  4274,  1658},
    {  4277,  1546},
    {  4302,  1439},
    {  4327,  1322},
    {  4417,  1263},
    {  4520,  1299},
    {  4626,  1341},
    {  4741,  1367},
    {  4848,  1402},
    {  4943,  1467},
    {  5055,  1503},
    {  5168,  1538},
    {  5230,  1625},
    {  5338,  1673},
    {  5453,  1703},
    {  5548,  1783},
    {  5657,  1822},
    {  5738,  1893},
    {  5781,  1999},
    {  5867,  2074},
    {  5943,  2159},
    {  5940,  2269},
    {  5865,  2358},
    {  5742,  2386},
    {  5653,  2463},
    {  5632,  2574},
    {  5531,  2526},
    {  5450,  2447},
    {  5337,  2410},
    {  5220,  2398},
    {  5137,  2462},
    {  5156,  2577},
    {  5081,  2501},
    {  5007,  2595},
    {  4963,  2705},
    {  4882,  2782},
    {  4825,  2889},
    {  4804,  3002},
    {  4900,  3046},
    {  5000,  3017},
    {  5071,  2919},
    {  5128,  2817},
    {  5236,  2765},
    {  5337,  2699},
    {  5449,  2658},
    {  5561,  2692},
    {  5683,  2707},
    {  5721,  2603},
    {  5832,  2558},
    {  5953,  2544},
    {  6078,  2524},
    {  6198,  2511},
    {  6313,  2524},
    {  6437,  2527},
    {  6561,  2536},
    {  6671,  2514},
    {  6743,  2406},
    {  6839,  2366},
    {  6928,  2283},
    {  7040,  2294},
    {  6954,  2238},
    {  6984,  2140},
    {  7082,  2071},
    {  7196,  2113},
    {  7226,  2222},
    {  7274,  2110},
    {  7269,  2000},
    {  7292,  1898},
    {  7307,  1784},
    {  7332,  1668},
    {  7374,  1564},
    {  7429,  1461},
    {  7469,  1360},
    {  7500,  1245},
    {  7563,  1149},
    {  7608,  1042},
    {  7636,   935},
    {  7699,   839},
    {  7801,   836},
    {  7870,   918},
    {  7925,  1009},
    {  7985,  1100},
    {  7994,  1215},
    {  8032,  1319},
    {  8011,  1420},
    {  8011,  1532},
    {  8100,  1591},
    {  8203,  1643},
    {  8263,  1729},
    {  8355,  1798},
    {  8449,  1872},
    {  8532,  1956},
    {  8627,  2000},
    {  8696,  2075},
    {  8776,  2169},
    {  8881,  2165},
    {  8985,  2203},
    {  9051,  2289},
    {  8987,  2367},
    {  9078,  2291},
    {  9178,  2230},
    {  9205,  2120},
    {  9272,  2042},
    {  9367,  1981},
    {  9413,  1882},
    {  9452,  1777},
    {  9435,  1663},
    {  9525,  1589},
    {  9627,  1650},
    {  9695,  1730},
    {  9766,  1645},
    {  9777,  1526},
    {  9808,  1414},
    {  9859,  1304},
    {  9865,  1189},
    {  9855,  1077},
    {  9850,   963},
    {  9822,   851},
    {  9903,   784},
    {  9970,   699},
    { 10032,   606},
    { 10047,   493},
    { 10078,   393},
    { 10133,   291},
    { 10223,   220},
    { 10321,   161},
    { 10427,   150},
    { 10379,   258},
    { 10342,   357},
    { 10345,   471},
    { 10280,   563},
    { 10195,   635},
    { 10103,   687},
    { 10017,   758},
    {  9995,   871},
    {  9920,   961},
    {  9936,  1070},
    {  9979,  1178},
    { 10002,  1287},
    { 10093,  1341},
    { 10158,  1265},
    { 10257,  1214},
    { 10310,  1123},
    { 10391,  1060},
    { 10496,  1008},
    { 10481,   906},
    { 10583,   924},
    { 10658,   993},
    { 10762,  1058},
    { 10862,  1117},
    { 10920,  1228},
    { 10929,  1329},
    { 10913,  1441},
    { 10873,  1543},
    { 10796,  1630},
    { 10707,  1709},
    { 10640,  1807},
    { 10566,  1890},
    { 10606,  1997},
    { 10674,  2082},
    { 10781,  2147},
    { 10882,  2171},
    { 10986,  2138},
    { 10999,  2033},
    { 11038,  2128},
    { 11154,  2155},
    { 11267,  2185},
    { 11352,  2261},
    { 11456,  2263},
    { 11577,  2284},
    { 11666,  2332},
    { 11774,  2399},
    { 11854,  2461},
    { 11924,  2551},
    { 11975,  2642},
    { 12037,  2726},
    { 12100,  2809},
    { 12161,  2888},
    { 12197,  2990},
    { 12076,  3011},
    { 12160,  3084},
    { 12087,  3176},
    { 11972,  3218},
    { 12094,  3190},
    { 12088,  3291},
    { 12038,  3398},
    { 11936,  3473},
    { 11998,  3576},
    { 12077,  3639},
    { 12201,  3695},
    { 12113,  3765},
    { 11992,  3735},
    { 11904,  3782},
    { 11783,  3827},
    { 11876,  3918},
    { 11971,  3994},
    { 12061,  4042},
    { 12185,  4087},
    { 12150,  3972},
    { 12265,  3950},
    { 12366,  3983},
    { 12472,  3969},
    { 12536,  3873},
    { 12615,  3782},
    { 12683,  3691},
    { 12674,  3590},
    { 12650,  3479},
    { 12752,  3476},
    { 12867,  3512},
    { 12954,  3587},
    { 12942,  3697},
    { 12876,  3798},
    { 12795,  3892},
    { 12800,  3999},
    { 12897,  4043},
    { 12976,  4130},
    { 13038,  4226},
    { 13129,  4273},
    { 13232,  4318},
    { 13361,  4283},
    { 13463,  4326},
    { 13547,  4386},
    { 13639,  4477},
    { 13719,  4543},
    { 13797,  4611},
    { 13870,  4714},
    { 13967,  4809},
    { 14032,  4907},
    { 14057,  5017},
    { 14078,  5134},
    { 14135,  5226},
    { 14123,  5333},
    { 14025,  5397},
    { 13907,  5422},
    { 13787,  5358},
    { 13670,  5390},
    { 13563,  5464},
    { 13628,  5544},
    { 13742,  5599},
    { 13833,  5671},
    { 13943,  5733},
    { 14053,  5794},
    { 14152,  5860},
    { 14263,  5924},
    { 14371,  5938},
    { 14479,  5938},
    { 14586,  5932},
    { 14716,  5933},
    { 14825,  5937},
    { 14931,  5973},
    { 15039,  5961},
    { 15147,  5952},
    { 15286,  5897},
    { 15437,  5915},
    { 15496,  6035},
    { 15610,  6101},
    { 15722,  6170},
    { 15833,  6180},
    { 15942,  6181},
    { 16014,  6097},
    { 16131,  6109},
    { 16270,  6165},
    { 16337,  6254},
    { 16459,  6265},
    { 16392,  6165},
    { 16309,  6076},
    { 16199,  6041},
    { 16102,  5973},
    { 15983,  5910},
    { 15894,  5838},
    { 15761,  5793},
    { 15667,  5711},
    { 15586,  5641},
    { 15556,  5527},
    { 15584,  5412},
    { 15610,  5298},
    { 15649,  5185},
    { 15733,  5129},
    { 15825,  5195},
    { 15863,  5297},
    { 15971,  5323},
    { 16037,  5434},
    { 16171,  5454},
    { 16175,  5559},
    { 16249,  5634},
    { 16305,  5752},
    { 16197,  5806},
    { 16271,  5884},
    { 16356,  5988},
    { 16456,  6001},
    { 16582,  6032},
    { 16712,  6036},
    { 16819,  6057},
    { 16931,  6055},
    { 17038,  6002},
    { 17147,  6073},
    { 17267,  6126},
    { 17404,  6176},
    { 17522,  6207},
    { 17622,  6232},
    { 17725,  6276},
    { 17822,  6250},
    { 17952,  6266},
    { 17863,  6358},
    { 17743,  6448},
    { 17644,  6463},
    { 17529,  6474},
    { 17655,  6485},
    { 17778,  6472},
    { 17906,  6475},
    {-17987,  6512},
    {-17954,  6615},
    {-17853,  6566},
    {-17748,  6551},
    {-17616,  6547},
    {-17514,  6480},
    {-17402,  6447},
    {-17273,  6457},
    {-17237,  6551},
    {-17122,  6562},
    {-17020,  6598},
    {-17148,  6676},
    {-17274,  6699},
    {-17422,  6710},
    {-17521,  6748},
    {-17630,  6794},
    {-17753,  6826},
    {-17867,  6863},
    {-17970,  6893},
    { 17564,  6906},
    { 17455,  6940},
    { 17282,  6966},
    { 17128,  6987},
    { 17048,  6882},
    { 16915,  6911},
    { 16814,  6955},
    { 16682,  6952},
    { 16517,  6959},
    { 16369,  6971},
    { 16212,  6960},
    { 16141,  6881},
    { 16071,  6963},
    { 15981,  7058},
    { 15853,  7096},
    { 15680,  7109},
    { 15518,  7103},
    { 15341,  7086},
    { 15193,  7101},
    { 15068,  7134},
    { 14922,  7178},
    { 14746,  7232},
    { 14630,  7189},
    { 14512,  7183},
    { 14622,  7196},
    { 14475,  7230},
    { 14624,  7234},
    { 14455,  7262},
    { 14263,  7270},
    { 14089,  7277},
    { 13968,  7247},
    { 13906,  7151},
    { 13803,  7131},
    { 13679,  7148},
    { 13523,  7154},
    { 13356,  7146},
    { 13249,  7180},
    { 13150,  7088},
    { 13017,  7101},
    { 12923,  7151},
    { 12827,  7208},
    { 12691,  7230},
    { 12568,  7236},
    { 12412,  7270},
    { 12224,  7288},
    { 12042,  7298},
    { 11858,  7320},
    { 11737,  7359},
    { 11637,  7366},
    { 11533,  7368},
    { 11372,  7340},
    { 11177,  7376},
    { 10998,  7395},
    { 10871,  7333},
    { 10682,  7316},
    { 10559,  7281},
    { 10652,  7333},
    { 10806,  7367},
    { 10947,  7410},
    { 11074,  7453},
    { 11246,  7491},
    { 11361,  7542},
    { 11294,  7618},
    { 11131,  7668},
    { 11017,  7672},
    { 10886,  7673},
    { 10678,  7660},
    { 10576,  7705},
    { 10433,  7768},
    { 10302,  7758},
    { 10132,  7710},
    { 10001,  7648},
    {  9976,  7538},
    {  9857,  7618},
    {  9745,  7600},
    {  9639,  7594},
    {  9524,  7614},
    {  9414,  7609},
    {  9230,  7575},
    {  9124,  7565},
    {  9011,  7556},
    {  8837,  7522},
    {  8698,  7475},
    {  8741,  7380},
    {  8598,  7341},
    {  8431,  7372},
    {  8329,  7366},
    {  8225,  7366},
    {  8122,  7361},
    {  8072,  7263},
    {  8208,  7226},
    {  8326,  7182},
    {  8361,  7072},
    {  8230,  7056},
    {  8314,  7163},
    {  8158,  7174},
    {  8035,  7216},
    {  7861,  7238},
    {  7691,  7201},
    {  7781,  7131},
    {  7638,  7121},
    {  7541,  7153},
    {  7551,  7266},
    {  7416,  7194},
    {  7320,  7145},
    {  7428,  7065},
    {  7361,  6982},
    {  7504,  6913},
    {  7657,  6913},
    {  7771,  6878},
    {  7772,  6774},
    {  7706,  6862},
    {  7596,  6895},
    {  7453,  6869},
    {  7448,  6758},
    {  7344,  6684},
    {  7239,  6648},
    {  7128,  6635},
    {  6987,  6643},
    {  7143,  6672},
    {  7247,  6746},
    {  7319,  6823},
    {  7255,  6927},
    {  7265,  7040},
    {  7193,  7148},
    {  7281,  7230},
    {  7130,  7290},
    {  7029,  7289},
    {  6893,  7258},
    {  6832,  7172},
    {  6708,  7130},
    {  6716,  7029},
    {  6797,  6949},
    {  6906,  6886},
    {  6764,  6856},
    {  6640,  6895},
    {  6494,  6925},
    {  6370,  6962},
    {  6209,  6975},
    {  6062,  6974},
    {  6037,  6872},
    {  5909,  6854},
    {  5744,  6864},
    {  5596,  6861},
    {  5471,  6826},
    {  5358,  6835},
    {  5254,  6854},
    {  5143,  6842},
    {  5002,  6809},
    {  4884,  6777},
    {  4787,  6745},
    {  4674,  6682},
    {  4569,  6705},
    {  4664,  6794},
    {  4517,  6857},
    {  4369,  6854},
    {  4383,  6726},
    {  4411,  6622},
    {  4299,  6641},
    {  4169,  6621},
    {  4057,  6588},
    {  4033,  6464},
    {  3889,  6474},
    {  3772,  6501},
    {  3659,  6491},
    {  3785,  6434},
    {  3674,  6393},
    {  3580,  6431},
    {  3487,  6468},
    {  3481,  6576},
    {  3355,  6638},
    {  3229,  6706},
    {  3345,  6679},
    {  3459,  6660},
    {  3598,  6634},
    {  3736,  6620},
    {  3871,  6607},
    {  4004,  6629},
    {  4100,  6672},
    {  4067,  6776},
    {  3968,  6810},
    {  3845,  6838},
    {  3715,  6885},
    {  3584,  6918},
    {  3428,  6931},
    {  3328,  6917},
    {  3232,  6952},
    {  3050,  6978},
    {  2923,  7002},
    {  3085,  7029},
    {  2915,  7078},
    {  2817,  7024},
    {  2743,  7095},
    {  2643,  7083},
    {  2543,  7026},
    {  2447,  7073},
    {  2342,  7024},
    {  2166,  7024},
    {  2060,  6970},
    {  1937,  6974},
    {  1831,  6932},
    {  1679,  6862},
    {  1573,  6813},
    {  1475,  6741},
    {  1374,  6685},
    {  1294,  6605},
    {  1216,  6505},
    {  1112,  6447},
    {   996,  6392},
    {  1130,  6396},
    {  1018,  6337},
    {   912,  6340},
    {   805,  6298},
    {   667,  6261},
    {   552,  6212},
    {   522,  6115},
    {   645,  6119},
    {   746,  6129},
    {   605,  6109},
    {   525,  6029},
    {   626,  6040},
    {   553,  5963},
    {   595,  5843},
    {   725,  5802},
    {   867,  5839},
    {   976,  5902},
    {  1064,  5978},
    {  1123,  5868},
    {  1185,  5762},
    {  1252,  5684},
    {  1296,  5575},
    {  1396,  5541},
    {  1499,  5616},
    {  1617,  5651},
    {  1661,  5762},
    {  1648,  5862},
    {  1749,  5885},
    {  1840,  5936},
    {  1720,  5933},
    {  1843,  5950},
    {  1766,  6058},
    {  1723,  6163},
    {  1796,  6263},
    {  1894,  6324},
    {  2002,  6362},
    {  2123,  6428},
    {  2156,  6533},
    {  2268,  6582},
    {  2406,  6579},
    {  2524,  6550},
    {  2428,  6452},
    {  2309,  6383},
    {  2191,  6321},
    {  2113,  6253},
    {  2154,  6147},
    {  2202,  6046},
    {  2299,  6019},
    {  2427,  6003},
    {  2585,  6033},
    {  2740,  6051},
    {  2857,  6058},
    {  2989,  6010},
    {  2873,  5982},
    {  2734,  5944},
    {  2624,  5958},
    {  2516,  5951},
    {  2412,  5935},
    {  2378,  5838},
    {  2439,  5743},
    {  2333,  5710},
    {  2238,  5770},
    {  2138,  5706},
    {  2106,  5595},
    {  2101,  5491},
    {  1995,  5484},
    {  1888,  5436},
    {  1781,  5481},
    {  1645,  5448},
    {  1514,  5411},
    {  1394,  5399},
    {  1286,  5438},
    {  1156,  5404},
    {  1029,  5439},
    {   959,  5523},
    {  1048,  5619},
    {  1051,  5726},
    {   912,  5714},
    {   816,  5644},
    {   859,  5514},
    {   897,  5399},
    {   769,  5370},
    {   662,  5344},
    {   535,  5311},
    {   442,  5224},
    {   369,  5148},
    {   255,  5110},
    {   158,  5061},
    {    68,  4986},
    {   -20,  4931},
    {  -135,  4964},
    {  -199,  4862},
    {  -311,  4881},
    {  -439,  4864},
    {  -373,  4780},
    {  -264,  4753},
    {  -186,  4662},
    {  -109,  4599},
    {   -61,  4506},
    {  -128,  4428},
    {  -197,  4335},
    {  -311,  4339},
    {  -433,  4341},
    {  -547,  4356},
    {  -668,  4358},
    {  -780,  4374},
    {  -884,  4330},
    {  -876,  4225},
    {  -866,  4110},
    {  -893,  3996},
    {  -944,  3894},
    {  -883,  3807},
    {  -883,  3706},
    {  -773,  3705},
    {  -650,  3696},
    {  -570,  3606},
    {  -455,  3658},
    {  -354,  3672},
    {  -251,  3681},
    {  -146,  3748},
    {   -57,  3822},
    {   -29,  3933},
    {    36,  4031},
    {   133,  4113},
    {   236,  4149},
    {   323,  4201},
    {   317,  4312},
    {   410,  4355},
    {   513,  4343},
    {   622,  4310},
    {   717,  4363},
    {   820,  4403},
    {   918,  4434},
    {  1019,  4391},
    {  1067,  4290},
    {  1154,  4233},
    {  1233,  4170},
    {  1325,  4127},
    {  1445,  4065},
    {  1554,  4003},
    {  1612,  3902},
    {  1565,  3806},
    {  1656,  3853},
    {  1709,  3938},
    {  1707,  4049},
    {  1814,  3988},
    {  1761,  4078},
    {  1663,  4120},
    {  1564,  4192},
    {  1461,  4220},
    {  1381,  4316},
    {  1278,  4397},
    {  1241,  4495},
    {  1317,  4572},
    {  1400,  4490},
    {  1503,  4457},
    {  1583,  4371},
    {  1687,  4338},
    {  1776,  4280},
    {  1869,  4237},
    {  1957,  4172},
    {  1939,  4058},
    {  2009,  3964},
    {  2098,  3894},
    {  2203,  3838},
    {  2166,  3737},
    {  2249,  3656},
    {  2290,  3752},
    {  2404,  3779},
    {  2320,  3865},
    {  2279,  3984},
    {  2382,  4005},
    {  2457,  4091},
    {  2561,  4087},
    {  2664,  4063},
    {  2761,  4098},
    {  2867,  4100},
    {  2800,  4194},
    {  2794,  4314},
    {  2865,  4410},
    {  2955,  4486},
    {  3000,  4576},
    {  3085,  4653},
    {  3191,  4678},
    {  3276,  4611},
    {  3350,  4511},
    {  3452,  4472},
    {  3557,  4507},
    {  3486,  4598},
    {  3608,  4665},
    {  3725,  4691},
    {  3842,  4716},
    {  3838,  4608},
    {  3759,  4533},
    {  3844,  4435},
    {  3939,  4384},
    {  4027,  4324},
    {  4123,  4280},
    {  4173,  4176},
    {  4090,  4120},
    {  3981,  4098},
    {  3868,  4096},
    {  3761,  4108},
    {  3656,  4131},
    {  3530,  4173},
    {  3408,  4197},
    {  3293,  4189},
    {  3190,  4151},
    {  3095,  4108},
    {  2982,  4115},
    {  2894,  4046},
    {  2783,  4043},
    {  2673,  4036},
    {  2624,  3948},
    {  2682,  3864},
    {  2715,  3766},
    {  2811,  3703},
    {  2909,  3654},
    {  3029,  3627},
    {  3113,  3683},
    {  3210,  3647},
    {  3330,  3613},
    {  3449,  3671},
    {  3548,  3659},
    {  3581,  3552},
    {  3584,  3444},
    {  3527,  3341},
    {  3484,  3232},
    {  3421,  3133},
    {  3297,  3110},
};

static MCoord ec1[] = {
    {-12813,  5274},
    {-12826,  5241},
    {-12806,  5249},
    {-12791,  5239},
    {-12681,  5222},
    {-12769,  5162},
    {-12691,  5091},
    {-12562,  5091},
    {-12454,  5043},
    {-12375,  4971},
    {-12290,  4901},
    {-12227,  4799},
    {-12286,  4715},
    {-12318,  4814},
    {-12454,  4834},
    {-12423,  4730},
    {-12348,  4624},
    {-12396,  4515},
    {-12411,  4400},
    {-12449,  4287},
    {-12416,  4176},
    {-12426,  4067},
    {-12376,  3961},
    {-12328,  3857},
    {-12241,  3803},
    {-12201,  3698},
    {-12153,  3604},
    {-12067,  3514},
    {-11988,  3444},
    {-11861,  3404},
    {-11755,  3339},
    {-11703,  3234},
    {-11641,  3132},
    {-11583,  3030},
    {-11508,  2942},
    {-11415,  2862},
    {-11491,  2783},
    {-11417,  2713},
    {-11304,  2662},
    {-11211,  2571},
    {-11174,  2456},
    {-11075,  2386},
    {-11002,  2295},
    {-10993,  2409},
    {-11068,  2476},
    {-11126,  2577},
    {-11176,  2673},
    {-11242,  2758},
    {-11306,  2850},
    {-11383,  2945},
    {-11463,  3032},
    {-11485,  3144},
    {-11378,  3156},
    {-11308,  3079},
    {-11257,  2973},
    {-11189,  2876},
    {-11094,  2792},
    {-11025,  2716},
    {-10923,  2643},
    {-10865,  2536},
    {-10769,  2449},
    {-10688,  2382},
    {-10608,  2291},
    {-10559,  2193},
    {-10543,  2087},
    {-10532,  1976},
    {-10436,  1907},
    {-10345,  1834},
    {-10231,  1797},
    {-10129,  1747},
    {-10020,  1698},
    { -9907,  1660},
    { -9796,  1610},
    { -9685,  1575},
    { -9570,  1590},
    { -9469,  1628},
    { -9363,  1582},
    { -9274,  1506},
    { -9188,  1427},
    { -9078,  1393},
    { -8970,  1353},
    { -8865,  1324},
    { -8748,  1335},
    { -8688,  1227},
    { -8609,  1144},
    { -8576,  1050},
    { -8516,   966},
    { -8418,   943},
    { -8338,   841},
    { -8236,   831},
    { -8147,   772},
    { -8055,   724},
    { -8038,   825},
    { -7950,   895},
    { -7845,   850},
    { -7814,   752},
    { -7742,   664},
    { -7742,   558},
    { -7733,   448},
    { -7730,   347},
    { -7791,   258},
    { -7894,   171},
    { -7980,    91},
    { -8021,    -9},
    { -8085,  -101},
    { -8088,  -215},
    { -7987,  -243},
    { -8027,  -335},
    { -8112,  -413},
    { -8115,  -521},
    { -8078,  -629},
    { -7985,  -695},
    { -7927,  -794},
    { -7867,  -892},
    { -7821,  -996},
    { -7767, -1097},
    { -7713, -1199},
    { -7650, -1294},
    { -7631, -1393},
    { -7562, -1484},
    { -7475, -1559},
    { -7373, -1618},
    { -7264, -1665},
    { -7161, -1724},
    { -7080, -1805},
    { -7029, -1901},
    { -7013, -2015},
    { -7007, -2130},
    { -7024, -2244},
    { -7053, -2345},
    { -7055, -2454},
    { -7065, -2562},
    { -7076, -2676},
    { -7109, -2784},
    { -7148, -2893},
    { -7137, -3005},
    { -7164, -3111},
    { -7148, -3226},
    { -7168, -3335},
    { -7202, -3444},
    { -7255, -3550},
    { -7301, -3661},
    { -7363, -3748},
    { -7346, -3865},
    { -7336, -3971},
    { -7388, -4075},
    { -7330, -4177},
    { -7244, -4230},
    { -7306, -4336},
    { -7276, -4440},
    { -7309, -4535},
    { -7379, -4648},
    { -7476, -4607},
    { -7553, -4675},
    { -7427, -4681},
    { -7366, -4773},
    { -7418, -4860},
    { -7382, -4963},
    { -7408, -5073},
    { -7368, -5168},
    { -7252, -5185},
    { -7355, -5212},
    { -7244, -5255},
    { -7136, -5279},
    { -7238, -5340},
    { -7118, -5383},
    { -7070, -5273},
    { -6951, -5236},
    { -6901, -5140},
    { -6893, -5039},
    { -6788, -4996},
    { -6739, -4889},
    { -6640, -4833},
    { -6575, -4749},
    { -6689, -4690},
    { -6752, -4593},
    { -6649, -4511},
    { -6537, -4450},
    { -6509, -4341},
    { -6456, -4252},
    { -6506, -4138},
    { -6408, -4101},
    { -6298, -4111},
    { -6241, -4024},
    { -6227, -3921},
    { -6123, -3898},
    { -6013, -3887},
    { -5904, -3867},
    { -5801, -3836},
    { -5713, -3750},
    { -5671, -3641},
    { -5718, -3533},
    { -5830, -3465},
    { -5853, -3363},
    { -5820, -3258},
    { -5842, -3365},
    { -5763, -3445},
    { -5638, -3482},
    { -5536, -3483},
    { -5432, -3466},
    { -5348, -3388},
    { -5258, -3303},
    { -5218, -3197},
    { -5149, -3102},
    { -5071, -3033},
    { -5116, -3124},
    { -5196, -3194},
    { -5099, -3133},
    { -5026, -3037},
    { -4970, -2932},
    { -4880, -2846},
    { -4859, -2738},
    { -4871, -2620},
    { -4797, -2514},
    { -4709, -2446},
    { -4606, -2382},
    { -4496, -2340},
    { -4385, -2299},
    { -4280, -2296},
    { -4189, -2248},
    { -4099, -2183},
    { -4063, -2079},
    { -4002, -1980},
    { -3973, -1875},
    { -3919, -1775},
    { -3908, -1661},
    { -3895, -1548},
    { -3899, -1433},
    { -3892, -1325},
    { -3806, -1264},
    { -3743, -1157},
    { -3681, -1071},
    { -3596,  -995},
    { -3522,  -906},
    { -3485,  -798},
    { -3489,  -686},
    { -3518,  -574},
    { -3597,  -506},
    { -3709,  -491},
    { -3801,  -423},
    { -3888,  -349},
    { -3988,  -290},
    { -4102,  -288},
    { -4216,  -280},
    { -4323,  -238},
    { -4425,  -249},
    { -4495,  -153},
    { -4590,  -119},
    { -4691,   -79},
    { -4804,   -74},
    { -4887,  -169},
    { -4955,  -261},
    { -5036,  -197},
    { -5086,  -107},
    { -5195,  -158},
    { -5155,   -57},
    { -5076,    21},
    { -4999,   107},
    { -5068,   210},
    { -5101,   316},
    { -5144,   428},
    { -5229,   485},
    { -5323,   552},
    { -5443,   592},
    { -5557,   597},
    { -5664,   596},
    { -5758,   640},
    { -5857,   655},
    { -5864,   756},
    { -5958,   827},
    { -6057,   856},
    { -6093,   950},
    { -6211,   987},
    { -6282,  1072},
    { -6413,  1061},
    { -6510,  1007},
    { -6610,  1055},
    { -6724,  1055},
    { -6829,  1076},
    { -6902,  1146},
    { -6984,  1203},
    { -7051,  1126},
    { -7151,  1073},
    { -7105,   968},
    { -7206,   988},
    { -7168,  1093},
    { -7114,  1207},
    { -7224,  1192},
    { -7325,  1133},
    { -7424,  1106},
    { -7522,  1078},
    { -7564,   975},
    { -7631,   897},
    { -7676,   801},
    { -7767,   888},
    { -7867,   943},
    { -7979,   941},
    { -8081,   891},
    { -8192,   894},
    { -8272,   966},
    { -8347,  1052},
    { -8373,  1154},
    { -8363,  1265},
    { -8349,  1367},
    { -8333,  1475},
    { -8404,  1564},
    { -8515,  1592},
    { -8629,  1581},
    { -8751,  1585},
    { -8857,  1583},
    { -8824,  1692},
    { -8811,  1805},
    { -8761,  1893},
    { -8745,  1998},
    { -8683,  2095},
    { -8773,  2153},
    { -8894,  2140},
    { -9013,  2113},
    { -9047,  2008},
    { -9100,  1912},
    { -9182,  1849},
    { -9284,  1849},
    { -9401,  1825},
    { -9503,  1860},
    { -9603,  1909},
    { -9662,  2009},
    { -9731,  2103},
    { -9774,  2211},
    { -9775,  2326},
    { -9766,  2442},
    { -9725,  2551},
    { -9743,  2656},
    { -9737,  2778},
    { -9649,  2864},
    { -9541,  2886},
    { -9485,  2972},
    { -9378,  2981},
    { -9278,  2964},
    { -9161,  2966},
    { -9053,  2926},
    { -8930,  2906},
    { -8973,  3006},
    { -8867,  3037},
    { -8746,  3035},
    { -8631,  3044},
    { -8534,  2977},
    { -8412,  3009},
    { -8315,  2933},
    { -8269,  2838},
    { -8255,  2732},
    { -8190,  2646},
    { -8120,  2553},
    { -8013,  2586},
    { -8010,  2701},
    { -8059,  2809},
    { -8099,  2922},
    { -8138,  3032},
    { -8130,  3141},
    { -8079,  3239},
    { -7967,  3286},
    { -7882,  3373},
    { -7775,  3428},
    { -7649,  3488},
    { -7576,  3582},
    { -7598,  3685},
    { -7705,  3727},
    { -7721,  3839},
    { -7648,  3914},
    { -7584,  3818},
    { -7542,  3925},
    { -7438,  3947},
    { -7409,  4045},
    { -7314,  4117},
    { -7202,  4132},
    { -7069,  4164},
    { -7079,  4280},
    { -6994,  4381},
    { -6887,  4446},
    { -6772,  4456},
    { -6661,  4510},
    { -6552,  4535},
    { -6465,  4594},
    { -6357,  4537},
    { -6469,  4518},
    { -6568,  4467},
    { -6567,  4356},
    { -6472,  4397},
    { -6379,  4451},
    { -6268,  4479},
    { -6162,  4513},
    { -6247,  4566},
    { -6365,  4586},
    { -6458,  4633},
    { -6491,  4741},
    { -6608,  4795},
    { -6489,  4817},
    { -6489,  4919},
    { -6620,  4920},
    { -6743,  4888},
    { -6857,  4845},
    { -6953,  4788},
    { -7030,  4719},
    { -6981,  4811},
    { -7079,  4839},
    { -6973,  4819},
    { -6888,  4884},
    { -6779,  4930},
    { -6661,  5012},
    { -6541,  5030},
    { -6405,  5029},
    { -6273,  5029},
    { -6146,  5016},
    { -6014,  5025},
    { -5908,  5080},
    { -5811,  5132},
    { -5681,  5152},
    { -5576,  5212},
    { -5586,  5331},
    { -5725,  5358},
    { -5820,  5421},
    { -5933,  5364},
    { -6062,  5369},
    { -5931,  5389},
    { -5810,  5434},
    { -5915,  5510},
    { -6032,  5516},
    { -6135,  5604},
    { -6230,  5678},
    { -6218,  5789},
    { -6327,  5840},
    { -6383,  5938},
    { -6456,  6008},
    { -6551,  5933},
    { -6641,  5875},
    { -6764,  5807},
    { -6905,  5789},
    { -6835,  5870},
    { -6989,  5871},
    { -6964,  5984},
    { -7073,  6002},
    { -6968,  6012},
    { -7032,  6104},
    { -7148,  6119},
    { -7236,  6184},
    { -7351,  6240},
    { -7463,  6220},
    { -7576,  6226},
    { -7696,  6252},
    { -7805,  6233},
    { -7774,  6122},
    { -7753,  6019},
    { -7799,  5923},
    { -7744,  5817},
    { -7667,  5743},
    { -7655,  5628},
    { -7732,  5553},
    { -7851,  5500},
    { -7956,  5471},
    { -7902,  5373},
    { -7869,  5260},
    { -7886,  5140},
    { -7997,  5123},
    { -8085,  5189},
    { -8184,  5264},
    { -8216,  5369},
    { -8223,  5481},
    { -8346,  5522},
    { -8474,  5526},
    { -8592,  5567},
    { -8741,  5600},
    { -8842,  5660},
    { -8981,  5698},
    { -9128,  5721},
    { -9247,  5699},
    { -9282,  5808},
    { -9369,  5876},
    { -9480,  5904},
    { -9470,  6018},
    { -9413,  6102},
    { -9343,  6180},
    { -9262,  6246},
    { -9144,  6282},
    { -9220,  6363},
    { -9331,  6388},
    { -9215,  6379},
    { -9103,  6360},
    { -9005,  6390},
    { -8887,  6401},
    { -8762,  6458},
    { -8879,  6532},
    { -8973,  6571},
    { -9113,  6589},
    { -8961,  6590},
    { -8851,  6556},
    { -8727,  6537},
    { -8602,  6608},
    { -8461,  6627},
    { -8358,  6642},
    { -8244,  6665},
    { -8130,  6736},
    { -8213,  6814},
    { -8145,  6910},
    { -8287,  6950},
    { -8429,  6982},
    { -8547,  6961},
    { -8576,  6835},
    { -8654,  6746},
    { -8762,  6742},
    { -8783,  6843},
    { -8904,  6920},
    { -9012,  6839},
    { -9100,  6923},
    { -9250,  6967},
    { -9290,  7089},
    { -9400,  7172},
    { -9562,  7161},
    { -9652,  7094},
    { -9599,  6984},
    { -9464,  6959},
    { -9356,  6931},
    { -9452,  6886},
    { -9513,  6806},
    { -9529,  6703},
    { -9628,  6752},
    { -9755,  6845},
    { -9844,  6799},
    { -9992,  6782},
    {-10145,  6772},
    {-10291,  6788},
    {-10438,  6806},
    {-10540,  6846},
    {-10692,  6878},
    {-10836,  6855},
    {-10709,  6833},
    {-10766,  6747},
    {-10893,  6748},
    {-10996,  6790},
    {-11128,  6777},
    {-11278,  6767},
    {-11430,  6775},
    {-11503,  6885},
    {-11651,  6887},
    {-11804,  6903},
    {-11946,  6931},
    {-12082,  6961},
    {-12234,  6981},
    {-12337,  6945},
    {-12444,  7002},
    {-12535,  6946},
    {-12656,  6970},
    {-12781,  7050},
    {-12895,  6983},
    {-13038,  6963},
    {-13189,  6934},
    {-13313,  6880},
    {-13194,  6948},
    {-13060,  6972},
    {-13207,  6976},
    {-13315,  6946},
    {-13443,  6909},
    {-13601,  6885},
    {-13753,  6902},
    {-13883,  6937},
    {-14024,  6961},
    {-14178,  6977},
    {-14321,  7008},
    {-14482,  6999},
    {-14638,  7018},
    {-14801,  7030},
    {-14958,  7050},
    {-15126,  7043},
    {-15253,  7081},
    {-15419,  7083},
    {-15573,  7087},
    {-15707,  7116},
    {-15840,  7082},
    {-15976,  7060},
    {-16078,  7038},
    {-16223,  7015},
    {-16319,  6937},
    {-16424,  6895},
    {-16585,  6887},
    {-16507,  6794},
    {-16400,  6752},
    {-16253,  6705},
    {-16112,  6661},
    {-16227,  6680},
    {-16322,  6608},
    {-16452,  6656},
    {-16568,  6624},
    {-16675,  6603},
    {-16788,  6570},
    {-16638,  6531},
    {-16535,  6450},
    {-16415,  6457},
    {-16286,  6446},
    {-16129,  6486},
    {-16084,  6396},
    {-16207,  6348},
    {-16358,  6308},
    {-16475,  6276},
    {-16574,  6190},
    {-16497,  6102},
    {-16380,  6092},
    {-16516,  6062},
    {-16418,  5997},
    {-16269,  5997},
    {-16184,  5913},
    {-16049,  5898},
    {-15899,  5851},
    {-15781,  5870},
    {-15758,  5760},
    {-15880,  5685},
    {-16003,  5644},
    {-16114,  5597},
    {-16246,  5551},
    {-16330,  5495},
    {-16216,  5509},
    {-16081,  5549},
    {-15967,  5569},
    {-15862,  5606},
    {-15747,  5673},
    {-15641,  5727},
    {-15528,  5782},
    {-15417,  5832},
    {-15393,  5941},
    {-15273,  5995},
    {-15186,  6074},
    {-15053,  6128},
    {-14939,  6095},
    {-15039,  6098},
    {-15134,  6035},
    {-15186,  5935},
    {-15045,  5954},
    {-14926,  5999},
    {-14827,  6018},
    {-14793,  6114},
    {-14652,  6110},
    {-14548,  6041},
    {-14446,  6021},
    {-14342,  6005},
    {-14226,  6006},
    {-14121,  5983},
    {-14012,  5975},
    {-13904,  5929},
    {-13806,  5895},
    {-13678,  5832},
    {-13574,  5846},
    {-13472,  5843},
    {-13354,  5790},
    {-13287,  5701},
    {-13180,  5625},
    {-13087,  5557},
    {-12993,  5514},
    {-12983,  5410},
    {-12865,  5382},
    {-12827,  5288},
};

static MCoord ec2[] = {
    {  7566, -6956},
    {  7505, -6964},
    {  7437, -6974},
    {  7360, -6985},
    {  7251, -7055},
    {  7149, -7102},
    {  7087, -7187},
    {  6957, -7228},
    {  6785, -7225},
    {  6837, -7122},
    {  6919, -7041},
    {  6804, -7046},
    {  6919, -6974},
    {  6976, -6866},
    {  6904, -6783},
    {  6752, -6779},
    {  6601, -6771},
    {  6451, -6760},
    {  6305, -6757},
    {  6158, -6751},
    {  6020, -6737},
    {  5893, -6726},
    {  5762, -6701},
    {  5649, -6638},
    {  5550, -6598},
    {  5412, -6587},
    {  5272, -6592},
    {  5145, -6615},
    {  5033, -6649},
    {  4912, -6696},
    {  4800, -6765},
    {  4656, -6728},
    {  4494, -6776},
    {  4360, -6803},
    {  4231, -6832},
    {  4095, -6860},
    {  3980, -6898},
    {  3882, -6984},
    {  3749, -6966},
    {  3628, -6946},
    {  3494, -6886},
    {  3398, -6850},
    {  3290, -6924},
    {  3162, -6961},
    {  3009, -6981},
    {  2853, -7000},
    {  2691, -7015},
    {  2529, -7033},
    {  2364, -7050},
    {  2196, -7041},
    {  2030, -7028},
    {  1869, -7008},
    {  1705, -7010},
    {  1543, -7027},
    {  1381, -7020},
    {  1239, -7048},
    {  1094, -7067},
    {   975, -7026},
    {   854, -7042},
    {   719, -7037},
    {   575, -7060},
    {   405, -7072},
    {   240, -7091},
    {    82, -7118},
    {   -41, -7160},
    {  -170, -7141},
    {  -296, -7126},
    {  -474, -7131},
    {  -611, -7123},
    {  -749, -7129},
    {  -841, -7174},
    {  -968, -7095},
    { -1107, -7160},
    { -1218, -7156},
    { -1307, -7273},
    { -1423, -7316},
    { -1607, -7336},
    { -1527, -7399},
    { -1427, -7388},
    { -1580, -7445},
    { -1721, -7487},
    { -1812, -7539},
    { -1933, -7578},
    { -2137, -7594},
    { -2247, -7597},
    { -2361, -7603},
    { -2478, -7611},
    { -2588, -7627},
    { -2789, -7653},
    { -2890, -7669},
    { -3077, -7709},
    { -3284, -7744},
    { -3449, -7789},
    { -3589, -7840},
    { -3484, -7914},
    { -3379, -7935},
    { -3236, -7942},
    { -3096, -7928},
    { -2961, -7914},
    { -2779, -7904},
    { -2902, -7940},
    { -2814, -8016},
    { -2920, -8037},
    { -3087, -8048},
    { -3234, -8064},
    { -3402, -8074},
    { -3561, -8088},
    { -3730, -8099},
    { -3884, -8116},
    { -4050, -8129},
    { -4195, -8148},
    { -4443, -8186},
    { -4642, -8180},
    { -4843, -8183},
    { -5036, -8192},
    { -5223, -8205},
    { -5407, -8219},
    { -5555, -8240},
    { -5659, -8265},
    { -5806, -8294},
    { -5928, -8250},
    { -6086, -8230},
    { -6247, -8210},
    { -6397, -8190},
    { -6542, -8170},
    { -6683, -8150},
    { -6829, -8130},
    { -6986, -8114},
    { -7159, -8103},
    { -7314, -8087},
    { -7454, -8069},
    { -7629, -8018},
    { -7889, -8003},
    { -7775, -8001},
    { -7650, -7984},
    { -7823, -7926},
    { -7983, -7924},
    { -8103, -7942},
    { -8290, -7898},
    { -8387, -7841},
    { -8212, -7857},
    { -8101, -7876},
    { -7956, -7881},
    { -7815, -7872},
    { -7965, -7813},
    { -8099, -7796},
    { -7992, -7775},
    { -7864, -7786},
    { -7729, -7792},
    { -7598, -7801},
    { -7468, -7810},
    { -7353, -7793},
    { -7532, -7747},
    { -7696, -7704},
    { -7812, -7653},
    { -7669, -7606},
    { -7542, -7652},
    { -7421, -7659},
    { -7297, -7663},
    { -7172, -7666},
    { -7042, -7666},
    { -6886, -7626},
    { -6777, -7615},
    { -6664, -7604},
    { -6564, -7588},
    { -6378, -7553},
    { -6314, -7475},
    { -6193, -7478},
    { -6120, -7390},
    { -6020, -7321},
    { -6139, -7253},
    { -6226, -7201},
    { -6114, -7179},
    { -6191, -7081},
    { -6247, -6986},
    { -6342, -6913},
    { -6421, -6848},
    { -6535, -6843},
    { -6499, -6729},
    { -6404, -6682},
    { -6271, -6656},
    { -6124, -6622},
    { -6236, -6588},
    { -6111, -6497},
    { -5962, -6442},
    { -5866, -6401},
    { -5774, -6361},
    { -5875, -6353},
    { -5975, -6384},
    { -6088, -6409},
    { -6232, -6470},
    { -6389, -6508},
    { -6481, -6597},
    { -6582, -6629},
    { -6687, -6697},
    { -6690, -6823},
    { -6715, -6927},
    { -6855, -6941},
    { -6779, -7051},
    { -6728, -7164},
    { -6746, -7273},
    { -6895, -7310},
    { -7083, -7328},
    { -7275, -7346},
    { -7463, -7368},
    { -7662, -7382},
    { -7842, -7364},
    { -7948, -7323},
    { -8060, -7320},
    { -8169, -7387},
    { -8351, -7371},
    { -8546, -7355},
    { -8654, -7327},
    { -8831, -7316},
    { -8938, -7302},
    { -9105, -7327},
    { -9208, -7318},
    { -9399, -7326},
    { -9598, -7327},
    { -9791, -7311},
    { -9964, -7302},
    {-10171, -7303},
    {-10300, -7274},
    {-10140, -7334},
    {-10038, -7337},
    {-10189, -7361},
    {-10050, -7448},
    { -9962, -7512},
    {-10163, -7524},
    {-10365, -7503},
    {-10478, -7506},
    {-10586, -7515},
    {-10794, -7526},
    {-10900, -7514},
    {-11038, -7519},
    {-11105, -7420},
    {-11216, -7483},
    {-11325, -7448},
    {-11461, -7402},
    {-11560, -7446},
    {-11663, -7453},
    {-11765, -7440},
    {-11928, -7461},
    {-12036, -7467},
    {-12146, -7471},
    {-12254, -7468},
    {-12361, -7472},
    {-12471, -7467},
    {-12581, -7465},
    {-12690, -7464},
    {-12796, -7469},
    {-12898, -7480},
    {-13007, -7482},
    {-13117, -7477},
    {-13225, -7473},
    {-13336, -7480},
    {-13530, -7460},
    {-13635, -7473},
    {-13804, -7506},
    {-13920, -7511},
    {-14081, -7549},
    {-14197, -7549},
    {-14406, -7570},
    {-14601, -7595},
    {-14801, -7613},
    {-14912, -7631},
    {-14728, -7643},
    {-14629, -7659},
    {-14818, -7747},
    {-14918, -7764},
    {-15114, -7744},
    {-15226, -7740},
    {-15405, -7717},
    {-15527, -7709},
    {-15736, -7719},
    {-15671, -7821},
    {-15534, -7815},
    {-15405, -7817},
    {-15551, -7859},
    {-15443, -7901},
    {-15308, -7913},
    {-15177, -7927},
    {-15053, -7945},
    {-14912, -7959},
    {-14776, -7974},
    {-14657, -7994},
    {-14562, -8049},
    {-14754, -8097},
    {-14989, -8134},
    {-15148, -8118},
    {-15318, -8108},
    {-15499, -8101},
    {-15663, -8115},
    {-15433, -8155},
    {-15281, -8235},
    {-15294, -8347},
    {-15169, -8430},
    {-14972, -8452},
    {-14706, -8466},
    {-14411, -8477},
    {-14108, -8486},
    {-13899, -8504},
    {-14085, -8522},
    {-14425, -8513},
    {-14780, -8510},
    {-15016, -8536},
    {-15344, -8533},
    {-15717, -8539},
    {-16062, -8530},
    {-16334, -8513},
    {-16600, -8496},
    {-16812, -8477},
    {-17076, -8459},
    {-17352, -8447},
    {-17659, -8445},
    {-17904, -8436},
    { 17876, -8416},
    { 17637, -8401},
    { 17404, -8386},
    { 17220, -8370},
    { 17100, -8349},
    { 16856, -8339},
    { 16682, -8280},
    { 16561, -8255},
    { 16436, -8234},
    { 16274, -8184},
    { 16126, -8156},
    { 16059, -8077},
    { 15905, -8043},
    { 15994, -7974},
    { 16122, -7898},
    { 16255, -7887},
    { 16372, -7869},
    { 16495, -7857},
    { 16675, -7857},
    { 16542, -7817},
    { 16427, -7771},
    { 16284, -7701},
    { 16281, -7600},
    { 16336, -7501},
    { 16479, -7466},
    { 16579, -7408},
    { 16745, -7348},
    { 16885, -7347},
    { 17009, -7267},
    { 17084, -7171},
    { 16941, -7141},
    { 16801, -7102},
    { 16675, -7069},
    { 16517, -7056},
    { 16351, -7056},
    { 16203, -7029},
    { 16055, -7007},
    { 15957, -6964},
    { 15830, -6930},
    { 15674, -6917},
    { 15521, -6911},
    { 15394, -6842},
    { 15280, -6883},
    { 15120, -6887},
    { 15027, -6844},
    { 14873, -6830},
    { 14722, -6804},
    { 14561, -6758},
    { 14415, -6704},
    { 14272, -6697},
    { 14137, -6678},
    { 13998, -6665},
    { 13857, -6651},
    { 13721, -6632},
    { 13583, -6619},
    { 13509, -6523},
    { 13413, -6612},
    { 13268, -6614},
    { 13129, -6622},
    { 12994, -6635},
    { 12896, -6709},
    { 12754, -6695},
    { 12623, -6631},
    { 12513, -6669},
    { 12402, -6655},
    { 12285, -6665},
    { 12140, -6669},
    { 12001, -6684},
    { 11854, -6692},
    { 11713, -6685},
    { 11556, -6637},
    { 11447, -6624},
    { 11356, -6578},
    { 11231, -6587},
    { 11097, -6605},
    { 10978, -6667},
    { 10837, -6662},
    { 10706, -6640},
    { 10569, -6625},
    { 10435, -6604},
    { 10299, -6592},
    { 10162, -6600},
    { 10050, -6633},
    {  9942, -6677},
    {  9841, -6653},
    {  9699, -6658},
    {  9549, -6665},
    {  9408, -6663},
    {  9262, -6661},
    {  9118, -6655},
    {  8978, -6669},
    {  8876, -6647},
    {  8770, -6680},
    {  8639, -6703},
    {  8498, -6714},
    {  8350, -6715},
    {  8216, -6727},
    {  8087, -6785},
    {  7942, -6804},
    {  7828, -6843},
    {  7741, -6916},
    {  7606, -6945},
};

static MCoord ec3[] = {
    { 14904, -2093},
    { 14882, -2080},
    { 14879, -2050},
    { 14874, -2025},
    { 14771, -1975},
    { 14669, -1917},
    { 14606, -1828},
    { 14595, -1718},
    { 14545, -1619},
    { 14528, -1506},
    { 14457, -1428},
    { 14362, -1392},
    { 14343, -1282},
    { 14295, -1186},
    { 14255, -1081},
    { 14197, -1191},
    { 14161, -1305},
    { 14159, -1416},
    { 14155, -1530},
    { 14129, -1644},
    { 14078, -1746},
    { 13967, -1752},
    { 13877, -1683},
    { 13775, -1629},
    { 13669, -1584},
    { 13575, -1511},
    { 13594, -1398},
    { 13656, -1287},
    { 13572, -1216},
    { 13454, -1204},
    { 13345, -1177},
    { 13243, -1123},
    { 13195, -1226},
    { 13091, -1247},
    { 13023, -1328},
    { 12956, -1406},
    { 12966, -1509},
    { 12849, -1479},
    { 12750, -1405},
    { 12632, -1412},
    { 12521, -1468},
    { 12441, -1559},
    { 12358, -1645},
    { 12250, -1693},
    { 12226, -1795},
    { 12164, -1878},
    { 12087, -1966},
    { 11970, -2000},
    { 11862, -2031},
    { 11750, -2069},
    { 11635, -2083},
    { 11541, -2152},
    { 11447, -2217},
    { 11379, -2306},
    { 11341, -2413},
    { 11380, -2520},
    { 11411, -2631},
    { 11411, -2757},
    { 11457, -2862},
    { 11495, -2970},
    { 11521, -3082},
    { 11573, -3188},
    { 11567, -3302},
    { 11497, -3396},
    { 11593, -3473},
    { 11722, -3502},
    { 11826, -3493},
    { 11943, -3439},
    { 12057, -3391},
    { 12160, -3384},
    { 12293, -3387},
    { 12401, -3337},
    { 12505, -3272},
    { 12627, -3225},
    { 12730, -3226},
    { 12827, -3199},
    { 12955, -3162},
    { 13057, -3159},
    { 13184, -3176},
    { 13303, -3211},
    { 13421, -3253},
    { 13483, -3342},
    { 13531, -3453},
    { 13632, -3415},
    { 13734, -3342},
    { 13747, -3450},
    { 13846, -3469},
    { 13925, -3537},
    { 13976, -3641},
    { 14004, -3749},
    { 14115, -3813},
    { 14246, -3839},
    { 14345, -3879},
    { 14435, -3834},
    { 14547, -3843},
    { 14634, -3902},
    { 14716, -3840},
    { 14802, -3788},
    { 14913, -3778},
    { 14995, -3711},
    { 15014, -3600},
    { 15077, -3501},
    { 15121, -3397},
    { 15180, -3292},
    { 15256, -3205},
    { 15306, -3096},
    { 15328, -2984},
    { 15361, -2872},
    { 15332, -2762},
    { 15311, -2652},
    { 15291, -2539},
    { 15209, -2454},
    { 15121, -2378},
    { 15080, -2277},
    { 14978, -2243},
    { 14932, -2142},
};

static MCoord ec4[] = {
    { -3567,  6622},
    { -3560,  6635},
    { -3498,  6633},
    { -3453,  6652},
    { -3348,  6729},
    { -3220,  6792},
    { -3056,  6814},
    { -2914,  6831},
    { -2771,  6852},
    { -2622,  6874},
    { -2521,  6915},
    { -2402,  6953},
    { -2289,  6990},
    { -2443,  7024},
    { -2601,  7027},
    { -2749,  7002},
    { -2851,  7045},
    { -2761,  7104},
    { -2602,  7107},
    { -2706,  7152},
    { -2818,  7194},
    { -2677,  7160},
    { -2517,  7137},
    { -2420,  7095},
    { -2264,  7053},
    { -2197,  7137},
    { -2290,  7175},
    { -2433,  7234},
    { -2547,  7233},
    { -2645,  7271},
    { -2526,  7307},
    { -2627,  7317},
    { -2499,  7355},
    { -2366,  7374},
    { -2265,  7329},
    { -2105,  7346},
    { -2222,  7412},
    { -2049,  7441},
    { -1918,  7450},
    { -2075,  7472},
    { -2183,  7507},
    { -1978,  7525},
    { -2055,  7595},
    { -2209,  7652},
    { -2109,  7687},
    { -2008,  7695},
    { -1871,  7682},
    { -1981,  7736},
    { -2088,  7791},
    { -2012,  7895},
    { -1883,  7976},
    { -1771,  7994},
    { -1982,  8000},
    { -1767,  8023},
    { -1651,  8040},
    { -1884,  8058},
    { -1995,  8062},
    { -1740,  8075},
    { -1559,  8082},
    { -1349,  8129},
    { -1250,  8156},
    { -1347,  8180},
    { -1535,  8191},
    { -1727,  8181},
    { -1833,  8154},
    { -2030,  8155},
    { -2166,  8131},
    { -2354,  8081},
    { -2260,  8133},
    { -2335,  8204},
    { -2570,  8158},
    { -2689,  8152},
    { -2538,  8191},
    { -2713,  8202},
    { -2932,  8194},
    { -3105,  8186},
    { -3232,  8183},
    { -3039,  8215},
    { -2787,  8218},
    { -2574,  8215},
    { -2381,  8226},
    { -2213,  8242},
    { -2369,  8283},
    { -2517,  8290},
    { -2832,  8309},
    { -3060,  8307},
    { -3257,  8296},
    { -3427,  8292},
    { -3219,  8309},
    { -2991,  8316},
    { -2741,  8315},
    { -2619,  8334},
    { -2860,  8348},
    { -3099,  8359},
    { -3375,  8356},
    { -3616,  8350},
    { -3763,  8343},
    { -3928,  8288},
    { -4173,  8314},
    { -4348,  8318},
    { -4520,  8301},
    { -4340,  8285},
    { -4115,  8278},
    { -3990,  8258},
    { -4185,  8266},
    { -4436,  8278},
    { -4537,  8186},
    { -4663,  8210},
    { -4815,  8229},
    { -4976,  8249},
    { -5091,  8238},
    { -5256,  8193},
    { -5358,  8172},
    { -5527,  8226},
    { -5695,  8218},
    { -5886,  8200},
    { -5699,  8146},
    { -5838,  8167},
    { -5964,  8190},
    { -6121,  8176},
    { -6325,  8109},
    { -6539,  8075},
    { -6653,  8055},
    { -6478,  8011},
    { -6552,  7928},
    { -6663,  7913},
    { -6798,  7907},
    { -6914,  7887},
    { -7048,  7870},
    { -7172,  7859},
    { -7267,  7812},
    { -7164,  7788},
    { -7062,  7781},
    { -6964,  7750},
    { -6847,  7756},
    { -6716,  7762},
    { -6845,  7724},
    { -6684,  7717},
    { -6813,  7718},
    { -6943,  7722},
    { -7072,  7718},
    { -6894,  7667},
    { -6721,  7599},
    { -6576,  7618},
    { -6416,  7624},
    { -6290,  7629},
    { -6180,  7621},
    { -6070,  7607},
    { -5886,  7573},
    { -5781,  7503},
    { -5645,  7451},
    { -5580,  7366},
    { -5470,  7278},
    { -5558,  7172},
    { -5449,  7137},
    { -5364,  7206},
    { -5252,  7165},
    { -5140,  7101},
    { -5241,  7068},
    { -5413,  7079},
    { -5299,  7030},
    { -5155,  7001},
    { -5037,  6992},
    { -5100,  6882},
    { -5259,  6846},
    { -5135,  6837},
    { -5277,  6814},
    { -5157,  6784},
    { -5037,  6760},
    { -5166,  6766},
    { -5295,  6766},
    { -5135,  6733},
    { -5276,  6729},
    { -5359,  6643},
    { -5215,  6654},
    { -5109,  6693},
    { -5208,  6650},
    { -5317,  6613},
    { -5209,  6596},
    { -5088,  6573},
    { -5226,  6542},
    { -5184,  6434},
    { -5088,  6479},
    { -4988,  6448},
    { -5115,  6422},
    { -5083,  6320},
    { -5016,  6242},
    { -4910,  6205},
    { -4829,  6121},
    { -4682,  6090},
    { -4578,  6113},
    { -4483,  6054},
    { -4349,  6013},
    { -4284,  6103},
    { -4232,  6196},
    { -4178,  6296},
    { -4089,  6361},
    { -4081,  6477},
    { -3990,  6552},
    { -3864,  6563},
    { -3757,  6636},
    { -3637,  6599},
};

static MCoord ec5[] = {
    { -6711,  6831},
    { -6753,  6831},
    { -6718,  6841},
    { -6769,  6849},
    { -6891,  6879},
    { -6780,  6921},
    { -6949,  6954},
    { -6832,  6968},
    { -6730,  6998},
    { -6832,  7014},
    { -6971,  6974},
    { -6873,  7036},
    { -7010,  7067},
    { -7130,  7023},
    { -7064,  7099},
    { -7229,  7077},
    { -7141,  7143},
    { -7276,  7149},
    { -7403,  7133},
    { -7502,  7169},
    { -7613,  7197},
    { -7513,  7241},
    { -7673,  7269},
    { -7842,  7253},
    { -7958,  7234},
    { -8087,  7232},
    { -8130,  7357},
    { -8300,  7368},
    { -8464,  7333},
    { -8567,  7271},
    { -8452,  7219},
    { -8573,  7204},
    { -8477,  7162},
    { -8626,  7105},
    { -8514,  7129},
    { -8605,  7178},
    { -8659,  7288},
    { -8511,  7363},
    { -8635,  7385},
    { -8816,  7359},
    { -8919,  7310},
    { -8981,  7225},
    { -8914,  7128},
    { -8745,  7103},
    { -8923,  7102},
    { -8807,  7033},
    { -8671,  7041},
    { -8551,  7005},
    { -8379,  6996},
    { -8209,  6985},
    { -8103,  7007},
    { -7948,  6988},
    { -7855,  7034},
    { -7766,  6988},
    { -7660,  6962},
    { -7567,  6916},
    { -7469,  6878},
    { -7348,  6832},
    { -7253,  6761},
    { -7157,  6665},
    { -7054,  6681},
    { -6943,  6649},
    { -7105,  6607},
    { -7202,  6666},
    { -7336,  6662},
    { -7434,  6617},
    { -7560,  6529},
    { -7708,  6543},
    { -7815,  6477},
    { -7696,  6425},
    { -7582,  6445},
    { -7469,  6447},
    { -7346,  6459},
    { -7254,  6392},
    { -7151,  6364},
    { -7068,  6289},
    { -6947,  6267},
    { -6798,  6220},
    { -6683,  6200},
    { -6756,  6298},
    { -6882,  6364},
    { -6781,  6363},
    { -6678,  6315},
    { -6562,  6291},
    { -6467,  6339},
    { -6531,  6436},
    { -6656,  6491},
    { -6768,  6559},
    { -6699,  6655},
    { -6582,  6624},
    { -6467,  6623},
    { -6415,  6516},
    { -6298,  6566},
    { -6187,  6635},
    { -6279,  6677},
    { -6445,  6710},
    { -6538,  6777},
    { -6653,  6801},
};

static MCoord ec6[] = {
    { 14111,  -919},
    { 14138,  -916},
    { 14167,  -921},
    { 14196,  -919},
    { 14306,  -909},
    { 14228,  -823},
    { 14353,  -821},
    { 14455,  -759},
    { 14566,  -793},
    { 14645,  -865},
    { 14716,  -948},
    { 14808, -1011},
    { 14923, -1026},
    { 15028, -1067},
    { 14992,  -972},
    { 14894,  -905},
    { 14812,  -810},
    { 14721,  -742},
    { 14784,  -643},
    { 14693,  -586},
    { 14583,  -545},
    { 14541,  -446},
    { 14448,  -384},
    { 14343,  -341},
    { 14231,  -311},
    { 14126,  -265},
    { 14017,  -236},
    { 13908,  -201},
    { 13802,  -156},
    { 13703,  -212},
    { 13612,  -265},
    { 13530,  -336},
    { 13462,  -256},
    { 13419,  -154},
    { 13345,   -72},
    { 13237,   -36},
    { 13131,   -83},
    { 13197,  -184},
    { 13295,  -226},
    { 13206,  -278},
    { 13286,  -345},
    { 13379,  -308},
    { 13450,  -396},
    { 13542,  -444},
    { 13652,  -476},
    { 13759,  -517},
    { 13833,  -602},
    { 13906,  -690},
    { 13890,  -814},
    { 14000,  -801},
    { 14067,  -885},
};

static MCoord ec7[] = {
    { 11767,   431},
    { 11799,   426},
    { 11829,   433},
    { 11853,   448},
    { 11926,   528},
    { 11834,   580},
    { 11741,   661},
    { 11639,   640},
    { 11567,   555},
    { 11473,   487},
    { 11389,   421},
    { 11313,   333},
    { 11210,   291},
    { 11125,   214},
    { 11025,   172},
    { 10915,   159},
    { 10893,    48},
    { 10919,   -52},
    { 11005,  -139},
    { 11020,  -249},
    { 11116,  -300},
    { 11225,  -332},
    { 11335,  -321},
    { 11447,  -344},
    { 11555,  -378},
    { 11626,  -288},
    { 11637,  -174},
    { 11727,   -88},
    { 11750,     9},
    { 11799,   103},
    { 11785,   203},
    { 11759,   300},
    { 11746,   414},
};

static MCoord ec8[] = {
    { -7617,  8258},
    { -7710,  8282},
    { -7876,  8290},
    { -7955,  8276},
    { -8138,  8266},
    { -7977,  8194},
    { -8233,  8214},
    { -8477,  8243},
    { -8585,  8230},
    { -8681,  8200},
    { -8857,  8202},
    { -9065,  8174},
    { -8849,  8151},
    { -8974,  8118},
    { -8858,  8105},
    { -8589,  8119},
    { -8874,  8093},
    { -8674,  8081},
    { -8559,  8103},
    { -8330,  8113},
    { -8546,  8097},
    { -8649,  8071},
    { -8374,  8068},
    { -8261,  8069},
    { -8121,  8064},
    { -7978,  8082},
    { -7759,  8135},
    { -7871,  8099},
    { -7731,  8089},
    { -7928,  8070},
    { -8065,  8047},
    { -8249,  8036},
    { -8058,  7969},
    { -8192,  7975},
    { -8386,  8022},
    { -8553,  8030},
    { -8656,  8018},
    { -8553,  7968},
    { -8407,  7912},
    { -8203,  7894},
    { -8373,  7881},
    { -8519,  7888},
    { -8662,  7876},
    { -8491,  7841},
    { -8373,  7756},
    { -8275,  7793},
    { -8417,  7736},
    { -8538,  7742},
    { -8678,  7786},
    { -8805,  7779},
    { -8707,  7728},
    { -8853,  7706},
    { -8666,  7648},
    { -8474,  7642},
    { -8367,  7657},
    { -8246,  7659},
    { -8086,  7624},
    { -7882,  7647},
    { -7787,  7689},
    { -7919,  7711},
    { -8022,  7718},
    { -8160,  7723},
    { -8010,  7730},
    { -7878,  7734},
    { -7656,  7796},
    { -7556,  7826},
    { -7787,  7889},
    { -7642,  7918},
    { -7490,  7909},
    { -7724,  7930},
    { -7524,  7943},
    { -7374,  7951},
    { -7150,  7978},
    { -7037,  8037},
    { -6921,  8048},
    { -6723,  8095},
    { -6606,  8118},
    { -6473,  8141},
    { -6729,  8136},
    { -6945,  8118},
    { -6729,  8145},
    { -6843,  8159},
    { -6576,  8168},
    { -6411,  8179},
    { -6244,  8200},
    { -6133,  8224},
    { -6245,  8249},
    { -6491,  8283},
    { -6745,  8270},
    { -7038,  8303},
    { -7181,  8303},
    { -7310,  8286},
    { -7410,  8294},
    { -7617,  8303},
};

static MCoord ec9[] = {
    { 12012,  -558},
    { 12036,  -554},
    { 12034,  -527},
    { 12030,  -500},
    { 12038,  -387},
    { 12044,  -280},
    { 12106,  -369},
    { 12168,  -479},
    { 12272,  -440},
    { 12233,  -334},
    { 12188,  -239},
    { 12238,  -146},
    { 12327,   -97},
    { 12213,   -85},
    { 12117,  -128},
    { 12010,   -67},
    { 12030,    40},
    { 12141,    48},
    { 12254,    49},
    { 12364,    29},
    { 12463,    73},
    { 12510,   166},
    { 12425,   101},
    { 12315,    94},
    { 12201,   105},
    { 12093,   133},
    { 11999,    55},
    { 11979,   -68},
    { 11931,  -159},
    { 11888,  -263},
    { 11945,  -352},
    { 11954,  -465},
    { 11964,  -565},
};

static MCoord ec10[] = {
    {  9522,   552},
    {  9524,   531},
    {  9534,   504},
    {  9547,   477},
    {  9631,   398},
    {  9719,   327},
    {  9775,   231},
    {  9874,   168},
    {  9908,    60},
    {  9979,   -19},
    { 10040,  -115},
    { 10087,  -218},
    { 10154,  -311},
    { 10231,  -393},
    { 10321,  -465},
    { 10407,  -538},
    { 10507,  -573},
    { 10587,  -505},
    { 10591,  -390},
    { 10573,  -268},
    { 10467,  -258},
    { 10445,  -146},
    { 10344,   -75},
    { 10374,    23},
    { 10261,    21},
    { 10211,   134},
    { 10128,   204},
    { 10023,   258},
    {  9951,   330},
    {  9857,   397},
    {  9796,   476},
    {  9700,   526},
    {  9591,   545},
};

static MCoord ec11[] = {
    {  4327, -2199},
    {  4328, -2224},
    {  4332, -2255},
    {  4340, -2283},
    {  4368, -2388},
    {  4407, -2494},
    {  4514, -2552},
    {  4631, -2518},
    {  4726, -2458},
    {  4767, -2348},
    {  4797, -2236},
    {  4837, -2127},
    {  4872, -2015},
    {  4908, -1905},
    {  4945, -1796},
    {  4969, -1689},
    {  4971, -1586},
    {  5043, -1511},
    {  5016, -1400},
    {  4985, -1289},
    {  4885, -1247},
    {  4852, -1345},
    {  4786, -1422},
    {  4709, -1535},
    {  4608, -1578},
    {  4501, -1612},
    {  4417, -1710},
    {  4405, -1818},
    {  4437, -1927},
    {  4427, -2033},
    {  4363, -2128},
};

static MCoord ec12[] = {
    { 14099,  4149},
    { 14081,  4126},
    { 14112,  4120},
    { 14118,  4096},
    { 14015,  4077},
    { 14006,  3970},
    { 13960,  3861},
    { 13880,  3771},
    { 13772,  3700},
    { 13675,  3729},
    { 13624,  3628},
    { 13543,  3551},
    { 13414,  3553},
    { 13307,  3554},
    { 13198,  3482},
    { 13090,  3422},
    { 13204,  3386},
    { 13300,  3431},
    { 13421,  3466},
    { 13541,  3458},
    { 13547,  3356},
    { 13640,  3419},
    { 13735,  3463},
    { 13868,  3503},
    { 13986,  3554},
    { 14060,  3635},
    { 14103,  3743},
    { 14151,  3844},
    { 14200,  3949},
    { 14153,  4055},
};

static MCoord ec13[] = {
    {  -501,  5857},
    {  -505,  5836},
    {  -527,  5817},
    {  -523,  5795},
    {  -569,  5700},
    {  -559,  5585},
    {  -508,  5495},
    {  -387,  5483},
    {  -306,  5416},
    {  -378,  5329},
    {  -443,  5218},
    {  -368,  5149},
    {  -264,  5164},
    {  -400,  5121},
    {  -487,  5058},
    {  -382,  5026},
    {  -283,  5070},
    {  -148,  5079},
    {   -26,  5081},
    {   102,  5100},
    {   155,  5210},
    {    97,  5296},
    {    11,  5347},
    {   -53,  5443},
    {  -142,  5503},
    {  -241,  5597},
    {  -344,  5600},
    {  -255,  5657},
    {  -189,  5735},
    {  -290,  5768},
    {  -414,  5760},
    {  -315,  5855},
    {  -426,  5853},
};

static MCoord ec14[] = {
    {-11453,  7261},
    {-11421,  7275},
    {-11400,  7303},
    {-11430,  7331},
    {-11607,  7313},
    {-11763,  7279},
    {-11881,  7204},
    {-11796,  7151},
    {-11645,  7148},
    {-11797,  7111},
    {-11677,  7061},
    {-11504,  7061},
    {-11336,  7064},
    {-11174,  7035},
    {-11281,  7023},
    {-11453,  7030},
    {-11622,  7019},
    {-11732,  6988},
    {-11641,  6941},
    {-11485,  6926},
    {-11361,  6903},
    {-11234,  6851},
    {-11081,  6859},
    {-10924,  6870},
    {-10783,  6895},
    {-10675,  6939},
    {-10568,  6914},
    {-10435,  6889},
    {-10277,  6885},
    {-10221,  6981},
    {-10090,  6988},
    {-10188,  7029},
    {-10340,  7059},
    {-10446,  7106},
    {-10502,  7219},
    {-10585,  7301},
    {-10757,  7327},
    {-10774,  7222},
    {-10887,  7260},
    {-11026,  7298},
    {-11155,  7233},
    {-11284,  7297},
    {-11415,  7261},
};

static MCoord ec15[] = {
    { -8486,  2185},
    { -8455,  2187},
    { -8431,  2186},
    { -8401,  2199},
    { -8299,  2251},
    { -8173,  2258},
    { -8079,  2205},
    { -7962,  2166},
    { -7854,  2133},
    { -7767,  2069},
    { -7706,  1989},
    { -7583,  1996},
    { -7466,  2005},
    { -7563,  2078},
    { -7653,  2125},
    { -7747,  2184},
    { -7856,  2231},
    { -7965,  2271},
    { -8078,  2308},
    { -8200,  2317},
    { -8321,  2296},
    { -8432,  2242},
};

static MCoord ec16[] = {
    { -5575,  5154},
    { -5607,  5154},
    { -5648,  5140},
    { -5678,  5120},
    { -5745,  5045},
    { -5787,  4954},
    { -5874,  4870},
    { -5932,  4787},
    { -5830,  4769},
    { -5704,  4758},
    { -5585,  4784},
    { -5531,  4695},
    { -5444,  4746},
    { -5352,  4676},
    { -5270,  4761},
    { -5380,  4780},
    { -5376,  4900},
    { -5476,  4936},
    { -5587,  4948},
    { -5645,  5032},
    { -5596,  5124},
};

static MCoord ec17[] = {
    { 17693, -3964},
    { 17693, -3945},
    { 17710, -3920},
    { 17743, -3907},
    { 17833, -3834},
    { 17721, -3798},
    { 17613, -3762},
    { 17556, -3662},
    { 17465, -3612},
    { 17407, -3518},
    { 17294, -3450},
    { 17347, -3561},
    { 17433, -3620},
    { 17472, -3713},
    { 17475, -3818},
    { 17396, -3908},
    { 17499, -3994},
    { 17493, -4095},
    { 17608, -4109},
    { 17687, -4010},
};

static MCoord ec18[] = {
    { 12220,  1848},
    { 12201,  1832},
    { 12169,  1833},
    { 12144,  1846},
    { 12043,  1787},
    { 12031,  1672},
    { 11989,  1578},
    { 12023,  1477},
    { 12075,  1387},
    { 12178,  1392},
    { 12290,  1360},
    { 12382,  1289},
    { 12342,  1398},
    { 12227,  1413},
    { 12150,  1511},
    { 12198,  1614},
    { 12244,  1722},
    { 12229,  1826},
};

static MCoord ec19[] = {
    { 17410, -4155},
    { 17415, -4126},
    { 17407, -4109},
    { 17384, -4110},
    { 17271, -4068},
    { 17191, -4157},
    { 17114, -4255},
    { 17026, -4321},
    { 16923, -4374},
    { 16823, -4419},
    { 16720, -4503},
    { 16663, -4594},
    { 16761, -4621},
    { 16898, -4663},
    { 17005, -4626},
    { 17091, -4530},
    { 17112, -4422},
    { 17209, -4383},
    { 17316, -4300},
    { 17395, -4208},
};

static MCoord ec20[] = {
    { 11003,  -789},
    { 11030,  -801},
    { 11056,  -813},
    { 11084,  -820},
    { 11199,  -829},
    { 11313,  -828},
    { 11422,  -862},
    { 11372,  -770},
    { 11268,  -716},
    { 11169,  -673},
    { 11069,  -653},
    { 10949,  -684},
    { 10850,  -648},
    { 10746,  -609},
    { 10643,  -600},
    { 10545,  -672},
    { 10647,  -709},
    { 10764,  -759},
    { 10876,  -766},
    { 10983,  -782},
};

static MCoord ec21[] = {
    { 14189,  5301},
    { 14184,  5271},
    { 14174,  5244},
    { 14167,  5217},
    { 14224,  5109},
    { 14215,  4994},
    { 14191,  4880},
    { 14201,  4769},
    { 14183,  4655},
    { 14304,  4659},
    { 14265,  4756},
    { 14286,  4869},
    { 14400,  4925},
    { 14375,  5045},
    { 14332,  5158},
    { 14332,  5300},
    { 14296,  5412},
    { 14186,  5338},
};

static MCoord ec22[] = {
    { 12542,   976},
    { 12542,   957},
    { 12551,   929},
    { 12546,   902},
    { 12457,   853},
    { 12337,   862},
    { 12241,   805},
    { 12192,   706},
    { 12282,   758},
    { 12404,   760},
    { 12405,   653},
    { 12493,   588},
    { 12551,   697},
    { 12658,   727},
    { 12637,   836},
    { 12597,   938},
};

static MCoord ec23[] = {
    { -1482,  6637},
    { -1539,  6623},
    { -1583,  6641},
    { -1639,  6646},
    { -1737,  6606},
    { -1853,  6604},
    { -2010,  6600},
    { -2103,  6534},
    { -2170,  6612},
    { -2290,  6642},
    { -2368,  6570},
    { -2213,  6549},
    { -2369,  6488},
    { -2260,  6479},
    { -2200,  6385},
    { -2059,  6377},
    { -1901,  6341},
    { -1789,  6363},
    { -1688,  6384},
    { -1579,  6418},
    { -1457,  6447},
    { -1372,  6520},
    { -1462,  6578},
};

static MCoord ec24[] = {
    { -7211,  1973},
    { -7235,  1977},
    { -7266,  1991},
    { -7296,  1992},
    { -7266,  1892},
    { -7366,  1854},
    { -7247,  1821},
    { -7151,  1771},
    { -7073,  1838},
    { -6963,  1843},
    { -6855,  1833},
    { -6948,  1912},
    { -7035,  1971},
    { -7156,  1989},
};

static MCoord ec25[] = {
    { 14193,  4551},
    { 14173,  4541},
    { 14161,  4515},
    { 14175,  4488},
    { 14143,  4378},
    { 14051,  4328},
    { 13981,  4229},
    { 14102,  4175},
    { 14178,  4259},
    { 14279,  4215},
    { 14385,  4280},
    { 14499,  4303},
    { 14531,  4420},
    { 14415,  4408},
    { 14311,  4451},
    { 14234,  4518},
};

static MCoord ec26[] = {
    {-11270,  7621},
    {-11368,  7625},
    {-11452,  7646},
    {-11537,  7627},
    {-11659,  7599},
    {-11542,  7588},
    {-11695,  7571},
    {-11576,  7561},
    {-11744,  7538},
    {-11601,  7509},
    {-11404,  7532},
    {-11264,  7517},
    {-11145,  7519},
    {-11334,  7487},
    {-11150,  7454},
    {-10980,  7486},
    {-10874,  7499},
    {-10773,  7499},
    {-10662,  7499},
    {-10564,  7546},
    {-10683,  7583},
    {-10820,  7613},
    {-10952,  7668},
    {-10899,  7563},
    {-11098,  7556},
    {-11222,  7604},
};

static MCoord ec27[] = {
    {  -732,  5531},
    {  -761,  5516},
    {  -800,  5516},
    {  -836,  5495},
    {  -922,  5426},
    { -1006,  5352},
    {  -943,  5262},
    { -1025,  5187},
    {  -912,  5153},
    {  -788,  5190},
    {  -655,  5222},
    {  -611,  5331},
    {  -557,  5444},
    {  -693,  5515},
};

static MCoord ec28[] = {
    { -7238, -7271},
    { -7178, -7266},
    { -7080, -7266},
    { -6987, -7261},
    { -6851, -7222},
    { -6823, -7108},
    { -6889, -7024},
    { -6958, -6941},
    { -7084, -6882},
    { -7213, -6915},
    { -7160, -7026},
    { -7092, -7107},
    { -7274, -7111},
    { -7413, -7153},
    { -7535, -7173},
    { -7433, -7213},
    { -7318, -7191},
    { -7201, -7179},
    { -7092, -7224},
    { -7280, -7234},
};

static MCoord ec29[] = {
    { -6853, -5482},
    { -6803, -5484},
    { -6754, -5487},
    { -6704, -5490},
    { -6556, -5491},
    { -6672, -5428},
    { -6778, -5371},
    { -6859, -5267},
    { -6964, -5263},
    { -7042, -5331},
    { -6960, -5422},
    { -7074, -5419},
    { -7179, -5450},
    { -7077, -5471},
    { -6936, -5488},
};

static MCoord ec30[] = {
    { -9207,  7663},
    { -9315,  7652},
    { -9325,  7669},
    { -9400,  7691},
    { -9516,  7701},
    { -9648,  7698},
    { -9500,  7630},
    { -9360,  7630},
    { -9232,  7591},
    { -9187,  7477},
    { -9005,  7457},
    { -8883,  7474},
    { -8705,  7450},
    { -8532,  7458},
    { -8340,  7473},
    { -8172,  7450},
    { -8056,  7458},
    { -7955,  7534},
    { -8118,  7571},
    { -8224,  7582},
    { -8348,  7578},
    { -8455,  7568},
    { -8562,  7552},
    { -8741,  7554},
    { -8859,  7554},
    { -8968,  7588},
    { -9094,  7610},
};

static MCoord ec31[] = {
    {  1088,  7940},
    {  1170,  7920},
    {  1193,  7892},
    {  1209,  7862},
    {  1371,  7824},
    {  1491,  7868},
    {  1594,  7853},
    {  1492,  7814},
    {  1653,  7782},
    {  1533,  7761},
    {  1426,  7748},
    {  1570,  7703},
    {  1678,  7667},
    {  1755,  7733},
    {  1843,  7787},
    {  2016,  7862},
    {  2118,  7878},
    {  1992,  7907},
    {  1893,  7926},
    {  1772,  7983},
    {  1639,  7995},
    {  1548,  7938},
    {  1428,  7968},
    {  1307,  7982},
    {  1181,  7974},
};

static MCoord ec32[] = {
    {  5644,  7469},
    {  5580,  7453},
    {  5542,  7428},
    {  5533,  7414},
    {  5419,  7370},
    {  5580,  7336},
    {  5703,  7353},
    {  5794,  7410},
    {  5963,  7470},
    {  6076,  7511},
    {  6259,  7550},
    {  6364,  7566},
    {  6470,  7577},
    {  6573,  7591},
    {  6676,  7605},
    {  6778,  7622},
    {  6888,  7669},
    {  6715,  7695},
    {  6612,  7677},
    {  6439,  7638},
    {  6318,  7626},
    {  6216,  7625},
    {  6107,  7618},
    {  5916,  7588},
    {  5756,  7542},
    {  5623,  7505},
};

static MCoord ec33[] = {
    { 15212,  -418},
    { 15194,  -425},
    { 15159,  -423},
    { 15162,  -451},
    { 15084,  -547},
    { 14970,  -552},
    { 14857,  -549},
    { 14950,  -615},
    { 15059,  -618},
    { 15153,  -558},
    { 15238,  -476},
};

static MCoord ec34[] = {
    {-11971,  7417},
    {-12037,  7432},
    {-12124,  7450},
    {-12227,  7448},
    {-12334,  7443},
    {-12445,  7432},
    {-12466,  7319},
    {-12544,  7236},
    {-12445,  7177},
    {-12347,  7131},
    {-12208,  7130},
    {-12057,  7154},
    {-11958,  7229},
    {-11854,  7277},
    {-11698,  7313},
    {-11546,  7350},
    {-11660,  7398},
    {-11835,  7424},
};

static MCoord ec35[] = {
    { -8316,  6495},
    { -8351,  6512},
    { -8410,  6526},
    { -8473,  6535},
    { -8579,  6584},
    { -8628,  6473},
    { -8711,  6366},
    { -8589,  6370},
    { -8460,  6333},
    { -8353,  6405},
    { -8247,  6386},
    { -8095,  6351},
    { -8173,  6414},
    { -8273,  6481},
};

static MCoord ec36[] = {
    {  7980,   747},
    {  7984,   717},
    {  7986,   688},
    {  7994,   660},
    {  8098,   608},
    {  8183,   679},
    {  8162,   783},
    {  8104,   888},
    {  8033,   971},
    {  7992,   861},
    {  7979,   761},
};

static MCoord ec37[] = {
    { 12885,    27},
    { 12868,    45},
    { 12846,    61},
    { 12829,    81},
    { 12795,   207},
    { 12742,   117},
    { 12769,    16},
    { 12828,   -82},
    { 12794,    40},
};

static MCoord ec38[] = {
    { 14796, -4077},
    { 14773, -4085},
    { 14738, -4096},
    { 14695, -4105},
    { 14593, -4105},
    { 14483, -4071},
    { 14515, -4191},
    { 14558, -4298},
    { 14674, -4359},
    { 14749, -4292},
    { 14822, -4211},
    { 14829, -4107},
};

static MCoord ec39[] = {
    { -9410,  8106},
    { -9495,  8095},
    { -9440,  8067},
    { -9526,  8057},
    { -9623,  8006},
    { -9488,  7969},
    { -9368,  7938},
    { -9209,  7934},
    { -9107,  7920},
    { -9263,  7916},
    { -9387,  7903},
    { -9251,  7854},
    { -9095,  7816},
    { -8996,  7835},
    { -8864,  7832},
    { -8702,  7892},
    { -8543,  7942},
    { -8667,  7956},
    { -8766,  8029},
    { -8916,  8037},
    { -9110,  8080},
    { -9277,  8131},
};

static MCoord ec40[] = {
    { 13173,  3257},
    { 13195,  3282},
    { 13195,  3303},
    { 13177,  3323},
    { 13085,  3392},
    { 12974,  3335},
    { 13057,  3254},
    { 13023,  3142},
    { 13140,  3154},
};

static MCoord ec41[] = {
    {-12762,  5079},
    {-12807,  5085},
    {-12831,  5067},
    {-12797,  5048},
    {-12685,  4991},
    {-12593,  4934},
    {-12497,  4902},
    {-12378,  4835},
    {-12424,  4931},
    {-12514,  4992},
    {-12608,  5043},
    {-12735,  5069},
};

static MCoord ec42[] = {
    { 12522,  -938},
    { 12547,  -924},
    { 12575,  -916},
    { 12603,  -906},
    { 12708,  -861},
    { 12600,  -849},
    { 12497,  -890},
    { 12393,  -940},
    { 12490,  -970},
};

static MCoord ec43[] = {
    { -5269, -8091},
    { -5147, -8086},
    { -4976, -8076},
    { -4807, -8068},
    { -4641, -8057},
    { -4493, -8042},
    { -4363, -7997},
    { -4497, -7884},
    { -4404, -7831},
    { -4614, -7794},
    { -4749, -7795},
    { -4862, -7812},
    { -5011, -7861},
    { -5063, -7947},
    { -5202, -8000},
    { -5319, -8020},
    { -5433, -8041},
};

static MCoord ec44[] = {
    {-10005,  7387},
    {-10063,  7374},
    {-10098,  7351},
    {-10041,  7328},
    {-10135,  7279},
    {-10267,  7281},
    {-10162,  7233},
    {-10026,  7198},
    { -9933,  7148},
    { -9826,  7169},
    { -9671,  7185},
    { -9720,  7283},
    { -9775,  7387},
    { -9886,  7375},
};

static MCoord ec45[] = {
    {  5142,  7176},
    {  5163,  7156},
    {  5244,  7152},
    {  5337,  7143},
    {  5452,  7073},
    {  5627,  7064},
    {  5743,  7075},
    {  5622,  7121},
    {  5539,  7202},
    {  5623,  7310},
    {  5462,  7337},
    {  5325,  7300},
    {  5209,  7211},
};

static MCoord ec46[] = {
    { 11949,  1140},
    { 11942,  1121},
    { 11934,  1090},
    { 11930,  1073},
    { 11859,   987},
    { 11773,   909},
    { 11874,   973},
    { 11962,  1045},
};

static MCoord ec47[] = {
    { 12120,  2510},
    { 12099,  2497},
    { 12083,  2471},
    { 12064,  2449},
    { 12013,  2343},
    { 12051,  2240},
    { 12133,  2303},
    { 12166,  2414},
    { 12167,  2520},
};

static MCoord ec48[] = {
    { 14036,  7485},
    { 14142,  7494},
    { 14235,  7490},
    { 14322,  7499},
    { 14216,  7560},
    { 14336,  7509},
    { 14441,  7510},
    { 14272,  7586},
    { 14128,  7605},
    { 13979,  7593},
    { 13874,  7615},
    { 13741,  7578},
    { 13836,  7476},
    { 13938,  7477},
};

static MCoord ec49[] = {
    { 16488, -2061},
    { 16465, -2042},
    { 16436, -2027},
    { 16411, -2017},
    { 16478, -2110},
    { 16577, -2179},
    { 16686, -2235},
    { 16600, -2146},
    { 16513, -2074},
};

static MCoord ec50[] = {
    { -4844,   -25},
    { -4864,   -22},
    { -4893,   -18},
    { -4921,   -14},
    { -5034,   -12},
    { -5068,  -114},
    { -4970,  -170},
    { -4881,  -119},
};

static MCoord ec51[] = {
    { 12816,  -287},
    { 12807,  -301},
    { 12791,  -335},
    { 12810,  -319},
    { 12910,  -336},
    { 13016,  -354},
    { 12946,  -280},
    { 12832,  -285},
};

static MCoord ec52[] = {
    { 12027,  -826},
    { 12013,  -835},
    { 11989,  -847},
    { 11987,  -877},
    { 12101,  -891},
    { 12215,  -874},
    { 12099,  -836},
};

static MCoord ec53[] = {
    {  1559,  3828},
    {  1531,  3823},
    {  1499,  3816},
    {  1465,  3810},
    {  1358,  3805},
    {  1255,  3802},
    {  1342,  3732},
    {  1437,  3696},
    {  1518,  3764},
};

static MCoord ec54[] = {
    { 15082,  -267},
    { 15091,  -278},
    { 15117,  -289},
    { 15142,  -305},
    { 15237,  -368},
    { 15284,  -474},
    { 15258,  -377},
    { 15168,  -307},
};

static MCoord ec55[] = {
    { 11721,  -837},
    { 11708,  -842},
    { 11683,  -859},
    { 11678,  -890},
    { 11782,  -891},
    { 11906,  -867},
    { 11809,  -813},
};

static MCoord ec56[] = {
    { 10954,  1991},
    { 10940,  1987},
    { 10922,  1975},
    { 10897,  1954},
    { 10873,  1854},
    { 10991,  1840},
    { 11057,  1916},
    { 10975,  1997},
};

static MCoord ec57[] = {
    { -9526,  7396},
    { -9498,  7377},
    { -9530,  7370},
    { -9563,  7350},
    { -9517,  7236},
    { -9411,  7206},
    { -9320,  7278},
    { -9164,  7300},
    { -9036,  7381},
    { -9186,  7400},
    { -9364,  7414},
};

static MCoord ec58[] = {
    {-10055,  7659},
    {-10035,  7636},
    { -9991,  7605},
    {-10056,  7611},
    {-10158,  7636},
    {-10240,  7571},
    {-10110,  7561},
    { -9957,  7568},
    { -9805,  7510},
    { -9756,  7612},
    { -9874,  7656},
};

static MCoord ec59[] = {
    {   918,  4121},
    {   896,  4106},
    {   866,  4088},
    {   826,  4086},
    {   849,  3980},
    {   937,  3917},
    {   973,  4038},
};

static MCoord ec60[] = {
    { 13462,  3418},
    { 13438,  3425},
    { 13408,  3436},
    { 13372,  3426},
    { 13270,  3380},
    { 13281,  3278},
    { 13372,  3350},
    { 13466,  3392},
};

static MCoord ec61[] = {
    {-11889,  7734},
    {-11949,  7718},
    {-12017,  7694},
    {-12090,  7670},
    {-12263,  7629},
    {-12109,  7604},
    {-11982,  7591},
    {-11871,  7644},
    {-11766,  7634},
    {-11607,  7670},
    {-11694,  7740},
    {-11796,  7736},
};

static MCoord ec62[] = {
    { -6041,  4692},
    { -6063,  4695},
    { -6094,  4669},
    { -6110,  4646},
    { -6030,  4569},
    { -6033,  4670},
};

static MCoord ec63[] = {
    {  2630,  3530},
    {  2613,  3522},
    {  2577,  3522},
    {  2548,  3532},
    {  2441,  3537},
    {  2536,  3498},
};

static MCoord ec64[] = {
    {  2450,  8032},
    {  2366,  8022},
    {  2294,  8037},
    {  2237,  8013},
    {  2028,  8039},
    {  1903,  8020},
    {  2128,  7977},
    {  2238,  7937},
    {  2369,  7921},
    {  2506,  7936},
    {  2685,  7981},
    {  2539,  8023},
};

static MCoord ec65[] = {
    { 12352,  1091},
    { 12335,  1095},
    { 12306,  1092},
    { 12294,  1069},
    { 12242,   977},
    { 12322,   912},
    { 12332,  1020},
};

static MCoord ec66[] = {
    { 10587,  -149},
    { 10576,  -165},
    { 10563,  -163},
    { 10540,  -166},
    { 10592,  -259},
    { 10600,  -158},
};

static MCoord ec67[] = {
    {-10225, -7219},
    {-10153, -7223},
    {-10062, -7229},
    { -9958, -7238},
    { -9781, -7251},
    { -9609, -7246},
    { -9694, -7187},
    { -9807, -7205},
    { -9956, -7205},
    {-10121, -7196},
    {-10224, -7205},
};

static MCoord ec68[] = {
    {-10381,  7936},
    {-10477,  7933},
    {-10553,  7914},
    {-10454,  7892},
    {-10256,  7830},
    {-10120,  7818},
    { -9945,  7785},
    {-10093,  7886},
    {-10232,  7900},
};

static MCoord ec69[] = {
    {  3459,  3568},
    {  3442,  3563},
    {  3411,  3550},
    {  3378,  3539},
    {  3278,  3518},
    {  3394,  3497},
};

static MCoord ec70[] = {
    { 12429,  1257},
    { 12432,  1241},
    { 12445,  1215},
    { 12470,  1198},
    { 12559,  1113},
    { 12545,  1221},
    { 12444,  1254},
};

static MCoord ec71[] = {
    { -7828,  1821},
    { -7804,  1815},
    { -7781,  1795},
    { -7754,  1785},
    { -7632,  1788},
    { -7738,  1846},
};

static MCoord ec72[] = {
    { 12192,  1187},
    { 12203,  1170},
    { 12207,  1142},
    { 12205,  1114},
    { 12314,  1145},
    { 12215,  1182},
};

static MCoord ec73[] = {
    { 11899,  -955},
    { 11919,  -973},
    { 11947,  -976},
    { 11973,  -985},
    { 12076, -1014},
    { 12002,  -937},
};

static MCoord ec74[] = {
    {  9967,  7938},
    {  9985,  7968},
    {  9953,  7995},
    {  9840,  7995},
    {  9696,  8013},
    {  9529,  8007},
    {  9332,  7957},
    {  9484,  7913},
    {  9612,  7901},
    {  9746,  7885},
    {  9882,  7881},
};

static MCoord ec75[] = {
    { -9796,  6989},
    { -9824,  6974},
    { -9835,  6948},
    { -9870,  6923},
    { -9742,  6857},
    { -9605,  6857},
    { -9714,  6960},
};

static MCoord ec76[] = {
    {  9300,  1355},
    {  9287,  1336},
    {  9283,  1308},
    {  9277,  1278},
    {  9264,  1162},
    {  9294,  1287},
};

static MCoord ec77[] = {
    { 10010,  7799},
    { 10130,  7816},
    { 10266,  7821},
    { 10411,  7830},
    { 10515,  7846},
    { 10337,  7909},
    { 10225,  7932},
    { 10120,  7906},
    { 10019,  7855},
};

static MCoord ec78[] = {
    { 12406,  1125},
    { 12396,  1113},
    { 12389,  1086},
    { 12376,  1060},
    { 12333,   953},
    { 12403,  1049},
};

static MCoord ec79[] = {
    { 15474,  -555},
    { 15473,  -583},
    { 15488,  -606},
    { 15509,  -625},
};

static MCoord ec80[] = {
    {-13359,  5635},
    {-13348,  5621},
    {-13321,  5596},
    {-13318,  5567},
    {-13223,  5478},
    {-13262,  5591},
};

static MCoord ec81[] = {
    { 12287,  7291},
    { 12377,  7280},
    { 12462,  7266},
    { 12537,  7248},
    { 12655,  7302},
    { 12506,  7365},
    { 12340,  7354},
};

static MCoord ec82[] = {
    { -6409,  4698},
    { -6434,  4676},
    { -6414,  4656},
    { -6384,  4638},
    { -6288,  4606},
    { -6391,  4663},
};

static MCoord ec83[] = {
    { -6369,  4986},
    { -6427,  4989},
    { -6414,  4974},
    { -6375,  4959},
    { -6264,  4915},
};

static MCoord ec84[] = {
    {  7019, -4959},
    {  6985, -4944},
    {  7016, -4936},
    {  7044, -4935},
    {  6919, -4906},
};

static MCoord ec85[] = {
    { 12032,  1347},
    { 12045,  1333},
    { 12067,  1312},
    { 12078,  1285},
};

static MCoord ec86[] = {
    { -8080,  7369},
    { -8083,  7347},
    { -8039,  7323},
    { -8007,  7297},
    { -7849,  7286},
    { -7653,  7283},
    { -7730,  7350},
    { -7926,  7365},
};

static MCoord ec87[] = {
    { -7378, -4336},
    { -7366, -4316},
    { -7357, -4293},
    { -7367, -4268},
};

static MCoord ec88[] = {
    { -6158, -8080},
    { -6057, -8059},
    { -6024, -8031},
    { -6019, -8002},
    { -6131, -7970},
    { -6247, -8023},
    { -6416, -8027},
    { -6639, -8018},
    { -6432, -8048},
    { -6304, -8069},
};

static MCoord ec89[] = {
    {-15324,  5783},
    {-15360,  5777},
    {-15376,  5752},
    {-15408,  5760},
    {-15284,  5740},
};

static MCoord ec90[] = {
    { 17874, -1700},
    { 17893, -1689},
    { 17916, -1674},
    { 17941, -1678},
};

static MCoord ec91[] = {
    { 13854,  -737},
    { 13837,  -741},
    { 13811,  -754},
    { 13793,  -776},
    { 13898,  -777},
};

static MCoord ec92[] = {
    {-15586,  2024},
    {-15584,  2002},
    {-15599,  1975},
    {-15591,  1946},
    {-15487,  1946},
    {-15568,  2020},
};

static MCoord ec93[] = {
    {   937,  4300},
    {   929,  4278},
    {   895,  4264},
    {   864,  4244},
    {   919,  4147},
    {   949,  4259},
};

static MCoord ec94[] = {
    {-13167,  5413},
    {-13201,  5401},
    {-13224,  5380},
    {-13237,  5368},
};

static MCoord ec95[] = {
    { 12433,  1144},
    { 12440,  1119},
    { 12451,  1095},
    { 12476,  1082},
};

static MCoord ec96[] = {
    { -6719,  1825},
    { -6711,  1799},
    { -6679,  1797},
    { -6648,  1797},
};

static MCoord ec97[] = {
    { 17807, -1825},
    { 17827, -1817},
    { 17854, -1811},
    { 17863, -1791},
    { 17776, -1741},
};

static MCoord ec98[] = {
    { -7469, -5002},
    { -7450, -4990},
    { -7450, -4965},
    { -7445, -4933},
};

static MCoord ec99[] = {
    { 14868,  4550},
    { 14842,  4535},
    { 14802,  4532},
    { 14780,  4521},
    { 14695,  4454},
    { 14802,  4506},
};

static MCoord ec100[] = {
    {-13492,  5833},
    {-13478,  5811},
    {-13470,  5780},
    {-13447,  5746},
};

static MCoord ec101[] = {
    { -5454,  7028},
    { -5460,  7001},
    { -5473,  6977},
    { -5455,  6958},
    { -5294,  6934},
    { -5195,  6971},
    { -5314,  7014},
};

static MCoord ec102[] = {
    {  9506,  8120},
    {  9346,  8101},
    {  9288,  8077},
    {  9233,  8045},
    {  9435,  8007},
    {  9586,  8020},
    {  9719,  8034},
    {  9634,  8111},
};

static MCoord ec103[] = {
    { 15853,  -763},
    { 15872,  -785},
    { 15894,  -802},
    { 15920,  -816},
};

static MCoord ec104[] = {
    { -7501,  6815},
    { -7532,  6825},
    { -7608,  6832},
    { -7675,  6820},
    { -7585,  6728},
    { -7508,  6800},
};

static MCoord ec105[] = {
    {-15870, -7978},
    {-15887, -7951},
    {-15968, -7927},
    {-16061, -7903},
    {-16281, -7878},
    {-16146, -7976},
    {-15993, -7985},
};

static MCoord ec106[] = {
    {-11873, -7385},
    {-11967, -7378},
    {-12069, -7375},
    {-12167, -7366},
    {-12280, -7364},
    {-12200, -7436},
    {-12098, -7428},
    {-11997, -7419},
};

static MCoord ec107[] = {
    {-13582,  5826},
    {-13619,  5815},
    {-13625,  5793},
    {-13611,  5768},
    {-13503,  5749},
};

static MCoord ec108[] = {
    { -9149,    -2},
    { -9133,   -28},
    { -9117,   -58},
    { -9141,   -78},
};

static MCoord ec109[] = {
    { 12604,  -318},
    { 12609,  -345},
    { 12629,  -364},
    { 12655,  -377},
};

static MCoord ec110[] = {
    { 17918,  7086},
    {-17994,  7096},
    {-17908,  7094},
    {-17819,  7103},
    {-17991,  7154},
    { 17935,  7136},
};

static MCoord ec111[] = {
    {  2303,  3890},
    {  2333,  3874},
    {  2359,  3852},
    {  2391,  3839},
};

static MCoord ec112[] = {
    { -7198,  4105},
    { -7238,  4103},
    { -7269,  4099},
    { -7309,  4095},
    { -7207,  4099},
};

static MCoord ec113[] = {
    {-16952,  6305},
    {-16900,  6321},
    {-16922,  6334},
    {-16976,  6344},
    {-17088,  6361},
    {-16982,  6308},
};

static MCoord ec114[] = {
    { -3601, -5486},
    { -3593, -5475},
    { -3607, -5448},
    { -3645, -5426},
    { -3781, -5399},
    { -3652, -5453},
};

static MCoord ec115[] = {
    { -5947, -5221},
    { -5913, -5209},
    { -5876, -5195},
    { -5829, -5182},
    { -5930, -5177},
};

static MCoord ec116[] = {
    { 12302,  -439},
    { 12287,  -457},
    { 12283,  -486},
    { 12278,  -514},
};

static MCoord ec117[] = {
    { -7165, -7958},
    { -7069, -7959},
    { -6978, -7933},
    { -6912, -7907},
    { -6748, -7855},
    { -6956, -7868},
    { -7067, -7888},
    { -7181, -7940},
};

static MCoord ec118[] = {
    {  1242,  5609},
    {  1202,  5587},
    {  1165,  5586},
    {  1112,  5572},
    {  1217,  5518},
};

static MCoord ec119[] = {
    { -6848, -5493},
    { -6885, -5496},
    { -6940, -5504},
    { -6976, -5518},
    { -6823, -5555},
};

static MCoord ec120[] = {
    { 14630,  7546},
    { 14635,  7518},
    { 14730,  7499},
    { 14819,  7482},
    { 14928,  7476},
    { 15034,  7488},
    { 14849,  7532},
    { 14741,  7539},
};

static MCoord ec121[] = {
    { 12670,  7252},
    { 12748,  7271},
    { 12829,  7287},
    { 12893,  7310},
    { 12759,  7349},
    { 12641,  7285},
};

static MCoord ec122[] = {
    { 11447,  -817},
    { 11463,  -836},
    { 11491,  -846},
    { 11516,  -873},
};

static MCoord ec123[] = {
    { 16066,  -833},
    { 16067,  -852},
    { 16072,  -879},
    { 16083,  -907},
};

static MCoord ec124[] = {
    {-12379, -7406},
    {-12411, -7379},
    {-12490, -7366},
    {-12555, -7341},
    {-12721, -7334},
    {-12620, -7377},
    {-12458, -7412},
};

static MCoord ec125[] = {
    { 15963,  -929},
    { 15963,  -951},
    { 15979,  -974},
    { 16007,  -981},
};

static MCoord ec126[] = {
    { 11291,  -689},
    { 11275,  -702},
    { 11288,  -717},
    { 11316,  -719},
};

static MCoord ec127[] = {
    { -6085, -5211},
    { -6053, -5215},
    { -6011, -5198},
    { -5974, -5182},
    { -6079, -5199},
};

static MCoord ec128[] = {
    { -9510,  7561},
    { -9582,  7543},
    { -9621,  7524},
    { -9625,  7497},
    { -9453,  7465},
    { -9348,  7503},
    { -9434,  7556},
};

static MCoord ec129[] = {
    { 13103, -1187},
    { 13124, -1173},
    { 13147, -1151},
    { 13136, -1125},
};

static MCoord ec130[] = {
    { -6107,  1082},
    { -6124,  1080},
    { -6151,  1069},
    { -6147,  1034},
};

static MCoord ec131[] = {
    {-13516,  5745},
    {-13544,  5744},
    {-13540,  5720},
    {-13526,  5692},
};

static MCoord ec132[] = {
    { 13547,  -163},
    { 13569,  -170},
    { 13596,  -179},
    { 13625,  -187},
};

static MCoord ec133[] = {
    { -7782,  2689},
    { -7752,  2682},
    { -7729,  2662},
    { -7720,  2641},
};

static MCoord ec134[] = {
    { -6919, -6758},
    { -6875, -6771},
    { -6814, -6749},
    { -6790, -6725},
    { -6901, -6741},
};

static MCoord ec135[] = {
    { 14088,  7376},
    { 14037,  7350},
    { 14012,  7341},
    { 14133,  7336},
    { 14331,  7328},
    { 14167,  7389},
};

static MCoord ec136[] = {
    {-13191,  5322},
    {-13233,  5314},
    {-13228,  5299},
    {-13204,  5277},
};

static MCoord ec137[] = {
    { -8243,  6295},
    { -8305,  6289},
    { -8350,  6279},
    { -8380,  6252},
    { -8256,  6240},
};

static MCoord ec138[] = {
    { -9825,  7872},
    { -9818,  7846},
    { -9745,  7816},
    { -9715,  7790},
    { -9510,  7806},
    { -9611,  7857},
    { -9726,  7876},
};

static MCoord ec139[] = {
    { 13751, -3605},
    { 13789, -3585},
    { 13767, -3570},
    { 13743, -3559},
};

static MCoord ec140[] = {
    {  2301,  7816},
    {  2136,  7815},
    {  2144,  7790},
    {  2118,  7754},
    {  2256,  7742},
    {  2366,  7746},
};

static MCoord ec141[] = {
    { 15645,  -664},
    { 15655,  -680},
    { 15677,  -700},
    { 15697,  -722},
};

static MCoord ec142[] = {
    {  9788,   104},
    {  9767,   123},
    {  9745,   147},
    {  9719,   143},
};

static MCoord ec143[] = {
    { 16129, -1025},
    { 16144, -1037},
    { 16161, -1059},
    { 16185, -1073},
};

static MCoord ec144[] = {
    {-16360,  5504},
    {-16401,  5499},
    {-16444,  5487},
    {-16480,  5463},
    {-16326,  5469},
};

static MCoord ec145[] = {
    { 12325,  1247},
    { 12323,  1210},
    { 12344,  1216},
    { 12369,  1201},
};

static MCoord ec146[] = {
    {-11003,  7811},
    {-11100,  7808},
    {-11229,  7799},
    {-11319,  7779},
    {-11180,  7736},
    {-11050,  7748},
};

static MCoord ec147[] = {
    { 16673, -1485},
    { 16657, -1476},
    { 16662, -1513},
    { 16666, -1543},
};

static MCoord ec148[] = {
    {  5335,  1252},
    {  5350,  1241},
    {  5377,  1232},
    {  5407,  1235},
};

static MCoord ec149[] = {
    {-13580,  6899},
    {-13520,  6893},
    {-13450,  6880},
    {-13451,  6888},
    {-13569,  6922},
};

static MCoord ec150[] = {
    {  1705,  5734},
    {  1692,  5718},
    {  1670,  5691},
    {  1647,  5666},
};

static MCoord ec151[] = {
    {  4825,  6896},
    {  4868,  6876},
    {  4945,  6883},
    {  5007,  6905},
    {  4876,  6946},
};

static MCoord ec152[] = {
    {-10455,  7358},
    {-10516,  7372},
    {-10620,  7372},
    {-10680,  7352},
    {-10546,  7296},
};

static MCoord ec153[] = {
    { 11627,  -825},
    { 11610,  -843},
    { 11597,  -874},
    { 11609,  -888},
};

static MCoord ec154[] = {
    { -7614, -7117},
    { -7531, -7109},
    { -7446, -7100},
    { -7373, -7083},
    { -7486, -7075},
    { -7649, -7102},
};

static MCoord ec155[] = {
    { -5167,  -106},
    { -5183,  -133},
    { -5159,  -131},
    { -5137,  -109},
};

static MCoord ec156[] = {
    {  9925,  -167},
    {  9916,  -144},
    {  9903,  -119},
    {  9887,   -96},
};

static MCoord ec157[] = {
    { -2581,  7105},
    { -2636,  7094},
    { -2718,  7083},
    { -2789,  7055},
    { -2636,  7054},
};

static MCoord ec158[] = {
    { 10766,  -258},
    { 10760,  -281},
    { 10762,  -310},
    { 10788,  -313},
};

static MCoord ec159[] = {
    {-16633,  5397},
    {-16661,  5393},
    {-16692,  5376},
    {-16709,  5356},
};

static MCoord ec160[] = {
    { 13081,     0},
    { 13067,    -4},
    { 13035,   -14},
    { 13048,   -31},
};

static MCoord ec161[] = {
    { 13450,  -547},
    { 13434,  -568},
    { 13433,  -595},
    { 13435,  -619},
};

static MCoord ec162[] = {
    {-16617,  6040},
    {-16655,  6033},
    {-16719,  6017},
    {-16694,  5997},
    {-16582,  5989},
};

static MCoord ec163[] = {
    { -7467, -5277},
    { -7445, -5296},
    { -7409, -5307},
    { -7365, -5320},
};

static MCoord ec164[] = {
    { -8167,  4590},
    { -8188,  4587},
    { -8237,  4591},
    { -8291,  4590},
    { -8190,  4560},
};

static MCoord ec165[] = {
    { 12438,  -168},
    { 12437,  -190},
    { 12462,  -197},
    { 12491,  -191},
};

static MCoord ec166[] = {
    { 13155,  -716},
    { 13138,  -737},
    { 13120,  -762},
    { 13112,  -783},
};

static MCoord ec167[] = {
    { -7219, -5376},
    { -7246, -5365},
    { -7283, -5354},
    { -7312, -5345},
};

static MCoord ec168[] = {
    { -7818,  2512},
    { -7820,  2489},
    { -7829,  2463},
    { -7810,  2439},
};

static MCoord ec169[] = {
    { 12716,  7243},
    { 12796,  7231},
    { 12870,  7212},
    { 12940,  7220},
    { 12820,  7257},
    { 12672,  7248},
};

static MCoord ec170[] = {
    {  4798,  8010},
    {  4878,  8021},
    {  4963,  8043},
    {  5120,  8062},
    {  5019,  8080},
    {  4905,  8057},
    {  4773,  8040},
};

static MCoord ec171[] = {
    {  5905,  6990},
    {  5953,  6980},
    {  6021,  6971},
    {  6037,  6994},
    {  5918,  7039},
};

static MCoord ec172[] = {
    { 13543,   -72},
    { 13568,   -85},
    { 13584,  -108},
    { 13621,  -114},
};

static MCoord ec173[] = {
    { -7668,  2545},
    { -7638,  2531},
    { -7618,  2508},
    { -7622,  2480},
};

static MCoord ec174[] = {
    {  1883,  5789},
    {  1848,  5779},
    {  1817,  5754},
    {  1825,  5709},
};

static MCoord ec175[] = {
    { 12587,  -787},
    { 12614,  -789},
    { 12644,  -790},
    { 12673,  -775},
};

static MCoord ec176[] = {
    { 15310, -2566},
    { 15320, -2538},
    { 15332, -2511},
    { 15329, -2483},
};

static MCoord ec177[] = {
    {   315,  3996},
    {   293,  3990},
    {   252,  3962},
    {   280,  3943},
};

static MCoord ec178[] = {
    { 12434,  1014},
    { 12410,  1006},
    { 12387,   986},
    { 12392,   965},
};

static MCoord ec179[] = {
    { -2328,  7284},
    { -2402,  7286},
    { -2432,  7264},
    { -2382,  7245},
    { -2252,  7222},
};

static MCoord ec180[] = {
    { -7440, -7291},
    { -7533, -7289},
    { -7584, -7314},
    { -7565, -7340},
    { -7442, -7339},
};

static MCoord ec181[] = {
    { -7876, -7311},
    { -7789, -7293},
    { -7751, -7270},
    { -7789, -7252},
    { -7901, -7246},
};

static MCoord ec182[] = {
    { -7978,  6239},
    { -8016,  6220},
    { -8026,  6191},
    { -7994,  6166},
};

static MCoord ec183[] = {
    { -9737,  2719},
    { -9739,  2703},
    { -9735,  2674},
    { -9721,  2630},
};

static MCoord ec184[] = {
    { 12265,  -462},
    { 12245,  -473},
    { 12237,  -496},
    { 12231,  -525},
};

static MCoord ec185[] = {
    { -2480,  7342},
    { -2548,  7324},
    { -2485,  7308},
    { -2346,  7311},
};

static MCoord ec186[] = {
    { 14609,  4446},
    { 14592,  4427},
    { 14557,  4386},
    { 14581,  4398},
};

static MCoord ec187[] = {
    { -7939,  5639},
    { -7957,  5626},
    { -7974,  5596},
    { -7928,  5601},
};

static MCoord ec188[] = {
    { 16358,  5857},
    { 16411,  5878},
    { 16461,  5894},
    { 16442,  5916},
    { 16343,  5857},
};

static MCoord ec189[] = {
    {-16788,  5353},
    {-16822,  5351},
    {-16848,  5328},
    {-16890,  5295},
    {-16791,  5338},
};

static MCoord ec190[] = {
    {  2285,  5860},
    {  2239,  5857},
    {  2196,  5840},
    {  2208,  5805},
    {  2314,  5845},
};

static MCoord ec191[] = {
    { 16770, -7766},
    { 16899, -7760},
    { 16895, -7740},
    { 16757, -7735},
    { 16656, -7763},
};

static MCoord ec192[] = {
    {-11077,  7873},
    {-11169,  7859},
    {-11301,  7840},
    {-11230,  7832},
    {-11099,  7832},
    {-10951,  7838},
};

static MCoord ec193[] = {
    { -7895,  2667},
    { -7877,  2654},
    { -7846,  2658},
    { -7803,  2667},
};

static MCoord ec194[] = {
    {  5628,  2696},
    {  5611,  2698},
    {  5579,  2688},
    {  5542,  2665},
};

static MCoord ec195[] = {
    {  9647,   240},
    {  9635,   253},
    {  9612,   270},
    {  9583,   286},
};

static MCoord ec196[] = {
    { -8126,  5321},
    { -8170,  5319},
    { -8191,  5300},
    { -8142,  5286},
};

static MCoord ec197[] = {
    { 12538,  -184},
    { 12557,  -192},
    { 12587,  -191},
    { 12621,  -185},
};

static MCoord ec198[] = {
    {  1507,  6827},
    {  1558,  6840},
    {  1616,  6850},
    {  1640,  6878},
    {  1519,  6843},
};

static MCoord ec199[] = {
    { 13410,  -618},
    { 13414,  -641},
    { 13408,  -664},
    { 13419,  -686},
};

static MCoord ec200[] = {
    { 13634, -1421},
    { 13649, -1422},
    { 13680, -1427},
    { 13683, -1415},
};

static MCoord ec201[] = {
    { 14962,  4563},
    { 15000,  4583},
    { 15029,  4603},
    { 15034,  4616},
    { 14948,  4562},
};

static MCoord ec202[] = {
    { 14741,  -200},
    { 14724,  -200},
    { 14696,  -195},
    { 14662,  -207},
};

static MCoord ec203[] = {
    { 16744, -1651},
    { 16762, -1653},
    { 16777, -1639},
    { 16752, -1616},
};

static MCoord ec204[] = {
    { 12824,  2683},
    { 12804,  2668},
    { 12787,  2654},
    { 12771,  2621},
};

static MCoord ec205[] = {
    { 15543,  5008},
    { 15583,  5024},
    { 15609,  5050},
    { 15595,  5066},
};

static MCoord ec206[] = {
    {  1048,  5554},
    {   983,  5547},
    {  1001,  5519},
    {  1033,  5506},
};

static MCoord ec207[] = {
    {-13130,  5595},
    {-13156,  5580},
    {-13170,  5555},
    {-13144,  5544},
};

static MCoord ec208[] = {
    {-13418,  5689},
    {-13427,  5672},
    {-13414,  5646},
    {-13413,  5618},
};

static MCoord ec209[] = {
    { 12347,  -125},
    { 12324,  -126},
    { 12297,  -118},
    { 12287,  -146},
};

static MCoord ec210[] = {
    { -6714, -5500},
    { -6755, -5492},
    { -6814, -5492},
    { -6811, -5512},
};

static MCoord ec211[] = {
    { 15744,  -798},
    { 15728,  -820},
    { 15752,  -832},
    { 15779,  -852},
};

static MCoord ec212[] = {
    { -1637,  2851},
    { -1667,  2838},
    { -1683,  2825},
    { -1659,  2804},
};

static MCoord ec213[] = {
    { 12744,  -141},
    { 12741,  -159},
    { 12764,  -171},
    { 12803,  -164},
};

static MCoord ec214[] = {
    {  -620,  5847},
    {  -651,  5838},
    {  -690,  5820},
    {  -695,  5788},
};

static MCoord ec215[] = {
    {-13323,  5697},
    {-13375,  5703},
    {-13375,  5683},
    {-13354,  5651},
};

static MCoord ec216[] = {
    { -1415,  2837},
    { -1433,  2814},
    { -1434,  2808},
    { -1401,  2822},
};

static MCoord ec217[] = {
    { 12445,  -816},
    { 12444,  -833},
    { 12473,  -840},
    { 12506,  -829},
};

static MCoord ec218[] = {
    { -2214,  7295},
    { -2296,  7304},
    { -2416,  7298},
    { -2378,  7289},
    { -2206,  7276},
};

static MCoord ec219[] = {
    { 12830,   201},
    { 12850,   209},
    { 12866,   233},
    { 12855,   257},
};

static MCoord ec220[] = {
    { -9347,  7775},
    { -9444,  7776},
    { -9578,  7773},
    { -9583,  7750},
    { -9438,  7746},
};

static MCoord ec221[] = {
    {  5560, -2089},
    {  5530, -2093},
    {  5531, -2119},
    {  5556, -2134},
};

static MCoord ec222[] = {
    { -5789, -6443},
    { -5745, -6436},
    { -5721, -6411},
    { -5773, -6392},
};

static MCoord ec223[] = {
    { -6423, -6470},
    { -6383, -6477},
    { -6309, -6461},
    { -6317, -6437},
};

static MCoord ec224[] = {
    { 13034,  -167},
    { 13018,  -172},
    { 12984,  -185},
    { 13002,  -201},
};

static MCoord ec225[] = {
    { -8307,  2182},
    { -8305,  2161},
    { -8297,  2146},
    { -8263,  2154},
};

static MCoord ec226[] = {
    {   886,   375},
    {   868,   369},
    {   850,   344},
    {   856,   324},
};

static MCoord ec227[] = {
    {-17422,  5239},
    {-17438,  5224},
    {-17498,  5206},
    {-17474,  5203},
};

static MCoord ec228[] = {
    { -7527,  2357},
    { -7512,  2328},
    { -7507,  2310},
    { -7489,  2300},
};

static MCoord ec229[] = {
    { 12752,   -30},
    { 12737,   -41},
    { 12746,   -71},
    { 12776,   -81},
};

static MCoord ec230[] = {
    { 13747,  5479},
    { 13784,  5472},
    { 13803,  5501},
    { 13767,  5514},
};

static MCoord ec231[] = {
    { -5634, -6342},
    { -5594, -6334},
    { -5531, -6334},
    { -5522, -6319},
    { -5640, -6328},
};

static MCoord ec232[] = {
    {-12899,  5329},
    {-12901,  5305},
    {-12904,  5285},
    {-12871,  5275},
};

static MCoord ec233[] = {
    { 10303,    83},
    { 10287,    95},
    { 10260,   106},
    { 10246,    94},
};

static MCoord ec234[] = {
    { -3763, -7863},
    { -3855, -7858},
    { -4092, -7855},
    { -3994, -7860},
    { -3853, -7864},
};

static MCoord ec235[] = {
    {  9067,  2278},
    {  9059,  2261},
    {  9070,  2219},
    {  9086,  2236},
};

static MCoord ec236[] = {
    { -2019, -7485},
    { -2016, -7469},
    { -2049, -7429},
    { -2122, -7445},
};

static MCoord ec237[] = {
    { -4999,    26},
    { -5028,    21},
    { -5026,     5},
    { -4994,    -1},
};

static MCoord ec238[] = {
    {-15218,  5838},
    {-15250,  5841},
    {-15292,  5827},
    {-15306,  5809},
};

static MCoord ec239[] = {
    { 16921,  6988},
    { 16835,  6999},
    { 16795,  6980},
    { 16865,  6961},
};

static MCoord ec240[] = {
    { -1900,  7675},
    { -1900,  7659},
    { -1873,  7612},
    { -1866,  7632},
};

static MCoord ec241[] = {
    { -7324, -4492},
    { -7302, -4483},
    { -7283, -4460},
    { -7301, -4443},
};

static MCoord ec242[] = {
    { 17179,   705},
    { 17116,   710},
    { 17148,   707},
    { 17169,   699},
};

static MCoord ec243[] = {
    {  5958,  8047},
    {  6097,  8047},
    {  6201,  8075},
    {  6041,  8083},
    {  5937,  8068},
};

static MCoord ec244[] = {
    { -7367,  2096},
    { -7343,  2094},
    { -7309,  2114},
    { -7330,  2118},
};

static MCoord ec245[] = {
    {-13024,  5388},
    {-13005,  5367},
    {-12964,  5340},
    {-12966,  5360},
};

static MCoord ec246[] = {
    { 13013, -1181},
    { 13048, -1175},
    { 13039, -1145},
    { 13022, -1142},
};

static MCoord ec247[] = {
    { 12683,  3354},
    { 12664,  3353},
    { 12628,  3334},
    { 12655,  3324},
};

static MCoord ec248[] = {
    {  7014,  7305},
    {  7127,  7320},
    {  7109,  7339},
    {  7027,  7344},
};

static MCoord ec249[] = {
    {-11781,  7609},
    {-11842,  7594},
    {-11896,  7561},
    {-11805,  7570},
};

static MCoord ec250[] = {
    {  5760, -2005},
    {  5738, -2028},
    {  5745, -2048},
    {  5773, -2037},
};

static MCoord ec251[] = {
    {  3920,  -607},
    {  3934,  -630},
    {  3950,  -627},
    {  3938,  -597},
};

static MCoord ec252[] = {
    { -4492,  8214},
    { -4472,  8240},
    { -4661,  8263},
    { -4698,  8242},
    { -4564,  8220},
};

static MCoord ec253[] = {
    { 16598,  5533},
    { 16596,  5520},
    { 16621,  5495},
    { 16652,  5485},
};

static MCoord ec254[] = {
    { -6875,  5162},
    { -6904,  5144},
    { -6886,  5121},
    { -6849,  5132},
};

static MCoord ec255[] = {
    { 12287, -1086},
    { 12313, -1081},
    { 12337, -1058},
    { 12323, -1055},
};

static MCoord ec256[] = {
    {-10593,  7772},
    {-10573,  7750},
    {-10502,  7720},
    {-10470,  7738},
};

static MCoord ec257[] = {
    { 11309,  7422},
    { 11311,  7446},
    { 11201,  7445},
    { 11175,  7425},
};

static MCoord ec258[] = {
    { -7517, -4867},
    { -7511, -4848},
    { -7537, -4812},
    { -7544, -4831},
};

static MCoord ec259[] = {
    {-15653,  2092},
    {-15639,  2065},
    {-15608,  2068},
    {-15613,  2087},
};

static MCoord ec260[] = {
    { -5891, -6220},
    { -5846, -6215},
    { -5783, -6200},
    { -5826, -6193},
};

static MCoord ec261[] = {
    { -7354,  6800},
    { -7408,  6807},
    { -7460,  6805},
    { -7440,  6781},
};

static MCoord ec262[] = {
    {  1934,  5427},
    {  1956,  5433},
    {  2010,  5461},
    {  1983,  5457},
};

static MCoord ec263[] = {
    {  2628,  3936},
    {  2595,  3926},
    {  2613,  3912},
    {  2647,  3903},
};

static MCoord ec264[] = {
    {-17247, -1379},
    {-17225, -1375},
    {-17229, -1351},
    {-17264, -1351},
};

static MCoord ec265[] = {
    { 16784, -4673},
    { 16767, -4713},
    { 16811, -4708},
    { 16808, -4688},
};

static MCoord ec266[] = {
    {  2814,  3642},
    {  2791,  3632},
    {  2775,  3604},
    {  2801,  3606},
};

static MCoord ec267[] = {
    {-11213,  2528},
    {-11216,  2513},
    {-11217,  2485},
    {-11216,  2471},
};

static MCoord ec268[] = {
    { 14822, -4023},
    { 14828, -4008},
    { 14805, -3980},
    { 14785, -3986},
};

static MCoord ec269[] = {
    { 15044,  -937},
    { 15050,  -957},
    { 15080,  -966},
    { 15087,  -953},
};

static MCoord ec270[] = {
    {  1730,  6911},
    {  1789,  6924},
    {  1776,  6951},
    {  1720,  6940},
};

static MCoord ec271[] = {
    { 11320, -2610},
    { 11314, -2593},
    { 11300, -2560},
    { 11294, -2570},
};

static MCoord ec272[] = {
    { 13089,   -88},
    { 13073,   -97},
    { 13077,  -122},
    { 13099,  -126},
};

static MCoord ec273[] = {
    {-14705,  6032},
    {-14727,  6023},
    {-14772,  5991},
    {-14745,  5993},
};

static MCoord ec274[] = {
    { -7057, -5361},
    { -7075, -5384},
    { -7072, -5412},
    { -7052, -5400},
};

static MCoord ec275[] = {
    {  4508,  8060},
    {  4625,  8052},
    {  4801,  8069},
    {  4739,  8081},
    {  4587,  8068},
};

static MCoord ec276[] = {
    {-11358,  2957},
    {-11354,  2940},
    {-11326,  2912},
    {-11324,  2927},
};

static MCoord ec277[] = {
    {-13048,  5361},
    {-13033,  5346},
    {-12994,  5322},
    {-12984,  5334},
};

static MCoord ec278[] = {
    { 12048,  -577},
    { 12045,  -592},
    { 12047,  -630},
    { 12053,  -620},
};

static MCoord ec279[] = {
    { 13915, -1674},
    { 13928, -1669},
    { 13960, -1650},
    { 13942, -1644},
};

static MCoord ec280[] = {
    { -9116, -7254},
    { -9149, -7272},
    { -9137, -7302},
    { -9103, -7302},
};

static MCoord ec281[] = {
    {-10079, -7268},
    {-10022, -7276},
    { -9922, -7275},
    { -9944, -7259},
};

static MCoord ec282[] = {
    { -8043,  2785},
    { -8038,  2771},
    { -8023,  2734},
    { -8026,  2744},
};

static MCoord ec283[] = {
    { 12120,  3178},
    { 12134,  3165},
    { 12171,  3150},
    { 12165,  3161},
};

static MCoord ec284[] = {
    { 14996,  -247},
    { 15009,  -257},
    { 15036,  -265},
    { 15038,  -246},
};

static MCoord ec285[] = {
    {-15796,  2170},
    {-15813,  2161},
    {-15816,  2141},
    {-15783,  2135},
};

static MCoord ec286[] = {
    { -7776,  2424},
    { -7786,  2406},
    { -7768,  2380},
    { -7754,  2390},
};

static MCoord ec287[] = {
    { 15080,  -980},
    { 15095, -1002},
    { 15122, -1009},
    { 15111,  -996},
};

static MCoord ec288[] = {
    { 15998, -1149},
    { 16011, -1161},
    { 16043, -1176},
    { 16041, -1167},
};

static MCoord ec289[] = {
    { 12341,  -826},
    { 12335,  -841},
    { 12347,  -855},
    { 12376,  -831},
};

static MCoord ec290[] = {
    { -7749,  6326},
    { -7768,  6339},
    { -7830,  6346},
    { -7829,  6326},
};

static MCoord ec291[] = {
    {  -625,  5765},
    {  -655,  5749},
    {  -608,  5721},
    {  -613,  5742},
};

static MCoord ec292[] = {
    { -9705,  2784},
    { -9717,  2769},
    { -9734,  2738},
    { -9728,  2745},
};

static MCoord ec293[] = {
    { 12415,  1401},
    { 12411,  1365},
    { 12436,  1366},
    { 12433,  1393},
};

static MCoord ec294[] = {
    { -1572,  2782},
    { -1543,  2783},
    { -1543,  2810},
    { -1572,  2807},
};

static MCoord ec295[] = {
    {  4326, -1142},
    {  4324, -1162},
    {  4335, -1185},
    {  4345, -1178},
};

static MCoord ec296[] = {
    {-17402,  5212},
    {-17375,  5205},
    {-17321,  5206},
    {-17333,  5211},
};

static MCoord ec297[] = {
    { -7571,  3519},
    { -7553,  3528},
    { -7547,  3557},
    { -7547,  3563},
};

static MCoord ec298[] = {
    {-12727,  5242},
    {-12751,  5232},
    {-12784,  5209},
    {-12766,  5208},
};

static MCoord ec299[] = {
    {-13315,  5523},
    {-13315,  5506},
    {-13285,  5477},
    {-13281,  5485},
};

static MCoord ec300[] = {
    {  9131,  7989},
    {  9258,  7972},
    {  9330,  7996},
    {  9156,  8005},
};

static MCoord ec301[] = {
    { 15320, -1135},
    { 15333, -1149},
    { 15361, -1160},
    { 15361, -1149},
};

static MCoord ec302[] = {
    { -8786,  4741},
    { -8808,  4747},
    { -8844,  4717},
    { -8813,  4724},
};

static MCoord ec303[] = {
    {  3972,  -544},
    {  3981,  -533},
    {  3985,  -504},
    {  3973,  -498},
};

static MCoord ec304[] = {
    { -2089,  7443},
    { -2177,  7433},
    { -2138,  7413},
    { -2041,  7421},
};

static MCoord ec305[] = {
    { 13851,  3831},
    { 13836,  3820},
    { 13827,  3793},
    { 13844,  3788},
};

static MCoord ec306[] = {
    { 10315,    90},
    { 10301,   105},
    { 10274,   112},
    { 10276,   101},
};

static MCoord ec307[] = {
    { -8653,  3040},
    { -8672,  3040},
    { -8711,  3035},
    { -8704,  3035},
};

static MCoord ec308[] = {
    { -8847,  4817},
    { -8869,  4811},
    { -8910,  4794},
    { -8897,  4790},
};

static MCoord ec309[] = {
    {  -260, -7100},
    {  -227, -7080},
    {  -318, -7068},
    {  -310, -7094},
};

static MCoord ec310[] = {
    {  2221,  7837},
    {  2151,  7858},
    {  2051,  7840},
    {  2118,  7822},
};

static MCoord ec311[] = {
    {-15944,  2222},
    {-15971,  2209},
    {-15953,  2191},
    {-15932,  2204},
};

static MCoord ec312[] = {
    { 10171,   205},
    { 10147,   203},
    { 10148,   178},
    { 10171,   181},
};

static MCoord ec313[] = {
    {-17173, -1404},
    {-17154, -1403},
    {-17157, -1390},
    {-17192, -1383},
};

static MCoord ec314[] = {
    { 13309,  -538},
    { 13292,  -580},
    { 13302,  -568},
    { 13316,  -543},
};

static MCoord ec315[] = {
    { -9113,  7753},
    { -9064,  7727},
    { -8975,  7733},
    { -9026,  7759},
};

static MCoord ec316[] = {
    { -7535, -7015},
    { -7470, -7005},
    { -7520, -6984},
    { -7574, -7000},
};

static MCoord ec317[] = {
    { 16730, -2082},
    { 16713, -2076},
    { 16713, -2101},
    { 16739, -2108},
};

static MCoord ec318[] = {
    {  5891,  2069},
    {  5882,  2057},
    {  5866,  2033},
    {  5876,  2030},
};

static MCoord ec319[] = {
    { -7868,  6929},
    { -7920,  6898},
    { -7875,  6897},
    { -7836,  6926},
};

static MCoord ec320[] = {
    {  1106,  5486},
    {  1125,  5468},
    {  1173,  5471},
    {  1149,  5487},
};

static MCoord ec321[] = {
    { -6140,  4764},
    { -6160,  4758},
    { -6192,  4734},
    { -6179,  4738},
};

static MCoord ec322[] = {
    {-11246,  2915},
    {-11250,  2893},
    {-11228,  2884},
    {-11227,  2917},
};

static MCoord ec323[] = {
    {  1638,  4319},
    {  1658,  4314},
    {  1700,  4312},
    {  1697,  4315},
};

static MCoord ec324[] = {
    { 12206,   673},
    { 12189,   663},
    { 12204,   643},
    { 12223,   662},
};

static MCoord ec325[] = {
    { 12297,  1312},
    { 12303,  1299},
    { 12327,  1279},
    { 12328,  1282},
};

static MCoord ec326[] = {
    {  7726,  7229},
    {  7811,  7241},
    {  7787,  7259},
    {  7714,  7244},
};

static MCoord ec327[] = {
    { -7453, -4862},
    { -7467, -4830},
    { -7485, -4843},
    { -7481, -4863},
};

static MCoord ec328[] = {
    { -7564,  2457},
    { -7544,  2421},
    { -7536,  2426},
    { -7556,  2451},
};

static MCoord ec329[] = {
    {-10303,  7630},
    {-10406,  7621},
    {-10390,  7605},
    {-10274,  7614},
};

static MCoord ec330[] = {
    {-10443,  7540},
    {-10477,  7519},
    {-10401,  7507},
    {-10382,  7532},
};

static MCoord ec331[] = {
    {  5516,  8095},
    {  5692,  8077},
    {  5691,  8091},
    {  5520,  8106},
};

static MCoord ec332[] = {
    { -6084, -6263},
    { -6018, -6266},
    { -6017, -6252},
    { -6088, -6253},
};

static MCoord ec333[] = {
    { -9806,  7409},
    { -9904,  7396},
    { -9883,  7384},
    { -9786,  7397},
};

static MCoord ec334[] = {
    { -7393,  2263},
    { -7413,  2230},
    { -7400,  2235},
    { -7385,  2261},
};

static MCoord ec335[] = {
    { -6117,  1473},
    { -6096,  1450},
    { -6088,  1466},
    { -6104,  1482},
};

static MCoord ec336[] = {
    {  -139,  6045},
    {  -142,  6021},
    {  -120,  6010},
    {  -112,  6041},
};

static MCoord ec337[] = {
    { -2573,  3779},
    { -2536,  3772},
    { -2527,  3783},
    { -2568,  3786},
};

static MCoord ec338[] = {
    {-10442,  7664},
    {-10445,  7645},
    {-10346,  7636},
    {-10373,  7657},
};

static MCoord ec339[] = {
    {-14953, -1774},
    {-14927, -1778},
    {-14930, -1764},
    {-14955, -1756},
};

static MCoord ec340[] = {
    { -8424,  6605},
    { -8369,  6572},
    { -8373,  6588},
};

static MCoord ec341[] = {
    { 10051, -6567},
    { 10089, -6565},
    { 10108, -6544},
    { 10040, -6553},
};

static MCoord ec342[] = {
    {  6305,  8074},
    {  6480,  8098},
    {  6324,  8094},
};

static MCoord ec343[] = {
    {-13239,  5635},
    {-13261,  5620},
    {-13227,  5600},
    {-13232,  5621},
};

static MCoord ec344[] = {
    {  1318,  5429},
    {  1354,  5430},
    {  1344,  5456},
    {  1322,  5447},
};

static MCoord ec345[] = {
    {  5790,  8012},
    {  5854,  8027},
    {  5782,  8046},
    {  5731,  8024},
};

static MCoord ec346[] = {
    { -7524, -5042},
    { -7494, -5022},
    { -7517, -5012},
    { -7533, -5031},
};

static MCoord ec347[] = {
    { 12958,  2844},
    { 12928,  2831},
    { 12935,  2820},
    { 12962,  2839},
};

static MCoord ec348[] = {
    { -7180, -5390},
    { -7211, -5395},
    { -7197, -5420},
    { -7178, -5407},
};

static MCoord ec349[] = {
    {  -573,  5648},
    {  -612,  5658},
    {  -618,  5638},
    {  -581,  5635},
};

static MCoord ec350[] = {
    {-17645, -4404},
    {-17638, -4381},
    {-17642, -4372},
    {-17666, -4383},
};

static MCoord ec351[] = {
    { -6437,  1101},
    { -6397,  1099},
    { -6418,  1105},
};

static MCoord ec352[] = {
    { -8671,  6821},
    { -8673,  6786},
    { -8639,  6802},
};

static MCoord ec353[] = {
    {  1614, -7014},
    {  1626, -6999},
    {  1562, -6991},
    {  1568, -7013},
};

static MCoord ec354[] = {
    { 12679,   452},
    { 12676,   417},
    { 12689,   433},
};

static MCoord ec355[] = {
    { 10230,   131},
    { 10229,   103},
    { 10245,   106},
};

static MCoord ec356[] = {
    { -6205, -6969},
    { -6205, -6932},
    { -6216, -6951},
};

static MCoord ec357[] = {
    { -8055,  6972},
    { -8026,  6958},
    { -7966,  6967},
    { -8004,  6977},
};

static MCoord ec358[] = {
    { 10249,   146},
    { 10218,   154},
    { 10241,   136},
};

static MCoord ec359[] = {
    {  2931,  6213},
    {  2907,  6207},
    {  2903,  6184},
    {  2939,  6196},
};

static MCoord ec360[] = {
    { 14396, -4010},
    { 14403, -3976},
    { 14387, -3996},
};

static MCoord ec361[] = {
    { 15253,  -900},
    { 15283,  -913},
    { 15272,  -897},
};

static MCoord ec362[] = {
    { 17266,  5289},
    { 17318,  5284},
    { 17290,  5299},
};

static MCoord ec363[] = {
    {  2215,  7047},
    {  2296,  7067},
    {  2235,  7063},
};

static MCoord ec364[] = {
    { 12097,   597},
    { 12129,   592},
    { 12121,   604},
};

static MCoord ec365[] = {
    {  9373,   717},
    {  9379,   687},
    {  9390,   705},
};

static MCoord ec366[] = {
    { 12213,  1266},
    { 12200,  1233},
    { 12212,  1253},
};

static MCoord ec367[] = {
    { -1345,  2920},
    { -1372,  2899},
    { -1351,  2901},
};

static MCoord ec368[] = {
    {-15724,  2115},
    {-15687,  2111},
    {-15700,  2119},
};

static MCoord ec369[] = {
    { 10462,   113},
    { 10436,   112},
    { 10452,    94},
};

static MCoord ec370[] = {
    { 12564,  1045},
    { 12560,  1010},
    { 12567,  1027},
};

static MCoord ec371[] = {
    { 13589,  7545},
    { 13590,  7573},
    { 13560,  7573},
    { 13551,  7548},
};

static MCoord ec372[] = {
    { -7487, -5105},
    { -7464, -5104},
    { -7449, -5085},
    { -7478, -5092},
};

static MCoord ec373[] = {
    { 16839, -1756},
    { 16826, -1773},
    { 16853, -1775},
};

static MCoord ec374[] = {
    { -6253, -6446},
    { -6220, -6416},
    { -6250, -6428},
};

static MCoord ec375[] = {
    { -6471,  6162},
    { -6521,  6163},
    { -6488,  6143},
};

static MCoord ec376[] = {
    { 16823, -1594},
    { 16819, -1561},
    { 16814, -1574},
};

static MCoord ec377[] = {
    {  2055,  3845},
    {  2044,  3831},
    {  2058,  3815},
    {  2064,  3832},
};

static MCoord ec378[] = {
    {  1432,  4517},
    {  1440,  4483},
    {  1441,  4502},
};

static MCoord ec379[] = {
    { -7043, -5489},
    { -7081, -5497},
    { -7062, -5511},
    { -7044, -5503},
};

static MCoord ec380[] = {
    { -8508,  6600},
    { -8486,  6569},
    { -8477,  6587},
};

static MCoord ec381[] = {
    {  1474,  4470},
    {  1505,  4444},
    {  1489,  4460},
};

static MCoord ec382[] = {
    { -9039,   -51},
    { -9044,   -70},
    { -9021,   -62},
};

static MCoord ec383[] = {
    { -1290,   757},
    { -1260,   750},
    { -1273,   763},
};

static MCoord ec384[] = {
    { 14320,  -842},
    { 14348,  -860},
    { 14335,  -848},
};

static MCoord ec385[] = {
    { 14778,  -554},
    { 14796,  -576},
    { 14797,  -556},
};

static MCoord ec386[] = {
    {  2598,  3856},
    {  2597,  3828},
    {  2614,  3840},
};

static MCoord ec387[] = {
    { -7329,  1892},
    { -7298,  1880},
    { -7314,  1894},
};

static MCoord ec388[] = {
    { -9982,  8014},
    { -9938,  7986},
    { -9905,  8007},
};

static MCoord ec389[] = {
    { 16920, -1873},
    { 16901, -1875},
    { 16923, -1893},
};

static MCoord ec390[] = {
    { 15209,  4706},
    { 15193,  4689},
    { 15226,  4714},
};

static MCoord ec391[] = {
    {  1973,  3979},
    {  1990,  3950},
    {  1990,  3969},
};

static MCoord ec392[] = {
    { -6163,  1602},
    { -6161,  1628},
    { -6177,  1619},
};

static MCoord ec393[] = {
    { -8701,  4529},
    { -8725,  4502},
    { -8705,  4515},
};

static MCoord ec394[] = {
    { 12592,  -197},
    { 12597,  -229},
    { 12598,  -210},
};

static MCoord ec395[] = {
    { -4942,     7},
    { -4967,    -2},
    { -4943,    -6},
};

static MCoord ec396[] = {
    { 14079,  7396},
    { 14071,  7421},
    { 14024,  7400},
};

static MCoord ec397[] = {
    {-11605, -7390},
    {-11689, -7406},
    {-11630, -7409},
};

static MCoord ec398[] = {
    { 12183,  1346},
    { 12200,  1328},
    { 12202,  1350},
};

static MCoord ec399[] = {
    { -5067,     0},
    { -5091,   -16},
    { -5069,   -13},
};

static MCoord ec400[] = {
    { -1845,  7534},
    { -1805,  7506},
    { -1799,  7525},
};

static MCoord ec401[] = {
    { -4024,  6447},
    { -4056,  6475},
    { -4054,  6461},
};

static MCoord ec402[] = {
    { 12019,   534},
    { 11996,   517},
    { 12016,   520},
};

static MCoord ec403[] = {
    { -7654,  6346},
    { -7709,  6360},
    { -7686,  6342},
};

static MCoord ec404[] = {
    { 13106,  3083},
    { 13094,  3054},
    { 13106,  3068},
};

static MCoord ec405[] = {
    { 12190,  -509},
    { 12192,  -535},
    { 12203,  -520},
};

static MCoord ec406[] = {
    { -6915,  1238},
    { -6893,  1215},
    { -6903,  1228},
};

static MCoord ec407[] = {
    { -7152, -5408},
    { -7124, -5426},
    { -7113, -5412},
};

static MCoord ec408[] = {
    {  5307,  7097},
    {  5282,  7127},
    {  5283,  7110},
};

static MCoord ec409[] = {
    {-17663,  5197},
    {-17680,  5173},
    {-17651,  5182},
};

static MCoord ec410[] = {
    { 11988,  1230},
    { 12012,  1210},
    { 12003,  1223},
};

static MCoord ec411[] = {
    {-15717,   173},
    {-15741,   190},
    {-15731,   175},
};

static MCoord ec412[] = {
    {   665,    40},
    {   654,    17},
    {   672,    27},
};

static MCoord ec413[] = {
    {  1497,  6859},
    {  1524,  6884},
    {  1479,  6874},
};

static MCoord ec414[] = {
    { -7418, -5083},
    { -7440, -5057},
    { -7438, -5077},
};

static MCoord ec415[] = {
    {   583,  5257},
    {   542,  5243},
    {   574,  5244},
};

static MCoord ec416[] = {
    { 13500,  3457},
    { 13479,  3432},
    { 13494,  3440},
};

static MCoord ec417[] = {
    { -6803,  6058},
    { -6825,  6035},
    { -6788,  6041},
};

static MCoord ec418[] = {
    {-12259,  4826},
    {-12253,  4809},
    {-12261,  4839},
};

static MCoord ec419[] = {
    { -7496, -5208},
    { -7484, -5179},
    { -7496, -5191},
};

static MCoord ec420[] = {
    { -7997,  -268},
    { -8020,  -288},
    { -8004,  -283},
};

static MCoord ec421[] = {
    { -1774,  2867},
    { -1790,  2875},
    { -1783,  2849},
};

static MCoord ec422[] = {
    {  4024,  1562},
    {  4009,  1581},
    {  3999,  1574},
};

static MCoord ec423[] = {
    { 13652, -1144},
    { 13669, -1118},
    { 13659, -1129},
};

static MCoord ec424[] = {
    { 16135,  -934},
    { 16146,  -962},
    { 16145,  -945},
};

static MCoord ec425[] = {
    { 15652,  -763},
    { 15667,  -783},
    { 15669,  -764},
};

static MCoord ec426[] = {
    {  4188,  1678},
    {  4202,  1670},
    {  4175,  1688},
};

static MCoord ec427[] = {
    { -6146,  1562},
    { -6136,  1537},
    { -6132,  1555},
};

static MCoord ec428[] = {
    {-17706,  5191},
    {-17743,  5176},
    {-17719,  5175},
};

static MCoord ec429[] = {
    { -7373, -4516},
    { -7407, -4505},
    { -7397, -4520},
};

static MCoord ec430[] = {
    { -5135,  8199},
    { -5254,  8221},
    { -5257,  8205},
};

static MCoord ec431[] = {
    {  9247,  1084},
    {  9238,  1062},
    {  9254,  1064},
};

static MCoord ec432[] = {
    { 16810, -1615},
    { 16803, -1630},
    { 16827, -1629},
};

static MCoord ec433[] = {
    {  7861,  7285},
    {  7910,  7275},
    {  7923,  7296},
};

static MCoord ec434[] = {
    { 10342, -6545},
    { 10308, -6520},
    { 10308, -6535},
};

static MCoord ec435[] = {
    { 14487,  1365},
    { 14472,  1341},
    { 14488,  1351},
};

static MCoord ec436[] = {
    {  5047,  2623},
    {  5052,  2596},
    {  5059,  2615},
};

static MCoord ec437[] = {
    { -5036,    61},
    { -5041,    32},
    { -5034,    46},
};

static MCoord ec438[] = {
    {  9465,  1624},
    {  9447,  1601},
    {  9462,  1609},
};

static MCoord ec439[] = {
    { 12402,  -846},
    { 12426,  -831},
    { 12411,  -831},
};

static MCoord ec440[] = {
    {-11477,  7798},
    {-11431,  7776},
    {-11399,  7794},
};

static MCoord ec441[] = {
    {  9830,   817},
    {  9831,   790},
    {  9840,   804},
};

static MCoord ec442[] = {
    { -2518,  1696},
    { -2510,  1714},
    { -2533,  1705},
};

static MCoord ec443[] = {
    { 17810, -1910},
    { 17835, -1902},
    { 17832, -1895},
};

static MCoord ec444[] = {
    { 16803, -2142},
    { 16787, -2151},
    { 16808, -2162},
};

static MCoord ec445[] = {
    { -6920, -5493},
    { -6970, -5493},
    { -6939, -5498},
};

static MCoord ec446[] = {
    { 12188,  1503},
    { 12192,  1477},
    { 12201,  1493},
};

static MCoord ec447[] = {
    { -2356,  1504},
    { -2375,  1520},
    { -2372,  1500},
};

static MCoord ec448[] = {
    { -7527,  6870},
    { -7506,  6844},
    { -7496,  6861},
};

static MCoord ec449[] = {
    { -9640,  2839},
    { -9666,  2822},
    { -9650,  2829},
};

static MCoord ec450[] = {
    { -8946,   -77},
    { -8947,   -90},
    { -8928,   -71},
};

static MCoord ec451[] = {
    {  -435,  5441},
    {  -462,  5419},
    {  -437,  5426},
};

static MCoord ec452[] = {
    { 10393,  1039},
    { 10398,  1015},
    { 10407,  1031},
};

static MCoord ec453[] = {
    {  1545,  6889},
    {  1587,  6913},
    {  1555,  6905},
};

static MCoord ec454[] = {
    { -4516, -6072},
    { -4565, -6056},
    { -4547, -6066},
};

static MCoord ec455[] = {
    { -7723,  6943},
    { -7717,  6920},
    { -7682,  6933},
};

static MCoord ec456[] = {
    {  1422,  6816},
    {  1479,  6833},
    {  1439,  6830},
};

static MCoord ec457[] = {
    {-14911, -7709},
    {-14996, -7692},
    {-14985, -7708},
};

static MCoord ec458[] = {
    { -8026,  2534},
    { -8045,  2511},
    { -8034,  2520},
};

static MCoord ec459[] = {
    {  -448,  5341},
    {  -447,  5322},
    {  -419,  5330},
};

static MCoord ec460[] = {
    { 16816, -1534},
    { 16815, -1506},
    { 16812, -1515},
};

static MCoord ec461[] = {
    { 13085,   -76},
    { 13058,   -84},
    { 13080,   -84},
};

static MCoord ec462[] = {
    {-17809,  5190},
    {-17801,  5171},
    {-17778,  5179},
};

static MCoord ec463[] = {
    { -3792,  6563},
    { -3749,  6567},
    { -3769,  6583},
};

static MCoord ec464[] = {
    {  1819,  6953},
    {  1874,  6972},
    {  1832,  6967},
};

static MCoord ec465[] = {
    {-17299,  6056},
    {-17254,  6037},
    {-17275,  6047},
};

static MCoord ec466[] = {
    {  1918,  6980},
    {  1945,  6998},
    {  1895,  6997},
};

static MCoord ec467[] = {
    { -7491, -4838},
    { -7499, -4815},
    { -7513, -4829},
};

static MCoord ec468[] = {
    {  3313,  -210},
    {  3296,  -194},
    {  3291,  -204},
};

static MCoord ec469[] = {
    { 13882,  -815},
    { 13864,  -825},
    { 13881,  -834},
};

static MCoord ec470[] = {
    { -7533,  3789},
    { -7517,  3814},
    { -7523,  3806},
};

static MCoord ec471[] = {
    {-13236,  5648},
    {-13216,  5624},
    {-13214,  5638},
};

static MCoord ec472[] = {
    {-13077, -7444},
    {-13156, -7434},
    {-13138, -7450},
};

static MCoord ec473[] = {
    { 15015,  -924},
    { 15023,  -945},
    { 15033,  -933},
};

static MCoord ec474[] = {
    { 12946,  3469},
    { 12933,  3444},
    { 12946,  3456},
};

static MCoord ec475[] = {
    { -7954,  5652},
    { -7987,  5632},
    { -7965,  5637},
};

static MCoord ec476[] = {
    {  1092,  5515},
    {  1072,  5490},
    {  1086,  5500},
};

static MCoord ec477[] = {
    { -7433, -4797},
    { -7398, -4793},
    { -7427, -4786},
};

static MCoord ec478[] = {
    {  1175,  5495},
    {  1185,  5472},
    {  1200,  5484},
};

static MCoord ec479[] = {
    { -9028,  7682},
    { -9015,  7658},
    { -8978,  7670},
};

static MCoord ec480[] = {
    {-12464,  4978},
    {-12433,  4960},
    {-12442,  4971},
};

static MCoord ec481[] = {
    {  9108,  2216},
    {  9113,  2241},
    {  9104,  2236},
};

static MCoord ec482[] = {
    {-13289,  5680},
    {-13289,  5660},
    {-13266,  5662},
};

static MCoord ec483[] = {
    { 15702,  -787},
    { 15703,  -807},
    { 15717,  -797},
};

static MCoord ec484[] = {
    { 15461,  -501},
    { 15461,  -526},
    { 15469,  -513},
};

static MCoord ec485[] = {
    { -6151,  1632},
    { -6131,  1624},
    { -6140,  1641},
};

static MCoord ec486[] = {
    { -6093,  1372},
    { -6091,  1395},
    { -6102,  1383},
};

static MCoord ec487[] = {
    { 15127, -2375},
    { 15116, -2352},
    { 15112, -2365},
};

static MCoord ec488[] = {
    {-12838,  5279},
    {-12839,  5253},
    {-12831,  5265},
};

static MCoord ec489[] = {
    { 16619, -5053},
    { 16603, -5076},
    { 16621, -5069},
};

static MCoord ec490[] = {
    { 16941, -1946},
    { 16925, -1944},
    { 16941, -1963},
};

static MCoord ec491[] = {
    {-14855, -7720},
    {-14774, -7730},
    {-14799, -7712},
};

static MCoord ec492[] = {
    {  4421, -1215},
    {  4443, -1225},
    {  4437, -1213},
};

static MCoord ec493[] = {
    { -6609, -6587},
    { -6577, -6565},
    { -6605, -6572},
};

static MCoord ec494[] = {
    {-10207,  7597},
    {-10298,  7585},
    {-10247,  7583},
};

static MCoord ec495[] = {
    {  2722,  3582},
    {  2714,  3556},
    {  2719,  3567},
};

static MCoord ec496[] = {
    { 12806,  -370},
    { 12828,  -363},
    { 12817,  -355},
};

static MCoord ec497[] = {
    {-12707, -7450},
    {-12759, -7432},
    {-12759, -7449},
};

static MCoord ec498[] = {
    {  2294,  6029},
    {  2258,  6012},
    {  2284,  6015},
};

static MCoord ec499[] = {
    { -7634,  3482},
    { -7642,  3473},
    { -7620,  3493},
};

static MCoord ec500[] = {
    { -5112,   -14},
    { -5129,   -32},
    { -5117,   -27},
};

static MCoord ec501[] = {
    { 16579, -1080},
    { 16603, -1076},
    { 16591, -1069},
};

static MCoord ec502[] = {
    { -7369, -5222},
    { -7393, -5200},
    { -7385, -5211},
};

static MCoord ec503[] = {
    {  4984, -1709},
    {  4996, -1685},
    {  4988, -1694},
};

static MCoord ec504[] = {
    {  2544,  4002},
    {  2517,  3993},
    {  2530,  3987},
};

static MCoord ec505[] = {
    { 12960,  -780},
    { 12966,  -797},
    { 12979,  -787},
};

static MCoord ec506[] = {
    {-12926,  5282},
    {-12908,  5259},
    {-12906,  5271},
};

static MCoord ec507[] = {
    {  1475,  5526},
    {  1491,  5506},
    {  1501,  5519},
};

static MCoord ec508[] = {
    { -7500, -5146},
    { -7468, -5132},
    { -7489, -5134},
};

static MCoord ec509[] = {
    {  9366,  1951},
    {  9383,  1934},
    {  9382,  1949},
};

static MCoord ec510[] = {
    { -7428, -4479},
    { -7402, -4471},
    { -7428, -4466},
};

static MCoord ec511[] = {
    {  2316,  7027},
    {  2348,  7048},
    {  2312,  7044},
};

static MCoord ec512[] = {
    { -7522, -4985},
    { -7538, -4966},
    { -7546, -4977},
};

static MCoord ec513[] = {
    {   154,  3913},
    {   133,  3898},
    {   154,  3899},
};

static MCoord ec514[] = {
    {  4814,  2998},
    {  4817,  2976},
    {  4828,  2987},
};

static MCoord ec515[] = {
    { -8662,  1628},
    { -8638,  1638},
    { -8649,  1637},
};

static MCoord ec516[] = {
    { -4124,  6326},
    { -4154,  6342},
    { -4167,  6336},
};

static MCoord ec517[] = {
    {  -629,  5588},
    {  -635,  5570},
    {  -608,  5576},
};

static MCoord ec518[] = {
    { -4380,  5996},
    { -4344,  6001},
    { -4381,  6009},
};

static MCoord ec519[] = {
    {  -718,  6230},
    {  -694,  6208},
    {  -695,  6218},
};

static MCoord ec520[] = {
    { -5037,   218},
    { -5045,   200},
    { -5030,   204},
};

static MCoord ec521[] = {
    { 17993, -1699},
    {-17990, -1682},
    { 17995, -1686},
};

static MCoord ec522[] = {
    {-15987,  5529},
    {-16008,  5507},
    {-15991,  5514},
};

static MCoord ec523[] = {
    { -7891,  7612},
    { -7943,  7593},
    { -7902,  7594},
};

static MCoord ec524[] = {
    {  7212, -7057},
    {  7201, -7037},
    {  7174, -7040},
};

static MCoord ec525[] = {
    {-10048,  6902},
    {-10055,  6882},
    {-10023,  6885},
};

static MCoord ec526[] = {
    { -5007,    65},
    { -5022,    49},
    { -5006,    51},
};

static MCoord ec527[] = {
    { -5110,  6992},
    { -5118,  6972},
    { -5083,  6980},
};

static MCoord ec528[] = {
    { -7315,  2238},
    { -7289,  2234},
    { -7300,  2242},
};

static MCoord ec529[] = {
    {  9835,  1234},
    {  9841,  1256},
    {  9832,  1250},
};

static MCoord ec530[] = {
    { -2430,  1657},
    { -2418,  1662},
    { -2442,  1666},
};

static MCoord ec531[] = {
    { -7505, -4609},
    { -7481, -4594},
    { -7497, -4594},
};

static MCoord ec532[] = {
    { 13463,   773},
    { 13455,   750},
    { 13464,   757},
};

static MCoord ec533[] = {
    {  1485,  4415},
    {  1508,  4397},
    {  1500,  4406},
};

static MCoord ec534[] = {
    { -9158,   -41},
    { -9146,   -32},
    { -9165,   -28},
};

static MCoord ec535[] = {
    {  1986,  6040},
    {  1982,  6021},
    {  2007,  6025},
};

static MCoord ec536[] = {
    {   422,  4004},
    {   400,  4004},
    {   419,  3991},
};

static MCoord ec537[] = {
    {   913,  6357},
    {   862,  6356},
    {   885,  6349},
};

static MCoord ec538[] = {
    {  2706,  3778},
    {  2678,  3776},
    {  2692,  3769},
};

static MCoord ec539[] = {
    { -5533, -6124},
    { -5494, -6116},
    { -5525, -6111},
};

static MCoord ec540[] = {
    { -7531, -5078},
    { -7526, -5056},
    { -7541, -5066},
};

static MCoord ec541[] = {
    {-13578,  5732},
    {-13577,  5712},
    {-13558,  5719},
};

static MCoord ec542[] = {
    {  1667,  4296},
    {  1700,  4292},
    {  1692,  4297},
};

static MCoord ec543[] = {
    { 10399,   138},
    { 10377,   139},
    { 10387,   130},
};

static MCoord ec544[] = {
    { -9078,   -28},
    { -9062,   -24},
    { -9078,   -14},
};

static MCoord ec545[] = {
    { -8673,  2058},
    { -8693,  2043},
    { -8682,  2044},
};

static MCoord ec546[] = {
    {  2735,  3687},
    {  2706,  3680},
    {  2719,  3680},
};

static MCoord ec547[] = {
    { 12566,   343},
    { 12553,   362},
    { 12554,   349},
};

static MCoord ec548[] = {
    {  1106,  3380},
    {  1084,  3385},
    {  1090,  3371},
};

static MCoord ec549[] = {
    { 13259, -1131},
    { 13258, -1109},
    { 13252, -1116},
};

static MCoord ec550[] = {
    { -7522, -4904},
    { -7543, -4887},
    { -7544, -4898},
};

static MCoord ec551[] = {
    { 13104,  -807},
    { 13088,  -823},
    { 13104,  -818},
};

static MCoord ec552[] = {
    { -7815,  6975},
    { -7853,  6959},
    { -7814,  6961},
};

static MCoord ec553[] = {
    {  -268,  5896},
    {  -308,  5903},
    {  -299,  5893},
};

static MCoord ec554[] = {
    { 11989,  1195},
    { 11995,  1177},
    { 12003,  1184},
};

static MCoord ec555[] = {
    { -7528, -5162},
    { -7511, -5141},
    { -7524, -5146},
};

static MCoord ec556[] = {
    {  2065,  3788},
    {  2082,  3771},
    {  2083,  3782},
};

static MCoord ec557[] = {
    { -7869,  5644},
    { -7884,  5625},
    { -7868,  5625},
};

static MCoord ec558[] = {
    { -8180,   757},
    { -8172,   738},
    { -8168,   749},
};

static MCoord ec559[] = {
    { 15109,  -842},
    { 15108,  -865},
    { 15112,  -856},
};

static MCoord ec560[] = {
    { -7443, -4576},
    { -7428, -4559},
    { -7446, -4561},
};

static MCoord ec561[] = {
    {  7323, -5298},
    {  7355, -5311},
    {  7345, -5300},
};

static MCoord ec562[] = {
    {  1643,  4334},
    {  1671,  4328},
    {  1666,  4337},
};

static MCoord ec563[] = {
    { -9033, -7306},
    { -8973, -7299},
    { -9007, -7292},
};

static MCoord ec564[] = {
    {-16069,  5881},
    {-16101,  5868},
    {-16083,  5866},
};

static MCoord ec565[] = {
    { 12778,  -811},
    { 12798,  -820},
    { 12793,  -812},
};

static MCoord ec566[] = {
    { -7058,  6277},
    { -7093,  6285},
    { -7069,  6269},
};

static MCoord ec567[] = {
    { 15342, -2772},
    { 15349, -2750},
    { 15340, -2756},
};

static MCoord ec568[] = {
    {  2473,  3797},
    {  2484,  3780},
    {  2492,  3787},
};

static MCoord ec569[] = {
    {-12802,  5205},
    {-12815,  5187},
    {-12798,  5190},
};

static MCoord ec570[] = {
    { -7401, -5234},
    { -7420, -5215},
    { -7420, -5223},
};

static MCoord ec571[] = {
    { 12172, -1057},
    { 12191, -1055},
    { 12185, -1046},
};

static MCoord ec572[] = {
    { -6428, -5472},
    { -6453, -5477},
    { -6416, -5478},
};

static MCoord ec573[] = {
    {-12689,  4984},
    {-12684,  4969},
    {-12665,  4976},
};

static MCoord ec574[] = {
    {-13328,  5614},
    {-13360,  5605},
    {-13343,  5601},
};

static MCoord ec575[] = {
    {  1455,  4522},
    {  1457,  4504},
    {  1470,  4508},
};

static MCoord ec576[] = {
    {  3972,  -797},
    {  3984,  -779},
    {  3972,  -785},
};

static MCoord ec577[] = {
    {-12882,  5371},
    {-12909,  5356},
    {-12894,  5358},
};

static MCoord ec578[] = {
    {  9601,  7712},
    {  9593,  7702},
    {  9653,  7720},
};

static MCoord ec579[] = {
    { -6052,  1134},
    { -6071,  1124},
    { -6060,  1124},
};

static MCoord ec580[] = {
    { -7524, -4803},
    { -7492, -4796},
    { -7505, -4795},
};

static MCoord ec581[] = {
    { -5082,   -56},
    { -5099,   -67},
    { -5087,   -69},
};

static MCoord ec582[] = {
    {-13037,  5409},
    {-13060,  5397},
    {-13044,  5392},
};

static MCoord ec583[] = {
    { 11945,  -842},
    { 11941,  -861},
    { 11950,  -856},
};

static MCoord ec584[] = {
    {-11201,  2453},
    {-11181,  2442},
    {-11184,  2450},
};

static MCoord ec585[] = {
    {-14612,  6041},
    {-14653,  6039},
    {-14634,  6033},
};

static MCoord ec586[] = {
    { 16771, -1547},
    { 16790, -1539},
    { 16777, -1536},
};

static MCoord ec587[] = {
    { -8469,  2975},
    { -8492,  2965},
    { -8484,  2967},
};

static MCoord ec588[] = {
    {-10027,  7673},
    {-10114,  7666},
    {-10077,  7664},
};

static MCoord ec589[] = {
    {  -529,  5571},
    {  -530,  5553},
    {  -512,  5559},
};

static MCoord ec590[] = {
    {-16071,  5540},
    {-16082,  5527},
    {-16060,  5525},
};

static MCoord ec591[] = {
    { -7602,  2367},
    { -7584,  2353},
    { -7589,  2361},
};

static MCoord ec592[] = {
    { -7794,  2210},
    { -7775,  2199},
    { -7778,  2208},
};

static MCoord ec593[] = {
    { -7364, -4575},
    { -7362, -4556},
    { -7375, -4561},
};

static MCoord ec594[] = {
    { 15343, -2734},
    { 15343, -2713},
    { 15338, -2719},
};

static MCoord ec595[] = {
    { -7558, -4868},
    { -7537, -4855},
    { -7554, -4855},
};

static MCoord ec596[] = {
    {  -106,  5069},
    {  -134,  5072},
    {  -128,  5062},
};

static MCoord ec597[] = {
    {  2636,  3768},
    {  2612,  3760},
    {  2622,  3759},
};

static MCoord ec598[] = {
    { -6146,  5693},
    { -6156,  5673},
    { -6143,  5678},
};

static MCoord ec599[] = {
    { -7486, -5213},
    { -7470, -5194},
    { -7482, -5199},
};

static MCoord ec600[] = {
    { 14957,  -135},
    { 14964,  -152},
    { 14969,  -143},
};

static MCoord ec601[] = {
    { -5947,  1308},
    { -5952,  1324},
    { -5960,  1315},
};

static MCoord ec602[] = {
    { 12723,   -25},
    { 12712,   -36},
    { 12724,   -40},
};

static MCoord ec603[] = {
    { -5635,  4710},
    { -5635,  4691},
    { -5628,  4693},
};

static MCoord ec604[] = {
    { 15735,  -840},
    { 15729,  -859},
    { 15737,  -855},
};

static MCoord ec605[] = {
    {-12800,  5172},
    {-12805,  5154},
    {-12791,  5157},
};

static MCoord ec606[] = {
    {  4509, -1281},
    {  4517, -1285},
    {  4510, -1267},
};

static MCoord ec607[] = {
    { -6838,  1230},
    { -6830,  1215},
    { -6824,  1220},
};

static MCoord ec608[] = {
    {  2069,  3885},
    {  2059,  3871},
    {  2068,  3867},
};

static MCoord ec609[] = {
    { 14332,  -837},
    { 14348,  -845},
    { 14349,  -837},
};

static MCoord ec610[] = {
    {  9600,  7627},
    {  9570,  7619},
    {  9645,  7620},
};

static MCoord ec611[] = {
    { 13618, -1167},
    { 13636, -1157},
    { 13629, -1158},
};

static MCoord ec612[] = {
    { -6773, -6777},
    { -6734, -6773},
    { -6757, -6764},
};

static MCoord ec613[] = {
    {-11988,  3405},
    {-11966,  3399},
    {-11968,  3405},
};

static MCoord ec614[] = {
    {-11517,  2816},
    {-11527,  2825},
    {-11530,  2809},
};

static MCoord ec615[] = {
    {   829,  5474},
    {   843,  5491},
    {   831,  5489},
};

static MCoord ec616[] = {
    { 13332,  -410},
    { 13348,  -423},
    { 13344,  -417},
};

static MCoord ec617[] = {
    { -5746, -6452},
    { -5705, -6446},
    { -5725, -6442},
};

static MCoord ec618[] = {
    { -7434,  2283},
    { -7417,  2271},
    { -7418,  2278},
};

static MCoord ec619[] = {
    {-12368,  4910},
    {-12348,  4894},
    {-12352,  4898},
};

static MCoord ec620[] = {
    {-12528,  5043},
    {-12524,  5027},
    {-12512,  5030},
};

static MCoord ec621[] = {
    {  1350,  6804},
    {  1381,  6814},
    {  1362,  6820},
};

static MCoord ec622[] = {
    {  9818,  1145},
    {  9827,  1162},
    {  9821,  1158},
};

static MCoord ec623[] = {
    {  8179,  7538},
    {  8209,  7533},
    {  8215,  7550},
};

static MCoord ec624[] = {
    { -7551, -4926},
    { -7537, -4912},
    { -7552, -4913},
};

static MCoord ec625[] = {
    { 15255, -1062},
    { 15273, -1067},
    { 15270, -1063},
};

static MCoord ec626[] = {
    { -7668,  3470},
    { -7692,  3468},
    { -7686,  3469},
};

static MCoord ec627[] = {
    { -9480,  2935},
    { -9496,  2922},
    { -9486,  2925},
};

static MCoord ec628[] = {
    { -6487,  1772},
    { -6469,  1771},
    { -6471,  1777},
};

static MCoord ec629[] = {
    {  3221,   -48},
    {  3221,   -30},
    {  3217,   -38},
};

static MCoord ec630[] = {
    {-14576,  6060},
    {-14609,  6054},
    {-14602,  6050},
};

static MCoord ec631[] = {
    { -7430, -4501},
    { -7408, -4498},
    { -7416, -4492},
};

static MCoord ec632[] = {
    {-12528,  5028},
    {-12525,  5011},
    {-12518,  5015},
};

static MCoord ec633[] = {
    { -9153,  1879},
    { -9171,  1871},
    { -9163,  1871},
};

static MCoord ec634[] = {
    {  5209,  1223},
    {  5226,  1217},
    {  5223,  1221},
};

static MCoord ec635[] = {
    { -7962,  2280},
    { -7946,  2270},
    { -7949,  2274},
};

static MCoord ec636[] = {
    { -9685,  2812},
    { -9696,  2798},
    { -9691,  2799},
};

static MCoord ec637[] = {
    {  1310,  6809},
    {  1291,  6794},
    {  1303,  6795},
};

static MCoord ec638[] = {
    { -7830,  2240},
    { -7816,  2233},
    { -7814,  2239},
};

static MCoord ec639[] = {
    {  9829,  1073},
    {  9824,  1087},
    {  9819,  1083},
};

static MCoord ec640[] = {
    {  9734,   206},
    {  9725,   219},
    {  9724,   213},
};

static MCoord ec641[] = {
    { -8798,  1790},
    { -8789,  1803},
    { -8793,  1803},
};
MRegion ereg[] = {
    {(char *)0, ec0, 999},
    {(char *)0, ec1, 657},
    {(char *)0, ec2, 418},
    {(char *)0, ec3, 116},
    {(char *)0, ec4, 202},
    {(char *)0, ec5, 98},
    {(char *)0, ec6, 51},
    {(char *)0, ec7, 33},
    {(char *)0, ec8, 94},
    {(char *)0, ec9, 33},
    {(char *)0, ec10, 33},
    {(char *)0, ec11, 31},
    {(char *)0, ec12, 30},
    {(char *)0, ec13, 33},
    {(char *)0, ec14, 43},
    {(char *)0, ec15, 22},
    {(char *)0, ec16, 21},
    {(char *)0, ec17, 20},
    {(char *)0, ec18, 18},
    {(char *)0, ec19, 20},
    {(char *)0, ec20, 20},
    {(char *)0, ec21, 18},
    {(char *)0, ec22, 16},
    {(char *)0, ec23, 23},
    {(char *)0, ec24, 14},
    {(char *)0, ec25, 16},
    {(char *)0, ec26, 26},
    {(char *)0, ec27, 14},
    {(char *)0, ec28, 20},
    {(char *)0, ec29, 15},
    {(char *)0, ec30, 27},
    {(char *)0, ec31, 25},
    {(char *)0, ec32, 26},
    {(char *)0, ec33, 11},
    {(char *)0, ec34, 18},
    {(char *)0, ec35, 14},
    {(char *)0, ec36, 11},
    {(char *)0, ec37, 9},
    {(char *)0, ec38, 12},
    {(char *)0, ec39, 22},
    {(char *)0, ec40, 9},
    {(char *)0, ec41, 12},
    {(char *)0, ec42, 9},
    {(char *)0, ec43, 17},
    {(char *)0, ec44, 14},
    {(char *)0, ec45, 13},
    {(char *)0, ec46, 8},
    {(char *)0, ec47, 9},
    {(char *)0, ec48, 14},
    {(char *)0, ec49, 9},
    {(char *)0, ec50, 8},
    {(char *)0, ec51, 8},
    {(char *)0, ec52, 7},
    {(char *)0, ec53, 9},
    {(char *)0, ec54, 8},
    {(char *)0, ec55, 7},
    {(char *)0, ec56, 8},
    {(char *)0, ec57, 11},
    {(char *)0, ec58, 11},
    {(char *)0, ec59, 7},
    {(char *)0, ec60, 8},
    {(char *)0, ec61, 12},
    {(char *)0, ec62, 6},
    {(char *)0, ec63, 6},
    {(char *)0, ec64, 12},
    {(char *)0, ec65, 7},
    {(char *)0, ec66, 6},
    {(char *)0, ec67, 11},
    {(char *)0, ec68, 9},
    {(char *)0, ec69, 6},
    {(char *)0, ec70, 7},
    {(char *)0, ec71, 6},
    {(char *)0, ec72, 6},
    {(char *)0, ec73, 6},
    {(char *)0, ec74, 11},
    {(char *)0, ec75, 7},
    {(char *)0, ec76, 6},
    {(char *)0, ec77, 9},
    {(char *)0, ec78, 6},
    {(char *)0, ec79, 4},
    {(char *)0, ec80, 6},
    {(char *)0, ec81, 7},
    {(char *)0, ec82, 6},
    {(char *)0, ec83, 5},
    {(char *)0, ec84, 5},
    {(char *)0, ec85, 4},
    {(char *)0, ec86, 8},
    {(char *)0, ec87, 4},
    {(char *)0, ec88, 10},
    {(char *)0, ec89, 5},
    {(char *)0, ec90, 4},
    {(char *)0, ec91, 5},
    {(char *)0, ec92, 6},
    {(char *)0, ec93, 6},
    {(char *)0, ec94, 4},
    {(char *)0, ec95, 4},
    {(char *)0, ec96, 4},
    {(char *)0, ec97, 5},
    {(char *)0, ec98, 4},
    {(char *)0, ec99, 6},
    {(char *)0, ec100, 4},
    {(char *)0, ec101, 7},
    {(char *)0, ec102, 8},
    {(char *)0, ec103, 4},
    {(char *)0, ec104, 6},
    {(char *)0, ec105, 7},
    {(char *)0, ec106, 8},
    {(char *)0, ec107, 5},
    {(char *)0, ec108, 4},
    {(char *)0, ec109, 4},
    {(char *)0, ec110, 6},
    {(char *)0, ec111, 4},
    {(char *)0, ec112, 5},
    {(char *)0, ec113, 6},
    {(char *)0, ec114, 6},
    {(char *)0, ec115, 5},
    {(char *)0, ec116, 4},
    {(char *)0, ec117, 8},
    {(char *)0, ec118, 5},
    {(char *)0, ec119, 5},
    {(char *)0, ec120, 8},
    {(char *)0, ec121, 6},
    {(char *)0, ec122, 4},
    {(char *)0, ec123, 4},
    {(char *)0, ec124, 7},
    {(char *)0, ec125, 4},
    {(char *)0, ec126, 4},
    {(char *)0, ec127, 5},
    {(char *)0, ec128, 7},
    {(char *)0, ec129, 4},
    {(char *)0, ec130, 4},
    {(char *)0, ec131, 4},
    {(char *)0, ec132, 4},
    {(char *)0, ec133, 4},
    {(char *)0, ec134, 5},
    {(char *)0, ec135, 6},
    {(char *)0, ec136, 4},
    {(char *)0, ec137, 5},
    {(char *)0, ec138, 7},
    {(char *)0, ec139, 4},
    {(char *)0, ec140, 6},
    {(char *)0, ec141, 4},
    {(char *)0, ec142, 4},
    {(char *)0, ec143, 4},
    {(char *)0, ec144, 5},
    {(char *)0, ec145, 4},
    {(char *)0, ec146, 6},
    {(char *)0, ec147, 4},
    {(char *)0, ec148, 4},
    {(char *)0, ec149, 5},
    {(char *)0, ec150, 4},
    {(char *)0, ec151, 5},
    {(char *)0, ec152, 5},
    {(char *)0, ec153, 4},
    {(char *)0, ec154, 6},
    {(char *)0, ec155, 4},
    {(char *)0, ec156, 4},
    {(char *)0, ec157, 5},
    {(char *)0, ec158, 4},
    {(char *)0, ec159, 4},
    {(char *)0, ec160, 4},
    {(char *)0, ec161, 4},
    {(char *)0, ec162, 5},
    {(char *)0, ec163, 4},
    {(char *)0, ec164, 5},
    {(char *)0, ec165, 4},
    {(char *)0, ec166, 4},
    {(char *)0, ec167, 4},
    {(char *)0, ec168, 4},
    {(char *)0, ec169, 6},
    {(char *)0, ec170, 7},
    {(char *)0, ec171, 5},
    {(char *)0, ec172, 4},
    {(char *)0, ec173, 4},
    {(char *)0, ec174, 4},
    {(char *)0, ec175, 4},
    {(char *)0, ec176, 4},
    {(char *)0, ec177, 4},
    {(char *)0, ec178, 4},
    {(char *)0, ec179, 5},
    {(char *)0, ec180, 5},
    {(char *)0, ec181, 5},
    {(char *)0, ec182, 4},
    {(char *)0, ec183, 4},
    {(char *)0, ec184, 4},
    {(char *)0, ec185, 4},
    {(char *)0, ec186, 4},
    {(char *)0, ec187, 4},
    {(char *)0, ec188, 5},
    {(char *)0, ec189, 5},
    {(char *)0, ec190, 5},
    {(char *)0, ec191, 5},
    {(char *)0, ec192, 6},
    {(char *)0, ec193, 4},
    {(char *)0, ec194, 4},
    {(char *)0, ec195, 4},
    {(char *)0, ec196, 4},
    {(char *)0, ec197, 4},
    {(char *)0, ec198, 5},
    {(char *)0, ec199, 4},
    {(char *)0, ec200, 4},
    {(char *)0, ec201, 5},
    {(char *)0, ec202, 4},
    {(char *)0, ec203, 4},
    {(char *)0, ec204, 4},
    {(char *)0, ec205, 4},
    {(char *)0, ec206, 4},
    {(char *)0, ec207, 4},
    {(char *)0, ec208, 4},
    {(char *)0, ec209, 4},
    {(char *)0, ec210, 4},
    {(char *)0, ec211, 4},
    {(char *)0, ec212, 4},
    {(char *)0, ec213, 4},
    {(char *)0, ec214, 4},
    {(char *)0, ec215, 4},
    {(char *)0, ec216, 4},
    {(char *)0, ec217, 4},
    {(char *)0, ec218, 5},
    {(char *)0, ec219, 4},
    {(char *)0, ec220, 5},
    {(char *)0, ec221, 4},
    {(char *)0, ec222, 4},
    {(char *)0, ec223, 4},
    {(char *)0, ec224, 4},
    {(char *)0, ec225, 4},
    {(char *)0, ec226, 4},
    {(char *)0, ec227, 4},
    {(char *)0, ec228, 4},
    {(char *)0, ec229, 4},
    {(char *)0, ec230, 4},
    {(char *)0, ec231, 5},
    {(char *)0, ec232, 4},
    {(char *)0, ec233, 4},
    {(char *)0, ec234, 5},
    {(char *)0, ec235, 4},
    {(char *)0, ec236, 4},
    {(char *)0, ec237, 4},
    {(char *)0, ec238, 4},
    {(char *)0, ec239, 4},
    {(char *)0, ec240, 4},
    {(char *)0, ec241, 4},
    {(char *)0, ec242, 4},
    {(char *)0, ec243, 5},
    {(char *)0, ec244, 4},
    {(char *)0, ec245, 4},
    {(char *)0, ec246, 4},
    {(char *)0, ec247, 4},
    {(char *)0, ec248, 4},
    {(char *)0, ec249, 4},
    {(char *)0, ec250, 4},
    {(char *)0, ec251, 4},
    {(char *)0, ec252, 5},
    {(char *)0, ec253, 4},
    {(char *)0, ec254, 4},
    {(char *)0, ec255, 4},
    {(char *)0, ec256, 4},
    {(char *)0, ec257, 4},
    {(char *)0, ec258, 4},
    {(char *)0, ec259, 4},
    {(char *)0, ec260, 4},
    {(char *)0, ec261, 4},
    {(char *)0, ec262, 4},
    {(char *)0, ec263, 4},
    {(char *)0, ec264, 4},
    {(char *)0, ec265, 4},
    {(char *)0, ec266, 4},
    {(char *)0, ec267, 4},
    {(char *)0, ec268, 4},
    {(char *)0, ec269, 4},
    {(char *)0, ec270, 4},
    {(char *)0, ec271, 4},
    {(char *)0, ec272, 4},
    {(char *)0, ec273, 4},
    {(char *)0, ec274, 4},
    {(char *)0, ec275, 5},
    {(char *)0, ec276, 4},
    {(char *)0, ec277, 4},
    {(char *)0, ec278, 4},
    {(char *)0, ec279, 4},
    {(char *)0, ec280, 4},
    {(char *)0, ec281, 4},
    {(char *)0, ec282, 4},
    {(char *)0, ec283, 4},
    {(char *)0, ec284, 4},
    {(char *)0, ec285, 4},
    {(char *)0, ec286, 4},
    {(char *)0, ec287, 4},
    {(char *)0, ec288, 4},
    {(char *)0, ec289, 4},
    {(char *)0, ec290, 4},
    {(char *)0, ec291, 4},
    {(char *)0, ec292, 4},
    {(char *)0, ec293, 4},
    {(char *)0, ec294, 4},
    {(char *)0, ec295, 4},
    {(char *)0, ec296, 4},
    {(char *)0, ec297, 4},
    {(char *)0, ec298, 4},
    {(char *)0, ec299, 4},
    {(char *)0, ec300, 4},
    {(char *)0, ec301, 4},
    {(char *)0, ec302, 4},
    {(char *)0, ec303, 4},
    {(char *)0, ec304, 4},
    {(char *)0, ec305, 4},
    {(char *)0, ec306, 4},
    {(char *)0, ec307, 4},
    {(char *)0, ec308, 4},
    {(char *)0, ec309, 4},
    {(char *)0, ec310, 4},
    {(char *)0, ec311, 4},
    {(char *)0, ec312, 4},
    {(char *)0, ec313, 4},
    {(char *)0, ec314, 4},
    {(char *)0, ec315, 4},
    {(char *)0, ec316, 4},
    {(char *)0, ec317, 4},
    {(char *)0, ec318, 4},
    {(char *)0, ec319, 4},
    {(char *)0, ec320, 4},
    {(char *)0, ec321, 4},
    {(char *)0, ec322, 4},
    {(char *)0, ec323, 4},
    {(char *)0, ec324, 4},
    {(char *)0, ec325, 4},
    {(char *)0, ec326, 4},
    {(char *)0, ec327, 4},
    {(char *)0, ec328, 4},
    {(char *)0, ec329, 4},
    {(char *)0, ec330, 4},
    {(char *)0, ec331, 4},
    {(char *)0, ec332, 4},
    {(char *)0, ec333, 4},
    {(char *)0, ec334, 4},
    {(char *)0, ec335, 4},
    {(char *)0, ec336, 4},
    {(char *)0, ec337, 4},
    {(char *)0, ec338, 4},
    {(char *)0, ec339, 4},
    {(char *)0, ec340, 3},
    {(char *)0, ec341, 4},
    {(char *)0, ec342, 3},
    {(char *)0, ec343, 4},
    {(char *)0, ec344, 4},
    {(char *)0, ec345, 4},
    {(char *)0, ec346, 4},
    {(char *)0, ec347, 4},
    {(char *)0, ec348, 4},
    {(char *)0, ec349, 4},
    {(char *)0, ec350, 4},
    {(char *)0, ec351, 3},
    {(char *)0, ec352, 3},
    {(char *)0, ec353, 4},
    {(char *)0, ec354, 3},
    {(char *)0, ec355, 3},
    {(char *)0, ec356, 3},
    {(char *)0, ec357, 4},
    {(char *)0, ec358, 3},
    {(char *)0, ec359, 4},
    {(char *)0, ec360, 3},
    {(char *)0, ec361, 3},
    {(char *)0, ec362, 3},
    {(char *)0, ec363, 3},
    {(char *)0, ec364, 3},
    {(char *)0, ec365, 3},
    {(char *)0, ec366, 3},
    {(char *)0, ec367, 3},
    {(char *)0, ec368, 3},
    {(char *)0, ec369, 3},
    {(char *)0, ec370, 3},
    {(char *)0, ec371, 4},
    {(char *)0, ec372, 4},
    {(char *)0, ec373, 3},
    {(char *)0, ec374, 3},
    {(char *)0, ec375, 3},
    {(char *)0, ec376, 3},
    {(char *)0, ec377, 4},
    {(char *)0, ec378, 3},
    {(char *)0, ec379, 4},
    {(char *)0, ec380, 3},
    {(char *)0, ec381, 3},
    {(char *)0, ec382, 3},
    {(char *)0, ec383, 3},
    {(char *)0, ec384, 3},
    {(char *)0, ec385, 3},
    {(char *)0, ec386, 3},
    {(char *)0, ec387, 3},
    {(char *)0, ec388, 3},
    {(char *)0, ec389, 3},
    {(char *)0, ec390, 3},
    {(char *)0, ec391, 3},
    {(char *)0, ec392, 3},
    {(char *)0, ec393, 3},
    {(char *)0, ec394, 3},
    {(char *)0, ec395, 3},
    {(char *)0, ec396, 3},
    {(char *)0, ec397, 3},
    {(char *)0, ec398, 3},
    {(char *)0, ec399, 3},
    {(char *)0, ec400, 3},
    {(char *)0, ec401, 3},
    {(char *)0, ec402, 3},
    {(char *)0, ec403, 3},
    {(char *)0, ec404, 3},
    {(char *)0, ec405, 3},
    {(char *)0, ec406, 3},
    {(char *)0, ec407, 3},
    {(char *)0, ec408, 3},
    {(char *)0, ec409, 3},
    {(char *)0, ec410, 3},
    {(char *)0, ec411, 3},
    {(char *)0, ec412, 3},
    {(char *)0, ec413, 3},
    {(char *)0, ec414, 3},
    {(char *)0, ec415, 3},
    {(char *)0, ec416, 3},
    {(char *)0, ec417, 3},
    {(char *)0, ec418, 3},
    {(char *)0, ec419, 3},
    {(char *)0, ec420, 3},
    {(char *)0, ec421, 3},
    {(char *)0, ec422, 3},
    {(char *)0, ec423, 3},
    {(char *)0, ec424, 3},
    {(char *)0, ec425, 3},
    {(char *)0, ec426, 3},
    {(char *)0, ec427, 3},
    {(char *)0, ec428, 3},
    {(char *)0, ec429, 3},
    {(char *)0, ec430, 3},
    {(char *)0, ec431, 3},
    {(char *)0, ec432, 3},
    {(char *)0, ec433, 3},
    {(char *)0, ec434, 3},
    {(char *)0, ec435, 3},
    {(char *)0, ec436, 3},
    {(char *)0, ec437, 3},
    {(char *)0, ec438, 3},
    {(char *)0, ec439, 3},
    {(char *)0, ec440, 3},
    {(char *)0, ec441, 3},
    {(char *)0, ec442, 3},
    {(char *)0, ec443, 3},
    {(char *)0, ec444, 3},
    {(char *)0, ec445, 3},
    {(char *)0, ec446, 3},
    {(char *)0, ec447, 3},
    {(char *)0, ec448, 3},
    {(char *)0, ec449, 3},
    {(char *)0, ec450, 3},
    {(char *)0, ec451, 3},
    {(char *)0, ec452, 3},
    {(char *)0, ec453, 3},
    {(char *)0, ec454, 3},
    {(char *)0, ec455, 3},
    {(char *)0, ec456, 3},
    {(char *)0, ec457, 3},
    {(char *)0, ec458, 3},
    {(char *)0, ec459, 3},
    {(char *)0, ec460, 3},
    {(char *)0, ec461, 3},
    {(char *)0, ec462, 3},
    {(char *)0, ec463, 3},
    {(char *)0, ec464, 3},
    {(char *)0, ec465, 3},
    {(char *)0, ec466, 3},
    {(char *)0, ec467, 3},
    {(char *)0, ec468, 3},
    {(char *)0, ec469, 3},
    {(char *)0, ec470, 3},
    {(char *)0, ec471, 3},
    {(char *)0, ec472, 3},
    {(char *)0, ec473, 3},
    {(char *)0, ec474, 3},
    {(char *)0, ec475, 3},
    {(char *)0, ec476, 3},
    {(char *)0, ec477, 3},
    {(char *)0, ec478, 3},
    {(char *)0, ec479, 3},
    {(char *)0, ec480, 3},
    {(char *)0, ec481, 3},
    {(char *)0, ec482, 3},
    {(char *)0, ec483, 3},
    {(char *)0, ec484, 3},
    {(char *)0, ec485, 3},
    {(char *)0, ec486, 3},
    {(char *)0, ec487, 3},
    {(char *)0, ec488, 3},
    {(char *)0, ec489, 3},
    {(char *)0, ec490, 3},
    {(char *)0, ec491, 3},
    {(char *)0, ec492, 3},
    {(char *)0, ec493, 3},
    {(char *)0, ec494, 3},
    {(char *)0, ec495, 3},
    {(char *)0, ec496, 3},
    {(char *)0, ec497, 3},
    {(char *)0, ec498, 3},
    {(char *)0, ec499, 3},
    {(char *)0, ec500, 3},
    {(char *)0, ec501, 3},
    {(char *)0, ec502, 3},
    {(char *)0, ec503, 3},
    {(char *)0, ec504, 3},
    {(char *)0, ec505, 3},
    {(char *)0, ec506, 3},
    {(char *)0, ec507, 3},
    {(char *)0, ec508, 3},
    {(char *)0, ec509, 3},
    {(char *)0, ec510, 3},
    {(char *)0, ec511, 3},
    {(char *)0, ec512, 3},
    {(char *)0, ec513, 3},
    {(char *)0, ec514, 3},
    {(char *)0, ec515, 3},
    {(char *)0, ec516, 3},
    {(char *)0, ec517, 3},
    {(char *)0, ec518, 3},
    {(char *)0, ec519, 3},
    {(char *)0, ec520, 3},
    {(char *)0, ec521, 3},
    {(char *)0, ec522, 3},
    {(char *)0, ec523, 3},
    {(char *)0, ec524, 3},
    {(char *)0, ec525, 3},
    {(char *)0, ec526, 3},
    {(char *)0, ec527, 3},
    {(char *)0, ec528, 3},
    {(char *)0, ec529, 3},
    {(char *)0, ec530, 3},
    {(char *)0, ec531, 3},
    {(char *)0, ec532, 3},
    {(char *)0, ec533, 3},
    {(char *)0, ec534, 3},
    {(char *)0, ec535, 3},
    {(char *)0, ec536, 3},
    {(char *)0, ec537, 3},
    {(char *)0, ec538, 3},
    {(char *)0, ec539, 3},
    {(char *)0, ec540, 3},
    {(char *)0, ec541, 3},
    {(char *)0, ec542, 3},
    {(char *)0, ec543, 3},
    {(char *)0, ec544, 3},
    {(char *)0, ec545, 3},
    {(char *)0, ec546, 3},
    {(char *)0, ec547, 3},
    {(char *)0, ec548, 3},
    {(char *)0, ec549, 3},
    {(char *)0, ec550, 3},
    {(char *)0, ec551, 3},
    {(char *)0, ec552, 3},
    {(char *)0, ec553, 3},
    {(char *)0, ec554, 3},
    {(char *)0, ec555, 3},
    {(char *)0, ec556, 3},
    {(char *)0, ec557, 3},
    {(char *)0, ec558, 3},
    {(char *)0, ec559, 3},
    {(char *)0, ec560, 3},
    {(char *)0, ec561, 3},
    {(char *)0, ec562, 3},
    {(char *)0, ec563, 3},
    {(char *)0, ec564, 3},
    {(char *)0, ec565, 3},
    {(char *)0, ec566, 3},
    {(char *)0, ec567, 3},
    {(char *)0, ec568, 3},
    {(char *)0, ec569, 3},
    {(char *)0, ec570, 3},
    {(char *)0, ec571, 3},
    {(char *)0, ec572, 3},
    {(char *)0, ec573, 3},
    {(char *)0, ec574, 3},
    {(char *)0, ec575, 3},
    {(char *)0, ec576, 3},
    {(char *)0, ec577, 3},
    {(char *)0, ec578, 3},
    {(char *)0, ec579, 3},
    {(char *)0, ec580, 3},
    {(char *)0, ec581, 3},
    {(char *)0, ec582, 3},
    {(char *)0, ec583, 3},
    {(char *)0, ec584, 3},
    {(char *)0, ec585, 3},
    {(char *)0, ec586, 3},
    {(char *)0, ec587, 3},
    {(char *)0, ec588, 3},
    {(char *)0, ec589, 3},
    {(char *)0, ec590, 3},
    {(char *)0, ec591, 3},
    {(char *)0, ec592, 3},
    {(char *)0, ec593, 3},
    {(char *)0, ec594, 3},
    {(char *)0, ec595, 3},
    {(char *)0, ec596, 3},
    {(char *)0, ec597, 3},
    {(char *)0, ec598, 3},
    {(char *)0, ec599, 3},
    {(char *)0, ec600, 3},
    {(char *)0, ec601, 3},
    {(char *)0, ec602, 3},
    {(char *)0, ec603, 3},
    {(char *)0, ec604, 3},
    {(char *)0, ec605, 3},
    {(char *)0, ec606, 3},
    {(char *)0, ec607, 3},
    {(char *)0, ec608, 3},
    {(char *)0, ec609, 3},
    {(char *)0, ec610, 3},
    {(char *)0, ec611, 3},
    {(char *)0, ec612, 3},
    {(char *)0, ec613, 3},
    {(char *)0, ec614, 3},
    {(char *)0, ec615, 3},
    {(char *)0, ec616, 3},
    {(char *)0, ec617, 3},
    {(char *)0, ec618, 3},
    {(char *)0, ec619, 3},
    {(char *)0, ec620, 3},
    {(char *)0, ec621, 3},
    {(char *)0, ec622, 3},
    {(char *)0, ec623, 3},
    {(char *)0, ec624, 3},
    {(char *)0, ec625, 3},
    {(char *)0, ec626, 3},
    {(char *)0, ec627, 3},
    {(char *)0, ec628, 3},
    {(char *)0, ec629, 3},
    {(char *)0, ec630, 3},
    {(char *)0, ec631, 3},
    {(char *)0, ec632, 3},
    {(char *)0, ec633, 3},
    {(char *)0, ec634, 3},
    {(char *)0, ec635, 3},
    {(char *)0, ec636, 3},
    {(char *)0, ec637, 3},
    {(char *)0, ec638, 3},
    {(char *)0, ec639, 3},
    {(char *)0, ec640, 3},
    {(char *)0, ec641, 3},
};

int nereg = (sizeof(ereg)/sizeof(ereg[0]));
