#include <stdio.h>
#include "forms.h"

#include "Xsqldefs.h"
#include "version.h"
#include "msql2_now.xpm"

/* Global variables */

int      sock;
int countflag;

/* some simple callbacks */

void XsqlInfo(FL_OBJECT *ob, long parent)
{
   fl_show_message(
	"Xsqlmenu: a powerful MiniSQL frontend build using the Xforms library",
	"by Kees Lemmens, The Netherlands (C) 1996," VERSION,
	"MiniSql: by Hughes Technologies; Xforms: by T. Zhao and M. Overmars");
}

void XsqlExit(FL_OBJECT *ob, long parent)
{
#ifndef FORMS081
   if(! fl_show_question("Do you want to quit ?",1))
     return;
#else
   if(! fl_show_question("Do you want to quit ?","",""))
     return;
#endif
     
   msqlClose(sock);
   exit(0);
}

void XsqlSetNewServer(FL_OBJECT *ob, long parent)
{
   SetNewServer((char *)fl_get_input(ob),(FD_Xsql *)parent);
}

void XsqlSetNewDatabase(FL_OBJECT *ob, long parent)
{
   SetNewDatabase((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

void XsqlSetNewTable(FL_OBJECT *ob, long parent)
{
   SetNewTable((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

/* end simple callbacks */

void Usage(char *naam)
{
   fprintf(stderr,"\nUsage  : %s [options] [<database> [<table>]]\n",naam);
   fprintf(stderr,  "Options: -h <host> : set remote database server\n");
   fprintf(stderr,  "         -c        : disable record count display\n");
   exit(1);
}

void Initialize(int argc,char *argv[],FD_Xsql *fd_Xsql)
{
   char *basename;
   int sf=0,x;
      
   basename=argv[0];
   
   fd_Xsql->vdata = NULL; /* Set hook for Info Structs to empty */

   x=argc;
   while(--x>0)                    /* parse options */
   {
      if(*argv[1]=='-')
      {
	 switch(*(++argv[1]))
	 {
	  case 'c':  countflag = NOCOUNT; break;
	  case 'h':
	    SetNewServer(argv[2],fd_Xsql); sf=1;
	    ++argv; --argc; --x;     break;
	  default:  Usage(basename); break;
	 }
	 ++argv; --argc;
      }
   }
   
   if(argc > 3)
     Usage(basename);

   if(sf == 0)
     SetNewServer(NULL,fd_Xsql);
   
   fl_set_pixmap_data(fd_Xsql->Logo,msql2logo);
#ifndef FORMS081
   fl_set_browser_hscrollbar(fd_Xsql->XsqlMessages,FL_ON);
   fl_set_browser_vscrollbar(fd_Xsql->XsqlMessages,FL_ON);
#endif
   fl_set_goodies_font(FL_NORMAL_TEXT,12); /* font for warnings ed. */

   if(argc >= 2)
     SetNewDatabase(argv[1],fd_Xsql);
   if(argc == 3)
     SetNewTable(argv[2],fd_Xsql);
}

int main(int argc, char *argv[])
{
   FD_Xsql *fd_Xsql;

   fl_initialize(&argc, argv, 0, 0, 0);
   
   fd_Xsql = create_form_Xsql();

   /* fill-in form initialization code */
   Initialize(argc,argv,fd_Xsql); /* set socket, database and tablename */

   /* show the first form */
   fl_show_form(fd_Xsql->Xsql,FL_PLACE_CENTER,FL_FULLBORDER,"Xsql");

   while(1)
     fl_do_forms();

   msqlClose(sock);

   return 0;
}
