/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/SelectioB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/ScrollBar.h>
#include <Xm/Label.h>
#include <Xm/DrawnB.h>
#include "xdir.h"
#include "llnl.h"
#include "cachemsg.h"
#include "pulldown.h"

extern Widget w_toplev;
extern Display *display;
extern Window root_window;
extern int depth;
extern struct dirwin_st *dirwin_head;

void cb_send_quoted_command();
void cb_general_preferences();
void cb_save_prefs();
void cb_quit();
void cb_about_xdir();
void cb_resize_dirwin();
void cb_dirwin_close();
void cb_change_layout();
void cb_goto_home();
void cb_refresh_dir();
void cb_select_all();
void cb_deselect_all();
void cb_use_wildcard();
void cb_make_dir();
void cb_delete();
void cb_rename_selected_entries();
void cb_goto_dir();
void cb_goto_parent();
void HandleMouseEvents();
void HandleExposeEvents();
void HandleKeyboardEvents();
void cb_scroll_vertical();
void cb_scroll_horizontal();
void cb_connect_to_remote();
void cb_connect_to_anonymous();
void cb_connect_to_local();
void cb_popup_diagnostics();
void cb_change_xfer_mode();
void cb_disconnect();
void cb_viewer_preferences();
void cb_firewall_preferences();
void cb_launcher_preferences();
void cb_xdir_overview();
void cb_getting_started();
void cb_using_help();
void cb_hidden_features();
void cb_contextual_help();
void cb_availability();
void cb_help_ur_button();
void cb_help_file_menu();
void cb_help_connect_menu();
void cb_help_select_menu();
void cb_help_ops_menu();
void cb_help_goto_menu();
void cb_help_wins_menu();
void cb_help_close_button();
void cb_help_delete_button();
void cb_help_mkdir_button();
void cb_help_home_button();
void cb_help_parent_button();
void cb_help_refresh_button();
void cb_help_dot_files_button();
void cb_help_tunneling_button();
void cb_help_full_info_button();
void cb_help_tree_button();
void cb_help_iconic_button();
void cb_help_tabular_button();
void cb_help_xfer_mode_menu();
void cb_help_display_area();
void cb_view_selected_files();
void cb_iconify_all();
void cb_deiconify_all();
void cb_change_tunneling_mode();
void cb_help_prefs_menu();
void cb_search();
void cb_search_again();
void cb_change_dotfiles_mode();
void cb_change_cache_mode();
void cb_help_cache_button();
void cb_edit_history();
Widget BuildPulldownMenu();
Widget create_button();

static Widget w_searchAgainItem;
static Widget w_deleteItem;
static Widget w_renameItem;
static Widget w_viewItem;
static Widget w_launchMenu;
static Widget w_viewedFilesMenu;
static Widget w_quotedItem;
static Widget w_ancestorsMenu;

static MenuItem file_menu[10] = {
	{ "About LLNL XDIR", &xmPushButtonGadgetClass,
	  'A', NULL, NULL, cb_about_xdir, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Iconify All", &xmPushButtonGadgetClass,
	  'I', NULL, NULL, cb_iconify_all, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Deiconify All", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_deiconify_all, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Close", &xmPushButtonGadgetClass,
	  'C', "Ctrl<Key>C", "Ctrl-C", cb_dirwin_close, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Edit History...", &xmPushButtonGadgetClass,
	  'E', NULL, NULL, cb_edit_history, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Quit", &xmPushButtonGadgetClass,
	  'Q', "Ctrl<Key>Q", "Ctrl-Q", cb_quit, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};


static MenuItem connect_menu[6] = {
	{ "Connect to Local", &xmPushButtonGadgetClass,
	  'L', NULL, NULL, cb_connect_to_local, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Connect to Remote...", &xmPushButtonGadgetClass,
	  'R', NULL, NULL, cb_connect_to_remote, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Connect to Anonymous...", &xmPushButtonGadgetClass,
	  'A', NULL, NULL, cb_connect_to_anonymous, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Disconnect", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_disconnect, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};

static MenuItem prefs_menu[7] = {
	{ "General Preferences", &xmPushButtonGadgetClass,
	  'G', NULL, NULL, cb_general_preferences, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Launcher Preferences", &xmPushButtonGadgetClass,
	  'L', NULL, NULL, cb_launcher_preferences, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Viewer Preferences", &xmPushButtonGadgetClass,
	  'V', NULL, NULL, cb_viewer_preferences, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Firewall Preferences", &xmPushButtonGadgetClass,
	  'F', NULL, NULL, cb_firewall_preferences, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Save Preferences", &xmPushButtonGadgetClass,
	  'S', NULL, NULL, cb_save_prefs, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};

static MenuItem select_menu[4] = {
	{ "Select All Entries", &xmPushButtonGadgetClass,
	  'S', "Ctrl<Key>A", "Ctrl-A", cb_select_all, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Deselect All Entries", &xmPushButtonGadgetClass,
	  'D', "Ctrl<Key>B", "Ctrl-B", cb_deselect_all, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Use Wildcard...", &xmPushButtonGadgetClass,
	  'U', NULL, NULL, cb_use_wildcard, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};

static MenuItem launch_menu[1] = {
	{ NULL }
};

static MenuItem ops_menu[13] = {
	{ "Search...", &xmPushButtonGadgetClass,
	  'S', "Ctrl<Key>F", "Ctrl-F", cb_search, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Search Again", &xmPushButtonGadgetClass,
	  'A', "Ctrl<Key>G", "Ctrl-G", cb_search_again, (MenuItem *)NULL,
	  &w_searchAgainItem },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Delete Selected Entries", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_delete, (MenuItem *)NULL,
	  &w_deleteItem },
	{ "Rename Selected Entries...", &xmPushButtonGadgetClass,
	  'R', NULL, NULL, cb_rename_selected_entries, (MenuItem *)NULL,
	  &w_renameItem },
	{ "View Selected Files", &xmPushButtonGadgetClass,
	  'V', NULL, NULL, cb_view_selected_files, (MenuItem *)NULL,
	  &w_viewItem },
	{ "Send Quoted Command...", &xmPushButtonGadgetClass,
	  'Q', NULL, NULL, cb_send_quoted_command, (MenuItem *)NULL,
	  &w_quotedItem },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Refresh Directory", &xmPushButtonGadgetClass,
	  'R', NULL, NULL, cb_refresh_dir, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Make Directory...", &xmPushButtonGadgetClass,
	  'M', NULL, NULL, cb_make_dir, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Launch", &xmCascadeButtonGadgetClass,
	  'L', NULL, NULL, NULL, launch_menu,
	  &w_launchMenu },
	{ NULL }
};

static MenuItem ancestors_menu[1] = {
	{ NULL }
};

static MenuItem goto_menu[6] = {
	{ "Ancestor", &xmCascadeButtonGadgetClass,
	  'A', NULL, NULL, NULL, ancestors_menu,
	  &w_ancestorsMenu },
	{ "Directory...", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_goto_dir, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Home Directory", &xmPushButtonGadgetClass,
	  'H', NULL, NULL, cb_goto_home, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Parent Directory", &xmPushButtonGadgetClass,
	  'P', NULL, NULL, cb_goto_parent, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};

static MenuItem viewed_files_menu[1] = {
	{ NULL }
};

static MenuItem wins_menu[5] = {
	{ "Diagnostics", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_popup_diagnostics, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Viewed Files", &xmCascadeButtonGadgetClass,
	  'V', NULL, NULL, NULL, viewed_files_menu,
	  &w_viewedFilesMenu },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};

static MenuItem help_menu[9] = {
	{ "LLNL XDIR Overview", &xmPushButtonGadgetClass,
	  'L', NULL, NULL, cb_xdir_overview, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Using Help", &xmPushButtonGadgetClass,
	  'U', NULL, NULL, cb_using_help, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Getting Started", &xmPushButtonGadgetClass,
	  'G', NULL, NULL, cb_getting_started, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Hidden Features", &xmPushButtonGadgetClass,
	  'H', NULL, NULL, cb_hidden_features, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Display Area", &xmPushButtonGadgetClass,
	  'D', NULL, NULL, cb_help_display_area, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Availability", &xmPushButtonGadgetClass,
	  'A', NULL, NULL, cb_availability, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "", &xmSeparatorGadgetClass,
	  '\0', NULL, NULL, NULL, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ "Contextual Help", &xmPushButtonGadgetClass,
	  'C', NULL, NULL, cb_contextual_help, (MenuItem *)NULL,
	  (Widget *)NULL },
	{ NULL }
};


/*
 * create_dir_window - Create a directory window.  Returns a pointer
 *                     to the structure created to hold info about
 *                     this window.
 */
struct dirwin_st *
create_dir_window()
{
	static int first_time = True;
	static Pixmap llnl_pixmap;
	static Pixmap cachemsg_pixmap;
	Arg args[12];
	int i;
	struct dirwin_st *dirwin;
	Widget widget;
    Widget w_homeButton;
	Widget w_mkdirButton;
	Widget w_refreshDirButton;
	Widget w_closeButton;
	Widget w_horizontal_sb;
	Widget w_vertical_sb;
	Widget w_opsMenu;
	Widget w_gotoMenu;
	Widget w_llnl;
	Widget w_pulldown;
	Widget w_prefsMenu;
	Pixel fg;
	Pixel bg;
	XmString label;
	Dimension h;

    /* Create struct to hold info about this directory window */
    dirwin = XtNew(struct dirwin_st);

    /* Add structure to linked list */
    dirwin->prev = NULL;
    dirwin->next = dirwin_head;
    if (dirwin_head)
        dirwin_head->prev = dirwin;
    dirwin_head = dirwin;

    /* Initialize structure */
    dirwin->has_selection = False;
    dirwin->nentries = 0;
    dirwin->dirname = NULL;
    dirwin->temp_for_search = False;
	dirwin->max_host_menu_used = 0;

	/* Create toplevel shell for directory window */
	dirwin->w_shell = XtVaCreatePopupShell("dirWindow",
		topLevelShellWidgetClass, w_toplev, NULL);

	/* Attach custom icon */
	attach_wm_icon(dirwin->w_shell);

	/* Create form */
	dirwin->w_form = XtVaCreateWidget("form", xmFormWidgetClass,
		dirwin->w_shell, NULL);

	/* Add callback for the WM_DELETE_WINDOW protocol */
	add_wm_delete_window_cb(dirwin->w_shell, cb_dirwin_close, dirwin, False);

	/* Create form for menu and "LLNL XDIR" button */
	dirwin->w_menuForm = XtVaCreateWidget(
		"menuForm",
		xmFormWidgetClass,
		dirwin->w_form,
		XmNtopAttachment,	XmATTACH_FORM,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL
	);

	/* Create upper-right button */
	dirwin->w_urButton = XtVaCreateManagedWidget(
		"llnlxdirButton",
		xmDrawnButtonWidgetClass,
		dirwin->w_menuForm,
		XmNpushButtonEnabled,	True,
		XmNwidth,				104,
		XmNtopAttachment,		XmATTACH_FORM,
		XmNtopOffset,			-2,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNbottomOffset,		-2,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNrightOffset,			-2,
		NULL
	);
	XtAddCallback(dirwin->w_urButton, XmNhelpCallback, cb_help_ur_button,
		(XtPointer)dirwin);
	add_llnlxdir_button_callbacks(dirwin);

	/* Create menu bar */
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(args[i], XmNrightWidget, dirwin->w_urButton); i++;
	XtSetArg(args[i], XmNrightOffset, 0); i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	dirwin->w_dirMenuBar = XmCreateMenuBar(dirwin->w_menuForm, "dirMenuBar",
		args ,i);

	/* Create File menu */
	widget = BuildPulldownMenu(dirwin->w_dirMenuBar, "File", 'F', file_menu,
		(XtPointer)dirwin);
	XtAddCallback(widget, XmNhelpCallback, cb_help_file_menu,
		(XtPointer)dirwin);

	/* Create Connect menu */
	widget = BuildPulldownMenu(dirwin->w_dirMenuBar, "Connect", 'C',
		connect_menu, (XtPointer)dirwin);
	XtAddCallback(widget, XmNhelpCallback, cb_help_connect_menu,
		(XtPointer)dirwin);

	/* Create Prefs menu */
	w_prefsMenu = BuildPulldownMenu(dirwin->w_dirMenuBar, "Prefs", 'P',
		prefs_menu, (XtPointer)dirwin);
	XtAddCallback(w_prefsMenu, XmNhelpCallback, cb_help_prefs_menu,
		(XtPointer)dirwin);

	/* Create Select menu */
	widget = BuildPulldownMenu(dirwin->w_dirMenuBar, "Select", 'S', select_menu,
		(XtPointer)dirwin);
	XtAddCallback(widget, XmNhelpCallback, cb_help_select_menu,
		(XtPointer)dirwin);

	/* Create Ops menu */
	w_opsMenu = BuildPulldownMenu(dirwin->w_dirMenuBar, "Ops", 'O', ops_menu,
		(XtPointer)dirwin);
	XtAddCallback(w_opsMenu, XmNhelpCallback, cb_help_ops_menu,
		(XtPointer)dirwin);
	dirwin->w_searchAgainItem = w_searchAgainItem;
	dirwin->w_deleteItem = w_deleteItem;
	dirwin->w_renameItem = w_renameItem;
	dirwin->w_viewItem = w_viewItem;
	dirwin->w_quotedItem = w_quotedItem;
	dirwin->w_launchMenu = w_launchMenu;

	/* Create Goto menu */
	w_gotoMenu = BuildPulldownMenu(dirwin->w_dirMenuBar, "Goto", 'G', goto_menu,
		(XtPointer)dirwin);
	XtAddCallback(w_gotoMenu, XmNhelpCallback, cb_help_goto_menu,
		(XtPointer)dirwin);
	dirwin->w_gotoMenu = w_gotoMenu;
	initialize_goto_menu(dirwin);
	dirwin->w_ancestorsMenu = w_ancestorsMenu;

	/* Create Windows menu */
	dirwin->w_winsMenu = BuildPulldownMenu(dirwin->w_dirMenuBar, "Wins", 'W',
		wins_menu, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_winsMenu, XmNhelpCallback, cb_help_wins_menu,
		(XtPointer)dirwin);
	initialize_wins_menu(dirwin);
	dirwin->w_viewedFilesMenu = w_viewedFilesMenu;
	initialize_viewed_files_menu(dirwin);

	/* Create Help Menu */
	widget = BuildPulldownMenu(dirwin->w_dirMenuBar, "Help", 'H', help_menu,
		(XtPointer)dirwin);
	XtVaSetValues(dirwin->w_dirMenuBar, XmNmenuHelpWidget, widget, NULL);

	XtManageChild(dirwin->w_dirMenuBar);
	XtManageChild(dirwin->w_menuForm);

	/* Create "Lawrence Livermore National Laboratory" label */
	if (first_time) {
    	XtVaGetValues(dirwin->w_form, XmNbackground, &bg, XmNforeground, &fg,
			NULL);
		llnl_pixmap = XCreatePixmapFromBitmapData(display, root_window,
			(char *)llnl_bits, llnl_width, llnl_height, fg, bg, depth);
	}
	w_llnl = XtVaCreateManagedWidget(
		"llnl",
		xmLabelWidgetClass,
		dirwin->w_form,
		XmNlabelType,			XmPIXMAP,
		XmNlabelPixmap,			llnl_pixmap,
		XmNmarginHeight,		0,
		XmNmarginWidth,			0,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNbottomOffset,		2,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNleftOffset,			20,
		NULL
	);

	/* Create "Cache Referenced" label */
	if (first_time) {
    	XtVaGetValues(dirwin->w_form, XmNbackground, &bg, XmNforeground, &fg,
			NULL);
		cachemsg_pixmap = XCreatePixmapFromBitmapData(display, root_window,
			(char *)cachemsg_bits, cachemsg_width, cachemsg_height, fg, bg,
			depth);
	}
	dirwin->w_cacheMsg = XtVaCreateWidget(
		"cacheMsg",
		xmLabelWidgetClass,
		dirwin->w_form,
		XmNlabelType,			XmPIXMAP,
		XmNlabelPixmap,			cachemsg_pixmap,
		XmNmarginHeight,		0,
		XmNmarginWidth,			0,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNbottomOffset,		4,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNrightOffset,			25,
		NULL
	);

	/* Create form for toolbar */
	dirwin->w_toolbarForm = XtVaCreateWidget(
		"toolbarForm",
		xmFormWidgetClass,
		dirwin->w_form,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			dirwin->w_menuForm,
		XmNtopOffset,			2,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNleftOffset,			1,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNrightOffset,			1,
   		NULL
	);

	/* Create "Close" button */
	w_closeButton = create_button("closeButton", dirwin, dirwin->w_toolbarForm);
	XtVaSetValues(w_closeButton,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNrightOffset,			4,
		NULL
	);
    XtAddCallback(w_closeButton, XmNactivateCallback, cb_dirwin_close,
		(XtPointer)dirwin);
	XtAddCallback(w_closeButton, XmNhelpCallback, cb_help_close_button,
		(XtPointer)dirwin);

	/* Create "Delete selected entries" button */
	dirwin->w_deleteButton = create_button("deleteButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_deleteButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			w_closeButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(dirwin->w_deleteButton, XmNactivateCallback, cb_delete,
		(XtPointer)dirwin);
	XtAddCallback(dirwin->w_deleteButton, XmNhelpCallback,
		cb_help_delete_button, (XtPointer)dirwin);

	/* Create "Make New Directory" button */
	w_mkdirButton = create_button("mkdirButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(w_mkdirButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_deleteButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(w_mkdirButton, XmNactivateCallback, cb_make_dir,
		(XtPointer)dirwin);
	XtAddCallback(w_mkdirButton, XmNhelpCallback, cb_help_mkdir_button,
		(XtPointer)dirwin);

	/* Create "Go to Home Directory" button */
	w_homeButton = create_button("homeButton", dirwin, dirwin->w_toolbarForm);
	XtVaSetValues(w_homeButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			w_mkdirButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(w_homeButton, XmNactivateCallback, cb_goto_home,
		(XtPointer)dirwin);
	XtAddCallback(w_homeButton, XmNhelpCallback, cb_help_home_button,
		(XtPointer)dirwin);

	/* Create "Go up to Parent" button */
	dirwin->w_upArrowButton = create_button("upArrowButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_upArrowButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			w_homeButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(dirwin->w_upArrowButton, XmNactivateCallback, cb_goto_parent,
		(XtPointer)dirwin);
	XtAddCallback(dirwin->w_upArrowButton, XmNhelpCallback,
		cb_help_parent_button, (XtPointer)dirwin);

	/* Initialize the "Go to Ancestors" menus */
	init_ancestors_menus(dirwin);

	/* Create "Refresh directory window" button */
	w_refreshDirButton = create_button("refreshDirButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(w_refreshDirButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_upArrowButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(w_refreshDirButton, XmNactivateCallback, cb_refresh_dir,
		(XtPointer)dirwin);
	XtAddCallback(w_refreshDirButton, XmNhelpCallback, cb_help_refresh_button,
		(XtPointer)dirwin);

	/* Create "Cache Mode" button */
	dirwin->w_cacheButton = create_button("cacheButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_cacheButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			w_refreshDirButton,
		XmNrightOffset,			8,
		NULL
	);
    XtAddCallback(dirwin->w_cacheButton, XmNactivateCallback,
		cb_change_cache_mode, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_cacheButton, XmNhelpCallback,
		cb_help_cache_button, (XtPointer)dirwin);

	/* Create "Dot Files Mode" button */
	dirwin->w_dotFilesButton = create_button("dotFilesButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_dotFilesButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_cacheButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(dirwin->w_dotFilesButton, XmNactivateCallback,
		cb_change_dotfiles_mode, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_dotFilesButton, XmNhelpCallback,
		cb_help_dot_files_button, (XtPointer)dirwin);

	/* Create "Tunneling Mode" button */
	dirwin->w_tunnelingButton = create_button("tunnelingButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_tunnelingButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_dotFilesButton,
		XmNrightOffset,			-2,
		NULL
	);
    XtAddCallback(dirwin->w_tunnelingButton, XmNactivateCallback,
		cb_change_tunneling_mode, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_tunnelingButton, XmNhelpCallback,
		cb_help_tunneling_button, (XtPointer)dirwin);

	/* Create "Full Info Layout" button */
	dirwin->w_fullInfoButton = create_button("fullInfoButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_fullInfoButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_tunnelingButton,
		XmNrightOffset,			8,
		NULL
	);
	XtAddCallback(dirwin->w_fullInfoButton, XmNactivateCallback,
		cb_change_layout, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_fullInfoButton, XmNhelpCallback,
		cb_help_full_info_button, (XtPointer)dirwin);

	/* Create "Tree Layout" button */
	dirwin->w_treeButton = create_button("treeButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_treeButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_fullInfoButton,
		XmNrightOffset,			-2,
		NULL
	);
	XtAddCallback(dirwin->w_treeButton, XmNactivateCallback,
		cb_change_layout, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_treeButton, XmNhelpCallback, cb_help_tree_button,
		(XtPointer)dirwin);

	/* Create "Iconic" button */
	dirwin->w_iconicButton = create_button("iconicButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_iconicButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_treeButton,
		XmNrightOffset,			-2,
		NULL
	);
	XtAddCallback(dirwin->w_iconicButton, XmNactivateCallback,
		cb_change_layout, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_iconicButton, XmNhelpCallback,
		cb_help_iconic_button, (XtPointer)dirwin);

	/* Create "Tabular" button */
	dirwin->w_tabularButton = create_button("tabularButton", dirwin,
		dirwin->w_toolbarForm);
	XtVaSetValues(dirwin->w_tabularButton,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			dirwin->w_iconicButton,
		XmNrightOffset,			-2,
		NULL
	);
	XtAddCallback(dirwin->w_tabularButton, XmNactivateCallback,
		cb_change_layout, (XtPointer)dirwin);
	XtAddCallback(dirwin->w_tabularButton, XmNhelpCallback,
		cb_help_tabular_button, (XtPointer)dirwin);

	/* Create the file transfer mode pulldown menu */
	w_pulldown = XmCreatePulldownMenu(dirwin->w_toolbarForm, "xferModeMenu",
		NULL, 0);
	label = XmStringCreateSimple("ASCII");
	dirwin->w_asciiItem = XtVaCreateManagedWidget(
		"asciiItem",
		xmPushButtonGadgetClass,
		w_pulldown,
		XmNlabelString, label,
		NULL
	);
	XtAddCallback(dirwin->w_asciiItem, XmNactivateCallback, cb_change_xfer_mode,
		(XtPointer)dirwin);
	XmStringFree(label);
	label = XmStringCreateSimple("Binary");
	dirwin->w_binaryItem = XtVaCreateManagedWidget(
		"asciiItem",
		xmPushButtonGadgetClass,
		w_pulldown,
		XmNlabelString, label,
		NULL
	);
	XtAddCallback(dirwin->w_binaryItem, XmNactivateCallback,
		cb_change_xfer_mode, (XtPointer)dirwin);
	XmStringFree(label);

    /* Create file transfer mode option menu */
    i = 0;
    XtSetArg(args[i], XmNsubMenuId, w_pulldown); i++;
	label = XmStringCreateSimple("");
	XtSetArg(args[i], XmNlabelString, label); i++;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(args[i], XmNleftOffset, -3); i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(args[i], XmNrightWidget, dirwin->w_tabularButton); i++;
	XtSetArg(args[i], XmNrightOffset, 14); i++;
	XtSetArg(args[i], XmNmarginHeight, 0); i++;
	XtSetArg(args[i], XmNmarginWidth, 0); i++;
    dirwin->w_xferModeMenu = XmCreateOptionMenu(dirwin->w_toolbarForm,
		"xferModeMenu", args, i);
	XmStringFree(label);
    XtManageChild(dirwin->w_xferModeMenu);
	widget = XmOptionButtonGadget(dirwin->w_xferModeMenu);
	XtAddCallback(widget, XmNhelpCallback, cb_help_xfer_mode_menu,
		(XtPointer)dirwin);
	XtManageChild(widget);

	XtManageChild(dirwin->w_toolbarForm);

    /* Create scrolled window to hold drawing area widget */
    dirwin->w_scrolledWindow = XtVaCreateManagedWidget(
        "scrolledWindow",
        xmScrolledWindowWidgetClass,
        dirwin->w_form,
        XmNscrollingPolicy,		XmAPPLICATION_DEFINED,
		XmNuserData,			dirwin,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			dirwin->w_toolbarForm,
		XmNtopOffset,			2,
		XmNbottomAttachment,	XmATTACH_WIDGET,
		XmNbottomWidget,		w_llnl,
		XmNbottomOffset,		2,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNleftOffset,			4,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNrightOffset,			4,
        NULL
    );

	/* Create scrollbars */
	w_vertical_sb = XtVaCreateManagedWidget(
		"vertical_scrollbar",
		xmScrollBarWidgetClass,
		dirwin->w_scrolledWindow,
		XmNorientation,	XmVERTICAL,
		NULL
	);
	XtAddCallback(w_vertical_sb, XmNvalueChangedCallback, cb_scroll_vertical,
		(XtPointer)dirwin);
	XtAddCallback(w_vertical_sb, XmNdragCallback, cb_scroll_vertical,
		(XtPointer)dirwin);
	w_horizontal_sb = XtVaCreateManagedWidget(
		"horizontal_scrollbar",
		xmScrollBarWidgetClass,
		dirwin->w_scrolledWindow,
		XmNorientation,	XmHORIZONTAL,
		NULL
	);
	XtAddCallback(w_horizontal_sb, XmNvalueChangedCallback,
		cb_scroll_horizontal, (XtPointer)dirwin);
	XtAddCallback(w_horizontal_sb, XmNdragCallback, cb_scroll_horizontal,
		(XtPointer)dirwin);

	/* Create frame to pretty up drawing area widget */
	dirwin->w_drawingAreaFrame = XtVaCreateManagedWidget(
		"drawingAreaFrame",
		xmFrameWidgetClass,
		dirwin->w_scrolledWindow,
		XmNshadowType,		XmSHADOW_IN,
		NULL
	);

	/* Create drawing area widget to hold directory entries */
	dirwin->w_drawingArea = XtVaCreateManagedWidget(
		"drawingArea",
		xmDrawingAreaWidgetClass,
		dirwin->w_drawingAreaFrame,
		XmNuserData,		dirwin,
   		NULL
	);
	XtAddCallback(dirwin->w_drawingArea, XmNhelpCallback,
		cb_help_display_area, (XtPointer)dirwin);
	XtAddEventHandler(dirwin->w_drawingArea,
		ButtonPressMask |
		ButtonReleaseMask |
		EnterWindowMask |
		LeaveWindowMask |
		Button1MotionMask,
		False,
		HandleMouseEvents,
		(XtPointer)dirwin
	);
	XtAddEventHandler(dirwin->w_drawingArea,
		KeyPressMask,
		False,
		HandleKeyboardEvents,
		(XtPointer)dirwin
	);
	XtAddEventHandler(dirwin->w_drawingArea,
		ExposureMask,
		False,
		HandleExposeEvents,
		(XtPointer)dirwin
	);
	XtAddEventHandler(dirwin->w_drawingArea,
		(EventMask)0,
		True,
		HandleExposeEvents,
		(XtPointer)dirwin
	);

	/* Initialize ScrolledWindow */
	XmScrolledWindowSetAreas(dirwin->w_scrolledWindow, w_horizontal_sb,
		w_vertical_sb, dirwin->w_drawingAreaFrame);

	XtManageChild(dirwin->w_form);

	/* Initialize the popup and pulldown launch menus */
	init_launch_menus(dirwin);

	/* Make upper-right button the same height as the menu bar */
	XtVaGetValues(dirwin->w_dirMenuBar, XmNheight, &h, NULL);
	XtVaSetValues(dirwin->w_urButton, XmNheight, h, NULL);

	XtPopup(dirwin->w_shell, XtGrabNone);

	if (first_time) {
		initialize_graphics(dirwin);
		initialize_ur_button(dirwin);
		first_time = False;
	}
	traverse_to_widget(dirwin->w_drawingArea);
	add_dialog_to_list(dirwin->w_shell);

	XtAddCallback(dirwin->w_drawingArea, XmNresizeCallback, cb_resize_dirwin,
		(XtPointer)dirwin);

	return dirwin;
}

