/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport.sharedport;

import com.aelitis.azureus.core.networkmanager.SelectorGuard;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.impl.transport.sharedport.PESharedPortServerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class PESharedPortSelector {
    public static final long SOCKET_TIMEOUT = 30000L;
    protected Selector selector;
    protected List register_list = new ArrayList(16);
    protected AEMonitor register_list_mon = new AEMonitor("PESharedPortSelector:RL");
    protected Map hash_map = new HashMap();

    protected PESharedPortSelector() throws IOException {
        this.selector = Selector.open();
        AEThread t = new AEThread("PESharedPortSelector"){

            public void runSupport() {
                PESharedPortSelector.this.selectLoop();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void selectLoop() {
        HashMap<SocketChannel, socketData> outstanding_sockets = new HashMap<SocketChannel, socketData>();
        ArrayList<socketData> sockets_to_handover = new ArrayList<socketData>();
        SelectorGuard selectorGuard = new SelectorGuard(10000);
        block27: while (true) {
            try {
                block42: {
                    try {
                        this.register_list_mon.enter();
                        if (this.register_list.size() <= 0) break block42;
                        int i = 0;
                        while (i < this.register_list.size()) {
                            socketData sd = (socketData)this.register_list.get(i);
                            SocketChannel socket = sd.getSocket();
                            try {
                                outstanding_sockets.put(socket, sd);
                                socket.register(this.selector, 1);
                            }
                            catch (Exception e) {
                                Debug.printStackTrace(e);
                                outstanding_sockets.remove(socket);
                                try {
                                    socket.close();
                                }
                                catch (IOException f) {
                                    Debug.printStackTrace(f);
                                }
                            }
                            ++i;
                        }
                        this.register_list.clear();
                    }
                    finally {
                        this.register_list_mon.exit();
                    }
                }
                selectorGuard.markPreSelectTime();
                int select_res = this.selector.select(500L);
                if (!selectorGuard.isSelectorOK(select_res, 10L)) {
                    this.selector = selectorGuard.repairSelector(this.selector);
                }
                int i = 0;
                while (i < sockets_to_handover.size()) {
                    socketData sd = (socketData)sockets_to_handover.get(i);
                    sd.getHandoverServer().connectionReceived(sd.getSocket(), sd.getHandoverData());
                    ++i;
                }
                sockets_to_handover.clear();
                if (select_res <= 0) continue;
                Iterator<SelectionKey> ready_it = this.selector.selectedKeys().iterator();
                while (ready_it.hasNext()) {
                    boolean remove_this_key;
                    SocketChannel channel;
                    block43: {
                        SelectionKey key = ready_it.next();
                        ready_it.remove();
                        channel = (SocketChannel)key.channel();
                        remove_this_key = false;
                        if (key.isValid() && key.isReadable()) {
                            socketData socket_data = (socketData)outstanding_sockets.get(channel);
                            if (socket_data == null) {
                                LGLogger.log(0, 0, 3, String.valueOf(this.getIP(channel)) + " : PESharedPortSelector: failed to find socket buffer");
                                remove_this_key = true;
                            } else {
                                try {
                                    ByteBuffer buffer = socket_data.getBuffer();
                                    int len = channel.read(buffer);
                                    if (len < 0) {
                                        remove_this_key = true;
                                        break block43;
                                    }
                                    if (buffer.position() < 48) break block43;
                                    byte[] contents = new byte[buffer.position()];
                                    buffer.flip();
                                    buffer.get(contents);
                                    HashWrapper hw = new HashWrapper(contents, 28, 20);
                                    PESharedPortServerImpl server = (PESharedPortServerImpl)this.hash_map.get(hw);
                                    if (server == null) {
                                        remove_this_key = true;
                                        LGLogger.log(0, 0, 3, String.valueOf(this.getIP(channel)) + " : PESharedPortSelector: failed to find matching info hash");
                                        break block43;
                                    }
                                    outstanding_sockets.remove(channel);
                                    key.cancel();
                                    socket_data.setHandoverServer(server);
                                    socket_data.setHandoverData(contents);
                                    sockets_to_handover.add(socket_data);
                                }
                                catch (IOException e) {
                                    remove_this_key = true;
                                    LGLogger.log(0, 0, 3, String.valueOf(this.getIP(channel)) + " : PESharedPortSelector: error occurred during socket read: " + e.toString());
                                }
                            }
                        } else {
                            Debug.out("key is invalid or is not readable");
                        }
                    }
                    if (!remove_this_key) continue;
                    outstanding_sockets.remove(channel);
                    try {
                        channel.close();
                    }
                    catch (IOException socket_data) {
                        // empty catch block
                    }
                }
                Iterator<SelectionKey> keys_it = this.selector.keys().iterator();
                long now = SystemTime.getCurrentTime();
                while (true) {
                    if (!keys_it.hasNext()) continue block27;
                    SelectionKey key = keys_it.next();
                    SocketChannel channel = (SocketChannel)key.channel();
                    socketData socket_data = (socketData)outstanding_sockets.get(channel);
                    if (socket_data == null || now - socket_data.getLastUseTime() <= 30000L) continue;
                    LGLogger.log(0, 0, 0, String.valueOf(this.getIP(socket_data.getSocket())) + " : PESharedPortSelector: timed out socket connection");
                    outstanding_sockets.remove(channel);
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof NullPointerException) {
                    Debug.out("null pointer exception");
                }
                Debug.printStackTrace(e);
                LGLogger.log(0, 0, "PESharedPortSelector: error occurred during processing: " + e.toString(), e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException f) {
                    Debug.printStackTrace(f);
                }
                try {
                    this.selector.close();
                }
                catch (Throwable f) {
                    // empty catch block
                }
                try {
                    this.selector = Selector.open();
                    Iterator s_it = outstanding_sockets.keySet().iterator();
                    while (true) {
                        if (!s_it.hasNext()) continue block27;
                        SocketChannel channel = (SocketChannel)s_it.next();
                        channel.register(this.selector, 1);
                    }
                }
                catch (Throwable f) {
                    try {
                        this.selector.close();
                    }
                    catch (Throwable channel) {
                        // empty catch block
                    }
                    try {
                        this.selector = Selector.open();
                        Iterator s_it = outstanding_sockets.keySet().iterator();
                        while (s_it.hasNext()) {
                            SocketChannel channel = (SocketChannel)s_it.next();
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        outstanding_sockets.clear();
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
            }
            break;
        }
    }

    public void addSocket(SocketChannel _socket) {
        try {
            this.register_list_mon.enter();
            socketData sd = new socketData(_socket);
            this.register_list.add(sd);
        }
        finally {
            this.register_list_mon.exit();
        }
        this.selector.wakeup();
    }

    public void addHash(PESharedPortServerImpl _server, byte[] _hash) {
        this.hash_map.put(new HashWrapper(_hash), _server);
    }

    public void removeHash(PESharedPortServerImpl _server, byte[] _hash) {
        this.hash_map.remove(new HashWrapper(_hash));
    }

    protected String getIP(SocketChannel socket) {
        Socket s = socket.socket();
        if (s == null) {
            return "??.??.??.??";
        }
        InetAddress addr = s.getInetAddress();
        if (addr == null) {
            return "??.??.??.??";
        }
        return addr.getHostAddress();
    }

    protected class socketData {
        protected SocketChannel socket;
        protected ByteBuffer buffer;
        protected long last_use_time = SystemTime.getCurrentTime();
        protected PESharedPortServerImpl server;
        protected byte[] data;

        protected socketData(SocketChannel _socket) {
            this.socket = _socket;
            this.buffer = ByteBuffer.allocate(68);
            this.buffer.position(0);
            this.buffer.limit(68);
        }

        protected SocketChannel getSocket() {
            return this.socket;
        }

        protected ByteBuffer getBuffer() {
            this.last_use_time = SystemTime.getCurrentTime();
            return this.buffer;
        }

        protected long getLastUseTime() {
            return this.last_use_time;
        }

        protected void setHandoverData(byte[] d) {
            this.data = d;
        }

        protected byte[] getHandoverData() {
            return this.data;
        }

        protected void setHandoverServer(PESharedPortServerImpl s) {
            this.server = s;
        }

        protected PESharedPortServerImpl getHandoverServer() {
            return this.server;
        }
    }
}

