/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TrackerStatus;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class TrackerChecker
implements TRTrackerScraperListener {
    private HashMap trackers;
    private AEMonitor trackers_mon = new AEMonitor("TrackerChecker:trackers");
    private TRTrackerScraperImpl scraper;
    private long lNextScrapeTime = 0L;
    private TrackerStatus nextTrackerStatus = null;
    private byte[] nextTrackerHash;
    private AEMonitor this_mon = new AEMonitor("TrackerChecker");

    protected TrackerChecker(TRTrackerScraperImpl _scraper) {
        this.scraper = _scraper;
        this.scraper.addListener(this);
        this.trackers = new HashMap();
        AEThread t = new AEThread("Tracker Scrape"){

            public void runSupport() {
                TrackerChecker.this.runScrapes();
            }
        };
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    protected TRTrackerScraperResponseImpl getHashData(TRTrackerClient tracker_client) {
        try {
            return this.getHashData(tracker_client.getTrackerUrl(), tracker_client.getTorrent().getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(TOTorrent torrent, URL target_url) {
        try {
            return this.getHashData(target_url == null ? torrent.getAnnounceURL() : target_url, torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(URL trackerUrl, HashWrapper hash) {
        if (trackerUrl == null) {
            return null;
        }
        byte[] hashBytes = hash.getHash();
        TRTrackerScraperResponseImpl data = null;
        String url_str = trackerUrl.toString();
        if (this.trackers.containsKey(url_str)) {
            TrackerStatus ts = (TrackerStatus)this.trackers.get(url_str);
            data = ts.getHashData(hashBytes);
            if (data == null) {
                data = ts.addHash(hashBytes);
            }
        } else {
            TrackerStatus ts = new TrackerStatus(this.scraper, trackerUrl);
            try {
                this.trackers_mon.enter();
                this.trackers.put(url_str, ts);
            }
            finally {
                this.trackers_mon.exit();
            }
            data = ts.addHash(hashBytes);
        }
        return data;
    }

    protected void removeHash(TOTorrent torrent) {
        try {
            this.removeHash(torrent.getAnnounceURL().toString(), torrent.getHashWrapper());
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            int i = 0;
            while (i < sets.length) {
                URL[] urls = sets[i].getAnnounceURLs();
                int j = 0;
                while (j < urls.length) {
                    this.removeHash(urls[j].toString(), torrent.getHashWrapper());
                    ++j;
                }
                ++i;
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void removeHash(String trackerUrl, HashWrapper hash) {
        TrackerStatus ts = (TrackerStatus)this.trackers.get(trackerUrl);
        if (ts != null) {
            ts.removeHash(hash);
        }
    }

    protected void syncUpdate(TOTorrent torrent, URL target_url) {
        if (torrent == null) {
            return;
        }
        try {
            byte[] hash = torrent.getHash();
            try {
                this.trackers_mon.enter();
                Iterator iter = this.trackers.values().iterator();
                while (iter.hasNext()) {
                    Map hashmap;
                    TrackerStatus ts = (TrackerStatus)iter.next();
                    if (target_url != null && !target_url.toString().equals(ts.getTrackerURL().toString()) || (hashmap = ts.getHashes()).get(hash) == null) continue;
                    ts.updateSingleHash(hash, true, false);
                    this.trackers_mon.exit();
                    return;
                }
            }
            finally {
                this.trackers_mon.exit();
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    private void runScrapes() {
        while (true) {
            if (this.lNextScrapeTime == 0L || this.lNextScrapeTime > SystemTime.getCurrentTime()) {
                if (!SystemTime.isErrorLast5sec()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.nextTrackerStatus != null) {
                this.nextTrackerStatus.updateSingleHash(this.nextTrackerHash, false);
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.checkForNextScrape();
        }
    }

    private void checkForNextScrape() {
        try {
            this.this_mon.enter();
            TRTrackerScraperResponseImpl nextResponse = null;
            long lNewNextScrapeTime = 0L;
            try {
                this.trackers_mon.enter();
                Iterator iter = this.trackers.values().iterator();
                while (iter.hasNext()) {
                    TrackerStatus ts = (TrackerStatus)iter.next();
                    Map hashmap = ts.getHashes();
                    try {
                        ts.getHashesMonitor().enter();
                        Iterator iterHashes = hashmap.values().iterator();
                        while (iterHashes.hasNext()) {
                            TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)iterHashes.next();
                            long lResponseNextScrapeTime = response.getNextScrapeStartTime();
                            if (response.getStatus() == 3 || nextResponse != null && lResponseNextScrapeTime >= lNewNextScrapeTime || this.nextTrackerStatus == response.getTrackerStatus() && this.nextTrackerHash == response.getHash()) continue;
                            lNewNextScrapeTime = lResponseNextScrapeTime;
                            nextResponse = response;
                        }
                    }
                    finally {
                        ts.getHashesMonitor().exit();
                    }
                }
            }
            finally {
                this.trackers_mon.exit();
            }
            if (nextResponse == null) {
                this.nextTrackerStatus = null;
                this.lNextScrapeTime = SystemTime.getCurrentTime() + 60000L;
            } else {
                this.nextTrackerStatus = nextResponse.getTrackerStatus();
                this.nextTrackerHash = nextResponse.getHash();
                this.lNextScrapeTime = lNewNextScrapeTime;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void scrapeReceived(TRTrackerScraperResponse response) {
        long lResponseNextScrapeTime = response.getNextScrapeStartTime();
        if (lResponseNextScrapeTime < this.lNextScrapeTime) {
            this.nextTrackerStatus = response.getTrackerStatus();
            this.nextTrackerHash = response.getHash();
            this.lNextScrapeTime = lResponseNextScrapeTime;
        }
    }
}

