/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleUtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.SemaphoreImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESecurityManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentFactoryImpl;
import org.gudy.azureus2.ui.common.UIImageRepository;

public class UtilitiesImpl
implements Utilities {
    protected PluginInterface pi;

    public UtilitiesImpl(PluginInterface _pi) {
        this.pi = _pi;
    }

    public String getAzureusUserDir() {
        String res = SystemProperties.getUserPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public boolean isCVSVersion() {
        return Constants.isCVSVersion();
    }

    public InputStream getImageAsStream(String image_name) {
        return UIImageRepository.getImageAsStream(image_name);
    }

    public Semaphore getSemaphore() {
        return new SemaphoreImpl();
    }

    public ByteBuffer allocateDirectByteBuffer(int size) {
        return DirectByteBufferPool.getBuffer((byte)1, size).getBuffer((byte)1);
    }

    public void freeDirectByteBuffer(ByteBuffer buffer) {
    }

    public Formatters getFormatters() {
        return new FormattersImpl();
    }

    public LocaleUtilities getLocaleUtilities() {
        return new LocaleUtilitiesImpl(this.pi);
    }

    public UTTimer createTimer(String name) {
        return new UTTimerImpl(this.pi, name);
    }

    public void createThread(String name, final Runnable target) {
        AEThread t = new AEThread(String.valueOf(this.pi.getPluginName()) + "::" + name){

            public void runSupport() {
                target.run();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void createProcess(String command_line) throws PluginException {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(command_line, false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            try {
                Runtime.getRuntime().exec(command_line);
            }
            catch (Throwable f) {
                throw new PluginException("Failed to create process", f);
            }
        }
    }

    public ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    public SESecurityManager getSecurityManager() {
        return new SESecurityManagerImpl();
    }

    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory() {
        return new SimpleXMLParserDocumentFactoryImpl();
    }
}

