/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentNodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLParserDocumentImpl
implements SimpleXMLParserDocument {
    protected Document document;
    protected SimpleXMLParserDocumentNodeImpl root_node;

    public SimpleXMLParserDocumentImpl(File file) throws SimpleXMLParserDocumentException {
        try {
            this.create(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocumentImpl(String data) throws SimpleXMLParserDocumentException {
        try {
            this.create(new ByteArrayInputStream(data.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SimpleXMLParserDocumentImpl(InputStream input_stream) throws SimpleXMLParserDocumentException {
        this.create(input_stream);
    }

    protected void create(InputStream input_stream) throws SimpleXMLParserDocumentException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(true);
            dbf.setExpandEntityReferences(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            MyErrorHandler error_handler = new MyErrorHandler(new PrintWriter((Writer)errorWriter, true));
            db.setErrorHandler(error_handler);
            this.document = db.parse(input_stream);
            SimpleXMLParserDocumentNodeImpl[] root_nodes = this.parseNode(this.document, false);
            if (root_nodes.length != 1) {
                throw new SimpleXMLParserDocumentException("invalid document - " + root_nodes.length + " root elements");
            }
            this.root_node = root_nodes[0];
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public String getName() {
        return this.root_node.getName();
    }

    public String getValue() {
        return this.root_node.getValue();
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        return this.root_node.getChildren();
    }

    public SimpleXMLParserDocumentNode getChild(String name) {
        return this.root_node.getChild(name);
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        return this.root_node.getAttributes();
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        return this.root_node.getAttribute(name);
    }

    public void print() {
        this.root_node.print("");
    }

    protected SimpleXMLParserDocumentNodeImpl[] parseNode(Node node, boolean skip_this_node) {
        short type = node.getNodeType();
        if (!(type != 1 && type != 7 || skip_this_node)) {
            return new SimpleXMLParserDocumentNodeImpl[]{new SimpleXMLParserDocumentNodeImpl(this, node)};
        }
        Vector<SimpleXMLParserDocumentNodeImpl> v = new Vector<SimpleXMLParserDocumentNodeImpl>();
        Node child = node.getFirstChild();
        while (child != null) {
            SimpleXMLParserDocumentNodeImpl[] kids = this.parseNode(child, false);
            int i = 0;
            while (i < kids.length) {
                v.addElement(kids[i]);
                ++i;
            }
            child = child.getNextSibling();
        }
        Object[] res = new SimpleXMLParserDocumentNodeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

