/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update.sf.impl2;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.html.HTMLPage;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.html.HTMLTable;
import org.gudy.azureus2.core3.html.HTMLTableCell;
import org.gudy.azureus2.core3.html.HTMLTableRow;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.pluginsimpl.update.sf.impl2.SFPluginDetailsImpl;

public class SFPluginDetailsLoaderImpl
implements SFPluginDetailsLoader,
ResourceDownloaderListener {
    public static final String site_prefix = "http://azureus.sourceforge.net/";
    public static final String page_url = "http://azureus.sourceforge.net/update/pluginlist2.php?type=release";
    protected static SFPluginDetailsLoaderImpl singleton;
    protected static AEMonitor class_mon;
    public static final int RELOAD_MIN_TIME = 3600000;
    protected boolean plugin_ids_loaded;
    protected long plugin_ids_loaded_at;
    protected List plugin_ids;
    protected Map plugin_map;
    protected List listeners = new ArrayList();
    protected ResourceDownloaderFactory rd_factory = ResourceDownloaderFactoryImpl.getSingleton();
    protected AEMonitor this_mon = new AEMonitor("SFPluginDetailsLoader");

    static {
        class_mon = new AEMonitor("SFPluginDetailsLoader:class");
    }

    public static SFPluginDetailsLoader getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new SFPluginDetailsLoaderImpl();
            }
            SFPluginDetailsLoaderImpl sFPluginDetailsLoaderImpl = singleton;
            class_mon.exit();
            return sFPluginDetailsLoaderImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected SFPluginDetailsLoaderImpl() {
        this.reset();
    }

    protected void loadPluginList() throws SFPluginDetailsException {
        try {
            ResourceDownloader dl = this.rd_factory.create(new URL(page_url));
            dl = this.rd_factory.getRetryDownloader(dl, 5);
            dl.addListener(this);
            Properties details = new Properties();
            details.load(dl.download());
            Iterator<Object> it = details.keySet().iterator();
            while (it.hasNext()) {
                String plugin_id = (String)it.next();
                String data = (String)details.get(plugin_id);
                int pos = 0;
                ArrayList<String> bits = new ArrayList<String>();
                while (pos < data.length()) {
                    int p1 = data.indexOf(59, pos);
                    if (p1 == -1) {
                        bits.add(data.substring(pos).trim());
                        break;
                    }
                    bits.add(data.substring(pos, p1).trim());
                    pos = p1 + 1;
                }
                String version = (String)bits.get(0);
                String name = (String)bits.get(1);
                this.plugin_ids.add(plugin_id);
                this.plugin_map.put(plugin_id.toLowerCase(), new SFPluginDetailsImpl(this, plugin_id, version, name));
            }
            this.plugin_ids_loaded = true;
            this.plugin_ids_loaded_at = SystemTime.getCurrentTime();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new SFPluginDetailsException("Plugin list load failed", e);
        }
    }

    protected void loadPluginDetails(SFPluginDetailsImpl details) throws SFPluginDetailsException {
        try {
            ResourceDownloader p_dl = this.rd_factory.create(new URL("http://azureus.sourceforge.net/plugin_details.php?plugin=" + details.getId()));
            p_dl = this.rd_factory.getRetryDownloader(p_dl, 5);
            p_dl.addListener(this);
            HTMLPage plugin_page = HTMLPageFactory.loadPage(p_dl.download());
            if (!this.processPluginPage(details, plugin_page)) {
                throw new SFPluginDetailsException("Plugin details load fails for '" + details.getId() + "': data not found");
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new SFPluginDetailsException("Plugin details load fails", e);
        }
    }

    protected boolean processPluginPage(SFPluginDetailsImpl details, HTMLPage page) throws SFPluginDetailsException {
        HTMLTable[] tables = page.getTables();
        return this.processPluginPage(details, tables);
    }

    protected boolean processPluginPage(SFPluginDetailsImpl details, HTMLTable[] tables) throws SFPluginDetailsException {
        int i = 0;
        while (i < tables.length) {
            HTMLTableCell[] cells;
            HTMLTable table = tables[i];
            HTMLTableRow[] rows = table.getRows();
            if (rows.length == 10 && (cells = rows[0].getCells()).length == 6 && cells[0].getContent().trim().equals("Name") && cells[5].getContent().trim().equals("Contact")) {
                HTMLTableCell[] detail_cells = rows[2].getCells();
                String plugin_name = detail_cells[0].getContent();
                String plugin_version = detail_cells[1].getContent();
                String plugin_auth = detail_cells[4].getContent();
                String[] dl_links = detail_cells[2].getLinks();
                String plugin_download = dl_links.length == 0 ? "<unknown>" : site_prefix + dl_links[0];
                HTMLTableCell[] cvs_detail_cells = rows[3].getCells();
                String plugin_cvs_version = cvs_detail_cells[1].getContent();
                String[] cvs_dl_links = cvs_detail_cells[2].getLinks();
                String plugin_cvs_download = cvs_dl_links.length == 0 ? "<unknown>" : site_prefix + cvs_dl_links[0];
                details.setDetails(plugin_download, plugin_auth, plugin_cvs_version, plugin_cvs_download, rows[6].getCells()[0].getContent(), rows[9].getCells()[0].getContent());
                return true;
            }
            HTMLTable[] sub_tables = table.getTables();
            boolean res = this.processPluginPage(details, sub_tables);
            if (res) {
                return res;
            }
            ++i;
        }
        return false;
    }

    protected void dumpTables(String indent, HTMLTable[] tables) {
        int i = 0;
        while (i < tables.length) {
            HTMLTable tab = tables[i];
            System.out.println(String.valueOf(indent) + "tab:" + tab.getContent());
            HTMLTableRow[] rows = tab.getRows();
            int j = 0;
            while (j < rows.length) {
                HTMLTableRow row = rows[j];
                System.out.println(String.valueOf(indent) + "  row[" + j + "]: " + rows[j].getContent());
                HTMLTableCell[] cells = row.getCells();
                int k = 0;
                while (k < cells.length) {
                    System.out.println(String.valueOf(indent) + "    cell[" + k + "]: " + cells[k].getContent());
                    ++k;
                }
                ++j;
            }
            this.dumpTables(String.valueOf(indent) + "  ", tab.getTables());
            ++i;
        }
    }

    public String[] getPluginIDs() throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            if (!this.plugin_ids_loaded) {
                this.loadPluginList();
            }
            String[] res = new String[this.plugin_ids.size()];
            this.plugin_ids.toArray(res);
            String[] stringArray = res;
            this.this_mon.exit();
            return stringArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public SFPluginDetails getPluginDetails(String name) throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            this.getPluginIDs();
            SFPluginDetails details = (SFPluginDetails)this.plugin_map.get(name.toLowerCase());
            if (details == null) {
                throw new SFPluginDetailsException("Plugin '" + name + "' not found");
            }
            SFPluginDetails sFPluginDetails = details;
            this.this_mon.exit();
            return sFPluginDetails;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public SFPluginDetails[] getPluginDetails() throws SFPluginDetailsException {
        String[] plugin_ids = this.getPluginIDs();
        SFPluginDetails[] res = new SFPluginDetails[plugin_ids.length];
        int i = 0;
        while (i < plugin_ids.length) {
            res[i] = this.getPluginDetails(plugin_ids[i]);
            ++i;
        }
        return res;
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.informListeners(activity);
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.informListeners("Error: " + e.getMessage());
    }

    protected void informListeners(String log) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SFPluginDetailsLoaderListener)this.listeners.get(i)).log(log);
            ++i;
        }
    }

    public void reset() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (now < this.plugin_ids_loaded_at) {
                this.plugin_ids_loaded_at = 0L;
            }
            if (now - this.plugin_ids_loaded_at > 3600000L) {
                LGLogger.log("SFPluginDetailsLoader: resetting values");
                this.plugin_ids_loaded = false;
                this.plugin_ids = new ArrayList();
                this.plugin_map = new HashMap();
            } else {
                LGLogger.log("SFPluginDetailsLoader: not resetting, cache still valid");
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(SFPluginDetailsLoaderListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SFPluginDetailsLoaderListener l) {
        this.listeners.remove(l);
    }
}

