/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class FileDownloadWindow
implements TorrentDownloaderCallBackInterface {
    AzureusCore azureus_core;
    Display display;
    Shell shell;
    ProgressBar progressBar;
    Label status;
    Button retry;
    Button cancel;
    TorrentDownloader downloader;

    public FileDownloadWindow(AzureusCore _azureus_core, Display display, final String url, final String referrer) {
        this.azureus_core = _azureus_core;
        String dirName = null;
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files", true)) {
            try {
                dirName = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dirName == null) {
            DirectoryDialog dd = new DirectoryDialog(MainWindow.getWindow().getShell(), 0);
            dd.setText(MessageText.getString("fileDownloadWindow.saveTorrentIn"));
            dirName = dd.open();
        }
        if (dirName == null) {
            return;
        }
        this.display = display;
        this.shell = new Shell(display, 2144);
        this.shell.setText(MessageText.getString("fileDownloadWindow.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        formLayout.spacing = 5;
        this.shell.setLayout((Layout)formLayout);
        Label lDownloading = new Label((Composite)this.shell, 0);
        lDownloading.setText(MessageText.getString("fileDownloadWindow.downloading"));
        Label lLocation = new Label((Composite)this.shell, 0);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)lDownloading);
        data.right = new FormAttachment(100, 0);
        lLocation.setLayoutData((Object)data);
        String shortUrl = url;
        if (url.length() > 70) {
            shortUrl = String.valueOf(url.substring(0, 70)) + "...";
        }
        lLocation.setText(shortUrl);
        lLocation.setToolTipText(url);
        this.progressBar = new ProgressBar((Composite)this.shell, 0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        data = new FormData();
        data.top = new FormAttachment((Control)lDownloading);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.width = 400;
        this.progressBar.setLayoutData((Object)data);
        Label lStatus = new Label((Composite)this.shell, 0);
        lStatus.setText(MessageText.getString("fileDownloadWindow.status"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.progressBar);
        lStatus.setLayoutData((Object)data);
        this.status = new Label((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.progressBar);
        data.left = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment(100, 0);
        this.status.setLayoutData((Object)data);
        this.retry = new Button((Composite)this.shell, 8);
        this.retry.setEnabled(false);
        this.retry.setText(MessageText.getString("fileDownloadWindow.retry"));
        final String _dirName = dirName;
        this.retry.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDownloadWindow.this.retry.setEnabled(false);
                FileDownloadWindow.this.status.setText("");
                FileDownloadWindow.this.downloader.cancel();
                FileDownloadWindow.this.downloader = TorrentDownloaderFactory.download(FileDownloadWindow.this, url, referrer, _dirName);
                FileDownloadWindow.this.downloader.start();
            }
        });
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText(MessageText.getString("Button.cancel"));
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDownloadWindow.this.downloader.cancel();
                FileDownloadWindow.this.shell.dispose();
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment((Control)this.cancel);
        data.width = 100;
        this.retry.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment(100, 0);
        data.width = 100;
        this.cancel.setLayoutData((Object)data);
        this.shell.pack();
        this.shell.open();
        this.downloader = TorrentDownloaderFactory.download(this, url, referrer, dirName);
        this.downloader.start();
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        this.update();
    }

    private void update() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    String stateText;
                    int percentDone = FileDownloadWindow.this.downloader.getPercentDone();
                    if (FileDownloadWindow.this.progressBar != null && !FileDownloadWindow.this.progressBar.isDisposed()) {
                        FileDownloadWindow.this.progressBar.setSelection(percentDone);
                    }
                    int state = FileDownloadWindow.this.downloader.getDownloadState();
                    switch (state) {
                        case 2: {
                            stateText = MessageText.getString("fileDownloadWindow.state_downloading");
                            break;
                        }
                        case 4: {
                            stateText = String.valueOf(MessageText.getString("fileDownloadWindow.state_error")) + FileDownloadWindow.this.downloader.getError();
                            break;
                        }
                        default: {
                            stateText = "";
                        }
                    }
                    if (FileDownloadWindow.this.status != null && !FileDownloadWindow.this.status.isDisposed()) {
                        FileDownloadWindow.this.status.setText(stateText);
                        FileDownloadWindow.this.status.setToolTipText(stateText);
                    }
                    if (state == 3 && FileDownloadWindow.this.shell != null && !FileDownloadWindow.this.shell.isDisposed()) {
                        FileDownloadWindow.this.shell.dispose();
                        TorrentOpener.openTorrent(FileDownloadWindow.this.azureus_core, FileDownloadWindow.this.downloader.getFile().getAbsolutePath());
                    }
                    if (!FileDownloadWindow.this.shell.isDisposed()) {
                        if (state == 4 && !FileDownloadWindow.this.retry.isDisposed()) {
                            FileDownloadWindow.this.retry.setEnabled(true);
                        }
                        FileDownloadWindow.this.shell.pack();
                        FileDownloadWindow.this.shell.layout();
                    }
                }
            });
        }
    }
}

