/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.python.TranslateArguments;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PythonServerCSource {
    private LanguageWriterForC d_lw = null;
    private Set d_includedFiles = new HashSet();
    private Class d_cls = null;

    public PythonServerCSource(Class cls) {
        this.d_cls = cls;
    }

    private Collection argSymbols() throws CodeGenerationException {
        String exceptionFundamentalName = BabelConfiguration.getBaseExceptionType();
        HashSet<SymbolID> references = new HashSet<SymbolID>();
        Iterator i = this.d_cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            references.addAll(m.getSymbolReferences());
            if (m.getThrows().isEmpty()) continue;
            references.add(Utilities.lookupSymbol(exceptionFundamentalName).getSymbolID());
        }
        references.remove(this.d_cls.getSymbolID());
        return references;
    }

    private void explainSkelSource() {
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL");
        this.d_lw.println("COMPILER. DO NOT EDIT THIS!");
        this.d_lw.println();
        this.d_lw.println("This file contains skeleton code to provide an interface");
        this.d_lw.println("between the sidl independent object representation and");
        this.d_lw.println("the Python implementation of a class.  This translates");
        this.d_lw.println("method calls to the IOR to method class in Python.");
        this.d_lw.println("This file is for the sidl type " + this.d_cls.getFullName() + ".");
        this.d_lw.endBlockComment(false);
        this.d_lw.println();
    }

    private void addInclude(String filename, boolean useGuard) {
        if (!this.d_includedFiles.contains(filename)) {
            this.d_includedFiles.add(filename);
            this.d_lw.generateInclude(filename, useGuard);
        }
    }

    private void includeHeaderFiles() throws CodeGenerationException {
        this.d_lw.printlnUnformatted("#include <Python.h>");
        this.addInclude(IOR.getHeaderFile(this.d_cls.getSymbolID()), true);
        this.addInclude("sidlObjA.h", false);
        this.addInclude("sidlPyArrays.h", false);
        this.addInclude("Numeric/arrayobject.h", false);
        this.addInclude("sidl_header.h", true);
        this.addInclude("sidl_Python.h", true);
        this.addInclude("sidl_BaseInterface_Module.h", false);
        this.addInclude(Python.getCHeaderPath(this.d_cls, "Module"), false);
        Iterator i = Utilities.convertIdsToSymbols(this.argSymbols()).iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            if (11 == sym.getSymbolType()) continue;
            this.addInclude(Python.getCHeaderPath(sym, "Module"), false);
        }
        this.d_lw.printlnUnformatted("#include <stdlib.h>");
        this.d_lw.printlnUnformatted("#include <string.h>");
        this.d_lw.println();
    }

    private void writeMethodSignature(Method m) throws CodeGenerationException {
        SymbolID id = this.d_cls.getSymbolID();
        Iterator arguments = m.getArgumentList().iterator();
        boolean needComma = false;
        this.d_lw.println("static " + IOR.getReturnString(m.getReturnType(), true, false));
        this.d_lw.println(Python.getSkelMethod(id, m) + "(");
        if (!m.isStatic() || arguments.hasNext() || !m.getThrows().isEmpty()) {
            this.d_lw.tab();
            if (!m.isStatic()) {
                this.d_lw.print("/* in */ " + IOR.getObjectName(id) + " *self");
                needComma = true;
            }
            while (arguments.hasNext()) {
                Argument arg = (Argument)arguments.next();
                if (needComma) {
                    this.d_lw.println(",");
                }
                this.d_lw.print("/* " + arg.getModeString() + " */ ");
                this.d_lw.print(IOR.getArgumentWithFormal(arg, true, false, false));
                needComma = true;
            }
            if (!m.getThrows().isEmpty()) {
                if (needComma) {
                    this.d_lw.println(",");
                }
                this.d_lw.println(IOR.getExceptionFundamentalType() + " *_exception");
                needComma = true;
            }
        } else {
            this.d_lw.print("void");
        }
        this.d_lw.println(")");
        if (needComma) {
            this.d_lw.backTab();
        }
    }

    private void declareLocalVariables() {
        this.d_lw.println("PyObject *_context;");
        this.d_lw.println("PyObject *_pfunc;");
        this.d_lw.println("PyObject *_args;");
        this.d_lw.println("PyObject *_result;");
    }

    private void getFunction(boolean isStatic, String methodName) {
        if (isStatic) {
            this.d_lw.println("if ((_context = PyImport_ImportModule(\"" + this.d_cls.getFullName() + "_Impl" + "\"))) {");
        } else {
            this.d_lw.println("if ((_context = (self ? self->d_data : NULL))) {");
        }
        this.d_lw.tab();
        this.d_lw.println("if ((_pfunc = PyObject_GetAttrString(_context, \"" + methodName + "\"))) {");
        this.d_lw.tab();
    }

    private void generateInit() throws CodeGenerationException {
        boolean usesGeneric = false;
        this.d_lw.println("static void _importModules(void) {");
        this.d_lw.tab();
        this.d_lw.println("static int _import = 1;");
        this.d_lw.println("if (_import) {");
        this.d_lw.tab();
        this.d_lw.println("_import = 0;");
        this.d_lw.println("import_SIDLObjA();");
        this.d_lw.println("import_SIDLPyArrays();");
        this.d_lw.println(Python.getExtendableImport(this.d_cls) + "();");
        Iterator i = Utilities.convertIdsToSymbols(this.argSymbols()).iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            if (11 == sym.getSymbolType()) continue;
            this.d_lw.println(Python.getExtendableImport(sym) + "();");
        }
        i = this.d_cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            ArrayList args = m.getArgumentList();
            Iterator argIt = args.iterator();
            while (argIt.hasNext()) {
                Argument arg = (Argument)argIt.next();
                Type argType = arg.getType();
                if (argType.getType() != 16 || argType.getArrayType() != null) continue;
                usesGeneric = true;
            }
        }
        if (usesGeneric) {
            this.d_lw.println(Python.getImport(BabelConfiguration.getBaseInterface()) + "();");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void handleExceptions(Method m, Set throwTypes) throws CodeGenerationException {
        Object[] exceptions = throwTypes.toArray();
        String baseType = IOR.getObjectName(Utilities.lookupSymbol(BabelConfiguration.getBaseExceptionType()).getSymbolID());
        Arrays.sort(exceptions, new LevelComparator(SymbolTable.getInstance()));
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("PyObject *_exType, *_exValue, *_exTrace;");
        this.d_lw.println("PyErr_Fetch(&_exType, &_exValue, &_exTrace);");
        for (int i = 0; i < exceptions.length; ++i) {
            SymbolID id = (SymbolID)exceptions[i];
            Symbol sym = Utilities.lookupSymbol(id);
            if (i > 0) {
                this.d_lw.print("else ");
            }
            this.d_lw.println("if (PyErr_GivenExceptionMatches(_exType, " + Python.getExceptionType(sym) + ")) {");
            this.d_lw.tab();
            this.d_lw.println(IOR.getObjectName(id) + " *_local_exception;");
            this.d_lw.println("(void)" + Python.getExtendableConverter(sym) + "(_exValue , &_local_exception);");
            this.d_lw.println("if (_local_exception) {");
            this.d_lw.tab();
            this.d_lw.println(Python.getExtendableAddRef(sym) + "(_local_exception);");
            this.d_lw.println("*_exception = (" + baseType + " *)_local_exception;");
            this.d_lw.backTab();
            this.d_lw.println("}");
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
        this.d_lw.println("else {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_Restore(_exType, _exValue, _exTrace);");
        this.d_lw.println("_exType = NULL;");
        this.d_lw.println("_exValue = NULL;");
        this.d_lw.println("_exTrace = NULL;");
        this.d_lw.println("PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_XDECREF(_exType);");
        this.d_lw.println("Py_XDECREF(_exValue);");
        this.d_lw.println("Py_XDECREF(_exTrace);");
        this.d_lw.println("PyErr_Clear();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
    }

    private void cleanupReferences(Method m) throws CodeGenerationException {
        Set throwTypes = m.getThrows();
        this.d_lw.println("Py_DECREF(_result);");
        this.d_lw.backTab();
        this.d_lw.println("}");
        if (!throwTypes.isEmpty()) {
            this.handleExceptions(m, throwTypes);
        }
        this.d_lw.println("if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(_args);");
        this.d_lw.backTab();
        this.d_lw.println("} else if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(_pfunc);");
        this.d_lw.backTab();
        this.d_lw.println("} else if (PyErr_Occurred()) {");
        this.d_lw.tab();
        this.d_lw.println("PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        if (m.isStatic()) {
            this.d_lw.println("Py_DECREF(_context);");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        if (m.isStatic()) {
            this.d_lw.println("else if (PyErr_Occurred()) {");
            this.d_lw.tab();
            this.d_lw.println("PyErr_Print();");
            this.d_lw.backTab();
            this.d_lw.println("}");
        }
    }

    private void declareReturnVariable(Method m) throws CodeGenerationException {
        Type t = m.getReturnType();
        if (t.getDetailedType() != 0) {
            this.d_lw.print(IOR.getReturnString(t) + " " + "_return");
            if (Utilities.isPointer(t)) {
                this.d_lw.print(" = NULL");
            } else if (t.getDetailedType() == 3) {
                this.d_lw.print(" = { 0.0, 0.0 }");
            } else if (t.getDetailedType() == 5) {
                this.d_lw.print(" = { 0.0, 0.0 }");
            } else {
                this.d_lw.print(" = (" + IOR.getReturnString(t) + ") 0");
            }
            this.d_lw.println(";");
        }
    }

    private void initializeOutVariables(Method m) {
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            if (arg.getMode() != 2 || !Utilities.isPointer(arg.getType())) continue;
            this.d_lw.println('*' + arg.getFormalName() + " = NULL;");
        }
        if (!m.getThrows().isEmpty()) {
            this.d_lw.println("*_exception = NULL;");
        }
    }

    private void releaseInOutParameters(Method m) throws CodeGenerationException {
        Iterator i = m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            if (1 != arg.getMode()) continue;
            Type t = arg.getType();
            switch (t.getDetailedType()) {
                case 10: {
                    this.d_lw.println("free((void *)*" + arg.getFormalName() + ");");
                    this.d_lw.println("*" + arg.getFormalName() + " = NULL;");
                    break;
                }
                case 12: 
                case 13: {
                    Extendable ext = (Extendable)Utilities.lookupSymbol(t.getSymbolID());
                    this.d_lw.println(Python.getExtendableDeref(ext) + "(*" + arg.getFormalName() + ");");
                    this.d_lw.println("*" + arg.getFormalName() + " = NULL;");
                    break;
                }
                case 16: {
                    if (t.isRarray()) break;
                    this.d_lw.println(Python.getDestroyArray(t.getArrayType()) + "((struct sidl__array *)(*" + arg.getFormalName() + "));");
                    this.d_lw.println("*" + arg.getFormalName() + " = NULL;");
                }
            }
        }
    }

    private void convertMethod(Method m) throws CodeGenerationException {
        TranslateArguments trans = new TranslateArguments(this.d_lw, m, false, false);
        this.writeMethodSignature(m);
        trans.setConvertIncoming(true);
        trans.setBorrowArrays(true);
        this.d_lw.println("{");
        this.d_lw.tab();
        this.declareLocalVariables();
        this.declareReturnVariable(m);
        this.initializeOutVariables(m);
        this.getFunction(m.isStatic(), m.getLongMethodName());
        trans.declareProxies();
        trans.convertIncomingArguments(true);
        this.d_lw.print("_args =");
        trans.convertSidlToPython();
        this.d_lw.println("if (_args) {");
        this.d_lw.tab();
        this.d_lw.println("_result = PyObject_CallObject(_pfunc, _args);");
        this.d_lw.println("if (_result) {");
        this.d_lw.tab();
        trans.setConvertIncoming(false);
        trans.declareProxy(m.getReturnType(), "_return", 2);
        this.d_lw.println("int _okay;");
        if (TranslateArguments.extractOut(m.getReturnType(), m.getArgumentList()).size() == 1) {
            this.d_lw.println("PyObject *_tmp = PyTuple_New(1);");
            this.d_lw.println("(void)PyTuple_SetItem(_tmp, 0, _result);");
            this.d_lw.println("_result = _tmp;");
        }
        this.releaseInOutParameters(m);
        this.d_lw.print("_okay = ");
        trans.setBorrowArrays(false);
        trans.convertPythonToSidl("_result");
        this.d_lw.println("if (_okay) {");
        this.d_lw.tab();
        trans.convertOutgoingArguments(false);
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.cleanupReferences(m);
        if (m.getReturnType().getDetailedType() != 0) {
            this.d_lw.println("return _return;");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void convertMethods(Collection methods) throws CodeGenerationException {
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.convertMethod(m);
        }
    }

    private void writeInitializeSEPV(Collection methods) {
        SymbolID id = this.d_cls.getSymbolID();
        Iterator i = methods.iterator();
        this.d_lw.openCxxExtern();
        this.d_lw.println("void");
        this.d_lw.println(Python.getSetSEPVName(id));
        this.d_lw.tab();
        this.d_lw.println("(" + IOR.getSEPVName(id) + " *sepv)");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("_importModules();");
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            this.d_lw.println("sepv->" + IOR.getVectorEntry(m.getLongMethodName()) + " = " + Python.getSkelMethod(id, m) + ";");
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.closeCxxExtern();
        this.d_lw.println();
    }

    private void writeInitializeEPV(Collection methods) {
        SymbolID id = this.d_cls.getSymbolID();
        Iterator i = methods.iterator();
        this.d_lw.openCxxExtern();
        this.d_lw.println("void");
        this.d_lw.println(Python.getSetEPVName(id));
        this.d_lw.tab();
        this.d_lw.println("(" + IOR.getEPVName(id) + " *epv)");
        this.d_lw.backTab();
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.println("_importModules();");
        while (i.hasNext()) {
            Method m = (Method)i.next();
            switch (m.getDefinitionModifier()) {
                case 0: 
                case 2: {
                    this.d_lw.println("epv->" + IOR.getVectorEntry(m.getLongMethodName()) + " = " + Python.getSkelMethod(id, m) + ";");
                    break;
                }
                case 1: {
                    this.d_lw.println("epv->" + IOR.getVectorEntry(m.getLongMethodName()) + " = NULL;");
                    break;
                }
            }
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.closeCxxExtern();
        this.d_lw.println();
    }

    private Collection extendMethods(Collection localMethods) throws CodeGenerationException {
        SymbolID id = this.d_cls.getSymbolID();
        ArrayList<Method> extendedMethods = new ArrayList<Method>(localMethods.size() + 2);
        extendedMethods.add(IOR.getBuiltinMethod(3, id));
        extendedMethods.add(IOR.getBuiltinMethod(4, id));
        extendedMethods.addAll(localMethods);
        return extendedMethods;
    }

    private void writeConstructor() throws CodeGenerationException {
        SymbolID id = this.d_cls.getSymbolID();
        Method ctor = IOR.getBuiltinMethod(3, id);
        this.writeMethodSignature(ctor);
        this.d_lw.println("{");
        this.d_lw.tab();
        this.declareLocalVariables();
        this.getFunction(true, id.getShortName());
        this.d_lw.println("_args = Py_BuildValue(\"(O&)\", (void *)");
        this.d_lw.tab();
        this.d_lw.println(Python.getExtendableBorrow(this.d_cls) + ", self);");
        this.d_lw.backTab();
        this.d_lw.println("if (_args) {");
        this.d_lw.tab();
        this.d_lw.println("_result = PyInstance_New(_pfunc, _args, NULL);");
        this.d_lw.println("if (_result) {");
        this.d_lw.tab();
        this.d_lw.println("self->d_data = _result;");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(_args);");
        this.d_lw.backTab();
        this.d_lw.println("} else {");
        this.d_lw.tab();
        this.d_lw.println("if (PyErr_Occurred()) PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(_pfunc);");
        this.d_lw.backTab();
        this.d_lw.println("} else {");
        this.d_lw.tab();
        this.d_lw.println("if (PyErr_Occurred()) PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println("Py_DECREF(_context);");
        this.d_lw.backTab();
        this.d_lw.println("} else {");
        this.d_lw.tab();
        this.d_lw.println("if (PyErr_Occurred()) PyErr_Print();");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void writeDestructor() throws CodeGenerationException {
        SymbolID id = this.d_cls.getSymbolID();
        Method dtor = IOR.getBuiltinMethod(4, id);
        this.writeMethodSignature(dtor);
        this.d_lw.println("{");
        this.d_lw.tab();
        this.d_lw.writeCommentLine("Remove only reference to Python object");
        this.d_lw.println("Py_XDECREF(((PyObject *)self->d_data));");
        this.d_lw.backTab();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        try {
            Collection methods = this.d_cls.getMethods(false);
            Collection extendedMethods = this.extendMethods(methods);
            this.d_lw = Python.createSkel(this.d_cls, "skeletons to link IOR to Python implementation");
            this.explainSkelSource();
            this.includeHeaderFiles();
            this.generateInit();
            this.convertMethods(methods);
            this.writeConstructor();
            this.writeDestructor();
            this.writeInitializeEPV(extendedMethods);
            if (this.d_cls.hasStaticMethod(false)) {
                this.writeInitializeSEPV(extendedMethods);
            }
            Object var4_3 = null;
            if (this.d_lw == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.d_lw == null) throw throwable;
            this.d_lw.close();
            this.d_lw = null;
            throw throwable;
        }
        this.d_lw.close();
        this.d_lw = null;
    }
}

