! 
! File:          f90_TimeStepper_Impl.F90
! Symbol:        f90.TimeStepper-v2.0
! Symbol Type:   class
! Babel Version: 0.9.6
! sidl Created:  20041004 21:49:21 PDT
! Generated:     20041004 21:49:29 PDT
! Description:   Server-side implementation for f90.TimeStepper
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.9.6
! source-line   = 7
! source-url    = file:/home/kumfert/scdemo/hands-on/task_0/babel-life/libF90/f90life.sidl
! 


! 
! Symbol "f90.TimeStepper" (version 2.0)
! 


#include "sidl_BaseInterface_fAbbrev.h"
#include "sidl_BaseClass_fAbbrev.h"
#include "sidl_ClassInfo_fAbbrev.h"
#include "conway_Ruleset_fAbbrev.h"
#include "conway_TimeStepper_fAbbrev.h"
#include "f90_TimeStepper_fAbbrev.h"
#include "conway_Environment_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine f90_TimeStepper__ctor_mi(self)
  use f90_TimeStepper
  use f90_TimeStepper_impl
  ! DO-NOT-DELETE splicer.begin(f90.TimeStepper._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(f90.TimeStepper._ctor.use)
  implicit none
  type(f90_TimeStepper_t) :: self ! in

! DO-NOT-DELETE splicer.begin(f90.TimeStepper._ctor)
  type(f90_TimeStepper_wrap) :: pd 
  allocate(pd%d_private_data)
  call set_null(pd%d_private_data%d_env)
  call set_null(pd%d_private_data%d_rules)
  call set_null(pd%d_private_data%d_next)
  pd%d_private_data%d_step = 0
  call f90_TimeStepper__set_data_m(self, pd)
! DO-NOT-DELETE splicer.end(f90.TimeStepper._ctor)
end subroutine f90_TimeStepper__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine f90_TimeStepper__dtor_mi(self)
  use f90_TimeStepper
  use f90_TimeStepper_impl
  ! DO-NOT-DELETE splicer.begin(f90.TimeStepper._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(f90.TimeStepper._dtor.use)
  implicit none
  type(f90_TimeStepper_t) :: self ! in

! DO-NOT-DELETE splicer.begin(f90.TimeStepper._dtor)
  type(f90_TimeStepper_wrap) :: pd
  call f90_TimeStepper__get_data_m(self,pd)
  if (not_null(pd%d_private_data%d_env)) then
    call deleteRef(pd%d_private_data%d_env)
    call set_null(pd%d_private_data%d_env)
  endif
  if (not_null(pd%d_private_data%d_rules)) then
    call deleteRef(pd%d_private_data%d_rules)
    call set_null(pd%d_private_data%d_rules)
  endif
  if (not_null(pd%d_private_data%d_next)) then
    call deleteRef(pd%d_private_data%d_next)
    call set_null(pd%d_private_data%d_rules)
  endif
  deallocate(pd%d_private_data)
! DO-NOT-DELETE splicer.end(f90.TimeStepper._dtor)
end subroutine f90_TimeStepper__dtor_mi


! 
! Method:  init[]
! 

recursive subroutine f90_TimeStepper_init_mi(self, env, rules)
  use f90_TimeStepper
  use conway_Environment
  use conway_Ruleset
  use f90_TimeStepper_impl
  ! DO-NOT-DELETE splicer.begin(f90.TimeStepper.init.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(f90.TimeStepper.init.use)
  implicit none
  type(f90_TimeStepper_t) :: self ! in
  type(conway_Environment_t) :: env ! in
  type(conway_Ruleset_t) :: rules ! in

! DO-NOT-DELETE splicer.begin(f90.TimeStepper.init)
  type(f90_TimeStepper_wrap) :: pd
  call f90_TimeStepper__get_data_m(self,pd)
  if ( not_null(env) ) then
    pd%d_private_data%d_env = env
    call addRef( pd%d_private_data%d_env)
  endif
  if ( not_null(rules)) then
    pd%d_private_data%d_rules = rules
    call addRef( pd%d_private_data%d_rules)
  endif
  pd%d_private_data%d_step = 0
! DO-NOT-DELETE splicer.end(f90.TimeStepper.init)
end subroutine f90_TimeStepper_init_mi


! 
! advance one more timestep 
! returns population count at new timestep
! 

recursive subroutine f90_TimeStepper_step_mi(self, retval)
  use f90_TimeStepper
  use f90_TimeStepper_impl
  ! DO-NOT-DELETE splicer.begin(f90.TimeStepper.step.use)
  use sidl_BaseException
  use conway_Ruleset
  use conway_Environment
  use sidl_BaseInterface
  ! DO-NOT-DELETE splicer.end(f90.TimeStepper.step.use)
  implicit none
  type(f90_TimeStepper_t) :: self ! in
  integer (selected_int_kind(9)) :: retval ! out

! DO-NOT-DELETE splicer.begin(f90.TimeStepper.step)
  type(f90_TimeStepper_wrap) :: pd 
  type(conway_Environment_t) :: env
  type(conway_Ruleset_t) :: rules
  type(sidl_int_2d) :: grid, next
  type(sidl_BaseInterface_t) :: exception
  logical :: alive
  integer( selected_int_kind(9)) :: x, y
 
  integer ( selected_int_kind(9)) :: low(2), high(2)
  call f90_TimeStepper__get_data_m(self,pd)
  ! dereference some memeber data for convenience
  env = pd%d_private_data%d_env
  rules = pd%d_private_data%d_rules
  next = pd%d_private_data%d_next

  ! make sure things are initialized
  if (is_null(env) .or. is_null(rules)) then
    retval = -1
    return
  endif
 
  call getGrid(env, grid)
  low(1)=lower(grid,0)
  low(2)=lower(grid,1)
  high(1)=upper(grid,0)
  high(2)=upper(grid,1)
  
  if ( is_null( next ) ) then
    call createCol(low,high,pd%d_private_data%d_next)
    next=pd%d_private_data%d_next
  endif

  retval=0
  do x = low(1),high(1)
    do y = low(2),high(2)
      call setAlive(rules, x, y, env, alive, exception ) 
      if ( not_null( exception ) ) then
        print *, 'Caught an exception that should not have happened'
        retval = -1
      endif
      if (alive) then
        next%d_data(x,y) = 1
        retval = retval + 1 
      else
        next%d_data(x,y) = 0
      endif
    enddo
  enddo
  call setGrid( env, next )
  pd%d_private_data%d_step = pd%d_private_data%d_step + 1
  return
! DO-NOT-DELETE splicer.end(f90.TimeStepper.step)
end subroutine f90_TimeStepper_step_mi


! 
! check the number of steps taken 
! 

recursive subroutine f90_TimeStepper_nStepsTaken_mi(self, retval)
  use f90_TimeStepper
  use f90_TimeStepper_impl
  ! DO-NOT-DELETE splicer.begin(f90.TimeStepper.nStepsTaken.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(f90.TimeStepper.nStepsTaken.use)
  implicit none
  type(f90_TimeStepper_t) :: self ! in
  integer (selected_int_kind(9)) :: retval ! out

! DO-NOT-DELETE splicer.begin(f90.TimeStepper.nStepsTaken)
  type(f90_TimeStepper_wrap) :: pd
  call f90_TimeStepper__get_data_m(self,pd)
  retval = pd%d_private_data%d_step
  return
! DO-NOT-DELETE splicer.end(f90.TimeStepper.nStepsTaken)
end subroutine f90_TimeStepper_nStepsTaken_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
