// 
// File:          objarg_EmployeeArray_Impl.hh
// Symbol:        objarg.EmployeeArray-v0.5
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for objarg.EmployeeArray
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 

#ifndef included_objarg_EmployeeArray_Impl_hh
#define included_objarg_EmployeeArray_Impl_hh

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_objarg_EmployeeArray_IOR_h
#include "objarg_EmployeeArray_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_objarg_Employee_hh
#include "objarg_Employee.hh"
#endif
#ifndef included_objarg_EmployeeArray_hh
#include "objarg_EmployeeArray.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif


#line 39 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.hh"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._includes)
#include <vector>
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._includes)
#line 43 "objarg_EmployeeArray_Impl.hh"

namespace objarg { 

  /**
   * Symbol "objarg.EmployeeArray" (version 0.5)
   * 
   * This class manages a collection of employees.
   */
  class EmployeeArray_impl
#line 51 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.hh"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._inherits)
#line 57 "objarg_EmployeeArray_Impl.hh"
  {

  private:
    // Pointer back to IOR.
    // Use this to dispatch back through IOR vtable.
    EmployeeArray self;

#line 61 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.hh"
    // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._implementation)
    typedef std::vector<objarg::Employee> d_array_t;
    d_array_t d_array;
    // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._implementation)
#line 70 "objarg_EmployeeArray_Impl.hh"

  private:
    // private default constructor (required)
    EmployeeArray_impl() 
    {} 

  public:
    // sidl constructor (required)
    // Note: alternate Skel constructor doesn't call addref()
    // (fixes bug #275)
    EmployeeArray_impl( struct objarg_EmployeeArray__object * s ) : self(s,
      true) { _ctor(); }

    // user defined construction
    void _ctor();

    // virtual destructor (required)
    virtual ~EmployeeArray_impl() { _dtor(); }

    // user defined destruction
    void _dtor();

    // static class initializer
    static void _load();

  public:


    /**
     * Return the number of employees in the employee array.
     */
    int32_t
    getLength() throw () 
    ;

    /**
     * Return the employee in position <code>index</code> where
     * <code>index</code> ranges from 1 to the length of the array.
     * If <code>index</code> is outside the range of the array (i.e.
     * less than or equal to zero or greater than the current number
     * of elements in the array), this method returns a NULL
     * employee object.
     */
    ::objarg::Employee
    at (
      /* in */ int32_t index
    )
    throw () 
    ;


    /**
     * Add an employee onto the end of the array.  It is perfectly
     * legal to add the same employee multiple times.
     * <code>true</code> is returned when the append was successful;
     * otherwise, <code>false</code> is returned to indicate
     * failure.  This method will not add a NULL employee.
     */
    bool
    appendEmployee (
      /* in */ ::objarg::Employee e
    )
    throw () 
    ;


    /**
     * Find the first employee in the array that has a name matching
     * <code>name</code>.  If a match exists, the index is returned,
     * and the employee is returned in parameter <code>e</code>.
     * 
     * If no match exists, 0 is returned, and <code>e</code> is NULL.
     */
    int32_t
    findByName (
      /* in */ const ::std::string& name,
      /* out */ ::objarg::Employee& e
    )
    throw () 
    ;


    /**
     * Determine the maximum salary in the array. If the maximum
     * salary in the array is greater than the current salary of
     * <code>e</code>, the salary of <code>e</code> will be 
     * increased to the maximum salary in the array.  If the
     * array is empty, no change will be made to <code>e</code>.
     * 
     * This method returns <code>true</code> iff the salary of
     * <code>e</code> is modified.
     */
    bool
    promoteToMaxSalary (
      /* inout */ ::objarg::Employee& e
    )
    throw () 
    ;

  };  // end class EmployeeArray_impl

} // end namespace objarg

#line 168 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.hh"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._misc)
#line 178 "objarg_EmployeeArray_Impl.hh"

#endif
