/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hu" locale.
 */
public class LocalizedNamesImpl_hu extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "HU",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "UM",
        "US",
        "AS",
        "VI",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AW",
        "AC",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CL",
        "CY",
        "CP",
        "KM",
        "CK",
        "CR",
        "TD",
        "CZ",
        "DK",
        "ZA",
        "GS",
        "KR",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EC",
        "GQ",
        "AE",
        "GB",
        "EG",
        "CI",
        "ER",
        "MP",
        "KP",
        "EE",
        "ET",
        "EU",
        "FK",
        "BY",
        "FO",
        "FJ",
        "FI",
        "TF",
        "GF",
        "FR",
        "PF",
        "PH",
        "GA",
        "GM",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GE",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "AN",
        "NL",
        "HN",
        "HK",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CX",
        "QA",
        "KZ",
        "TL",
        "KE",
        "CN",
        "KG",
        "KI",
        "CC",
        "CO",
        "CG",
        "CD",
        "CF",
        "CU",
        "KW",
        "QO",
        "LA",
        "PL",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "HU",
        "MO",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "NA",
        "NR",
        "DE",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "NO",
        "EH",
        "IT",
        "OM",
        "RU",
        "AM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PT",
        "PR",
        "RE",
        "RO",
        "RW",
        "BL",
        "KN",
        "MF",
        "PM",
        "VC",
        "SB",
        "SV",
        "SM",
        "LC",
        "ST",
        "SC",
        "SL",
        "ES",
        "SJ",
        "LK",
        "SR",
        "CH",
        "SE",
        "WS",
        "SA",
        "SN",
        "SH",
        "RS",
        "CS",
        "SG",
        "SY",
        "SK",
        "SI",
        "SO",
        "SD",
        "SZ",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TR",
        "TT",
        "TA",
        "TN",
        "TC",
        "TV",
        "TM",
        "UG",
        "NC",
        "NZ",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "ZM",
        "ZW",
        "CV",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Világ");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Észak-Amerika");
    namesMap.put("005", "Dél-Amerika");
    namesMap.put("009", "Óceánia");
    namesMap.put("011", "Nyugat-Afrika");
    namesMap.put("013", "Közép-Amerika");
    namesMap.put("014", "Kelet-Afrika");
    namesMap.put("015", "Észak-Afrika");
    namesMap.put("017", "Közép-Afrika");
    namesMap.put("018", "Afrika déli része");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika északi része");
    namesMap.put("029", "Karib-térség");
    namesMap.put("030", "Kelet-Ázsia");
    namesMap.put("034", "Dél-Ázsia");
    namesMap.put("035", "Délkelet-Ázsia");
    namesMap.put("039", "Dél-Európa");
    namesMap.put("053", "Ausztrália és Új-Zéland");
    namesMap.put("054", "Melanézia");
    namesMap.put("057", "Mikronéziai régió");
    namesMap.put("061", "Polinézia");
    namesMap.put("062", "Délközép-Ázsia");
    namesMap.put("142", "Ázsia");
    namesMap.put("143", "Közép-Ázsia");
    namesMap.put("145", "Nyugat-Ázsia");
    namesMap.put("150", "Európa");
    namesMap.put("151", "Kelet-Európa");
    namesMap.put("154", "Észak-Európa");
    namesMap.put("155", "Nyugat-Európa");
    namesMap.put("172", "Független Államok Közössége");
    namesMap.put("419", "Latin-Amerika és a Karib-térség");
    namesMap.put("830", "Csatorna-szigetek");
    namesMap.put("AC", "Ascension-sziget");
    namesMap.put("AE", "Egyesült Arab Emirátus");
    namesMap.put("AF", "Afganisztán");
    namesMap.put("AG", "Antigua és Barbuda");
    namesMap.put("AL", "Albánia");
    namesMap.put("AM", "Örményország");
    namesMap.put("AN", "Holland Antillák");
    namesMap.put("AQ", "Antarktisz");
    namesMap.put("AR", "Argentína");
    namesMap.put("AS", "Amerikai Szamoa");
    namesMap.put("AT", "Ausztria");
    namesMap.put("AU", "Ausztrália");
    namesMap.put("AX", "Aland-szigetek");
    namesMap.put("AZ", "Azerbajdzsán");
    namesMap.put("BA", "Bosznia-Hercegovina");
    namesMap.put("BD", "Banglades");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BR", "Brazília");
    namesMap.put("BS", "Bahama-szigetek");
    namesMap.put("BT", "Bhután");
    namesMap.put("BV", "Bouvet-sziget");
    namesMap.put("BY", "Fehéroroszország");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kókusz-szigetek");
    namesMap.put("CD", "Kongó - Kinshasa");
    namesMap.put("CF", "Közép-afrikai Köztársaság");
    namesMap.put("CG", "Kongó - Brazzaville");
    namesMap.put("CH", "Svájc");
    namesMap.put("CI", "Elefántcsontpart");
    namesMap.put("CK", "Cook-szigetek");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kína");
    namesMap.put("CO", "Kolumbia");
    namesMap.put("CP", "Clipperton-sziget");
    namesMap.put("CS", "Szerbia és Montenegró");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Zöld-foki Köztársaság");
    namesMap.put("CX", "Karácsony-szigetek");
    namesMap.put("CY", "Ciprus");
    namesMap.put("CZ", "Csehország");
    namesMap.put("DE", "Németország");
    namesMap.put("DJ", "Dzsibuti");
    namesMap.put("DK", "Dánia");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikai Köztársaság");
    namesMap.put("DZ", "Algéria");
    namesMap.put("EA", "Ceuta és Melilla");
    namesMap.put("EE", "Észtország");
    namesMap.put("EG", "Egyiptom");
    namesMap.put("EH", "Nyugat-Szahara");
    namesMap.put("ES", "Spanyolország");
    namesMap.put("ET", "Etiópia");
    namesMap.put("EU", "Európai Unió");
    namesMap.put("FI", "Finnország");
    namesMap.put("FJ", "Fidzsi");
    namesMap.put("FK", "Falkland-szigetek");
    namesMap.put("FM", "Mikronézia");
    namesMap.put("FO", "Feröer-szigetek");
    namesMap.put("FR", "Franciaország");
    namesMap.put("GB", "Egyesült Királyság");
    namesMap.put("GE", "Grúzia");
    namesMap.put("GF", "Francia Guyana");
    namesMap.put("GH", "Ghána");
    namesMap.put("GI", "Gibraltár");
    namesMap.put("GL", "Grönland");
    namesMap.put("GQ", "Egyenlítői-Guinea");
    namesMap.put("GR", "Görögország");
    namesMap.put("GS", "Dél Grúzia és a Déli Szendvics-szigetek");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard és McDonald Szigetek");
    namesMap.put("HR", "Horvátország");
    namesMap.put("HU", "Magyarország");
    namesMap.put("IC", "Kanári-szigetek");
    namesMap.put("ID", "Indonézia");
    namesMap.put("IE", "Írország");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Man-sziget");
    namesMap.put("IO", "Brit Indiai-óceáni Terület");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Izland");
    namesMap.put("IT", "Olaszország");
    namesMap.put("JO", "Jordánia");
    namesMap.put("JP", "Japán");
    namesMap.put("KG", "Kirgizisztán");
    namesMap.put("KH", "Kambodzsa");
    namesMap.put("KM", "Comore-szigetek");
    namesMap.put("KN", "Saint Kitts és Nevis");
    namesMap.put("KP", "Észak-Korea");
    namesMap.put("KR", "Dél-Korea");
    namesMap.put("KW", "Kuvait");
    namesMap.put("KY", "Kajmán-szigetek");
    namesMap.put("KZ", "Kazahsztán");
    namesMap.put("LA", "Laosz");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Santa Lucia");
    namesMap.put("LK", "Srí Lanka");
    namesMap.put("LR", "Libéria");
    namesMap.put("LT", "Litvánia");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Lettország");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marokkó");
    namesMap.put("ME", "Montenegró");
    namesMap.put("MG", "Madagaszkár");
    namesMap.put("MH", "Marshall-szigetek");
    namesMap.put("MK", "Macedónia");
    namesMap.put("MM", "Mianmar [Burma]");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MO", "Makaó");
    namesMap.put("MP", "Északi Mariana-szigetek");
    namesMap.put("MR", "Mauritánia");
    namesMap.put("MT", "Málta");
    namesMap.put("MV", "Maldív-szigetek");
    namesMap.put("MX", "Mexikó");
    namesMap.put("MY", "Malajzia");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Új-Kaledónia");
    namesMap.put("NF", "Norfolk-sziget");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NL", "Hollandia");
    namesMap.put("NO", "Norvégia");
    namesMap.put("NP", "Nepál");
    namesMap.put("NZ", "Új-Zéland");
    namesMap.put("OM", "Omán");
    namesMap.put("PF", "Francia Polinézia");
    namesMap.put("PG", "Pápua Új-Guinea");
    namesMap.put("PH", "Fülöp-szigetek");
    namesMap.put("PK", "Pakisztán");
    namesMap.put("PL", "Lengyelország");
    namesMap.put("PM", "Saint Pierre és Miquelon");
    namesMap.put("PN", "Pitcairn-szigetek");
    namesMap.put("PS", "Palesztin Terület");
    namesMap.put("PT", "Portugália");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Külső-Óceánia");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Románia");
    namesMap.put("RS", "Szerbia");
    namesMap.put("RU", "Oroszországi Föderáció");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Szaúd-Arábia");
    namesMap.put("SB", "Salamon-szigetek");
    namesMap.put("SC", "Seychelle-szigetek");
    namesMap.put("SD", "Szudán");
    namesMap.put("SE", "Svédország");
    namesMap.put("SG", "Szingapúr");
    namesMap.put("SH", "Szent Helena");
    namesMap.put("SI", "Szlovénia");
    namesMap.put("SJ", "Spitzbergák és Jan Mayen-szigetek");
    namesMap.put("SK", "Szlovákia");
    namesMap.put("SN", "Szenegál");
    namesMap.put("SO", "Szomália");
    namesMap.put("ST", "Sao Tomé és Príncipe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Szíria");
    namesMap.put("SZ", "Szváziföld");
    namesMap.put("TC", "Turks- és Caicos-szigetek");
    namesMap.put("TD", "Csád");
    namesMap.put("TF", "Francia Déli Területek");
    namesMap.put("TH", "Thaiföld");
    namesMap.put("TJ", "Tadzsikisztán");
    namesMap.put("TL", "Kelet-Timor");
    namesMap.put("TM", "Türkmenisztán");
    namesMap.put("TN", "Tunézia");
    namesMap.put("TR", "Törökország");
    namesMap.put("TT", "Trinidad és Tobago");
    namesMap.put("TW", "Tajvan");
    namesMap.put("TZ", "Tanzánia");
    namesMap.put("UA", "Ukrajna");
    namesMap.put("UM", "Amerikai Csendes-óceáni Szigetek");
    namesMap.put("US", "Amerikai Egyesült Államok");
    namesMap.put("UZ", "Üzbegisztán");
    namesMap.put("VA", "Vatikán");
    namesMap.put("VC", "Saint Vincent és a Grenadine-szigetek");
    namesMap.put("VG", "Brit Virgin-szigetek");
    namesMap.put("VI", "Amerikai Virgin-szigetek");
    namesMap.put("WF", "Wallis- és Futuna-szigetek");
    namesMap.put("WS", "Szamoa");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Dél-afrikai Köztársaság");
    namesMap.put("ZZ", "Ismeretlen vagy érvénytelen körzet");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Világ",
        "002": "Afrika",
        "003": "Észak-Amerika",
        "005": "Dél-Amerika",
        "009": "Óceánia",
        "011": "Nyugat-Afrika",
        "013": "Közép-Amerika",
        "014": "Kelet-Afrika",
        "015": "Észak-Afrika",
        "017": "Közép-Afrika",
        "018": "Afrika déli része",
        "019": "Amerika",
        "021": "Amerika északi része",
        "029": "Karib-térség",
        "030": "Kelet-Ázsia",
        "034": "Dél-Ázsia",
        "035": "Délkelet-Ázsia",
        "039": "Dél-Európa",
        "053": "Ausztrália és Új-Zéland",
        "054": "Melanézia",
        "057": "Mikronéziai régió",
        "061": "Polinézia",
        "062": "Délközép-Ázsia",
        "142": "Ázsia",
        "143": "Közép-Ázsia",
        "145": "Nyugat-Ázsia",
        "150": "Európa",
        "151": "Kelet-Európa",
        "154": "Észak-Európa",
        "155": "Nyugat-Európa",
        "172": "Független Államok Közössége",
        "419": "Latin-Amerika és a Karib-térség",
        "830": "Csatorna-szigetek",
        "AC": "Ascension-sziget",
        "AE": "Egyesült Arab Emirátus",
        "AF": "Afganisztán",
        "AG": "Antigua és Barbuda",
        "AL": "Albánia",
        "AM": "Örményország",
        "AN": "Holland Antillák",
        "AQ": "Antarktisz",
        "AR": "Argentína",
        "AS": "Amerikai Szamoa",
        "AT": "Ausztria",
        "AU": "Ausztrália",
        "AX": "Aland-szigetek",
        "AZ": "Azerbajdzsán",
        "BA": "Bosznia-Hercegovina",
        "BD": "Banglades",
        "BG": "Bulgária",
        "BH": "Bahrein",
        "BO": "Bolívia",
        "BR": "Brazília",
        "BS": "Bahama-szigetek",
        "BT": "Bhután",
        "BV": "Bouvet-sziget",
        "BY": "Fehéroroszország",
        "CA": "Kanada",
        "CC": "Kókusz-szigetek",
        "CD": "Kongó - Kinshasa",
        "CF": "Közép-afrikai Köztársaság",
        "CG": "Kongó - Brazzaville",
        "CH": "Svájc",
        "CI": "Elefántcsontpart",
        "CK": "Cook-szigetek",
        "CM": "Kamerun",
        "CN": "Kína",
        "CO": "Kolumbia",
        "CP": "Clipperton-sziget",
        "CS": "Szerbia és Montenegró",
        "CU": "Kuba",
        "CV": "Zöld-foki Köztársaság",
        "CX": "Karácsony-szigetek",
        "CY": "Ciprus",
        "CZ": "Csehország",
        "DE": "Németország",
        "DJ": "Dzsibuti",
        "DK": "Dánia",
        "DM": "Dominika",
        "DO": "Dominikai Köztársaság",
        "DZ": "Algéria",
        "EA": "Ceuta és Melilla",
        "EE": "Észtország",
        "EG": "Egyiptom",
        "EH": "Nyugat-Szahara",
        "ES": "Spanyolország",
        "ET": "Etiópia",
        "EU": "Európai Unió",
        "FI": "Finnország",
        "FJ": "Fidzsi",
        "FK": "Falkland-szigetek",
        "FM": "Mikronézia",
        "FO": "Feröer-szigetek",
        "FR": "Franciaország",
        "GB": "Egyesült Királyság",
        "GE": "Grúzia",
        "GF": "Francia Guyana",
        "GH": "Ghána",
        "GI": "Gibraltár",
        "GL": "Grönland",
        "GQ": "Egyenlítői-Guinea",
        "GR": "Görögország",
        "GS": "Dél Grúzia és a Déli Szendvics-szigetek",
        "HK": "Hongkong",
        "HM": "Heard és McDonald Szigetek",
        "HR": "Horvátország",
        "HU": "Magyarország",
        "IC": "Kanári-szigetek",
        "ID": "Indonézia",
        "IE": "Írország",
        "IL": "Izrael",
        "IM": "Man-sziget",
        "IO": "Brit Indiai-óceáni Terület",
        "IQ": "Irak",
        "IR": "Irán",
        "IS": "Izland",
        "IT": "Olaszország",
        "JO": "Jordánia",
        "JP": "Japán",
        "KG": "Kirgizisztán",
        "KH": "Kambodzsa",
        "KM": "Comore-szigetek",
        "KN": "Saint Kitts és Nevis",
        "KP": "Észak-Korea",
        "KR": "Dél-Korea",
        "KW": "Kuvait",
        "KY": "Kajmán-szigetek",
        "KZ": "Kazahsztán",
        "LA": "Laosz",
        "LB": "Libanon",
        "LC": "Santa Lucia",
        "LK": "Srí Lanka",
        "LR": "Libéria",
        "LT": "Litvánia",
        "LU": "Luxemburg",
        "LV": "Lettország",
        "LY": "Líbia",
        "MA": "Marokkó",
        "ME": "Montenegró",
        "MG": "Madagaszkár",
        "MH": "Marshall-szigetek",
        "MK": "Macedónia",
        "MM": "Mianmar [Burma]",
        "MN": "Mongólia",
        "MO": "Makaó",
        "MP": "Északi Mariana-szigetek",
        "MR": "Mauritánia",
        "MT": "Málta",
        "MV": "Maldív-szigetek",
        "MX": "Mexikó",
        "MY": "Malajzia",
        "MZ": "Mozambik",
        "NA": "Namíbia",
        "NC": "Új-Kaledónia",
        "NF": "Norfolk-sziget",
        "NG": "Nigéria",
        "NL": "Hollandia",
        "NO": "Norvégia",
        "NP": "Nepál",
        "NZ": "Új-Zéland",
        "OM": "Omán",
        "PF": "Francia Polinézia",
        "PG": "Pápua Új-Guinea",
        "PH": "Fülöp-szigetek",
        "PK": "Pakisztán",
        "PL": "Lengyelország",
        "PM": "Saint Pierre és Miquelon",
        "PN": "Pitcairn-szigetek",
        "PS": "Palesztin Terület",
        "PT": "Portugália",
        "QA": "Katar",
        "QO": "Külső-Óceánia",
        "RE": "Reunion",
        "RO": "Románia",
        "RS": "Szerbia",
        "RU": "Oroszországi Föderáció",
        "RW": "Ruanda",
        "SA": "Szaúd-Arábia",
        "SB": "Salamon-szigetek",
        "SC": "Seychelle-szigetek",
        "SD": "Szudán",
        "SE": "Svédország",
        "SG": "Szingapúr",
        "SH": "Szent Helena",
        "SI": "Szlovénia",
        "SJ": "Spitzbergák és Jan Mayen-szigetek",
        "SK": "Szlovákia",
        "SN": "Szenegál",
        "SO": "Szomália",
        "ST": "Sao Tomé és Príncipe",
        "SV": "Salvador",
        "SY": "Szíria",
        "SZ": "Szváziföld",
        "TC": "Turks- és Caicos-szigetek",
        "TD": "Csád",
        "TF": "Francia Déli Területek",
        "TH": "Thaiföld",
        "TJ": "Tadzsikisztán",
        "TL": "Kelet-Timor",
        "TM": "Türkmenisztán",
        "TN": "Tunézia",
        "TR": "Törökország",
        "TT": "Trinidad és Tobago",
        "TW": "Tajvan",
        "TZ": "Tanzánia",
        "UA": "Ukrajna",
        "UM": "Amerikai Csendes-óceáni Szigetek",
        "US": "Amerikai Egyesült Államok",
        "UZ": "Üzbegisztán",
        "VA": "Vatikán",
        "VC": "Saint Vincent és a Grenadine-szigetek",
        "VG": "Brit Virgin-szigetek",
        "VI": "Amerikai Virgin-szigetek",
        "WF": "Wallis- és Futuna-szigetek",
        "WS": "Szamoa",
        "YE": "Jemen",
        "ZA": "Dél-afrikai Köztársaság",
        "ZZ": "Ismeretlen vagy érvénytelen körzet"
    };
  }-*/;
}
